/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsCredentialedAgreement;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDHDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDomain;

public class BcDefaultTlsCredentialedAgreement
implements TlsCredentialedAgreement {
    protected TlsCredentialedAgreement agreementCredentials;

    public BcDefaultTlsCredentialedAgreement(BcTlsCrypto bcTlsCrypto, Certificate certificate, AsymmetricKeyParameter asymmetricKeyParameter) {
        if (bcTlsCrypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (asymmetricKeyParameter instanceof DHPrivateKeyParameters) {
            this.agreementCredentials = new DHCredentialedAgreement(bcTlsCrypto, certificate, (DHPrivateKeyParameters)asymmetricKeyParameter);
        } else if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            this.agreementCredentials = new ECCredentialedAgreement(bcTlsCrypto, certificate, (ECPrivateKeyParameters)asymmetricKeyParameter);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
    }

    @Override
    public Certificate getCertificate() {
        return this.agreementCredentials.getCertificate();
    }

    @Override
    public TlsSecret generateAgreement(TlsCertificate tlsCertificate) throws IOException {
        return this.agreementCredentials.generateAgreement(tlsCertificate);
    }

    private class DHCredentialedAgreement
    implements TlsCredentialedAgreement {
        final BcTlsCrypto crypto;
        final Certificate certificate;
        final DHPrivateKeyParameters privateKey;

        DHCredentialedAgreement(BcTlsCrypto bcTlsCrypto, Certificate certificate, DHPrivateKeyParameters dHPrivateKeyParameters) {
            this.crypto = bcTlsCrypto;
            this.certificate = certificate;
            this.privateKey = dHPrivateKeyParameters;
        }

        @Override
        public TlsSecret generateAgreement(TlsCertificate tlsCertificate) throws IOException {
            DHPublicKeyParameters dHPublicKeyParameters = BcTlsCertificate.convert(this.crypto, tlsCertificate).getPubKeyDH();
            return BcTlsDHDomain.calculateDHAgreement(this.crypto, this.privateKey, dHPublicKeyParameters, false);
        }

        @Override
        public Certificate getCertificate() {
            return this.certificate;
        }
    }

    private class ECCredentialedAgreement
    implements TlsCredentialedAgreement {
        final BcTlsCrypto crypto;
        final Certificate certificate;
        final ECPrivateKeyParameters privateKey;

        ECCredentialedAgreement(BcTlsCrypto bcTlsCrypto, Certificate certificate, ECPrivateKeyParameters eCPrivateKeyParameters) {
            this.crypto = bcTlsCrypto;
            this.certificate = certificate;
            this.privateKey = eCPrivateKeyParameters;
        }

        @Override
        public TlsSecret generateAgreement(TlsCertificate tlsCertificate) throws IOException {
            ECPublicKeyParameters eCPublicKeyParameters = BcTlsCertificate.convert(this.crypto, tlsCertificate).getPubKeyEC();
            return BcTlsECDomain.calculateECDHAgreement(this.crypto, this.privateKey, eCPublicKeyParameters);
        }

        @Override
        public Certificate getCertificate() {
            return this.certificate;
        }
    }
}

