/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.SocketUtilsIPV6;
import org.jruby.ext.socket.SubnetUtils;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Ifaddr
extends RubyObject {
    private String name;
    private boolean isUp;
    private boolean isLoopback;
    private boolean isPointToPoint;
    private InetAddress address;
    private InetAddress broadcast;
    private InterfaceAddress interfaceAddress;
    private NetworkInterface networkInterface;
    private boolean isLink;
    private String netmask;
    private int index;
    private String flagStatus;
    private Addrinfo addr;

    public static void createIfaddr(Ruby runtime2) {
        RubyClass ifaddr = runtime2.getClass("Socket").defineClassUnder("Ifaddr", runtime2.getObject(), Ifaddr::new);
        ifaddr.defineAnnotatedMethods(Ifaddr.class);
    }

    public Ifaddr(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass);
    }

    public Ifaddr(Ruby runtime2, RubyClass metaClass, NetworkInterface ni, InterfaceAddress it) throws SocketException {
        super(runtime2, metaClass);
        this.name = ni.getDisplayName();
        this.isLoopback = ni.isLoopback();
        this.isUp = ni.isUp();
        this.isPointToPoint = ni.isPointToPoint();
        this.index = ni.getIndex();
        this.networkInterface = ni;
        this.isLink = false;
        this.address = it.getAddress();
        this.broadcast = it.getBroadcast();
        this.interfaceAddress = it;
        this.setAddr(runtime2);
        this.setNetmask(it);
        this.setInspectString(ni);
    }

    public Ifaddr(Ruby runtime2, RubyClass metaClass, NetworkInterface ni) throws SocketException {
        super(runtime2, metaClass);
        this.name = ni.getDisplayName();
        this.isLoopback = ni.isLoopback();
        this.isUp = ni.isUp();
        this.isPointToPoint = ni.isPointToPoint();
        this.index = ni.getIndex();
        this.networkInterface = ni;
        this.isLink = true;
        this.setAddr(runtime2);
        this.setInspectString(ni);
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        return context.runtime.newString("#<Socket::Ifaddr: " + this.name + " " + this.flagStatus + ">");
    }

    @JRubyMethod
    public IRubyObject name(ThreadContext context) {
        return context.runtime.newString(this.name);
    }

    @JRubyMethod
    public IRubyObject addr(ThreadContext context) {
        return this.addr;
    }

    @JRubyMethod
    public IRubyObject broadaddr(ThreadContext context) {
        if (this.broadcast != null && !this.isLink) {
            return new Addrinfo(context.runtime, context.runtime.getClass("Addrinfo"), this.broadcast);
        }
        try {
            if (this.isLink && !this.networkInterface.isLoopback()) {
                return new Addrinfo(context.runtime, context.runtime.getClass("Addrinfo"), this.networkInterface, true);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject ifindex(ThreadContext context) {
        return context.runtime.newFixnum(this.index);
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject flags(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject netmask(ThreadContext context) throws UnknownHostException {
        if (this.netmask == null) {
            return context.nil;
        }
        return new Addrinfo(context.runtime, context.runtime.getClass("Addrinfo"), InetAddress.getByName(this.netmask));
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject dstaddr(ThreadContext context) {
        return context.nil;
    }

    private void setAddr(Ruby runtime2) {
        if (this.address != null && !this.isLink) {
            this.addr = new Addrinfo(runtime2, runtime2.getClass("Addrinfo"), this.address);
        }
        if (this.isLink) {
            this.addr = new Addrinfo(runtime2, runtime2.getClass("Addrinfo"), this.networkInterface, false);
        }
    }

    private void setNetmask(InterfaceAddress it) {
        if ((this.isLoopback || it.getNetworkPrefixLength() != 0) && this.address instanceof Inet4Address) {
            String subnet = this.ipAddress() + "/" + it.getNetworkPrefixLength();
            if (this.isLoopback) {
                subnet = this.ipAddress() + "/8";
            }
            SubnetUtils utils = new SubnetUtils(subnet);
            this.netmask = utils.getInfo().getNetmask();
        } else if (it.getNetworkPrefixLength() != 0 && this.address instanceof Inet6Address) {
            this.netmask = SocketUtilsIPV6.getIPV6NetMask(this.ipAddress() + "/" + it.getNetworkPrefixLength());
        }
    }

    private void setInspectString(NetworkInterface nif) throws SocketException {
        String string2 = this.flagStatus = nif.isUp() ? "UP" : "DOWN";
        if (nif.isLoopback()) {
            this.flagStatus = this.flagStatus + ",LOOPBACK";
        }
        if (nif.isPointToPoint()) {
            this.flagStatus = this.flagStatus + ",PTP";
        }
        if (nif.isVirtual()) {
            this.flagStatus = this.flagStatus + ",VIRTUAL";
        }
        if (nif.supportsMulticast()) {
            this.flagStatus = this.flagStatus + ",MULTICAST";
        }
        this.flagStatus = this.flagStatus + ",MTU=" + nif.getMTU();
        byte[] mac = nif.getHardwareAddress();
        if (mac != null) {
            this.flagStatus = this.flagStatus + ",HWADDR=";
            for (int i2 = 0; i2 < mac.length; ++i2) {
                if (i2 > 0) {
                    this.flagStatus = this.flagStatus + ":";
                }
                this.flagStatus = this.flagStatus + String.format("%02x", mac[i2]);
            }
        }
        if (this.isLink) {
            this.flagStatus = this.flagStatus + " " + this.addr.packet_inspect();
        } else {
            if (!this.ipAddress().equals("")) {
                this.flagStatus = this.flagStatus + " " + this.ipAddress();
            }
            if (this.broadcast != null) {
                this.flagStatus = this.flagStatus + " broadcast=" + this.getBroadcastAsString();
            }
            if (this.netmask != null) {
                this.flagStatus = this.flagStatus + " netmask=" + this.netmask;
            }
        }
    }

    private String ipAddress() {
        if (this.address instanceof Inet4Address) {
            return this.address.toString().substring(1);
        }
        if (this.address instanceof Inet6Address) {
            return this.address.toString().substring(1).split("%")[0];
        }
        return "";
    }

    private String getBroadcastAsString() {
        if (this.broadcast == null) {
            return "";
        }
        return this.broadcast.toString().substring(1);
    }
}

