/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.LocalVariableCompiler;
import org.jruby.ir.targets.indy.Bootstrap;
import org.jruby.ir.targets.simple.NormalLocalVariableCompiler;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.DynamicScopeGenerator;
import org.jruby.util.CodegenUtils;

public class IndyLocalVariableCompiler
implements LocalVariableCompiler {
    private final IRBytecodeAdapter compiler;
    private final NormalLocalVariableCompiler normalLocalVariableCompiler;

    public IndyLocalVariableCompiler(IRBytecodeAdapter irBytecodeAdapter) {
        this.compiler = irBytecodeAdapter;
        this.normalLocalVariableCompiler = new NormalLocalVariableCompiler(irBytecodeAdapter);
    }

    @Override
    public void getHeapLocal(int depth, int location) {
        if (depth == 0 && location < DynamicScopeGenerator.SPECIALIZED_GETS.size()) {
            this.normalLocalVariableCompiler.getHeapLocal(depth, location);
            return;
        }
        this.compiler.adapter.invokedynamic("getHeapLocal", CodegenUtils.sig(IRubyObject.class, DynamicScope.class), Bootstrap.getHeapLocalHandle(), depth, location);
    }

    @Override
    public void getHeapLocalOrNil(int depth, int location) {
        this.compiler.loadContext();
        this.compiler.adapter.invokedynamic("getHeapLocalOrNil", CodegenUtils.sig(IRubyObject.class, DynamicScope.class, ThreadContext.class), Bootstrap.getHeapLocalOrNilHandle(), depth, location);
    }
}

