/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jcodings.Encoding;
import org.jruby.EvalType;
import org.jruby.Finalizable;
import org.jruby.MetaClass;
import org.jruby.ObjectFlags;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaUtil;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;
import org.jruby.runtime.builtin.InternalVariables;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.marshal.CoreObjectType;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.IdUtil;
import org.jruby.util.Inspector;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.unsafe.UnsafeHolder;

public class RubyBasicObject
implements Cloneable,
IRubyObject,
Serializable,
Comparable<IRubyObject>,
CoreObjectType,
InstanceVariables,
InternalVariables {
    protected transient RubyClass metaClass;
    protected int flags;
    public transient Object[] varTable;
    public volatile transient int varTableStamp;
    public static final long VAR_TABLE_OFFSET = UnsafeHolder.fieldOffset(RubyBasicObject.class, "varTable");
    public static final long STAMP_OFFSET = UnsafeHolder.fieldOffset(RubyBasicObject.class, "varTableStamp");
    public static final String ERR_INSECURE_SET_INST_VAR = "Insecure: can't modify instance variable";
    public static final int ALL_F = -1;
    public static final int FALSE_F = ObjectFlags.FALSE_F;
    public static final int NIL_F = ObjectFlags.NIL_F;
    public static final int FROZEN_F = ObjectFlags.FROZEN_F;
    public static final IRubyObject NEVER = new RubyBasicObject();
    public static final IRubyObject UNDEF = new RubyBasicObject();
    public static final ObjectAllocator BASICOBJECT_ALLOCATOR = RubyBasicObject::new;
    @Deprecated
    public static final int FL_USHIFT = 4;
    @Deprecated
    public static final int USER0_F = 16;
    @Deprecated
    public static final int USER1_F = 32;
    @Deprecated
    public static final int USER2_F = 64;
    @Deprecated
    public static final int USER3_F = 128;
    @Deprecated
    public static final int USER4_F = 256;
    @Deprecated
    public static final int USER5_F = 512;
    @Deprecated
    public static final int USER6_F = 1024;
    @Deprecated
    public static final int USER7_F = 2048;
    @Deprecated
    public static final int USER8_F = 4096;
    @Deprecated
    public static final int USER9_F = 8192;
    @Deprecated
    public static final int USERA_F = 16384;
    @Deprecated
    public static final int REFINED_MODULE_F = 8192;
    @Deprecated
    public static final int IS_OVERLAID_F = 16384;
    @Deprecated
    public static final int COMPARE_BY_IDENTITY_F = 4096;
    @Deprecated
    public static final int TAINTED_F = 0;

    private RubyBasicObject() {
    }

    public static RubyClass createBasicObjectClass(Ruby runtime2, RubyClass objectClass) {
        objectClass.setClassIndex(ClassIndex.OBJECT);
        objectClass.defineAnnotatedMethods(RubyBasicObject.class);
        RubyBasicObject.recacheBuiltinMethods(runtime2);
        return objectClass;
    }

    static void recacheBuiltinMethods(Ruby runtime2) {
        RubyClass objectClass = runtime2.getBasicObject();
        runtime2.setDefaultMethodMissing(objectClass.searchMethod("method_missing"), objectClass.metaClass.searchMethod("method_missing"));
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        return context.nil;
    }

    @Deprecated
    public IRubyObject initialize19(ThreadContext context) {
        return this.initialize(context);
    }

    public RubyBasicObject(Ruby runtime2, RubyClass metaClass) {
        this.metaClass = metaClass;
        runtime2.addToObjectSpace(true, this);
    }

    public RubyBasicObject(RubyClass metaClass) {
        this.metaClass = metaClass;
    }

    protected RubyBasicObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace) {
        this.metaClass = metaClass;
        runtime2.addToObjectSpace(useObjectSpace, this);
    }

    protected final void testFrozen(String message2) {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError(message2, this);
        }
    }

    protected final void testFrozen() {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError((this.isClass() ? "Class: " : (this.isModule() ? "Module: " : "object: ")) + this.inspect(), this);
        }
    }

    public final void setFlag(int flag, boolean set2) {
        this.flags = set2 ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public final boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    @Override
    public final IRubyObject checkCallMethod(ThreadContext context, String name2) {
        return Helpers.invokeChecked(context, (IRubyObject)this, name2);
    }

    @Override
    public final IRubyObject checkCallMethod(ThreadContext context, JavaSites.CheckedSites sites) {
        return Helpers.invokeChecked(context, (IRubyObject)this, sites);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2) {
        return Helpers.invoke(context, this, name2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject arg2) {
        return Helpers.invoke(context, (IRubyObject)this, name2, arg2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject[] args2) {
        return Helpers.invoke(context, (IRubyObject)this, name2, args2);
    }

    public final IRubyObject callMethod(String name2, IRubyObject ... args2) {
        return Helpers.invoke(this.metaClass.runtime.getCurrentContext(), (IRubyObject)this, name2, args2);
    }

    public final IRubyObject callMethod(String name2, IRubyObject arg2) {
        return Helpers.invoke(this.metaClass.runtime.getCurrentContext(), (IRubyObject)this, name2, arg2);
    }

    public final IRubyObject callMethod(String name2) {
        return Helpers.invoke(this.metaClass.runtime.getCurrentContext(), this, name2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject[] args2, Block block) {
        return Helpers.invoke(context, (IRubyObject)this, name2, args2, block);
    }

    @Override
    public final boolean isNil() {
        return (this.flags & NIL_F) != 0;
    }

    @Override
    public final boolean isTrue() {
        return (this.flags & FALSE_F) == 0;
    }

    public final boolean isFalse() {
        return (this.flags & FALSE_F) != 0;
    }

    @Override
    public boolean isFrozen() {
        return (this.flags & FROZEN_F) != 0;
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.flags = frozen ? (this.flags |= FROZEN_F) : (this.flags &= ~FROZEN_F);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public boolean isSpecialConst() {
        return this.isImmediate() || !this.isTrue();
    }

    public boolean isSpecialObject() {
        return this.isImmediate() || this instanceof RubyBignum || this instanceof RubyFloat || this instanceof RubyRational || this instanceof RubyComplex;
    }

    @Override
    public final RubyClass getMetaClass() {
        return this.metaClass;
    }

    public static RubyClass getMetaClass(IRubyObject arg2) {
        return ((RubyBasicObject)arg2).metaClass;
    }

    @Override
    public RubyClass getSingletonClass() {
        RubyClass klass = this.metaClass.toSingletonClass(this);
        if (this.isFrozen()) {
            klass.setFrozen(true);
        }
        return klass;
    }

    public RubyClass makeMetaClass(RubyClass superClass) {
        MetaClass klass = new MetaClass(this.getRuntime(), superClass, this);
        this.setMetaClass(klass);
        klass.setMetaClass(superClass.getRealClass().metaClass);
        superClass.addSubclass(klass);
        return klass;
    }

    public void setMetaClass(RubyClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public final RubyClass getType() {
        return this.metaClass.getRealClass();
    }

    @Override
    public final boolean respondsTo(String name2) {
        Ruby runtime2 = this.metaClass.runtime;
        CacheEntry entry = this.metaClass.searchWithCache("respond_to?");
        DynamicMethod respondTo = entry.method;
        if (respondTo.equals(runtime2.getRespondToMethod()) && this.metaClass.searchMethod("respond_to_missing?").equals(runtime2.getRespondToMissingMethod())) {
            return this.metaClass.respondsToMethod(name2, false);
        }
        ThreadContext context = runtime2.getCurrentContext();
        RubySymbol mname = runtime2.newSymbol(name2);
        if (respondTo.isUndefined()) {
            return RubyBasicObject.sites((ThreadContext)context).respond_to.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)mname).isTrue();
        }
        return respondTo.callRespondTo(context, this, "respond_to?", entry.sourceModule, mname);
    }

    @Override
    public final boolean respondsToMissing(String name2) {
        return this.respondsToMissing(name2, true);
    }

    @Override
    public final boolean respondsToMissing(String name2, boolean incPrivate) {
        CacheEntry entry = this.metaClass.searchWithCache("respond_to_missing?");
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined()) {
            return false;
        }
        Ruby runtime2 = this.metaClass.runtime;
        return method2.call(runtime2.getCurrentContext(), (IRubyObject)this, entry.sourceModule, "respond_to_missing?", (IRubyObject)runtime2.newSymbol(name2), runtime2.newBoolean(incPrivate)).isTrue();
    }

    @Override
    public final Ruby getRuntime() {
        return this.metaClass.runtime;
    }

    @Override
    public Class<?> getJavaClass() {
        Object obj = JavaUtil.unwrapJava(this.dataGetStruct(), null);
        return obj != null ? obj.getClass() : this.getClass();
    }

    @Override
    public String asJavaString() {
        IRubyObject str = this.checkStringType();
        if (!str.isNil()) {
            return ((RubyString)str).asJavaString();
        }
        throw this.getRuntime().newTypeError(RubyStringBuilder.str(this.getRuntime(), this.inspect(), " is not a string"));
    }

    @Override
    public RubyString asString() {
        Ruby runtime2 = this.metaClass.runtime;
        ThreadContext context = runtime2.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        IRubyObject str = sites.to_s.call(context, this, this);
        if (!(str instanceof RubyString)) {
            return (RubyString)this.anyToString();
        }
        return (RubyString)str;
    }

    @Override
    public RubyArray convertToArray() {
        Ruby runtime2 = this.metaClass.runtime;
        ThreadContext context = runtime2.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        return (RubyArray)TypeConverter.convertToType(context, this, runtime2.getArray(), sites.to_ary_checked);
    }

    @Override
    public RubyHash convertToHash() {
        Ruby runtime2 = this.metaClass.runtime;
        ThreadContext context = runtime2.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        return (RubyHash)TypeConverter.convertToType(context, this, runtime2.getHash(), sites.to_hash_checked);
    }

    @Override
    public RubyFloat convertToFloat() {
        Ruby runtime2 = this.metaClass.runtime;
        ThreadContext context = runtime2.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        return (RubyFloat)TypeConverter.convertToType(context, this, runtime2.getFloat(), sites.to_f_checked);
    }

    @Override
    public RubyInteger convertToInteger() {
        Ruby runtime2 = this.metaClass.runtime;
        ThreadContext context = runtime2.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        IRubyObject result2 = TypeConverter.convertToType(context, (IRubyObject)this, runtime2.getInteger(), sites.to_int_checked, true);
        if (!(result2 instanceof RubyInteger)) {
            throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, (RubyModule)this.getMetaClass()), "#to_int should return Integer"));
        }
        return (RubyInteger)result2;
    }

    @Override
    public RubyInteger convertToInteger(String convertMethod) {
        IRubyObject result2;
        if (convertMethod.equals("to_int")) {
            return this.convertToInteger();
        }
        Ruby runtime2 = this.metaClass.runtime;
        if (convertMethod.equals("to_i")) {
            ThreadContext context = runtime2.getCurrentContext();
            JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
            result2 = TypeConverter.convertToType(context, (IRubyObject)this, runtime2.getInteger(), sites.to_i_checked, true);
        } else {
            result2 = TypeConverter.convertToType((IRubyObject)this, runtime2.getInteger(), convertMethod, true);
        }
        if (!(result2 instanceof RubyInteger)) {
            throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, (RubyModule)this.getMetaClass()), "#", RubyStringBuilder.ids(runtime2, convertMethod), " should return Integer"));
        }
        return (RubyInteger)result2;
    }

    @Override
    public RubyString convertToString() {
        Ruby runtime2 = this.metaClass.runtime;
        ThreadContext context = runtime2.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        return (RubyString)TypeConverter.convertToType(context, this, runtime2.getString(), sites.to_str_checked);
    }

    @Override
    public IRubyObject anyToString() {
        Ruby runtime2 = this.metaClass.runtime;
        String hex2 = Integer.toHexString(System.identityHashCode(this));
        ByteList className = this.metaClass.getRealClass().toRubyString(runtime2.getCurrentContext()).getByteList();
        ByteList bytes2 = new ByteList(2 + className.realSize() + 3 + hex2.length() + 1);
        bytes2.setEncoding(className.getEncoding());
        bytes2.append(35).append(60);
        bytes2.append(className);
        bytes2.append(58).append(48).append(120);
        bytes2.append(hex2.getBytes());
        bytes2.append(62);
        RubyString str = RubyString.newString(runtime2, bytes2);
        return str;
    }

    public RubyString decode(String id2) {
        return (RubyString)this.getRuntime().newSymbol(id2).to_s();
    }

    @Override
    public IRubyObject checkStringType() {
        Ruby runtime2 = this.metaClass.runtime;
        ThreadContext context = runtime2.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        return TypeConverter.checkStringType(context, sites.to_str_checked, this);
    }

    @Override
    public final IRubyObject checkStringType19() {
        return this.checkStringType();
    }

    @Override
    public IRubyObject checkArrayType() {
        Ruby runtime2 = this.metaClass.runtime;
        ThreadContext context = runtime2.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        return TypeConverter.checkArrayType(context, sites.to_ary_checked, this);
    }

    @Override
    public <T> T toJava(Class<T> target) {
        return this.defaultToJava(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T defaultToJava(Class<T> target) {
        if (target == Void.TYPE) {
            return null;
        }
        Object value2 = this.unwrap_java_object();
        if (value2 != null) {
            if (target.isAssignableFrom(value2.getClass())) {
                this.getRuntime().getJavaSupport().getObjectProxyCache().put(value2, this);
                return (T)value2;
            }
        } else {
            if (JavaUtil.isDuckTypeConvertable(this.getClass(), target)) {
                RubyBasicObject rubyBasicObject = this;
                synchronized (rubyBasicObject) {
                    if (this.unwrap_java_object() != null) {
                        return this.defaultToJava(target);
                    }
                    return JavaUtil.convertProcToInterface(this.getRuntime().getCurrentContext(), this, target);
                }
            }
            if (target.isAssignableFrom(this.getClass())) {
                return (T)this;
            }
        }
        throw this.getRuntime().newTypeError("cannot convert instance of " + this.getClass() + " to " + target);
    }

    private Object unwrap_java_object() {
        Object innerWrapper = this.dataGetStruct();
        if (innerWrapper instanceof JavaProxy) {
            return ((JavaProxy)innerWrapper).getObject();
        }
        return null;
    }

    @Override
    public IRubyObject dup() {
        if (this.isSpecialObject()) {
            return this;
        }
        IRubyObject dup2 = this.metaClass.getRealClass().allocate();
        ThreadContext context = this.getRuntime().getCurrentContext();
        RubyBasicObject.initCopy(context, dup2, this);
        RubyBasicObject.sites((ThreadContext)context).initialize_dup.call(context, dup2, dup2, (IRubyObject)this);
        return dup2;
    }

    private static void initCopy(ThreadContext context, IRubyObject clone2, IRubyObject original) {
        assert (!clone2.isFrozen()) : "frozen object (" + clone2.getMetaClass().getName() + ") allocated";
        original.copySpecialInstanceVariables(clone2);
        if (original.hasVariables()) {
            clone2.syncVariables(original);
        }
        if (original instanceof RubyModule) {
            RubyModule cloneMod = (RubyModule)clone2;
            cloneMod.syncConstants((RubyModule)original);
            cloneMod.syncClassVariables((RubyModule)original);
        }
    }

    protected static boolean OBJ_INIT_COPY(IRubyObject obj, IRubyObject orig) {
        if (obj == orig) {
            return false;
        }
        RubyBasicObject.objInitCopy(obj, orig);
        return true;
    }

    protected static void objInitCopy(IRubyObject obj, IRubyObject orig) {
        if (obj == orig) {
            return;
        }
        ((RubyBasicObject)obj).checkFrozen();
        if (obj.getClass() != orig.getClass() || obj.getMetaClass().getRealClass() != orig.getMetaClass().getRealClass()) {
            throw obj.getRuntime().newTypeError("initialize_copy should take same class object");
        }
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
    }

    static RubyString inspect(ThreadContext context, IRubyObject object) {
        return RubyString.objAsString(context, Helpers.invokedynamic(context, object, MethodNames.INSPECT));
    }

    @Override
    public IRubyObject rbClone() {
        Ruby runtime2 = this.getRuntime();
        return this.rbCloneInternal(runtime2.getCurrentContext(), runtime2.getNil());
    }

    public IRubyObject rbClone(ThreadContext context, IRubyObject maybeOpts) {
        IRubyObject kwfreeze = ArgsUtil.getFreezeOpt(context, maybeOpts);
        return this.rbCloneInternal(context, kwfreeze);
    }

    private RubyBasicObject rbCloneInternal(ThreadContext context, IRubyObject freeze2) {
        if (this.isSpecialObject()) {
            Ruby runtime2 = context.runtime;
            if (freeze2 == runtime2.getFalse()) {
                throw runtime2.newArgumentError(RubyStringBuilder.str(runtime2, "can't unfreeze ", RubyStringBuilder.types(runtime2, (RubyModule)this.getType())));
            }
            return this;
        }
        RubyBasicObject clone2 = (RubyBasicObject)this.metaClass.getRealClass().allocate();
        clone2.setMetaClass(this.getSingletonClassCloneAndAttach(clone2));
        RubyBasicObject.initCopy(context, clone2, this);
        if (freeze2 == context.nil) {
            RubyBasicObject.sites((ThreadContext)context).initialize_clone.call(context, (IRubyObject)clone2, (IRubyObject)clone2, (IRubyObject)this);
            if (this.isFrozen()) {
                clone2.setFrozen(true);
            }
        } else {
            RubyHash opts = RubyHash.newHash(context.runtime, this.getRuntime().newSymbol("freeze"), freeze2);
            context.callInfo = 2;
            RubyBasicObject.sites((ThreadContext)context).initialize_clone.call(context, (IRubyObject)clone2, (IRubyObject)clone2, (IRubyObject)this, (IRubyObject)opts);
            if (freeze2 == context.tru) {
                clone2.setFrozen(true);
            }
        }
        return clone2;
    }

    protected RubyClass getSingletonClassClone() {
        return this.getSingletonClassCloneAndAttach(null);
    }

    protected RubyClass getSingletonClassCloneAndAttach(RubyBasicObject attach2) {
        RubyClass klass = this.getMetaClass();
        if (!klass.isSingleton()) {
            return klass;
        }
        MetaClass clone2 = new MetaClass(this.getRuntime(), klass.getSuperClass(), attach2);
        clone2.flags = klass.flags;
        if (this instanceof RubyClass) {
            clone2.setMetaClass(clone2);
        } else {
            clone2.setMetaClass(klass.getSingletonClassClone());
        }
        if (klass.hasVariables()) {
            clone2.syncVariables(klass);
        }
        clone2.syncConstants(klass);
        klass.cloneMethods(clone2);
        ((MetaClass)clone2.getMetaClass()).setAttached(clone2);
        return clone2;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public synchronized void dataWrapStruct(Object obj) {
        if (obj == null) {
            this.removeInternalVariable("__wrap_struct__");
        } else {
            this.fastSetInternalVariable("__wrap_struct__", obj);
        }
    }

    @Override
    public synchronized Object dataGetStruct() {
        return this.getInternalVariable("__wrap_struct__");
    }

    @Override
    @JRubyMethod(name={"__id__"})
    public IRubyObject id() {
        return this.getRuntime().newFixnum(this.getObjectId());
    }

    protected long getObjectId() {
        return this.metaClass.getRealClass().getVariableTableManager().getObjectId(this);
    }

    @Override
    public IRubyObject inspect() {
        if (!this.isImmediate() && !(this instanceof RubyModule) && this.hasVariables()) {
            return this.hashyInspect();
        }
        return this.to_s();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IRubyObject hashyInspect() {
        Ruby runtime2 = this.getRuntime();
        RubyString part = Inspector.inspectPrefix(runtime2.getCurrentContext(), this.metaClass.getRealClass(), this.inspectHashCode());
        if (runtime2.isInspecting(this)) {
            EncodingUtils.encStrBufCat(runtime2, part, Inspector.SPACE_DOT_DOT_DOT_GT);
            return part;
        }
        try {
            runtime2.registerInspecting(this);
            RubyString rubyString = this.inspectObj(runtime2, part);
            return rubyString;
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
    }

    public static IRubyObject rbInspect(ThreadContext context, IRubyObject obj) {
        Ruby runtime2 = context.runtime;
        RubyString str = RubyBasicObject.sites((ThreadContext)context).inspect.call(context, obj, obj).asString();
        Encoding enc = runtime2.getDefaultInternalEncoding();
        if (enc == null) {
            enc = runtime2.getDefaultExternalEncoding();
        }
        if (!enc.isAsciiCompatible()) {
            if (!str.isAsciiOnly()) {
                return RubyString.rbStrEscape(context, str);
            }
            return str;
        }
        if (str.getEncoding() != enc && !str.isAsciiOnly()) {
            return RubyString.rbStrEscape(context, str);
        }
        return str;
    }

    protected int inspectHashCode() {
        return System.identityHashCode(this);
    }

    private RubyString inspectObj(Ruby runtime2, RubyString part) {
        ThreadContext context = runtime2.getCurrentContext();
        boolean first2 = true;
        for (Map.Entry<String, VariableAccessor> entry : this.metaClass.getVariableTableManager().getVariableAccessorsForRead().entrySet()) {
            RubySymbol symbol;
            Object value2 = entry.getValue().get(this);
            if (!(value2 instanceof IRubyObject) || !(symbol = runtime2.newSymbol(entry.getKey())).validInstanceVariableName()) continue;
            IRubyObject obj = (IRubyObject)value2;
            if (!first2) {
                EncodingUtils.encStrBufCat(runtime2, part, Inspector.COMMA);
            }
            EncodingUtils.encStrBufCat(runtime2, part, Inspector.SPACE);
            EncodingUtils.encStrBufCat(runtime2, part, symbol.asString().encode(context, runtime2.getEncodingService().convertEncodingToRubyEncoding(part.getEncoding())).asString().getByteList());
            EncodingUtils.encStrBufCat(runtime2, part, Inspector.EQUALS);
            EncodingUtils.encStrBufCat(runtime2, part, RubyBasicObject.sites((ThreadContext)context).inspect.call(context, obj, obj).convertToString().getByteList());
            first2 = false;
        }
        EncodingUtils.encStrBufCat(runtime2, part, Inspector.GT);
        return part;
    }

    @JRubyMethod(name={"!"})
    public IRubyObject op_not(ThreadContext context) {
        return this.isTrue() ? context.fals : context.tru;
    }

    @JRubyMethod(name={"!="}, required=1)
    public IRubyObject op_not_equal(ThreadContext context, IRubyObject other) {
        return RubyBoolean.newBoolean(context, !RubyBasicObject.sites((ThreadContext)context).op_equal.call(context, (IRubyObject)this, (IRubyObject)this, other).isTrue());
    }

    @Override
    public int compareTo(IRubyObject other) {
        Ruby runtime2 = this.metaClass.runtime;
        IRubyObject cmp2 = Helpers.invokedynamic(runtime2.getCurrentContext(), (IRubyObject)this, MethodNames.OP_CMP, other);
        if (!cmp2.isNil()) {
            return (int)cmp2.convertToInteger().getLongValue();
        }
        return 0;
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        return this == obj ? context.tru : context.fals;
    }

    @Deprecated
    public IRubyObject op_equal_19(ThreadContext context, IRubyObject obj) {
        return this.op_equal(context, obj);
    }

    @Override
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return context.nil;
    }

    protected static boolean equalInternal(ThreadContext context, IRubyObject that, IRubyObject other) {
        return that == other || Helpers.invokedynamic(context, that, MethodNames.OP_EQUAL, other).isTrue();
    }

    @Override
    public boolean eql(IRubyObject other) {
        return Helpers.invokedynamic(this.metaClass.runtime.getCurrentContext(), (IRubyObject)this, MethodNames.EQL, other).isTrue();
    }

    @Override
    public void addFinalizer(IRubyObject f) {
        Finalizer finalizer = (Finalizer)this.getInternalVariable("__finalizer__");
        if (finalizer == null) {
            long id2 = this.getObjectId();
            IRubyObject fixnumId = this.id();
            this.getRuntime().getObjectSpace().registerObjectId(id2, this);
            finalizer = new Finalizer(fixnumId);
            this.setInternalVariable("__finalizer__", finalizer);
            this.getRuntime().addFinalizer(finalizer);
        }
        finalizer.addFinalizer(f);
    }

    @Override
    public void removeFinalizers() {
        Finalizer finalizer = (Finalizer)this.getInternalVariable("__finalizer__");
        if (finalizer != null) {
            finalizer.removeFinalizers();
            this.removeInternalVariable("__finalizer__");
            this.getRuntime().removeFinalizer(finalizer);
        }
    }

    @Override
    public Object getVariable(int index2) {
        return VariableAccessor.getVariable(this, index2);
    }

    @Override
    public void setVariable(int index2, Object value2) {
        this.ensureInstanceVariablesSettable();
        if (index2 < 0) {
            return;
        }
        this.metaClass.getVariableTableManager().setVariableInternal(this, index2, value2);
    }

    public final Object getFFIHandle() {
        return this.metaClass.getVariableTableManager().getFFIHandle(this);
    }

    public final void setFFIHandle(Object value2) {
        this.metaClass.getVariableTableManager().setFFIHandle(this, value2);
    }

    @Override
    public boolean hasVariables() {
        return this.metaClass.getVariableTableManager().hasVariables(this);
    }

    protected boolean hasInstanceVariables() {
        return this.metaClass.getVariableTableManager().hasInstanceVariables(this);
    }

    @Override
    public List<Variable<Object>> getVariableList() {
        Map<String, VariableAccessor> ivarAccessors = this.metaClass.getVariableAccessorsForRead();
        ArrayList<Variable<Object>> list2 = new ArrayList<Variable<Object>>(ivarAccessors.size());
        for (Map.Entry<String, VariableAccessor> entry : ivarAccessors.entrySet()) {
            Object value2 = entry.getValue().get(this);
            if (value2 == null) continue;
            list2.add(new VariableEntry<Object>(entry.getKey(), value2));
        }
        return list2;
    }

    @Override
    public List<String> getVariableNameList() {
        Map<String, VariableAccessor> ivarAccessors = this.metaClass.getVariableAccessorsForRead();
        ArrayList<String> list2 = new ArrayList<String>(ivarAccessors.size());
        for (Map.Entry<String, VariableAccessor> entry : ivarAccessors.entrySet()) {
            Object value2 = entry.getValue().get(this);
            if (value2 == null) continue;
            list2.add(entry.getKey());
        }
        return list2;
    }

    protected boolean variableTableContains(String name2) {
        return this.metaClass.getVariableAccessorForRead(name2).get(this) != null;
    }

    protected Object variableTableFetch(String name2) {
        return this.metaClass.getVariableAccessorForRead(name2).get(this);
    }

    protected Object variableTableStore(String name2, Object value2) {
        this.metaClass.getVariableAccessorForWrite(name2).set(this, value2);
        return value2;
    }

    protected Object variableTableRemove(String name2) {
        return this.metaClass.getVariableTableManager().clearVariable(this, name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void variableTableSync(List<Variable<Object>> vars) {
        RubyBasicObject rubyBasicObject = this;
        synchronized (rubyBasicObject) {
            for (Variable<Object> var : vars) {
                this.variableTableStore(var.getName(), var.getValue());
            }
        }
    }

    @Override
    public InternalVariables getInternalVariables() {
        return this;
    }

    @Override
    public boolean hasInternalVariable(String name2) {
        assert (!IdUtil.isRubyVariable(name2));
        return this.variableTableContains(name2);
    }

    @Override
    public Object getInternalVariable(String name2) {
        assert (!IdUtil.isRubyVariable(name2));
        return this.variableTableFetch(name2);
    }

    @Override
    public void setInternalVariable(String name2, Object value2) {
        assert (!IdUtil.isRubyVariable(name2));
        this.variableTableStore(name2, value2);
    }

    @Override
    public Object removeInternalVariable(String name2) {
        assert (!IdUtil.isRubyVariable(name2));
        return this.variableTableRemove(name2);
    }

    @Override
    public void syncVariables(IRubyObject other) {
        this.metaClass.getVariableTableManager().syncVariables(this, other);
    }

    @Override
    public InstanceVariables getInstanceVariables() {
        return this;
    }

    @Override
    public boolean hasInstanceVariable(String name2) {
        return this.variableTableContains(name2);
    }

    @Override
    public IRubyObject getInstanceVariable(String name2) {
        return (IRubyObject)this.variableTableFetch(name2);
    }

    @Override
    public IRubyObject setInstanceVariable(String name2, IRubyObject value2) {
        assert (value2 != null);
        this.ensureInstanceVariablesSettable();
        return (IRubyObject)this.variableTableStore(name2, value2);
    }

    @Override
    public IRubyObject removeInstanceVariable(String name2) {
        this.ensureInstanceVariablesSettable();
        return (IRubyObject)this.variableTableRemove(name2);
    }

    @Override
    public List<Variable<IRubyObject>> getInstanceVariableList() {
        Map<String, VariableAccessor> ivarAccessors = this.metaClass.getVariableAccessorsForRead();
        ArrayList<Variable<IRubyObject>> list2 = new ArrayList<Variable<IRubyObject>>(ivarAccessors.size());
        for (Map.Entry<String, VariableAccessor> entry : ivarAccessors.entrySet()) {
            String key2 = entry.getKey();
            Object value2 = entry.getValue().get(this);
            if (!(value2 instanceof IRubyObject) || !IdUtil.isInstanceVariable(key2)) continue;
            list2.add(new VariableEntry<IRubyObject>(key2, (IRubyObject)value2));
        }
        return list2;
    }

    @Override
    public List<String> getInstanceVariableNameList() {
        Map<String, VariableAccessor> ivarAccessors = this.metaClass.getVariableAccessorsForRead();
        ArrayList<String> list2 = new ArrayList<String>(ivarAccessors.size());
        for (Map.Entry<String, VariableAccessor> entry : ivarAccessors.entrySet()) {
            String key2 = entry.getKey();
            Object value2 = entry.getValue().get(this);
            if (!(value2 instanceof IRubyObject) || !IdUtil.isInstanceVariable(key2)) continue;
            list2.add(key2);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyInstanceVariablesInto(InstanceVariables other) {
        for (Variable<IRubyObject> var : this.getInstanceVariableList()) {
            RubyBasicObject rubyBasicObject = this;
            synchronized (rubyBasicObject) {
                other.setInstanceVariable(var.getName(), var.getValue());
            }
        }
    }

    public final void ensureInstanceVariablesSettable() {
        if (!this.isFrozen()) {
            return;
        }
        this.raiseFrozenError();
    }

    private void raiseFrozenError() throws RaiseException {
        if (this instanceof RubyModule) {
            throw this.getRuntime().newFrozenError("class/module ", this);
        }
        throw this.getRuntime().newFrozenError(this);
    }

    @Override
    @Deprecated
    public final int getNativeTypeIndex() {
        return this.getNativeClassIndex().ordinal();
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.BASICOBJECT;
    }

    public boolean isBuiltin(String methodName) {
        return this.metaClass.isMethodBuiltin(methodName);
    }

    @JRubyMethod(name={"singleton_method_added"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_added(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.nil;
    }

    @JRubyMethod(name={"singleton_method_removed"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_removed(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.nil;
    }

    @JRubyMethod(name={"singleton_method_undefined"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_undefined(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.nil;
    }

    @Deprecated
    public static IRubyObject singleton_method_added19(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return RubyBasicObject.singleton_method_added(context, recv2, symbolId, block);
    }

    @Deprecated
    public static IRubyObject singleton_method_removed19(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return RubyBasicObject.singleton_method_removed(context, recv2, symbolId, block);
    }

    @Deprecated
    public static IRubyObject singleton_method_undefined19(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return RubyBasicObject.singleton_method_undefined(context, recv2, symbolId, block);
    }

    @JRubyMethod(name={"method_missing"}, rest=true, module=true, omit=true, visibility=Visibility.PRIVATE)
    public static IRubyObject method_missing(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Visibility lastVis = context.getLastVisibility();
        CallType lastCallType = context.getLastCallType();
        if (args2.length == 0 || !(args2[0] instanceof RubySymbol)) {
            throw context.runtime.newArgumentError("no id given");
        }
        return RubyKernel.methodMissingDirect(context, recv2, (RubySymbol)args2[0], lastVis, lastCallType, args2);
    }

    @Deprecated
    public static IRubyObject method_missing19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyBasicObject.method_missing(context, recv2, args2, block);
    }

    @JRubyMethod(name={"__send__"}, omit=true, keywords=true)
    public IRubyObject send(ThreadContext context, IRubyObject arg0, Block block) {
        String name2 = RubySymbol.checkID(arg0);
        StaticScope staticScope = context.getCurrentStaticScope();
        return this.getMetaClass().finvokeWithRefinements(context, this, staticScope, name2, block);
    }

    @JRubyMethod(name={"__send__"}, omit=true, keywords=true)
    public IRubyObject send(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        String name2 = RubySymbol.checkID(arg0);
        StaticScope staticScope = context.getCurrentStaticScope();
        arg1 = IRRuntimeHelpers.dupIfKeywordRestAtCallsite(context, arg1);
        return this.getMetaClass().finvokeWithRefinements(context, (IRubyObject)this, staticScope, name2, arg1, block);
    }

    @JRubyMethod(name={"__send__"}, omit=true, keywords=true)
    public IRubyObject send(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        String name2 = RubySymbol.checkID(arg0);
        StaticScope staticScope = context.getCurrentStaticScope();
        arg2 = IRRuntimeHelpers.dupIfKeywordRestAtCallsite(context, arg2);
        return this.getMetaClass().finvokeWithRefinements(context, this, staticScope, name2, arg1, arg2, block);
    }

    @JRubyMethod(name={"__send__"}, required=1, rest=true, omit=true, keywords=true)
    public IRubyObject send(ThreadContext context, IRubyObject[] args2, Block block) {
        int callInfo = context.callInfo;
        if (args2.length > 0) {
            if ((callInfo & 1) != 0) {
                IRubyObject last2 = args2[args2.length - 1];
                if (last2 instanceof RubyHash && ((RubyHash)last2).isRuby2KeywordHash()) {
                    args2[args2.length - 1] = ((RubyHash)last2).dupFast(context);
                    ((RubyHash)args2[args2.length - 1]).setRuby2KeywordHash(false);
                    context.callInfo |= 6;
                }
            } else if (args2.length > 1) {
                args2[args2.length - 1] = IRRuntimeHelpers.dupIfKeywordRestAtCallsite(context, args2[args2.length - 1]);
            }
        }
        String name2 = RubySymbol.checkID(args2[0]);
        StaticScope staticScope = context.getCurrentStaticScope();
        int length2 = args2.length - 1;
        args2 = length2 == 0 ? IRubyObject.NULL_ARRAY : ArraySupport.newCopy(args2, 1, length2);
        return this.getMetaClass().finvokeWithRefinements(context, (IRubyObject)this, staticScope, name2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject yieldUnder(ThreadContext context, RubyModule under, IRubyObject[] args2, Block block, EvalType evalType) {
        context.preExecuteUnder(this, under, block);
        IRubyObject savedBindingSelf = block.getBinding().getSelf();
        IRubyObject savedFrameSelf = block.getBinding().getFrame().getSelf();
        Visibility savedVisibility = block.getBinding().getVisibility();
        block.getBinding().setVisibility(Visibility.PUBLIC);
        try {
            if (args2.length == 1) {
                IRubyObject valueInYield = args2[0];
                IRubyObject iRubyObject = this.setupBlock(block, evalType).yieldNonArray(context, valueInYield, this);
                return iRubyObject;
            }
            RubyArray valueInYield = RubyArray.newArrayMayCopy(context.runtime, args2);
            IRubyObject iRubyObject = this.setupBlock(block, evalType).yieldArray(context, valueInYield, this);
            return iRubyObject;
        }
        finally {
            block.getBinding().setVisibility(savedVisibility);
            block.getBinding().setSelf(savedBindingSelf);
            block.getBinding().getFrame().setSelf(savedFrameSelf);
            context.postExecuteUnder();
        }
    }

    private Block setupBlock(Block block, EvalType evalType) {
        block = block.getProcObject() == null ? block.cloneBlockForEval(this, evalType) : block.deepCloneBlockForEval(this, evalType);
        block.getBinding().setVisibility(Visibility.PUBLIC);
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject yieldUnder(ThreadContext context, RubyModule under, Block block, EvalType evalType) {
        context.preExecuteUnder(this, under, block);
        try {
            IRubyObject iRubyObject = this.setupBlock(block, evalType).yieldNonArray(context, this, this);
            return iRubyObject;
        }
        finally {
            context.postExecuteUnder();
        }
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, Block block, EvalType evalType) {
        if (!block.isGiven()) {
            throw context.runtime.newArgumentError(0, 1, 3);
        }
        return this.yieldUnder(context, mod, block, evalType);
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg2, Block block, EvalType evalType) {
        if (block.isGiven()) {
            throw context.runtime.newArgumentError(1, 0);
        }
        RubyString evalStr = arg2 instanceof RubyString ? (RubyString)arg2 : arg2.convertToString();
        String file2 = "(eval)";
        int line = 0;
        return this.evalUnder(context, mod, evalStr, file2, line, evalType);
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg0, IRubyObject arg1, Block block, EvalType evalType) {
        if (block.isGiven()) {
            throw context.runtime.newArgumentError(2, 0);
        }
        RubyString evalStr = arg0 instanceof RubyString ? (RubyString)arg0 : arg0.convertToString();
        String file2 = arg1.convertToString().asJavaString();
        int line = 0;
        return this.evalUnder(context, mod, evalStr, file2, line, evalType);
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block, EvalType evalType) {
        if (block.isGiven()) {
            throw context.runtime.newArgumentError(2, 0);
        }
        RubyString evalStr = arg0 instanceof RubyString ? (RubyString)arg0 : arg0.convertToString();
        String file2 = arg1.convertToString().asJavaString();
        int line = (int)(arg2.convertToInteger().getLongValue() - 1L);
        return this.evalUnder(context, mod, evalStr, file2, line, evalType);
    }

    protected RubyModule getInstanceEvalClass() {
        if (this.isImmediate()) {
            return this.getRuntime().getDummy();
        }
        return this.getSingletonClass();
    }

    public IRubyObject evalUnder(ThreadContext context, RubyModule under, RubyString src, String file2, int line, EvalType evalType) {
        return Interpreter.evalSimple(context, under, this, src, file2, line, evalType);
    }

    @JRubyMethod(name={"equal?"}, required=1)
    public IRubyObject equal_p(ThreadContext context, IRubyObject other) {
        return this == other ? context.tru : context.fals;
    }

    @Deprecated
    public IRubyObject equal_p19(ThreadContext context, IRubyObject other) {
        return this.equal_p(context, other);
    }

    public IRubyObject eql_p(IRubyObject obj) {
        return this == obj ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (this == other || Helpers.invokedynamic(context, (IRubyObject)this, MethodNames.OP_EQUAL, other).isTrue()) {
            return RubyFixnum.zero(context.runtime);
        }
        return context.nil;
    }

    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != original.getMetaClass().getRealClass()) {
            throw this.getRuntime().newTypeError("initialize_copy should take same class object");
        }
        return this;
    }

    public void checkFrozen() {
        this.testFrozen();
    }

    @Deprecated
    public final RubyBoolean respond_to_p(IRubyObject mname) {
        return this.getRuntime().newBoolean(this.getMetaClass().respondsToMethod(mname.asJavaString(), true));
    }

    @Deprecated
    public final RubyBoolean respond_to_p19(IRubyObject mname) {
        return this.respond_to_p(this.getRuntime().getCurrentContext(), mname, false);
    }

    @Deprecated
    public final RubyBoolean respond_to_p(IRubyObject mname, IRubyObject includePrivate) {
        String name2 = mname.asJavaString();
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name2, !includePrivate.isTrue()));
    }

    @Deprecated
    public final RubyBoolean respond_to_p19(IRubyObject mname, IRubyObject includePrivate) {
        return this.respond_to_p(this.getRuntime().getCurrentContext(), mname, includePrivate.isTrue());
    }

    final RubyBoolean respond_to_p(ThreadContext context, IRubyObject methodName, boolean includePrivate) {
        RubySymbol name2 = TypeConverter.checkID(methodName);
        if (this.getMetaClass().respondsToMethod(name2.idString(), !includePrivate, context.getCurrentStaticScope())) {
            return context.tru;
        }
        Ruby runtime2 = context.runtime;
        IRubyObject result2 = RubyBasicObject.sites((ThreadContext)context).respond_to_missing.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)name2, (IRubyObject)runtime2.newBoolean(includePrivate));
        return context.runtime.newBoolean(result2.isTrue());
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(super.hashCode());
    }

    public RubyClass type() {
        return this.getMetaClass().getRealClass();
    }

    @Deprecated
    public RubyClass type_deprecated() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Object#type is deprecated; use Object#class");
        return this.type();
    }

    public IRubyObject display(ThreadContext context, IRubyObject[] args2) {
        IRubyObject port = args2.length == 0 ? context.runtime.getGlobalVariables().get("$>") : args2[0];
        port.callMethod(context, "write", this);
        return context.nil;
    }

    public IRubyObject freeze(ThreadContext context) {
        if ((this.flags & FROZEN_F) == 0) {
            this.flags |= FROZEN_F;
        }
        return this;
    }

    public RubyBoolean frozen_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isFrozen());
    }

    public RubyBoolean instance_of_p(ThreadContext context, IRubyObject type2) {
        if (this.type() == type2) {
            return context.tru;
        }
        if (!(type2 instanceof RubyModule)) {
            throw context.runtime.newTypeError("class or module required");
        }
        return context.fals;
    }

    public RubyBoolean kind_of_p(ThreadContext context, IRubyObject type2) {
        if (!(type2 instanceof RubyModule)) {
            throw context.runtime.newTypeError("class or module required");
        }
        return RubyBoolean.newBoolean(context, ((RubyModule)type2).isInstance(this));
    }

    public IRubyObject methods(ThreadContext context, IRubyObject ... args2) {
        return this.methodsImpl(context, args2.length == 1 ? args2[0].isTrue() : true);
    }

    @Deprecated
    public IRubyObject methods19(ThreadContext context, IRubyObject[] args2) {
        return this.methods(context, args2);
    }

    final IRubyObject methodsImpl(ThreadContext context, boolean all) {
        RubyArray methods2 = RubyArray.newArray(context.runtime);
        HashSet<String> seen = new HashSet<String>();
        RubyClass metaClass = this.getMetaClass();
        if (metaClass.isSingleton()) {
            metaClass.populateInstanceMethodNames(seen, methods2, Visibility.PRIVATE, false, true, false);
            if (all) {
                metaClass.getSuperClass().populateInstanceMethodNames(seen, methods2, Visibility.PRIVATE, false, true, true);
            }
        } else if (all) {
            metaClass.populateInstanceMethodNames(seen, methods2, Visibility.PRIVATE, false, true, true);
        }
        return methods2;
    }

    @Deprecated
    public final IRubyObject methods(ThreadContext context, IRubyObject[] args2, boolean useSymbols) {
        return this.methodsImpl(context, args2.length == 1 ? args2[0].isTrue() : true);
    }

    public IRubyObject public_methods(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().instanceMethods(args2, Visibility.PUBLIC, true, false);
    }

    @Deprecated
    public IRubyObject public_methods19(ThreadContext context, IRubyObject[] args2) {
        return this.public_methods(context, args2);
    }

    public IRubyObject protected_methods(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().instanceMethods(args2, Visibility.PROTECTED, true, false);
    }

    @Deprecated
    public IRubyObject protected_methods19(ThreadContext context, IRubyObject[] args2) {
        return this.protected_methods(context, args2);
    }

    public IRubyObject private_methods(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().instanceMethods(args2, Visibility.PRIVATE, true, false);
    }

    @Deprecated
    public IRubyObject private_methods19(ThreadContext context, IRubyObject[] args2) {
        return this.private_methods(context, args2);
    }

    public RubyArray singleton_methods(ThreadContext context, IRubyObject[] args2) {
        Set names2;
        Ruby runtime2 = context.runtime;
        boolean all = args2.length == 1 ? args2[0].isTrue() : true;
        RubyClass klass = this.metaClass;
        RubyModule origin = klass.getMethodLocation();
        Set set2 = names2 = klass.isSingleton() || all ? new HashSet() : Collections.EMPTY_SET;
        if (klass.isSingleton()) {
            origin.getMethods().forEach((k, v) -> {
                if (v.getVisibility() != Visibility.PRIVATE) {
                    names2.add(runtime2.newSymbol((String)k));
                }
            });
            klass = klass.getSuperClass();
        }
        if (all) {
            while (klass != null && (klass.isSingleton() || klass.isIncluded())) {
                if (klass != origin) {
                    klass.getMethods().forEach((k, v) -> {
                        if (v.getVisibility() != Visibility.PRIVATE) {
                            names2.add(runtime2.newSymbol((String)k));
                        }
                    });
                }
                klass = klass.getSuperClass();
            }
        }
        if (names2.isEmpty()) {
            return runtime2.newEmptyArray();
        }
        return RubyArray.newArray(runtime2, names2);
    }

    public IRubyObject singleton_method(IRubyObject name2) {
        RubySymbol symbol = TypeConverter.checkID(name2);
        String methodName = symbol.idString();
        RubyClass klass = this.metaClass;
        if (klass.isSingleton()) {
            CacheEntry entry = klass.searchWithCache(methodName);
            if (klass == entry.method.getDefinedClass()) {
                RubyMethod newMethod = RubyMethod.newMethod(klass, methodName, klass, methodName, entry, this);
                return newMethod;
            }
        }
        throw this.getRuntime().newNameError(RubyStringBuilder.str(this.getRuntime(), "undefined method `", symbol, "' for `", this.inspect(), "'"), symbol);
    }

    public IRubyObject method(IRubyObject name2) {
        RubySymbol symbol = TypeConverter.checkID(name2);
        return this.getMetaClass().newMethod((IRubyObject)this, symbol.idString(), true, null, true);
    }

    public IRubyObject method(IRubyObject name2, StaticScope refinedScope) {
        RubySymbol symbol = TypeConverter.checkID(name2);
        return this.getMetaClass().newMethod((IRubyObject)this, symbol.idString(), refinedScope, true, null, true);
    }

    @Deprecated
    public IRubyObject method19(IRubyObject name2) {
        return this.method(name2);
    }

    public IRubyObject to_s() {
        return this.anyToString();
    }

    public RubyArray to_a(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        runtime2.getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "default 'to_a' will be obsolete");
        return runtime2.newArray((IRubyObject)this);
    }

    @JRubyMethod(name={"instance_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_eval(ThreadContext context, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), block, EvalType.INSTANCE_EVAL);
    }

    @JRubyMethod(name={"instance_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, block, EvalType.INSTANCE_EVAL);
    }

    @JRubyMethod(name={"instance_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, block, EvalType.INSTANCE_EVAL);
    }

    @JRubyMethod(name={"instance_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, arg2, block, EvalType.INSTANCE_EVAL);
    }

    @JRubyMethod(name={"instance_eval"}, rest=true, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_eval(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.instance_eval(context, block);
            }
            case 1: {
                return this.instance_eval(context, args2[0], block);
            }
            case 2: {
                return this.instance_eval(context, args2[0], args2[1], block);
            }
            case 3: {
                return this.instance_eval(context, args2[0], args2[1], args2[2], block);
            }
        }
        throw context.runtime.newArgumentError(args2.length, 1, 3);
    }

    @Deprecated
    public IRubyObject instance_eval19(ThreadContext context, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), block, EvalType.INSTANCE_EVAL);
    }

    @Deprecated
    public IRubyObject instance_eval19(ThreadContext context, IRubyObject arg0, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, block, EvalType.INSTANCE_EVAL);
    }

    @Deprecated
    public IRubyObject instance_eval19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, block, EvalType.INSTANCE_EVAL);
    }

    @Deprecated
    public IRubyObject instance_eval19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, arg2, block, EvalType.INSTANCE_EVAL);
    }

    @JRubyMethod(name={"instance_exec"}, optional=3, rest=true, keywords=true, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_exec(ThreadContext context, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            throw context.runtime.newLocalJumpErrorNoBlock();
        }
        RubyClass klazz = this.isImmediate() ? context.runtime.getDummy() : this.getSingletonClass();
        return this.yieldUnder(context, klazz, args2, block, EvalType.INSTANCE_EVAL);
    }

    @Deprecated
    public IRubyObject instance_exec19(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.instance_exec(context, args2, block);
    }

    public IRubyObject extend(IRubyObject[] args2) {
        Ruby runtime2 = this.metaClass.runtime;
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (args2[i2].isModule()) continue;
            throw runtime2.newTypeError(args2[i2], runtime2.getModule());
        }
        ThreadContext context = runtime2.getCurrentContext();
        for (int i3 = args2.length - 1; i3 >= 0; --i3) {
            args2[i3].callMethod(context, "extend_object", this);
            args2[i3].callMethod(context, "extended", this);
        }
        return this;
    }

    @Deprecated
    public IRubyObject send(ThreadContext context, Block block) {
        throw context.runtime.newArgumentError(0, 1);
    }

    @Deprecated
    public IRubyObject send19(ThreadContext context, IRubyObject arg0, Block block) {
        return this.send(context, arg0, block);
    }

    @Deprecated
    public IRubyObject send19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.send(context, arg0, arg1, block);
    }

    @Deprecated
    public IRubyObject send19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.send(context, arg0, arg1, arg2, block);
    }

    @Deprecated
    public IRubyObject send19(ThreadContext context, IRubyObject[] args2, Block block) {
        if (args2.length == 0) {
            throw context.runtime.newArgumentError(0, 1);
        }
        return this.send(context, args2, block);
    }

    public IRubyObject nil_p(ThreadContext context) {
        return context.fals;
    }

    public IRubyObject op_match(ThreadContext context, IRubyObject arg2) {
        return context.nil;
    }

    public IRubyObject op_not_match(ThreadContext context, IRubyObject arg2) {
        return RubyBoolean.newBoolean(context, !RubyBasicObject.sites((ThreadContext)context).match.call(context, (IRubyObject)this, (IRubyObject)this, arg2).isTrue());
    }

    public IRubyObject instance_variable_defined_p(ThreadContext context, IRubyObject name2) {
        return RubyBoolean.newBoolean(context, this.variableTableContains(this.validateInstanceVariable(name2)));
    }

    public IRubyObject instance_variable_get(ThreadContext context, IRubyObject name2) {
        Object value2 = this.variableTableFetch(this.validateInstanceVariable(name2));
        return value2 != null ? (IRubyObject)value2 : context.nil;
    }

    public IRubyObject instance_variable_set(IRubyObject name2, IRubyObject value2) {
        return (IRubyObject)this.variableTableStore(this.validateInstanceVariable(name2), value2);
    }

    public IRubyObject remove_instance_variable(ThreadContext context, IRubyObject name2, Block block) {
        this.ensureInstanceVariablesSettable();
        IRubyObject value2 = (IRubyObject)this.variableTableRemove(this.validateInstanceVariable(name2));
        if (value2 != null) {
            return value2;
        }
        throw context.runtime.newNameError("instance variable %1$s not defined", (IRubyObject)this, name2);
    }

    public RubyArray instance_variables(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        List<String> nameList = this.getInstanceVariableNameList();
        int size2 = nameList.size();
        RubyArray array2 = RubyArray.newBlankArrayInternal(runtime2, size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            array2.eltInternalSet(i2, runtime2.newSymbol(nameList.get(i2)));
        }
        array2.realLength = size2;
        return array2;
    }

    @Deprecated
    public RubyArray instance_variables19(ThreadContext context) {
        return this.instance_variables(context);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof IRubyObject) {
            ThreadContext context = this.metaClass.runtime.getCurrentContext();
            JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
            IRubyObject equals = Helpers.invokeChecked(context, (IRubyObject)this, sites.equals_checked, (IRubyObject)other);
            if (equals == null) {
                return false;
            }
            return equals.isTrue();
        }
        return false;
    }

    public int hashCode() {
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        IRubyObject hashValue = Helpers.invokeChecked(context, (IRubyObject)this, RubyBasicObject.sites((ThreadContext)context).hash_checked);
        if (hashValue == null) {
            return super.hashCode();
        }
        if (hashValue instanceof RubyFixnum) {
            return (int)RubyNumeric.fix2long(hashValue);
        }
        return RubyBasicObject.nonFixnumHashCode(hashValue);
    }

    protected static int nonFixnumHashCode(IRubyObject hashValue) {
        RubyInteger integer = hashValue.convertToInteger();
        if (integer instanceof RubyBignum) {
            return integer.getBigIntegerValue().intValue();
        }
        return (int)integer.getLongValue();
    }

    @Deprecated
    protected String validateInstanceVariable(String name2) {
        if (IdUtil.isValidInstanceVariableName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("`%1$s' is not allowable as an instance variable name", (IRubyObject)this, name2);
    }

    @Deprecated
    protected String validateInstanceVariable(IRubyObject name2, String _unused_) {
        return this.validateInstanceVariable(name2);
    }

    protected String validateInstanceVariable(IRubyObject name2) {
        return RubySymbol.retrieveIDSymbol(name2, (sym, newSym) -> {
            if (!sym.validInstanceVariableName()) {
                throw this.getRuntime().newNameError("`%1$s' is not allowable as an instance variable name", (IRubyObject)this, name2);
            }
        }).idString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.metaClass.isSingleton()) {
            throw new IOException("can not serialize singleton object");
        }
        oos.defaultWriteObject();
        oos.writeUTF(this.metaClass.getName());
        this.metaClass.getVariableTableManager().serializeVariables(this, oos);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Ruby ruby = Ruby.getThreadLocalRuntime();
        if (ruby == null) {
            throw new IOException("No thread-local org.jruby.Ruby available; can't deserialize Ruby object. Set with Ruby#setThreadLocalRuntime.");
        }
        ois.defaultReadObject();
        this.metaClass = (RubyClass)ruby.getClassFromPath(ois.readUTF());
        this.metaClass.getVariableTableManager().deserializeVariables(this, ois);
    }

    private static JavaSites.BasicObjectSites sites(ThreadContext context) {
        return context.sites.BasicObject;
    }

    @Deprecated
    protected RubyBasicObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace, boolean canBeTainted) {
        this(runtime2, metaClass, useObjectSpace);
    }

    @Override
    @Deprecated
    public IRubyObject callSuper(ThreadContext context, IRubyObject[] args2, Block block) {
        return Helpers.invokeSuper(context, (IRubyObject)this, args2, block);
    }

    @Override
    @Deprecated
    public final IRubyObject callMethod(ThreadContext context, int methodIndex, String name2) {
        return Helpers.invoke(context, this, name2);
    }

    @Override
    @Deprecated
    public final IRubyObject callMethod(ThreadContext context, int methodIndex, String name2, IRubyObject arg2) {
        return Helpers.invoke(context, (IRubyObject)this, name2, arg2, Block.NULL_BLOCK);
    }

    @Override
    @Deprecated
    public RubyInteger convertToInteger(int methodIndex, String convertMethod) {
        return this.convertToInteger(convertMethod);
    }

    @Override
    @Deprecated
    public int getVariableCount() {
        return this.getMetaClass().getVariableTableSize();
    }

    @Deprecated
    protected boolean variableTableFastContains(String internedName) {
        return this.variableTableContains(internedName);
    }

    @Deprecated
    protected Object variableTableFastFetch(String internedName) {
        return this.variableTableFetch(internedName);
    }

    @Deprecated
    protected Object variableTableFastStore(String internedName, Object value2) {
        return this.variableTableStore(internedName, value2);
    }

    @Override
    @Deprecated
    public boolean fastHasInternalVariable(String internedName) {
        return this.hasInternalVariable(internedName);
    }

    @Override
    @Deprecated
    public Object fastGetInternalVariable(String internedName) {
        return this.getInternalVariable(internedName);
    }

    @Override
    @Deprecated
    public void fastSetInternalVariable(String internedName, Object value2) {
        this.setInternalVariable(internedName, value2);
    }

    @Override
    @Deprecated
    public void syncVariables(List<Variable<Object>> variables) {
        this.variableTableSync(variables);
    }

    @Override
    @Deprecated
    public boolean fastHasInstanceVariable(String internedName) {
        return this.hasInstanceVariable(internedName);
    }

    @Override
    @Deprecated
    public IRubyObject fastGetInstanceVariable(String internedName) {
        return this.getInstanceVariable(internedName);
    }

    @Override
    @Deprecated
    public IRubyObject fastSetInstanceVariable(String internedName, IRubyObject value2) {
        return this.setInstanceVariable(internedName, value2);
    }

    @Override
    @Deprecated
    public boolean isUntrusted() {
        return false;
    }

    @Override
    @Deprecated
    public void setUntrusted(boolean untrusted) {
    }

    @Deprecated
    public RubyBoolean untrusted_p(ThreadContext context) {
        return context.fals;
    }

    @Deprecated
    public IRubyObject untrust(ThreadContext context) {
        return this;
    }

    @Deprecated
    public IRubyObject trust(ThreadContext context) {
        return this;
    }

    @Deprecated
    public final Object getNativeHandle() {
        return null;
    }

    @Deprecated
    public final void setNativeHandle(Object value2) {
    }

    @Override
    @Deprecated
    public synchronized Object dataGetStructChecked() {
        TypeConverter.checkData(this);
        return this.getInternalVariable("__wrap_struct__");
    }

    @Deprecated
    public IRubyObject op_match19(ThreadContext context, IRubyObject arg2) {
        return context.nil;
    }

    @Deprecated
    public RubyArray to_a() {
        return this.to_a(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public RubyBoolean tainted_p(ThreadContext context) {
        return context.fals;
    }

    @Deprecated
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    @Deprecated
    IRubyObject tainted() {
        return this;
    }

    @Deprecated
    protected final void taint(Ruby runtime2) {
    }

    @Deprecated
    public IRubyObject untaint(ThreadContext context) {
        return this;
    }

    @Override
    @Deprecated
    public boolean isTaint() {
        return false;
    }

    @Override
    @Deprecated
    public void setTaint(boolean taint2) {
    }

    @Override
    @Deprecated
    public IRubyObject infectBy(IRubyObject obj) {
        return this;
    }

    @Deprecated
    final RubyBasicObject infectBy(RubyBasicObject obj) {
        return this;
    }

    @Deprecated
    final RubyBasicObject infectBy(int tuFlags) {
        return this;
    }

    public static class Finalizer
    implements Finalizable {
        private final IRubyObject id;
        private final AtomicBoolean finalized;
        private IRubyObject firstFinalizer;
        private List<IRubyObject> finalizers;

        public Finalizer(RubyFixnum id2) {
            this((IRubyObject)id2);
        }

        Finalizer(IRubyObject id2) {
            this.id = id2;
            this.finalized = new AtomicBoolean(false);
        }

        public void addFinalizer(IRubyObject finalizer) {
            if (this.firstFinalizer == null) {
                this.firstFinalizer = finalizer;
            } else {
                if (this.finalizers == null) {
                    this.finalizers = new ArrayList<IRubyObject>(4);
                }
                this.finalizers.add(finalizer);
            }
        }

        public void removeFinalizers() {
            this.firstFinalizer = null;
            this.finalizers = null;
        }

        @Override
        public void finalize() {
            if (this.finalized.compareAndSet(false, true)) {
                if (this.firstFinalizer != null) {
                    this.callFinalizer(this.firstFinalizer);
                }
                if (this.finalizers != null) {
                    for (int i2 = 0; i2 < this.finalizers.size(); ++i2) {
                        this.callFinalizer(this.finalizers.get(i2));
                    }
                }
            }
        }

        private void callFinalizer(IRubyObject finalizer) {
            ThreadContext context = finalizer.getRuntime().getCurrentContext();
            try {
                RubyBasicObject.sites((ThreadContext)context).call.call(context, finalizer, finalizer, this.id);
            }
            finally {
                context.setErrorInfo(context.nil);
            }
        }
    }
}

