/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rules;

import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.rules.FieldTransform;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import io.confluent.kafka.schemaregistry.rules.RuleExecutor;
import java.util.Objects;

public interface FieldRuleExecutor
extends RuleExecutor {
    public FieldTransform newTransform(RuleContext var1) throws RuleException;

    @Override
    default public Object transform(RuleContext ctx, Object message) throws RuleException {
        switch (ctx.ruleMode()) {
            case WRITE: 
            case UPGRADE: {
                int i;
                for (i = ctx.index() + 1; i < ctx.rules().size(); ++i) {
                    if (!FieldRuleExecutor.haveSameTags(ctx.rule(), ctx.rules().get(i))) continue;
                    return message;
                }
                break;
            }
            case READ: 
            case DOWNGRADE: {
                int i;
                for (i = 0; i < ctx.index(); ++i) {
                    if (!FieldRuleExecutor.haveSameTags(ctx.rule(), ctx.rules().get(i))) continue;
                    return message;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported rule mode " + (Object)((Object)ctx.ruleMode()));
            }
        }
        try (FieldTransform transform = this.newTransform(ctx);){
            if (transform != null) {
                Object object = ctx.target().transformMessage(ctx, transform, message);
                return object;
            }
            Object object = message;
            return object;
        }
    }

    public static boolean haveSameTags(Rule rule1, Rule rule2) {
        return rule1.getKind() == rule2.getKind() && rule1.getMode() == rule2.getMode() && Objects.equals(rule1.getType(), rule2.getType()) && Objects.equals(rule1.getTags(), rule2.getTags());
    }
}

