/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.InternalTriggerExecutionContext;
import org.apache.derby.impl.sql.execute.TriggerEvent;

abstract class GenericTriggerExecutor {
    final InternalTriggerExecutionContext tec;
    final TriggerDescriptor triggerd;
    final Activation activation;
    private final LanguageConnectionContext lcc;
    private boolean whenClauseRetrieved;
    private boolean actionRetrieved;
    private SPSDescriptor whenClause;
    private SPSDescriptor action;
    private ExecPreparedStatement whenPS;
    private Activation spsWhenActivation;
    private ExecPreparedStatement actionPS;
    private Activation spsActionActivation;

    GenericTriggerExecutor(InternalTriggerExecutionContext internalTriggerExecutionContext, TriggerDescriptor triggerDescriptor, Activation activation, LanguageConnectionContext languageConnectionContext) {
        this.tec = internalTriggerExecutionContext;
        this.triggerd = triggerDescriptor;
        this.activation = activation;
        this.lcc = languageConnectionContext;
    }

    abstract void fireTrigger(TriggerEvent var1, CursorResultSet var2, CursorResultSet var3, int[] var4) throws StandardException;

    private SPSDescriptor getWhenClause() throws StandardException {
        if (!this.whenClauseRetrieved) {
            this.whenClauseRetrieved = true;
            this.whenClause = this.triggerd.getWhenClauseSPS(this.lcc);
        }
        return this.whenClause;
    }

    private SPSDescriptor getAction() throws StandardException {
        if (!this.actionRetrieved) {
            this.actionRetrieved = true;
            this.action = this.triggerd.getActionSPS(this.lcc);
        }
        return this.action;
    }

    private boolean executeSPS(SPSDescriptor sPSDescriptor, boolean bl) throws StandardException {
        Activation activation;
        boolean bl2 = false;
        boolean bl3 = false;
        ExecPreparedStatement execPreparedStatement = bl ? this.whenPS : this.actionPS;
        Activation activation2 = activation = bl ? this.spsWhenActivation : this.spsActionActivation;
        while (true) {
            Object object;
            if (execPreparedStatement == null || bl2) {
                this.lcc.getStatementContext().setActivation(this.activation);
                execPreparedStatement = sPSDescriptor.getPreparedStatement();
                execPreparedStatement = execPreparedStatement.getClone();
                execPreparedStatement.setValid();
                activation = execPreparedStatement.getActivation(this.lcc, false);
                execPreparedStatement.setSource(sPSDescriptor.getText());
                execPreparedStatement.setSPSAction();
                if (bl) {
                    this.whenPS = execPreparedStatement;
                    this.spsWhenActivation = activation;
                } else {
                    this.actionPS = execPreparedStatement;
                    this.spsActionActivation = activation;
                }
            }
            StatementContext statementContext = this.lcc.getStatementContext();
            try {
                ResultSet resultSet = execPreparedStatement.executeSubStatement(this.activation, activation, false, 0L);
                if (bl) {
                    object = resultSet.getNextRow();
                    DataValueDescriptor dataValueDescriptor = object.getColumn(1);
                    bl3 = !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
                } else if (resultSet.returnsRows()) {
                    while (resultSet.getNextRow() != null) {
                    }
                }
                resultSet.close();
            }
            catch (StandardException standardException) {
                object = this.lcc.getStatementContext();
                if (object != null && statementContext != object) {
                    object.cleanupOnError(standardException);
                }
                if (standardException.getMessageId().equals("XCL32.S")) {
                    bl2 = true;
                    sPSDescriptor.revalidate(this.lcc);
                    continue;
                }
                activation.close();
                throw standardException;
            }
            break;
        }
        return bl3;
    }

    protected void clearSPS() throws StandardException {
        if (this.spsActionActivation != null) {
            this.spsActionActivation.close();
        }
        this.actionPS = null;
        this.spsActionActivation = null;
        if (this.spsWhenActivation != null) {
            this.spsWhenActivation.close();
        }
        this.whenPS = null;
        this.spsWhenActivation = null;
    }

    final void executeWhenClauseAndAction() throws StandardException {
        SPSDescriptor sPSDescriptor = this.getWhenClause();
        if (sPSDescriptor == null || this.executeSPS(sPSDescriptor, true)) {
            this.executeSPS(this.getAction(), false);
        }
    }
}

