/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import java.io.IOException;
import json.ext.ByteListTranscoder;
import json.ext.Utils;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;

final class StringDecoder
extends ByteListTranscoder {
    private int surrogatePairStart = -1;
    private boolean allowControlCharacters = false;
    private ByteList out;
    private final byte[] aux = new byte[4];

    public StringDecoder(boolean bl) {
        this.allowControlCharacters = bl;
    }

    ByteList decode(ThreadContext threadContext, ByteList byteList, int n, int n2) {
        try {
            this.init(byteList, n, n2);
            this.out = new ByteList(n2 - n);
            while (this.hasNext()) {
                this.handleChar(threadContext, this.readUtf8Char(threadContext));
            }
            this.quoteStop(this.pos);
            return this.out;
        }
        catch (IOException iOException) {
            throw threadContext.runtime.newIOErrorFromException(iOException);
        }
    }

    @Override
    protected int readUtf8Char(ThreadContext threadContext) {
        int n = super.readUtf8Char(threadContext);
        if (n < 32 && !this.allowControlCharacters) {
            throw this.invalidControlChar(threadContext);
        }
        return n;
    }

    private void handleChar(ThreadContext threadContext, int n) throws IOException {
        if (n == 92) {
            this.quoteStop(this.charStart);
            this.handleEscapeSequence(threadContext);
        } else {
            this.quoteStart();
        }
    }

    private void handleEscapeSequence(ThreadContext threadContext) throws IOException {
        this.ensureMin(threadContext, 1);
        switch (this.readUtf8Char(threadContext)) {
            case 98: {
                this.append(8);
                break;
            }
            case 102: {
                this.append(12);
                break;
            }
            case 110: {
                this.append(10);
                break;
            }
            case 114: {
                this.append(13);
                break;
            }
            case 116: {
                this.append(9);
                break;
            }
            case 47: {
                this.append(47);
                break;
            }
            case 34: {
                this.append(34);
                break;
            }
            case 92: {
                this.append(92);
                break;
            }
            case 117: {
                this.ensureMin(threadContext, 4);
                int n = this.readHex(threadContext);
                if (Character.isHighSurrogate((char)n)) {
                    this.handleLowSurrogate(threadContext, (char)n);
                    break;
                }
                if (Character.isLowSurrogate((char)n)) {
                    throw this.invalidUtf8(threadContext);
                }
                this.writeUtf8Char(n);
                break;
            }
            default: {
                throw this.invalidEscape(threadContext);
            }
        }
    }

    @Override
    protected void append(int n) throws IOException {
        this.out.append(n);
    }

    @Override
    protected void append(byte[] byArray, int n, int n2) throws IOException {
        this.out.append(byArray, n, n2);
    }

    private void handleLowSurrogate(ThreadContext threadContext, char c) throws IOException {
        this.surrogatePairStart = this.charStart;
        this.ensureMin(threadContext, 1);
        int n = this.readUtf8Char(threadContext);
        if (n == 92) {
            this.ensureMin(threadContext, 5);
            if (this.readUtf8Char(threadContext) != 117) {
                throw this.invalidUtf8(threadContext);
            }
            n = this.readHex(threadContext);
        }
        if (!Character.isLowSurrogate((char)n)) {
            throw this.invalidUtf8(threadContext);
        }
        this.writeUtf8Char(Character.toCodePoint(c, (char)n));
        this.surrogatePairStart = -1;
    }

    private void writeUtf8Char(int n) throws IOException {
        if (n < 128) {
            this.append(n);
        } else if (n < 2048) {
            this.aux[0] = (byte)(0xC0 | n >>> 6);
            this.aux[1] = this.tailByte(n & 0x3F);
            this.append(this.aux, 0, 2);
        } else if (n < 65536) {
            this.aux[0] = (byte)(0xE0 | n >>> 12);
            this.aux[1] = this.tailByte(n >>> 6);
            this.aux[2] = this.tailByte(n);
            this.append(this.aux, 0, 3);
        } else {
            this.aux[0] = (byte)(0xF0 | n >>> 18);
            this.aux[1] = this.tailByte(n >>> 12);
            this.aux[2] = this.tailByte(n >>> 6);
            this.aux[3] = this.tailByte(n);
            this.append(this.aux, 0, 4);
        }
    }

    private byte tailByte(int n) {
        return (byte)(0x80 | n & 0x3F);
    }

    private int readHex(ThreadContext threadContext) {
        int n = this.pos;
        int n2 = 0;
        int n3 = 4;
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5 = this.readUtf8Char(threadContext);
            if (n5 >= 48 && n5 <= 57) {
                n4 = n5 - 48;
            } else if (n5 >= 97 && n5 <= 102) {
                n4 = 10 + n5 - 97;
            } else if (n5 >= 65 && n5 <= 70) {
                n4 = 10 + n5 - 65;
            } else {
                throw new NumberFormatException("Invalid base 16 number " + this.src.subSequence(n, n + n3));
            }
            n2 = n2 * 16 + n4;
        }
        return n2;
    }

    @Override
    protected RaiseException invalidUtf8(ThreadContext threadContext) {
        ByteList byteList = new ByteList(ByteList.plain((CharSequence)"partial character in source, but hit end near "));
        int n = this.surrogatePairStart != -1 ? this.surrogatePairStart : this.charStart;
        byteList.append(this.src, n, this.srcEnd - n);
        return Utils.newException(threadContext, "ParserError", threadContext.runtime.newString(byteList));
    }

    protected RaiseException invalidControlChar(ThreadContext threadContext) {
        ByteList byteList = new ByteList(ByteList.plain((CharSequence)"invalid ASCII control character in string: "));
        byteList.append(this.src, this.charStart, this.srcEnd - this.charStart);
        return Utils.newException(threadContext, "ParserError", threadContext.runtime.newString(byteList));
    }

    protected RaiseException invalidEscape(ThreadContext threadContext) {
        ByteList byteList = new ByteList(ByteList.plain((CharSequence)"invalid escape character in string: "));
        byteList.append(this.src, this.charStart, this.srcEnd - this.charStart);
        return Utils.newException(threadContext, "ParserError", threadContext.runtime.newString(byteList));
    }
}

