/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.support;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.fielddata.DocValueBits;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.LeafPointFieldData;
import org.elasticsearch.index.fielddata.MultiPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;
import org.elasticsearch.xpack.spatial.index.fielddata.IndexCartesianPointFieldData;

public abstract class CartesianPointValuesSource
extends ValuesSource {
    public static final CartesianPointValuesSource EMPTY = new CartesianPointValuesSource(){

        @Override
        public SortedNumericLongValues sortedNumericLongValues(LeafReaderContext context) {
            return SortedNumericLongValues.EMPTY;
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
            return FieldData.emptySortedBinary();
        }
    };

    @Override
    public DocValueBits docsWithValue(LeafReaderContext context) {
        MultiCartesianPointValues pointValues = this.pointValues(context);
        return FieldData.docsWithValue(pointValues);
    }

    @Override
    public final Function<Rounding, Rounding.Prepared> roundingPreparer(AggregationContext context) {
        throw AggregationErrors.unsupportedRounding("POINT");
    }

    public final MultiCartesianPointValues pointValues(LeafReaderContext context) {
        return new MultiCartesianPointValues(this.sortedNumericLongValues(context));
    }

    public abstract SortedNumericLongValues sortedNumericLongValues(LeafReaderContext var1);

    public static final class MultiCartesianPointValues
    extends MultiPointValues<CartesianPoint> {
        private final CartesianPoint point = new CartesianPoint();

        public MultiCartesianPointValues(SortedNumericLongValues numericValues) {
            super(numericValues);
        }

        @Override
        public CartesianPoint nextValue() throws IOException {
            return this.point.resetFromEncoded(this.numericValues.nextValue());
        }
    }

    public static class Fielddata
    extends CartesianPointValuesSource {
        protected final IndexCartesianPointFieldData indexFieldData;

        public Fielddata(IndexCartesianPointFieldData indexFieldData) {
            this.indexFieldData = indexFieldData;
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
            return ((LeafPointFieldData)this.indexFieldData.load(context)).getBytesValues();
        }

        @Override
        public SortedNumericLongValues sortedNumericLongValues(LeafReaderContext context) {
            return ((LeafPointFieldData)this.indexFieldData.load(context)).getSortedNumericLongValues();
        }
    }
}

