/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.spatial.search.aggregations.GeoShapeMetricAggregation;
import org.elasticsearch.xpack.spatial.search.aggregations.MergedGeoLines;

public class InternalGeoLine
extends InternalAggregation
implements GeoShapeMetricAggregation {
    private static final double SCALE = Math.pow(10.0, 6.0);
    private final long[] line;
    private final double[] sortVals;
    private final boolean complete;
    private final boolean includeSorts;
    private final SortOrder sortOrder;
    private final int size;
    private final boolean nonOverlapping;
    private final boolean simplified;

    InternalGeoLine(String name, long[] line, double[] sortVals, Map<String, Object> metadata, boolean complete, boolean includeSorts, SortOrder sortOrder, int size, boolean nonOverlapping, boolean simplified) {
        super(name, metadata);
        this.line = line;
        this.sortVals = sortVals;
        this.complete = complete;
        this.includeSorts = includeSorts;
        this.sortOrder = sortOrder;
        this.size = size;
        this.nonOverlapping = nonOverlapping;
        this.simplified = simplified;
    }

    public InternalGeoLine(StreamInput in) throws IOException {
        super(in);
        this.line = in.readLongArray();
        this.sortVals = in.readDoubleArray();
        this.complete = in.readBoolean();
        this.includeSorts = in.readBoolean();
        this.sortOrder = SortOrder.readFromStream(in);
        this.size = in.readVInt();
        this.nonOverlapping = in.readBoolean();
        this.simplified = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeLongArray(this.line);
        out.writeDoubleArray(this.sortVals);
        out.writeBoolean(this.complete);
        out.writeBoolean(this.includeSorts);
        this.sortOrder.writeTo(out);
        out.writeVInt(this.size);
        out.writeBoolean(this.nonOverlapping);
        out.writeBoolean(this.simplified);
    }

    @Override
    protected AggregatorReducer getLeaderReducer(AggregationReduceContext reduceContext, final int size) {
        return new AggregatorReducer(){
            final List<InternalGeoLine> internalGeoLines;
            int mergedSize;
            boolean reducedComplete;
            boolean reducedIncludeSorts;
            boolean reducedNonOverlapping;
            boolean reducedSimplified;
            {
                this.internalGeoLines = new ArrayList<InternalGeoLine>(size);
                this.mergedSize = 0;
                this.reducedComplete = true;
                this.reducedIncludeSorts = true;
                this.reducedNonOverlapping = InternalGeoLine.this.nonOverlapping;
                this.reducedSimplified = InternalGeoLine.this.simplified;
            }

            @Override
            public void accept(InternalAggregation aggregation) {
                InternalGeoLine geoLine = (InternalGeoLine)aggregation;
                this.internalGeoLines.add(geoLine);
                this.mergedSize += geoLine.line.length;
                this.reducedComplete &= geoLine.complete;
                this.reducedIncludeSorts &= geoLine.includeSorts;
                this.reducedNonOverlapping &= geoLine.nonOverlapping;
                this.reducedSimplified |= geoLine.simplified;
            }

            @Override
            public InternalAggregation get() {
                this.reducedComplete &= this.mergedSize <= InternalGeoLine.this.size();
                int finalSize = Math.min(this.mergedSize, InternalGeoLine.this.size());
                MergedGeoLines mergedGeoLines = this.reducedNonOverlapping ? new MergedGeoLines.NonOverlapping(this.internalGeoLines, finalSize, InternalGeoLine.this.sortOrder, this.reducedSimplified) : new MergedGeoLines.Overlapping(this.internalGeoLines, finalSize, InternalGeoLine.this.sortOrder, this.reducedSimplified);
                mergedGeoLines.merge();
                return new InternalGeoLine(InternalGeoLine.this.getName(), mergedGeoLines.getFinalPoints(), mergedGeoLines.getFinalSortValues(), InternalGeoLine.this.getMetadata(), this.reducedComplete, this.reducedIncludeSorts, InternalGeoLine.this.sortOrder(), InternalGeoLine.this.size(), InternalGeoLine.this.nonOverlapping, InternalGeoLine.this.simplified);
            }
        };
    }

    @Override
    protected boolean mustReduceOnSingleInternalAgg() {
        return true;
    }

    @Override
    public String getWriteableName() {
        return "geo_line";
    }

    public long[] line() {
        return this.line;
    }

    public double[] sortVals() {
        return this.sortVals;
    }

    public int length() {
        return this.line == null ? 0 : this.line.length;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean includeSorts() {
        return this.includeSorts;
    }

    public SortOrder sortOrder() {
        return this.sortOrder;
    }

    public int size() {
        return this.size;
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("type", "Feature").field("geometry", this.geoJSONGeometry()).startObject("properties").field("complete", this.isComplete());
        if (this.includeSorts) {
            builder.field("sort_values", this.sortVals);
        }
        builder.endObject();
        return builder;
    }

    private double roundDegrees(double degree) {
        return (double)Math.round(degree * SCALE) / SCALE;
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1 && "value".equals(path.get(0))) {
            return this.line;
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + String.valueOf(path));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.line), Arrays.hashCode(this.sortVals), this.complete, this.includeSorts, this.sortOrder, this.size);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalGeoLine that = (InternalGeoLine)obj;
        return super.equals(obj) && Arrays.equals(this.line, that.line) && Arrays.equals(this.sortVals, that.sortVals) && Objects.equals(this.complete, that.complete) && Objects.equals(this.includeSorts, that.includeSorts) && Objects.equals(this.sortOrder, that.sortOrder) && Objects.equals(this.size, that.size);
    }

    @Override
    public Map<String, Object> geoJSONGeometry() {
        ArrayList<double[]> coordinates = new ArrayList<double[]>();
        for (int i = 0; i < this.line.length; ++i) {
            int x = (int)(this.line[i] >> 32);
            int y = (int)this.line[i];
            coordinates.add(new double[]{this.roundDegrees(GeoEncodingUtils.decodeLongitude(x)), this.roundDegrees(GeoEncodingUtils.decodeLatitude(y))});
        }
        HashMap<String, Object> geoJSON = new HashMap<String, Object>();
        if (coordinates.size() == 1) {
            geoJSON.put("type", "Point");
            geoJSON.put("coordinates", coordinates.get(0));
        } else {
            geoJSON.put("type", "LineString");
            geoJSON.put("coordinates", coordinates.toArray());
        }
        return geoJSON;
    }
}

