/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.XYDocValuesField;
import org.apache.lucene.document.XYPointField;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeometryFormatterFactory;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractPointGeometryFieldMapper;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.blockloader.docvalues.LongsBlockLoader;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.lucene.spatial.XYQueriesUtils;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;
import org.elasticsearch.xpack.spatial.index.fielddata.plain.CartesianPointIndexFieldData;
import org.elasticsearch.xpack.spatial.index.mapper.ShapeQueryable;
import org.elasticsearch.xpack.spatial.script.field.CartesianPointDocValuesField;
import org.elasticsearch.xpack.spatial.search.aggregations.support.CartesianPointValuesSourceType;

public class PointFieldMapper
extends AbstractPointGeometryFieldMapper<CartesianPoint> {
    public static final String CONTENT_TYPE = "point";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings())));
    private final Builder builder;

    private static Builder builder(FieldMapper in) {
        return ((PointFieldMapper)in).builder;
    }

    public PointFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, CartesianPointParser parser, Builder builder) {
        super(simpleName, mappedFieldType, builderParams, builder.ignoreMalformed.get(), builder.ignoreZValue.get(), builder.nullValue.get(), parser);
        this.builder = builder;
    }

    @Override
    protected void index(DocumentParserContext context, CartesianPoint point) {
        boolean indexed = this.fieldType().indexType().hasPoints();
        boolean hasDocValues = this.fieldType().hasDocValues();
        boolean store = this.fieldType().isStored();
        if (indexed && hasDocValues) {
            context.doc().add(new XYFieldWithDocValues(this.fieldType().name(), (float)point.getX(), (float)point.getY()));
        } else if (hasDocValues) {
            context.doc().add(new XYDocValuesField(this.fieldType().name(), (float)point.getX(), (float)point.getY()));
        } else if (indexed) {
            context.doc().add(new XYPointField(this.fieldType().name(), (float)point.getX(), (float)point.getY()));
        }
        if (store) {
            context.doc().add(new StoredField(this.fieldType().name(), point.toString()));
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public PointFieldType fieldType() {
        return (PointFieldType)this.mappedFieldType;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.builder.ignoreMalformed.getDefaultValue().value()).init(this);
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> PointFieldMapper.builder((FieldMapper)m).indexed.get(), true);
        final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> PointFieldMapper.builder((FieldMapper)m).hasDocValues.get(), true);
        final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> PointFieldMapper.builder((FieldMapper)m).stored.get(), false);
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> PointFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<CartesianPoint> nullValue;
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name, boolean ignoreMalformedByDefault) {
            super(name);
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> PointFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), ignoreMalformedByDefault);
            this.nullValue = AbstractPointGeometryFieldMapper.nullValueParam(m -> PointFieldMapper.builder((FieldMapper)m).nullValue.get(), (n, c, o) -> o == null ? null : Builder.parseNullValue(o, this.ignoreZValue.get().value(), this.ignoreMalformed.get().value()), () -> null, XContentBuilder::field).acceptsNull();
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.ignoreZValue, this.nullValue, this.meta};
        }

        private static CartesianPoint parseNullValue(Object nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            CartesianPoint point = CartesianPoint.parsePoint(nullValue, ignoreZValue);
            if (!ignoreMalformed) {
                if (!Double.isFinite(point.getX())) {
                    throw new IllegalArgumentException("illegal x value [" + point.getX() + "]");
                }
                if (!Double.isFinite(point.getY())) {
                    throw new IllegalArgumentException("illegal y value [" + point.getY() + "]");
                }
            }
            return point;
        }

        @Override
        public FieldMapper build(MapperBuilderContext context) {
            if (this.multiFieldsBuilder.hasMultiFields()) {
                DEPRECATION_LOGGER.warn(DeprecationCategory.MAPPINGS, "point_multifields", "Adding multifields to [point] mappers has no effect", new Object[0]);
            }
            CartesianPointParser parser = new CartesianPointParser(this.leafName(), p -> CartesianPoint.parsePoint(p, (boolean)this.ignoreZValue.get().value()), this.nullValue.get(), this.ignoreZValue.get().value(), this.ignoreMalformed.get().value());
            PointFieldType ft = new PointFieldType(context.buildFullName(this.leafName()), this.indexed.get(), this.stored.get(), this.hasDocValues.get(), parser, this.nullValue.get(), context.isSourceSynthetic(), this.meta.get());
            return new PointFieldMapper(this.leafName(), ft, this.builderParams(this, context), parser, this);
        }
    }

    public static class PointFieldType
    extends AbstractPointGeometryFieldMapper.AbstractPointFieldType<CartesianPoint>
    implements ShapeQueryable {
        private final boolean isSyntheticSource;

        private PointFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, CartesianPointParser parser, CartesianPoint nullValue, boolean isSyntheticSource, Map<String, String> meta) {
            super(name, IndexType.points(indexed, hasDocValues), stored, parser, nullValue, meta);
            this.isSyntheticSource = isSyntheticSource;
        }

        public PointFieldType(String name) {
            this(name, true, false, true, null, null, false, Collections.emptyMap());
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return new CartesianPointIndexFieldData.Builder(this.name(), CartesianPointValuesSourceType.instance(), CartesianPointDocValuesField::new);
        }

        @Override
        public String typeName() {
            return PointFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query shapeQuery(Geometry shape, String fieldName, ShapeRelation relation, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            return XYQueriesUtils.toXYPointQuery(shape, fieldName, relation, this.indexType());
        }

        @Override
        protected Function<List<CartesianPoint>, List<Object>> getFormatter(String format) {
            return GeometryFormatterFactory.getFormatter(format, p -> new Point(p.getX(), p.getY()));
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (blContext.fieldExtractPreference() == MappedFieldType.FieldExtractPreference.DOC_VALUES && this.hasDocValues()) {
                return new LongsBlockLoader(this.name());
            }
            if (this.isSyntheticSource && blContext.parentField(this.name()) == null) {
                return this.blockLoaderFromFallbackSyntheticSource(blContext);
            }
            return this.blockLoaderFromSource(blContext);
        }
    }

    static class XYFieldWithDocValues
    extends Field {
        private static final FieldType TYPE = new FieldType();
        private final long docValue;

        XYFieldWithDocValues(String name, float x, float y) {
            super(name, TYPE);
            byte[] bytes;
            if (this.fieldsData == null) {
                bytes = new byte[8];
                this.fieldsData = new BytesRef(bytes);
            } else {
                bytes = ((BytesRef)this.fieldsData).bytes;
            }
            int xEncoded = XYEncodingUtils.encode(x);
            int yEncoded = XYEncodingUtils.encode(y);
            NumericUtils.intToSortableBytes(xEncoded, bytes, 0);
            NumericUtils.intToSortableBytes(yEncoded, bytes, 4);
            this.docValue = (long)xEncoded << 32 | (long)yEncoded & 0xFFFFFFFFL;
        }

        @Override
        public Number numericValue() {
            return this.docValue;
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.getClass().getSimpleName());
            result.append(" <");
            result.append(this.name);
            result.append(':');
            byte[] bytes = ((BytesRef)this.fieldsData).bytes;
            result.append(XYEncodingUtils.decode(bytes, 0));
            result.append(',');
            result.append(XYEncodingUtils.decode(bytes, 4));
            result.append('>');
            return result.toString();
        }

        static {
            TYPE.setDimensions(2, 4);
            TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
            TYPE.freeze();
        }
    }

    private static class CartesianPointParser
    extends AbstractPointGeometryFieldMapper.PointParser<CartesianPoint> {
        CartesianPointParser(String field, CheckedFunction<XContentParser, CartesianPoint, IOException> objectParser, CartesianPoint nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            super(field, objectParser, nullValue, ignoreZValue, ignoreMalformed, true);
        }

        @Override
        protected CartesianPoint validate(CartesianPoint in) {
            if (!this.ignoreMalformed) {
                if (!Double.isFinite(in.getX())) {
                    throw new IllegalArgumentException("illegal x value [" + in.getX() + "] for " + this.field);
                }
                if (!Double.isFinite(in.getY())) {
                    throw new IllegalArgumentException("illegal y value [" + in.getY() + "] for " + this.field);
                }
            }
            return in;
        }

        @Override
        protected CartesianPoint createPoint(double x, double y) {
            return new CartesianPoint(x, y);
        }

        @Override
        public CartesianPoint normalizeFromSource(CartesianPoint point) {
            return point;
        }
    }
}

