/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import java.io.IOException;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Point;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.geometry.utils.GeographyValidator;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;
import org.elasticsearch.xpack.spatial.index.fielddata.ShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.Tile2DVisitor;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSourceType;

public abstract class GeoShapeValues
extends ShapeValues<GeoShapeValue> {
    public static final GeoShapeValues EMPTY = new GeoShapeValues(){
        private final GeoShapeValuesSourceType DEFAULT_VALUES_SOURCE_TYPE = GeoShapeValuesSourceType.instance();

        @Override
        public boolean advanceExact(int doc) {
            return false;
        }

        @Override
        public ValuesSourceType valuesSourceType() {
            return this.DEFAULT_VALUES_SOURCE_TYPE;
        }

        @Override
        public GeoShapeValue value() {
            throw new UnsupportedOperationException();
        }
    };

    protected GeoShapeValues() {
        super(CoordinateEncoder.GEO, GeoShapeValue::new, new GeoShapeIndexer(Orientation.CCW, "missing"));
    }

    @Override
    public GeometryValidator geometryValidator() {
        return GeographyValidator.instance(true);
    }

    public static class GeoShapeValue
    extends ShapeValues.ShapeValue {
        private final Tile2DVisitor tile2DVisitor = new Tile2DVisitor();

        public GeoShapeValue() {
            super(CoordinateEncoder.GEO, (x, y) -> new GeoPoint((double)y, (double)x));
        }

        public GeoShapeValue(StreamInput in) throws IOException {
            this();
            this.reset(in);
        }

        @Override
        protected Component2D centroidAsComponent2D() throws IOException {
            return LatLonGeometry.create(new Point(this.getY(), this.getX()));
        }

        public GeoRelation relate(int minX, int maxX, int minY, int maxY) throws IOException {
            this.tile2DVisitor.reset(minX, minY, maxX, maxY);
            this.visit(this.tile2DVisitor);
            return this.tile2DVisitor.relation();
        }

        public GeoRelation relate(LatLonGeometry geometry) throws IOException {
            return this.relate(LatLonGeometry.create(geometry));
        }

        @Override
        public String getWriteableName() {
            return "GeoShapeValue";
        }
    }
}

