/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.action.TransformTaskMatcher;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class ScheduleNowTransformAction
extends ActionType<Response> {
    public static final ScheduleNowTransformAction INSTANCE = new ScheduleNowTransformAction();
    public static final String NAME = "cluster:admin/transform/schedule_now";

    private ScheduleNowTransformAction() {
        super(NAME);
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable,
    ToXContentObject {
        public static final Response TRUE = new Response(true);
        private final boolean acknowledged;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.acknowledged = in.readBoolean();
        }

        public Response(boolean acknowledged) {
            super(Collections.emptyList(), Collections.emptyList());
            this.acknowledged = acknowledged;
        }

        public Response(List<TaskOperationFailure> taskFailures, List<? extends ElasticsearchException> nodeFailures, boolean acknowledged) {
            super(taskFailures, nodeFailures);
            this.acknowledged = acknowledged;
        }

        public boolean isAcknowledged() {
            return this.acknowledged;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.acknowledged);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.toXContentCommon(builder, params);
            builder.field("acknowledged", this.acknowledged);
            builder.endObject();
            return builder;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.acknowledged == response.acknowledged;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.acknowledged);
        }
    }

    public static final class Request
    extends BaseTasksRequest<Request> {
        private final String id;

        public Request(String id, TimeValue timeout) {
            this.id = ExceptionsHelper.requireNonNull(id, TransformField.ID.getPreferredName());
            this.setTimeout(ExceptionsHelper.requireNonNull(timeout, TransformField.TIMEOUT.getPreferredName()));
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
        }

        public static Request fromXContent(String id, TimeValue timeout) {
            return new Request(id, timeout);
        }

        @Override
        public ActionRequestValidationException validate() {
            if ("_all".equals(this.id)) {
                ActionRequestValidationException e = new ActionRequestValidationException();
                e.addValidationError("_schedule_now API does not support _all wildcard");
                return e;
            }
            return null;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
        }

        public int hashCode() {
            return Objects.hash(this.getTimeout(), this.id);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return this.id.equals(other.id) && this.getTimeout().equals(other.getTimeout());
        }

        @Override
        public boolean match(Task task) {
            TransformTaskMatcher matcher;
            return task instanceof TransformTaskMatcher && (matcher = (TransformTaskMatcher)((Object)task)).match(this.id);
        }
    }
}

