/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.TaskId;

public class GetCheckpointNodeAction
extends ActionType<Response> {
    public static final GetCheckpointNodeAction INSTANCE = new GetCheckpointNodeAction();
    public static final String NAME = "indices:monitor/transform/checkpoint[n]";

    private GetCheckpointNodeAction() {
        super(NAME);
    }

    public static class Request
    extends LegacyActionRequest
    implements IndicesRequest {
        private final Set<ShardId> shards;
        private final OriginalIndices originalIndices;
        private final TimeValue timeout;

        public Request(Set<ShardId> shards, OriginalIndices originalIndices, TimeValue timeout) {
            this.shards = shards;
            this.originalIndices = originalIndices;
            this.timeout = timeout;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.shards = in.readCollectionAsImmutableSet(ShardId::new);
            this.originalIndices = OriginalIndices.readOriginalIndices(in);
            this.timeout = in.readOptionalTimeValue();
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeCollection(this.shards);
            OriginalIndices.writeOriginalIndices(this.originalIndices, out);
            out.writeOptionalTimeValue(this.timeout);
        }

        public Set<ShardId> getShards() {
            return this.shards;
        }

        public OriginalIndices getOriginalIndices() {
            return this.originalIndices;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Request that = (Request)obj;
            return Objects.equals(this.shards, that.shards) && Objects.equals(this.originalIndices, that.originalIndices) && Objects.equals(this.timeout, that.timeout);
        }

        public int hashCode() {
            return Objects.hash(this.shards, this.originalIndices, this.timeout);
        }

        @Override
        public String[] indices() {
            return this.originalIndices.indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.originalIndices.indicesOptions();
        }

        @Override
        public CancellableTask createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, Strings.format("get_checkpoint_node[%d;%d]", this.indices() != null ? this.indices().length : 0, this.shards != null ? this.shards.size() : 0), parentTaskId, headers);
        }
    }

    public static class Response
    extends ActionResponse {
        private final Map<String, long[]> checkpoints;

        public Response(Map<String, long[]> checkpoints) {
            this.checkpoints = checkpoints;
        }

        public Response(StreamInput in) throws IOException {
            this.checkpoints = in.readOrderedMap(StreamInput::readString, StreamInput::readLongArray);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.getCheckpoints(), StreamOutput::writeLongArray);
        }

        public Map<String, long[]> getCheckpoints() {
            return this.checkpoints;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Response that = (Response)obj;
            return this.checkpoints.size() == that.checkpoints.size() && this.checkpoints.entrySet().stream().allMatch(e -> Arrays.equals((long[])e.getValue(), that.checkpoints.get(e.getKey())));
        }

        public int hashCode() {
            int hash = 1;
            for (Map.Entry<String, long[]> e : this.checkpoints.entrySet()) {
                hash = 31 * hash + Objects.hash(e.getKey(), Arrays.hashCode(e.getValue()));
            }
            return hash;
        }
    }
}

