/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.xpack.core.ssl.SSLService;

public abstract class AbstractSslBuilder<T> {
    public T build(SslConfiguration config, SSLContext sslContext) {
        String[] ciphers = this.supportedCiphers(this.sslParameters(sslContext).getCipherSuites(), config.getCipherSuites(), false);
        String[] supportedProtocols = config.supportedProtocols().toArray(Strings.EMPTY_ARRAY);
        HostnameVerifier verifier = config.verificationMode().isHostnameVerificationEnabled() ? SSLIOSessionStrategy.getDefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE;
        return this.build(sslContext, supportedProtocols, ciphers, verifier);
    }

    String[] supportedCiphers(String[] supportedCiphers, List<String> requestedCiphers, boolean log) {
        return SSLService.supportedCiphers(supportedCiphers, requestedCiphers, log);
    }

    SSLParameters sslParameters(SSLContext sslContext) {
        return sslContext.getSupportedSSLParameters();
    }

    abstract T build(SSLContext var1, String[] var2, String[] var3, HostnameVerifier var4);
}

