/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.privilege;

import java.util.Collections;
import java.util.function.Predicate;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.admin.indices.readonly.TransportAddIndexBlockAction;
import org.elasticsearch.action.admin.indices.settings.put.TransportUpdateSettingsAction;
import org.elasticsearch.action.search.TransportSearchShardsAction;
import org.elasticsearch.index.seqno.RetentionLeaseActions;
import org.elasticsearch.persistent.CompletionPersistentTaskAction;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.xpack.core.security.action.ActionTypes;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.core.security.support.StringMatcher;

public final class SystemPrivilege
extends Privilege {
    public static final SystemPrivilege INSTANCE = new SystemPrivilege();
    private static final Predicate<String> ALLOWED_ACTIONS = StringMatcher.of("internal:*", "indices:monitor/*", "cluster:monitor/*", "cluster:admin/bootstrap/*", "cluster:admin/reroute", "indices:admin/mapping/put", "indices:admin/mapping/auto_put", "indices:admin/template/put", "indices:admin/template/delete", "indices:admin/seq_no/global_checkpoint_sync*", "indices:admin/reshard/split*", "indices:admin/seq_no/retention_lease_sync*", "indices:admin/seq_no/retention_lease_background_sync*", RetentionLeaseActions.ADD.name() + "*", RetentionLeaseActions.REMOVE.name() + "*", RetentionLeaseActions.RENEW.name() + "*", "indices:admin/settings/update", CompletionPersistentTaskAction.INSTANCE.name(), "indices:data/write/*", "indices:data/read/*", "indices:admin/refresh", "indices:admin/aliases", TransportCreateIndexAction.TYPE.name() + "*", TransportAddIndexBlockAction.TYPE.name() + "*", TransportUpdateSettingsAction.TYPE.name() + "*", TransportSearchShardsAction.TYPE.name(), ActionTypes.RELOAD_REMOTE_CLUSTER_CREDENTIALS_ACTION.name());
    private static final Predicate<String> PREDICATE = action -> {
        if (TransportActionProxy.isProxyAction(action)) {
            return ALLOWED_ACTIONS.test(TransportActionProxy.unwrapAction(action));
        }
        return ALLOWED_ACTIONS.test((String)action);
    };

    private SystemPrivilege() {
        super(Collections.singleton("internal"), new String[0]);
    }

    @Override
    public Predicate<String> predicate() {
        return PREDICATE;
    }
}

