/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptorsIntersection;
import org.elasticsearch.xpack.core.security.user.InternalUser;
import org.elasticsearch.xpack.core.security.user.InternalUsers;
import org.elasticsearch.xpack.core.security.user.User;

public final class CrossClusterAccessSubjectInfo {
    public static final String CROSS_CLUSTER_ACCESS_SUBJECT_INFO_HEADER_KEY = "_cross_cluster_access_subject_info";
    private static final Logger logger = LogManager.getLogger(CrossClusterAccessSubjectInfo.class);
    private static final Set<String> API_KEY_AUTHENTICATION_METADATA_TO_KEEP = Set.of("_security_api_key_id", "_security_api_key_name", "_security_api_key_creator_realm_name", "_security_api_key_creator_realm_type");
    private static final Set<String> SERVICE_ACCOUNT_AUTHENTICATION_METADATA_TO_KEEP = Set.of("_token_name", "_token_source");
    private final Authentication authentication;
    private final List<RoleDescriptorsBytes> roleDescriptorsBytesList;

    public CrossClusterAccessSubjectInfo(Authentication authentication, RoleDescriptorsIntersection roleDescriptorsIntersection) throws IOException {
        this(authentication, CrossClusterAccessSubjectInfo.toRoleDescriptorsBytesList(roleDescriptorsIntersection));
    }

    private CrossClusterAccessSubjectInfo(Authentication authentication, List<RoleDescriptorsBytes> roleDescriptorsBytesList) {
        this.authentication = authentication;
        this.roleDescriptorsBytesList = roleDescriptorsBytesList;
    }

    public void writeToContext(ThreadContext ctx) throws IOException {
        ctx.putHeader(CROSS_CLUSTER_ACCESS_SUBJECT_INFO_HEADER_KEY, this.encode());
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public CrossClusterAccessSubjectInfo cleanAndValidate() {
        if (this.authentication.isCrossClusterAccess()) {
            Subject effectiveSubject = this.authentication.getEffectiveSubject();
            throw new IllegalArgumentException("subject [" + effectiveSubject.getUser().principal() + "] has type [" + String.valueOf((Object)effectiveSubject.getType()) + "] but nested cross cluster access is not supported");
        }
        CrossClusterAccessSubjectInfo cleanCopy = new CrossClusterAccessSubjectInfo(this.copyAuthenticationWithCleanMetadata(), this.roleDescriptorsBytesList);
        cleanCopy.validate();
        return cleanCopy;
    }

    public List<RoleDescriptorsBytes> getRoleDescriptorsBytesList() {
        return this.roleDescriptorsBytesList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrossClusterAccessSubjectInfo that = (CrossClusterAccessSubjectInfo)o;
        if (!this.authentication.equals(that.authentication)) {
            return false;
        }
        return this.roleDescriptorsBytesList.equals(that.roleDescriptorsBytesList);
    }

    public int hashCode() {
        int result = this.authentication.hashCode();
        result = 31 * result + this.roleDescriptorsBytesList.hashCode();
        return result;
    }

    public String toString() {
        return "CrossClusterAccessSubjectInfo{authentication=" + String.valueOf(this.authentication) + ", roleDescriptorsBytesList=" + String.valueOf(this.roleDescriptorsBytesList) + "}";
    }

    private static List<RoleDescriptorsBytes> toRoleDescriptorsBytesList(RoleDescriptorsIntersection roleDescriptorsIntersection) throws IOException {
        assert (roleDescriptorsIntersection.roleDescriptorsList().stream().noneMatch(rds -> rds.size() > 1)) : "sets with more than one role descriptor are not supported for cross cluster access authentication";
        ArrayList<RoleDescriptorsBytes> roleDescriptorsBytesList = new ArrayList<RoleDescriptorsBytes>();
        for (Set<RoleDescriptor> roleDescriptors : roleDescriptorsIntersection.roleDescriptorsList()) {
            roleDescriptorsBytesList.add(RoleDescriptorsBytes.fromRoleDescriptors(roleDescriptors));
        }
        return roleDescriptorsBytesList;
    }

    public String encode() throws IOException {
        BytesStreamOutput out = new BytesStreamOutput();
        out.setTransportVersion(this.authentication.getEffectiveSubject().getTransportVersion());
        TransportVersion.writeVersion(this.authentication.getEffectiveSubject().getTransportVersion(), out);
        this.authentication.writeTo(out);
        out.writeCollection(this.roleDescriptorsBytesList);
        return Base64.getEncoder().encodeToString(BytesReference.toBytes(out.bytes()));
    }

    public static CrossClusterAccessSubjectInfo decode(String header) throws IOException {
        Objects.requireNonNull(header);
        byte[] bytes = Base64.getDecoder().decode(header);
        StreamInput in = StreamInput.wrap(bytes);
        TransportVersion version = TransportVersion.readVersion(in);
        in.setTransportVersion(version);
        Authentication authentication = new Authentication(in);
        List<RoleDescriptorsBytes> roleDescriptorsBytesList = in.readCollectionAsImmutableList(RoleDescriptorsBytes::new);
        return new CrossClusterAccessSubjectInfo(authentication, roleDescriptorsBytesList);
    }

    public Map<String, Object> copyWithCrossClusterAccessEntries(Map<String, Object> authenticationMetadata) {
        assert (!authenticationMetadata.containsKey("_security_cross_cluster_access_authentication")) : "metadata already contains [_security_cross_cluster_access_authentication] entry";
        assert (!authenticationMetadata.containsKey("_security_cross_cluster_access_role_descriptors")) : "metadata already contains [_security_cross_cluster_access_role_descriptors] entry";
        assert (!this.getAuthentication().isCrossClusterAccess()) : "authentication included in cross cluster access header cannot itself be cross cluster access";
        HashMap<String, Object> copy = new HashMap<String, Object>(authenticationMetadata);
        copy.put("_security_cross_cluster_access_authentication", this.getAuthentication());
        copy.put("_security_cross_cluster_access_role_descriptors", this.getRoleDescriptorsBytesList());
        return Collections.unmodifiableMap(copy);
    }

    private Authentication copyAuthenticationWithCleanMetadata() {
        assert (!this.authentication.isCrossClusterAccess());
        if (this.authentication.isAuthenticatedAsApiKey()) {
            return this.authentication.copyWithFilteredMetadataFields(API_KEY_AUTHENTICATION_METADATA_TO_KEEP);
        }
        if (this.authentication.isServiceAccount()) {
            return this.authentication.copyWithFilteredMetadataFields(SERVICE_ACCOUNT_AUTHENTICATION_METADATA_TO_KEEP);
        }
        return this.authentication.copyWithEmptyMetadata();
    }

    private void validate() {
        assert (!this.authentication.isCrossClusterAccess());
        this.authentication.checkConsistency();
        User user = this.authentication.getEffectiveSubject().getUser();
        if (user == InternalUsers.SYSTEM_USER) {
            if (!this.getRoleDescriptorsBytesList().isEmpty()) {
                logger.warn("Received non-empty remote access role descriptors bytes list for _system user. These will be ignored during authorization.");
                assert (false) : "role descriptors bytes list for internal cross cluster access user must be empty";
            }
        } else if (user instanceof InternalUser) {
            throw new IllegalArgumentException("received cross cluster request from an unexpected internal user [" + user.principal() + "]");
        }
    }

    public static final class RoleDescriptorsBytes
    implements Writeable {
        public static final RoleDescriptorsBytes EMPTY = new RoleDescriptorsBytes(new BytesArray("{}"));
        private static final RoleDescriptor.Parser ROLE_DESCRIPTOR_PARSER = RoleDescriptor.parserBuilder().allowRestriction(true).allowDescription(true).build();
        private final BytesReference rawBytes;

        public RoleDescriptorsBytes(BytesReference rawBytes) {
            this.rawBytes = rawBytes;
        }

        public RoleDescriptorsBytes(StreamInput streamInput) throws IOException {
            this(streamInput.readBytesReference());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBytesReference(this.rawBytes);
        }

        public String digest() {
            return MessageDigests.toHexString(MessageDigests.digest(this.rawBytes, MessageDigests.sha256()));
        }

        public static RoleDescriptorsBytes fromRoleDescriptors(Set<RoleDescriptor> roleDescriptors) throws IOException {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            for (RoleDescriptor roleDescriptor : roleDescriptors) {
                builder.field(roleDescriptor.getName(), roleDescriptor);
            }
            builder.endObject();
            return new RoleDescriptorsBytes(BytesReference.bytes(builder));
        }

        public Set<RoleDescriptor> toRoleDescriptors() {
            Set<RoleDescriptor> set;
            block9: {
                XContentParser parser = XContentHelper.createParser(XContentParserConfiguration.EMPTY, this.rawBytes, XContentType.JSON);
                try {
                    ArrayList<RoleDescriptor> roleDescriptors = new ArrayList<RoleDescriptor>();
                    parser.nextToken();
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        parser.nextToken();
                        String roleName = parser.currentName();
                        roleDescriptors.add(ROLE_DESCRIPTOR_PARSER.parse(roleName, parser));
                    }
                    set = Set.copyOf(roleDescriptors);
                    if (parser == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                parser.close();
            }
            return set;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RoleDescriptorsBytes that = (RoleDescriptorsBytes)o;
            return Objects.equals(this.rawBytes, that.rawBytes);
        }

        public int hashCode() {
            return Objects.hash(this.rawBytes);
        }

        public String toString() {
            return "RoleDescriptorsBytes{rawBytes=" + String.valueOf(this.rawBytes) + "}";
        }
    }
}

