/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.action.apikey.ApiKey;
import org.elasticsearch.xpack.core.security.action.apikey.BaseSingleUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.CertificateIdentity;
import org.elasticsearch.xpack.core.security.action.apikey.CrossClusterApiKeyRoleDescriptorBuilder;

public final class UpdateCrossClusterApiKeyRequest
extends BaseSingleUpdateApiKeyRequest {
    public UpdateCrossClusterApiKeyRequest(String id, @Nullable CrossClusterApiKeyRoleDescriptorBuilder roleDescriptorBuilder, @Nullable Map<String, Object> metadata, @Nullable TimeValue expiration, @Nullable CertificateIdentity certificateIdentity) {
        super(roleDescriptorBuilder == null ? null : List.of(roleDescriptorBuilder.build()), metadata, expiration, id, certificateIdentity);
    }

    @Override
    public ApiKey.Type getType() {
        return ApiKey.Type.CROSS_CLUSTER;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.roleDescriptors == null && this.metadata == null && this.certificateIdentity == null) {
            validationException = ValidateActions.addValidationError("must update [access], [metadata], or [certificate_identity] for cross-cluster API keys", validationException);
        }
        return validationException;
    }
}

