/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;

public class RollupFeatureSetUsage
extends XPackFeatureUsage {
    private final int numberOfRollupJobs;

    public RollupFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.numberOfRollupJobs = input.readVInt();
    }

    public RollupFeatureSetUsage(int numberOfRollupJobs) {
        super("rollup", true, true);
        this.numberOfRollupJobs = numberOfRollupJobs;
    }

    public int getNumberOfRollupJobs() {
        return this.numberOfRollupJobs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.numberOfRollupJobs);
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.field("number_of_rollup_jobs", this.numberOfRollupJobs);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }
}

