/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.template.put.TransportPutComposableIndexTemplateAction;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;

public final class MlIndexAndAlias {
    public static final String BWC_MAPPINGS_VERSION = "8.11.0";
    public static final String FIRST_INDEX_SIX_DIGIT_SUFFIX = "-000001";
    private static final Logger logger = LogManager.getLogger(MlIndexAndAlias.class);
    private static final Predicate<String> HAS_SIX_DIGIT_SUFFIX = Pattern.compile("\\d{6}").asMatchPredicate();
    private static final Predicate<String> IS_ANOMALIES_SHARED_INDEX = Pattern.compile(".ml-anomalies-shared-\\d{6}").asMatchPredicate();
    private static final Predicate<String> IS_ANOMALIES_STATE_INDEX = Pattern.compile(".ml-state-\\d{6}").asMatchPredicate();
    public static final String ROLLOVER_ALIAS_SUFFIX = ".rollover_alias";
    static final Comparator<String> INDEX_NAME_COMPARATOR = (index1, index2) -> {
        String[] index1Parts = index1.split("-");
        String index1Suffix = index1Parts[index1Parts.length - 1];
        boolean index1HasSixDigitsSuffix = HAS_SIX_DIGIT_SUFFIX.test(index1Suffix);
        String[] index2Parts = index2.split("-");
        String index2Suffix = index2Parts[index2Parts.length - 1];
        boolean index2HasSixDigitsSuffix = HAS_SIX_DIGIT_SUFFIX.test(index2Suffix);
        if (index1HasSixDigitsSuffix && index2HasSixDigitsSuffix) {
            return index1Suffix.compareTo(index2Suffix);
        }
        if (index1HasSixDigitsSuffix != index2HasSixDigitsSuffix) {
            return Boolean.compare(index1HasSixDigitsSuffix, index2HasSixDigitsSuffix);
        }
        return index1.compareTo((String)index2);
    };

    private MlIndexAndAlias() {
    }

    public static void createIndexAndAliasIfNecessary(Client client, ClusterState clusterState, IndexNameExpressionResolver resolver, String indexPatternPrefix, String alias, TimeValue masterNodeTimeout, ActiveShardCount waitForShardCount, ActionListener<Boolean> finalListener) {
        MlIndexAndAlias.createIndexAndAliasIfNecessary(client, clusterState, resolver, indexPatternPrefix, FIRST_INDEX_SIX_DIGIT_SUFFIX, alias, masterNodeTimeout, waitForShardCount, finalListener);
    }

    public static void createIndexAndAliasIfNecessary(Client client, ClusterState clusterState, IndexNameExpressionResolver resolver, String indexPatternPrefix, String indexNumber, String alias, TimeValue masterNodeTimeout, ActiveShardCount waitForShardCount, ActionListener<Boolean> finalListener) {
        Optional indexPointedByCurrentWriteAlias;
        ActionListener<Boolean> loggingListener = ActionListener.wrap(finalListener::onResponse, e -> {
            logger.error(() -> Strings.format("Failed to create alias and index with pattern [%s] and alias [%s]", indexPatternPrefix, alias), (Throwable)e);
            finalListener.onFailure((Exception)e);
        });
        ActionListener<Boolean> indexCreatedListener = loggingListener.delegateFailureAndWrap((delegate, created) -> {
            if (created.booleanValue()) {
                MlIndexAndAlias.waitForShardsReady(client, alias, masterNodeTimeout, delegate);
            } else {
                delegate.onResponse(false);
            }
        });
        String legacyIndexWithoutSuffix = indexPatternPrefix;
        String indexPattern = indexPatternPrefix + "*";
        String firstConcreteIndex = indexPatternPrefix + indexNumber;
        String[] concreteIndexNames = resolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandHidden(), indexPattern);
        Optional<Object> optional = indexPointedByCurrentWriteAlias = clusterState.getMetadata().getProject().hasAlias(alias) ? ((IndexAbstraction)clusterState.getMetadata().getProject().getIndicesLookup().get(alias)).getIndices().stream().map(Index::getName).findFirst() : Optional.empty();
        if (concreteIndexNames.length == 0) {
            if (indexPointedByCurrentWriteAlias.isEmpty()) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, true, waitForShardCount, masterNodeTimeout, indexCreatedListener);
                return;
            }
            logger.error("There are no indices matching '{}' pattern but '{}' alias points at [{}]. This should never happen.", (Object)indexPattern, (Object)alias, indexPointedByCurrentWriteAlias.get());
        } else if (concreteIndexNames.length == 1 && concreteIndexNames[0].equals(legacyIndexWithoutSuffix)) {
            if (indexPointedByCurrentWriteAlias.isEmpty()) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, true, waitForShardCount, masterNodeTimeout, indexCreatedListener);
                return;
            }
            if (((String)indexPointedByCurrentWriteAlias.get()).equals(legacyIndexWithoutSuffix)) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, false, waitForShardCount, masterNodeTimeout, indexCreatedListener.delegateFailureAndWrap((l, unused) -> MlIndexAndAlias.updateWriteAlias(client, alias, legacyIndexWithoutSuffix, firstConcreteIndex, masterNodeTimeout, l)));
                return;
            }
            logger.error("There is exactly one index (i.e. '{}') matching '{}' pattern but '{}' alias points at [{}]. This should never happen.", (Object)legacyIndexWithoutSuffix, (Object)indexPattern, (Object)alias, indexPointedByCurrentWriteAlias.get());
        } else if (indexPointedByCurrentWriteAlias.isEmpty()) {
            assert (concreteIndexNames.length > 0);
            String latestConcreteIndexName = MlIndexAndAlias.latestIndex(concreteIndexNames);
            MlIndexAndAlias.updateWriteAlias(client, alias, null, latestConcreteIndexName, masterNodeTimeout, loggingListener);
            return;
        }
        loggingListener.onResponse(false);
    }

    public static void createSystemIndexIfNecessary(Client client, ClusterState clusterState, SystemIndexDescriptor descriptor, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        String primaryIndex = descriptor.getPrimaryIndex();
        if (clusterState.getMetadata().getProject().hasIndexAbstraction(primaryIndex)) {
            finalListener.onResponse(true);
            return;
        }
        ActionListener<Boolean> indexCreatedListener = ActionListener.wrap(created -> {
            if (created.booleanValue()) {
                MlIndexAndAlias.waitForShardsReady(client, primaryIndex, masterNodeTimeout, finalListener);
            } else {
                finalListener.onResponse(false);
            }
        }, e -> {
            if (ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException) {
                finalListener.onResponse(true);
            } else {
                finalListener.onFailure((Exception)e);
            }
        });
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(primaryIndex);
        createIndexRequest.settings(descriptor.getSettings());
        createIndexRequest.mapping(descriptor.getMappings());
        createIndexRequest.origin("ml");
        createIndexRequest.masterNodeTimeout(masterNodeTimeout);
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", createIndexRequest, indexCreatedListener.delegateFailureAndWrap((l, r) -> l.onResponse(r.isAcknowledged())), client.admin().indices()::create);
    }

    private static void waitForShardsReady(Client client, String index, TimeValue masterNodeTimeout, ActionListener<Boolean> listener) {
        ClusterHealthRequest healthRequest = new ClusterHealthRequest(masterNodeTimeout, index).waitForYellowStatus().waitForNoRelocatingShards(true).waitForNoInitializingShards(true);
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", healthRequest, listener.delegateFailureAndWrap((l, response) -> l.onResponse(!response.isTimedOut())), client.admin().cluster()::health);
    }

    private static void createFirstConcreteIndex(Client client, String index, String alias, boolean addAlias, ActiveShardCount waitForShardCount, TimeValue masterNodeTimeout, ActionListener<Boolean> listener) {
        logger.info("About to create first concrete index [{}] with alias [{}]", (Object)index, (Object)alias);
        CreateIndexRequestBuilder requestBuilder = client.admin().indices().prepareCreate(index);
        if (addAlias) {
            requestBuilder.addAlias(new Alias(alias).isHidden(true));
        }
        requestBuilder.setWaitForActiveShards(waitForShardCount);
        CreateIndexRequest request = (CreateIndexRequest)requestBuilder.request();
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", request, ActionListener.wrap(createIndexResponse -> listener.onResponse(true), createIndexFailure -> {
            if (ExceptionsHelper.unwrapCause(createIndexFailure) instanceof ResourceAlreadyExistsException) {
                if (addAlias) {
                    MlIndexAndAlias.updateWriteAlias(client, alias, null, index, masterNodeTimeout, listener);
                } else {
                    listener.onResponse(true);
                }
            } else {
                listener.onFailure((Exception)createIndexFailure);
            }
        }), client.admin().indices()::create);
    }

    public static void updateWriteAlias(Client client, String alias, @Nullable String currentIndex, String newIndex, TimeValue masterNodeTimeout, ActionListener<Boolean> listener) {
        if (currentIndex != null) {
            logger.info("About to move write alias [{}] from index [{}] to index [{}]", (Object)alias, (Object)currentIndex, (Object)newIndex);
        } else {
            logger.info("About to create write alias [{}] for index [{}]", (Object)alias, (Object)newIndex);
        }
        IndicesAliasesRequestBuilder requestBuilder = client.admin().indices().prepareAliases(masterNodeTimeout, masterNodeTimeout).addAliasAction(IndicesAliasesRequest.AliasActions.add().index(newIndex).alias(alias).isHidden(true).writeIndex(true));
        if (currentIndex != null) {
            requestBuilder.removeAlias(currentIndex, alias);
        }
        IndicesAliasesRequest request = (IndicesAliasesRequest)requestBuilder.request();
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", request, listener.delegateFailureAndWrap((l, resp) -> l.onResponse(resp.isAcknowledged())), client.admin().indices()::aliases);
    }

    public static void installIndexTemplateIfRequired(ClusterState clusterState, Client client, IndexTemplateConfig templateConfig, TimeValue masterTimeout, ActionListener<Boolean> listener) {
        TransportPutComposableIndexTemplateAction.Request request;
        String templateName = templateConfig.getTemplateName();
        if (MlIndexAndAlias.hasIndexTemplate(clusterState, templateName, templateConfig.getVersion())) {
            listener.onResponse(true);
            return;
        }
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, templateConfig.loadBytes());){
            request = (TransportPutComposableIndexTemplateAction.Request)new TransportPutComposableIndexTemplateAction.Request(templateConfig.getTemplateName()).indexTemplate(ComposableIndexTemplate.parse(parser)).masterNodeTimeout(masterTimeout);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("unable to parse composable template " + templateConfig.getTemplateName(), (Throwable)e, new Object[0]);
        }
        MlIndexAndAlias.installIndexTemplateIfRequired(clusterState, client, templateConfig.getVersion(), request, listener);
    }

    public static void installIndexTemplateIfRequired(ClusterState clusterState, Client client, int templateVersion, TransportPutComposableIndexTemplateAction.Request templateRequest, ActionListener<Boolean> listener) {
        if (MlIndexAndAlias.hasIndexTemplate(clusterState, templateRequest.name(), templateVersion)) {
            listener.onResponse(true);
            return;
        }
        ActionListener<AcknowledgedResponse> innerListener = listener.delegateFailureAndWrap((l, response) -> {
            if (!response.isAcknowledged()) {
                logger.warn("error adding template [{}], request was not acknowledged", (Object)templateRequest.name());
            }
            l.onResponse(response.isAcknowledged());
        });
        ClientHelper.executeAsyncWithOrigin(client, "ml", TransportPutComposableIndexTemplateAction.TYPE, templateRequest, innerListener);
    }

    private static boolean hasIndexTemplate(ClusterState state, String templateName, long version) {
        ComposableIndexTemplate template = state.getMetadata().getProject().templatesV2().get(templateName);
        return template != null && Long.valueOf(version).equals(template.version());
    }

    public static String ensureValidResultsIndexName(String indexName) {
        return MlIndexAndAlias.has6DigitSuffix(indexName) ? indexName : indexName + FIRST_INDEX_SIX_DIGIT_SUFFIX;
    }

    public static boolean has6DigitSuffix(String indexName) {
        String[] indexParts = indexName.split("-");
        String suffix = indexParts[indexParts.length - 1];
        return HAS_SIX_DIGIT_SUFFIX.test(suffix);
    }

    public static boolean isAnomaliesSharedIndex(String indexName) {
        return IS_ANOMALIES_SHARED_INDEX.test(indexName);
    }

    public static boolean isAnomaliesStateIndex(String indexName) {
        return IS_ANOMALIES_STATE_INDEX.test(indexName);
    }

    public static String latestIndex(String[] concreteIndices) {
        return concreteIndices.length == 1 ? concreteIndices[0] : Arrays.stream(concreteIndices).max(INDEX_NAME_COMPARATOR).get();
    }

    public static void sortIndices(List<String> indices) {
        indices.sort(INDEX_NAME_COMPARATOR);
    }

    public static boolean indexIsReadWriteCompatibleInV9(IndexVersion version) {
        return version.onOrAfter(IndexVersions.V_8_0_0);
    }

    public static String baseIndexName(String index) {
        return MlIndexAndAlias.has6DigitSuffix(index) ? index.substring(0, index.length() - FIRST_INDEX_SIX_DIGIT_SUFFIX.length()) : index;
    }

    public static String[] indicesMatchingBasename(String baseIndexName, IndexNameExpressionResolver expressionResolver, ClusterState latestState) {
        return expressionResolver.concreteIndexNames(latestState, IndicesOptions.lenientExpandOpenHidden(), baseIndexName + "*");
    }

    public static String latestIndexMatchingBaseName(String index, IndexNameExpressionResolver expressionResolver, ClusterState latestState) {
        String baseIndexName = MlIndexAndAlias.baseIndexName(index);
        String[] matching = MlIndexAndAlias.indicesMatchingBasename(baseIndexName, expressionResolver, latestState);
        if (matching.length == 0) {
            return index;
        }
        String[] filtered = (String[])Arrays.stream(matching).filter(i -> i.equals(index) || MlIndexAndAlias.has6DigitSuffix(i) && i.length() == baseIndexName.length() + FIRST_INDEX_SIX_DIGIT_SUFFIX.length()).toArray(String[]::new);
        return MlIndexAndAlias.latestIndex(filtered);
    }

    public static void rollover(Client client, RolloverRequest rolloverRequest, ActionListener<String> listener) {
        client.admin().indices().rolloverIndex(rolloverRequest, ActionListener.wrap(response -> listener.onResponse(response.getNewIndex()), e -> {
            if (e instanceof ResourceAlreadyExistsException) {
                ResourceAlreadyExistsException alreadyExistsException = (ResourceAlreadyExistsException)e;
                listener.onResponse(alreadyExistsException.getIndex().getName());
            } else {
                listener.onFailure((Exception)e);
            }
        }));
    }

    public static Tuple<String, String> createRolloverAliasAndNewIndexName(String index) {
        String indexName = Objects.requireNonNull(index);
        String rolloverAlias = indexName + ROLLOVER_ALIAS_SUFFIX;
        String newIndexName = MlIndexAndAlias.has6DigitSuffix(index) ? null : indexName + FIRST_INDEX_SIX_DIGIT_SUFFIX;
        return new Tuple<CallSite, CallSite>((CallSite)((Object)rolloverAlias), (CallSite)((Object)newIndexName));
    }

    public static IndicesAliasesRequestBuilder createIndicesAliasesRequestBuilder(Client client) {
        return client.admin().indices().prepareAliases(TimeValue.THIRTY_SECONDS, TimeValue.THIRTY_SECONDS);
    }

    public static void createAliasForRollover(Client client, String indexName, String aliasName, ActionListener<IndicesAliasesResponse> listener) {
        logger.info("creating rollover [{}] alias for [{}]", (Object)aliasName, (Object)indexName);
        MlIndexAndAlias.createIndicesAliasesRequestBuilder(client).addAliasAction(IndicesAliasesRequest.AliasActions.add().index(indexName).alias(aliasName).isHidden(true)).execute(listener);
    }

    public static void updateAliases(IndicesAliasesRequestBuilder request, ActionListener<Boolean> listener) {
        request.execute(listener.delegateFailure((l, response) -> l.onResponse(Boolean.TRUE)));
    }

    public static IndicesAliasesRequestBuilder addStateIndexRolloverAliasActions(IndicesAliasesRequestBuilder aliasRequestBuilder, String newIndex, ClusterState clusterState, List<String> allStateIndices) {
        allStateIndices.stream().filter(index -> clusterState.metadata().getProject().index((String)index) != null).forEach(index -> aliasRequestBuilder.addAliasAction(IndicesAliasesRequest.AliasActions.remove().indices((String)index).alias(AnomalyDetectorsIndex.jobStateIndexWriteAlias())));
        aliasRequestBuilder.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(newIndex).alias(AnomalyDetectorsIndex.jobStateIndexWriteAlias()).isHidden(true).writeIndex(true));
        return aliasRequestBuilder;
    }

    private static Optional<String> findEarliestIndexWithAlias(Map<String, List<AliasMetadata>> aliasesMap, String targetAliasName) {
        return aliasesMap.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(am -> am.alias().equals(targetAliasName))).map(Map.Entry::getKey).min(INDEX_NAME_COMPARATOR);
    }

    private static void addReadAliasesForResultsIndices(IndicesAliasesRequestBuilder aliasRequestBuilder, String jobId, Map<String, List<AliasMetadata>> aliasesMap, List<String> allJobResultsIndices, String readAliasName) {
        int indexOfEarliestIndexWithAlias = MlIndexAndAlias.findEarliestIndexWithAlias(aliasesMap, readAliasName).map(allJobResultsIndices::indexOf).filter(i -> i >= 0).orElse(0);
        aliasRequestBuilder.addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(allJobResultsIndices.subList(indexOfEarliestIndexWithAlias, allJobResultsIndices.size()).toArray(new String[0])).alias(readAliasName).isHidden(true).filter(QueryBuilders.termQuery(Job.ID.getPreferredName(), jobId)));
    }

    public static IndicesAliasesRequestBuilder addResultsIndexRolloverAliasActions(IndicesAliasesRequestBuilder aliasRequestBuilder, String newIndex, ClusterState clusterState, List<String> currentJobResultsIndices) {
        Map<String, List<AliasMetadata>> aliasesMap = clusterState.metadata().getProject().findAllAliases(currentJobResultsIndices.toArray(new String[0]));
        if (aliasesMap == null) {
            return aliasRequestBuilder;
        }
        ArrayList<String> allJobResultsIndices = new ArrayList<String>(currentJobResultsIndices);
        allJobResultsIndices.add(newIndex);
        MlIndexAndAlias.sortIndices(allJobResultsIndices);
        aliasesMap.values().stream().flatMap(Collection::stream).filter(alias -> MlIndexAndAlias.isAnomaliesReadAlias(alias.alias()) || MlIndexAndAlias.isAnomaliesWriteAlias(alias.alias())).flatMap(alias -> AnomalyDetectorsIndex.jobIdFromAlias(alias.alias()).stream().map(jobId -> new Tuple<String, AliasMetadata>((String)jobId, (AliasMetadata)alias))).collect(Collectors.groupingBy(Tuple::v1, Collectors.mapping(Tuple::v2, Collectors.toList()))).forEach((jobId, jobAliases) -> {
            String writeAliasName = AnomalyDetectorsIndex.resultsWriteAlias(jobId);
            String readAliasName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
            MlIndexAndAlias.moveWriteAlias(aliasRequestBuilder, newIndex, currentJobResultsIndices, writeAliasName);
            MlIndexAndAlias.addReadAliasesForResultsIndices(aliasRequestBuilder, jobId, aliasesMap, allJobResultsIndices, readAliasName);
        });
        return aliasRequestBuilder;
    }

    private static void moveWriteAlias(IndicesAliasesRequestBuilder aliasRequestBuilder, String newIndex, List<String> currentJobResultsIndices, String writeAliasName) {
        aliasRequestBuilder.addAliasAction(IndicesAliasesRequest.AliasActions.remove().indices(currentJobResultsIndices.toArray(new String[0])).alias(writeAliasName));
        aliasRequestBuilder.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(newIndex).alias(writeAliasName).isHidden(true).writeIndex(true));
    }

    public static boolean isAnomaliesWriteAlias(String aliasName) {
        return aliasName.startsWith(".ml-anomalies-.write-");
    }

    public static boolean isAnomaliesReadAlias(String aliasName) {
        if (!aliasName.startsWith(".ml-anomalies-")) {
            return false;
        }
        String jobIdPart = aliasName.substring(".ml-anomalies-".length());
        return MlStrings.isValidId(jobIdPart);
    }
}

