/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.results;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.job.config.Detector;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshotField;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.TimingStats;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyCause;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyScoreExplanation;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.BucketInfluencer;
import org.elasticsearch.xpack.core.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.core.ml.job.results.Forecast;
import org.elasticsearch.xpack.core.ml.job.results.ForecastRequestStats;
import org.elasticsearch.xpack.core.ml.job.results.GeoResults;
import org.elasticsearch.xpack.core.ml.job.results.Influence;
import org.elasticsearch.xpack.core.ml.job.results.Influencer;
import org.elasticsearch.xpack.core.ml.job.results.ModelPlot;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.utils.ExponentialAverageCalculationContext;

public final class ReservedFieldNames {
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private static final String[] RESERVED_RESULT_FIELD_NAME_ARRAY = new String[]{"all_field_values", Job.ID.getPreferredName(), AnomalyCause.PROBABILITY.getPreferredName(), AnomalyCause.OVER_FIELD_NAME.getPreferredName(), AnomalyCause.OVER_FIELD_VALUE.getPreferredName(), AnomalyCause.BY_FIELD_NAME.getPreferredName(), AnomalyCause.BY_FIELD_VALUE.getPreferredName(), AnomalyCause.CORRELATED_BY_FIELD_VALUE.getPreferredName(), AnomalyCause.PARTITION_FIELD_NAME.getPreferredName(), AnomalyCause.PARTITION_FIELD_VALUE.getPreferredName(), AnomalyCause.FUNCTION.getPreferredName(), AnomalyCause.FUNCTION_DESCRIPTION.getPreferredName(), AnomalyCause.TYPICAL.getPreferredName(), AnomalyCause.ACTUAL.getPreferredName(), AnomalyCause.GEO_RESULTS.getPreferredName(), AnomalyCause.INFLUENCERS.getPreferredName(), AnomalyCause.FIELD_NAME.getPreferredName(), AnomalyRecord.PROBABILITY.getPreferredName(), AnomalyRecord.MULTI_BUCKET_IMPACT.getPreferredName(), AnomalyRecord.BY_FIELD_NAME.getPreferredName(), AnomalyRecord.BY_FIELD_VALUE.getPreferredName(), AnomalyRecord.CORRELATED_BY_FIELD_VALUE.getPreferredName(), AnomalyRecord.PARTITION_FIELD_NAME.getPreferredName(), AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName(), AnomalyRecord.FUNCTION.getPreferredName(), AnomalyRecord.FUNCTION_DESCRIPTION.getPreferredName(), AnomalyRecord.TYPICAL.getPreferredName(), AnomalyRecord.ACTUAL.getPreferredName(), AnomalyRecord.GEO_RESULTS.getPreferredName(), AnomalyRecord.ANOMALY_SCORE_EXPLANATION.getPreferredName(), AnomalyRecord.INFLUENCERS.getPreferredName(), AnomalyRecord.FIELD_NAME.getPreferredName(), AnomalyRecord.OVER_FIELD_NAME.getPreferredName(), AnomalyRecord.OVER_FIELD_VALUE.getPreferredName(), AnomalyRecord.CAUSES.getPreferredName(), AnomalyRecord.RECORD_SCORE.getPreferredName(), AnomalyRecord.INITIAL_RECORD_SCORE.getPreferredName(), AnomalyRecord.BUCKET_SPAN.getPreferredName(), AnomalyScoreExplanation.ANOMALY_TYPE.getPreferredName(), AnomalyScoreExplanation.ANOMALY_LENGTH.getPreferredName(), AnomalyScoreExplanation.SINGLE_BUCKET_IMPACT.getPreferredName(), AnomalyScoreExplanation.MULTI_BUCKET_IMPACT.getPreferredName(), AnomalyScoreExplanation.ANOMALY_CHARACTERISTICS_IMPACT.getPreferredName(), AnomalyScoreExplanation.LOWER_CONFIDENCE_BOUND.getPreferredName(), AnomalyScoreExplanation.TYPICAL_VALUE.getPreferredName(), AnomalyScoreExplanation.UPPER_CONFIDENCE_BOUND.getPreferredName(), AnomalyScoreExplanation.HIGH_VARIANCE_PENALTY.getPreferredName(), AnomalyScoreExplanation.INCOMPLETE_BUCKET_PENALTY.getPreferredName(), AnomalyScoreExplanation.MULTIMODAL_DISTRIBUTION.getPreferredName(), AnomalyScoreExplanation.BY_FIELD_FIRST_OCCURRENCE.getPreferredName(), AnomalyScoreExplanation.BY_FIELD_RELATIVE_RARITY.getPreferredName(), GeoResults.TYPICAL_POINT.getPreferredName(), GeoResults.ACTUAL_POINT.getPreferredName(), Bucket.ANOMALY_SCORE.getPreferredName(), Bucket.BUCKET_INFLUENCERS.getPreferredName(), Bucket.BUCKET_SPAN.getPreferredName(), Bucket.EVENT_COUNT.getPreferredName(), Bucket.INITIAL_ANOMALY_SCORE.getPreferredName(), Bucket.PROCESSING_TIME_MS.getPreferredName(), Bucket.SCHEDULED_EVENTS.getPreferredName(), BucketInfluencer.INITIAL_ANOMALY_SCORE.getPreferredName(), BucketInfluencer.ANOMALY_SCORE.getPreferredName(), BucketInfluencer.RAW_ANOMALY_SCORE.getPreferredName(), BucketInfluencer.PROBABILITY.getPreferredName(), CategoryDefinition.CATEGORY_ID.getPreferredName(), CategoryDefinition.TERMS.getPreferredName(), CategoryDefinition.REGEX.getPreferredName(), CategoryDefinition.MAX_MATCHING_LENGTH.getPreferredName(), CategoryDefinition.EXAMPLES.getPreferredName(), CategoryDefinition.NUM_MATCHES.getPreferredName(), CategoryDefinition.PREFERRED_TO_CATEGORIES.getPreferredName(), DataCounts.PROCESSED_RECORD_COUNT.getPreferredName(), DataCounts.PROCESSED_FIELD_COUNT.getPreferredName(), DataCounts.INPUT_BYTES.getPreferredName(), DataCounts.INPUT_RECORD_COUNT.getPreferredName(), DataCounts.INPUT_FIELD_COUNT.getPreferredName(), DataCounts.INVALID_DATE_COUNT.getPreferredName(), DataCounts.MISSING_FIELD_COUNT.getPreferredName(), DataCounts.OUT_OF_ORDER_TIME_COUNT.getPreferredName(), DataCounts.EMPTY_BUCKET_COUNT.getPreferredName(), DataCounts.SPARSE_BUCKET_COUNT.getPreferredName(), DataCounts.BUCKET_COUNT.getPreferredName(), DataCounts.LATEST_RECORD_TIME.getPreferredName(), DataCounts.EARLIEST_RECORD_TIME.getPreferredName(), DataCounts.LAST_DATA_TIME.getPreferredName(), DataCounts.LATEST_EMPTY_BUCKET_TIME.getPreferredName(), DataCounts.LATEST_SPARSE_BUCKET_TIME.getPreferredName(), DataCounts.LOG_TIME.getPreferredName(), Detector.DETECTOR_INDEX.getPreferredName(), Influence.INFLUENCER_FIELD_NAME.getPreferredName(), Influence.INFLUENCER_FIELD_VALUES.getPreferredName(), Influencer.PROBABILITY.getPreferredName(), Influencer.INFLUENCER_FIELD_NAME.getPreferredName(), Influencer.INFLUENCER_FIELD_VALUE.getPreferredName(), Influencer.INITIAL_INFLUENCER_SCORE.getPreferredName(), Influencer.INFLUENCER_SCORE.getPreferredName(), Influencer.BUCKET_SPAN.getPreferredName(), ModelPlot.PARTITION_FIELD_NAME.getPreferredName(), ModelPlot.PARTITION_FIELD_VALUE.getPreferredName(), ModelPlot.OVER_FIELD_NAME.getPreferredName(), ModelPlot.OVER_FIELD_VALUE.getPreferredName(), ModelPlot.BY_FIELD_NAME.getPreferredName(), ModelPlot.BY_FIELD_VALUE.getPreferredName(), ModelPlot.MODEL_FEATURE.getPreferredName(), ModelPlot.MODEL_LOWER.getPreferredName(), ModelPlot.MODEL_UPPER.getPreferredName(), ModelPlot.MODEL_MEDIAN.getPreferredName(), ModelPlot.ACTUAL.getPreferredName(), Forecast.FORECAST_LOWER.getPreferredName(), Forecast.FORECAST_UPPER.getPreferredName(), Forecast.FORECAST_PREDICTION.getPreferredName(), Forecast.FORECAST_ID.getPreferredName(), ForecastRequestStats.START_TIME.getPreferredName(), ForecastRequestStats.END_TIME.getPreferredName(), ForecastRequestStats.CREATE_TIME.getPreferredName(), ForecastRequestStats.EXPIRY_TIME.getPreferredName(), ForecastRequestStats.MESSAGES.getPreferredName(), ForecastRequestStats.PROGRESS.getPreferredName(), ForecastRequestStats.STATUS.getPreferredName(), ForecastRequestStats.MEMORY_USAGE.getPreferredName(), ModelSizeStats.MODEL_BYTES_FIELD.getPreferredName(), ModelSizeStats.PEAK_MODEL_BYTES_FIELD.getPreferredName(), ModelSizeStats.TOTAL_BY_FIELD_COUNT_FIELD.getPreferredName(), ModelSizeStats.TOTAL_OVER_FIELD_COUNT_FIELD.getPreferredName(), ModelSizeStats.TOTAL_PARTITION_FIELD_COUNT_FIELD.getPreferredName(), ModelSizeStats.BUCKET_ALLOCATION_FAILURES_COUNT_FIELD.getPreferredName(), ModelSizeStats.MEMORY_STATUS_FIELD.getPreferredName(), ModelSizeStats.ASSIGNMENT_MEMORY_BASIS_FIELD.getPreferredName(), ModelSizeStats.LOG_TIME_FIELD.getPreferredName(), ModelSnapshot.DESCRIPTION.getPreferredName(), ModelSnapshotField.SNAPSHOT_ID.getPreferredName(), ModelSnapshot.SNAPSHOT_DOC_COUNT.getPreferredName(), ModelSnapshot.LATEST_RECORD_TIME.getPreferredName(), ModelSnapshot.LATEST_RESULT_TIME.getPreferredName(), ModelSnapshot.RETAIN.getPreferredName(), ModelSnapshot.MIN_VERSION.getPreferredName(), Result.RESULT_TYPE.getPreferredName(), Result.TIMESTAMP.getPreferredName(), Result.IS_INTERIM.getPreferredName(), TimingStats.BUCKET_COUNT.getPreferredName(), TimingStats.MIN_BUCKET_PROCESSING_TIME_MS.getPreferredName(), TimingStats.MAX_BUCKET_PROCESSING_TIME_MS.getPreferredName(), TimingStats.AVG_BUCKET_PROCESSING_TIME_MS.getPreferredName(), TimingStats.EXPONENTIAL_AVG_BUCKET_PROCESSING_TIME_MS.getPreferredName(), TimingStats.EXPONENTIAL_AVG_CALCULATION_CONTEXT.getPreferredName(), DatafeedTimingStats.SEARCH_COUNT.getPreferredName(), DatafeedTimingStats.BUCKET_COUNT.getPreferredName(), DatafeedTimingStats.TOTAL_SEARCH_TIME_MS.getPreferredName(), DatafeedTimingStats.EXPONENTIAL_AVG_CALCULATION_CONTEXT.getPreferredName(), ExponentialAverageCalculationContext.INCREMENTAL_METRIC_VALUE_MS.getPreferredName(), ExponentialAverageCalculationContext.LATEST_TIMESTAMP.getPreferredName(), ExponentialAverageCalculationContext.PREVIOUS_EXPONENTIAL_AVERAGE_MS.getPreferredName(), "@timestamp", "_id", "_index"};
    public static final Set<String> RESERVED_RESULT_FIELD_NAMES = new HashSet<String>(Arrays.asList(RESERVED_RESULT_FIELD_NAME_ARRAY));

    public static boolean isValidFieldName(String fieldName) {
        String[] segments = DOT_PATTERN.split(fieldName);
        return !RESERVED_RESULT_FIELD_NAMES.contains(segments[0]);
    }

    private ReservedFieldNames() {
    }
}

