/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.process.autodetect.state;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class Quantiles
implements ToXContentObject,
Writeable {
    public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    public static final ParseField QUANTILE_STATE = new ParseField("quantile_state", new String[0]);
    public static final ParseField TYPE = new ParseField("quantiles", new String[0]);
    public static final ConstructingObjectParser<Quantiles, Void> STRICT_PARSER = Quantiles.createParser(false);
    public static final ConstructingObjectParser<Quantiles, Void> LENIENT_PARSER = Quantiles.createParser(true);
    private final String jobId;
    private final Date timestamp;
    private final String quantileState;

    private static ConstructingObjectParser<Quantiles, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<Quantiles, Void> parser = new ConstructingObjectParser<Quantiles, Void>(TYPE.getPreferredName(), ignoreUnknownFields, a -> new Quantiles((String)a[0], (Date)a[1], (String)a[2]));
        parser.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> new Date(p.longValue()), TIMESTAMP, ObjectParser.ValueType.LONG);
        parser.declareString(ConstructingObjectParser.constructorArg(), QUANTILE_STATE);
        return parser;
    }

    public static String documentId(String jobId) {
        return jobId + "_" + String.valueOf(TYPE);
    }

    public static String v54DocumentId(String jobId) {
        return jobId + "-" + String.valueOf(TYPE);
    }

    public static String extractJobId(String docId) {
        int suffixIndex = docId.lastIndexOf("_" + String.valueOf(TYPE));
        return suffixIndex <= 0 ? Quantiles.v54extractJobId(docId) : docId.substring(0, suffixIndex);
    }

    private static String v54extractJobId(String docId) {
        int suffixIndex = docId.lastIndexOf("-" + String.valueOf(TYPE));
        return suffixIndex <= 0 ? null : docId.substring(0, suffixIndex);
    }

    public Quantiles(String jobId, Date timestamp, String quantileState) {
        this.jobId = jobId;
        this.timestamp = Objects.requireNonNull(timestamp);
        this.quantileState = Objects.requireNonNull(quantileState);
    }

    public Quantiles(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.timestamp = new Date(in.readVLong());
        this.quantileState = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeVLong(this.timestamp.getTime());
        out.writeOptionalString(this.quantileState);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.timestamp != null) {
            builder.field(TIMESTAMP.getPreferredName(), this.timestamp.getTime());
        }
        if (this.quantileState != null) {
            builder.field(QUANTILE_STATE.getPreferredName(), this.quantileState);
        }
        builder.endObject();
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getQuantileState() {
        return this.quantileState;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.timestamp, this.quantileState);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Quantiles)) {
            return false;
        }
        Quantiles that = (Quantiles)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.quantileState, that.quantileState);
    }
}

