/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TokenizationUpdate;

public abstract class AbstractTokenizationUpdate
implements TokenizationUpdate {
    private final Tokenization.Truncate truncate;
    private final Integer span;

    protected static void declareCommonParserFields(ConstructingObjectParser<? extends AbstractTokenizationUpdate, Void> parser) {
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), Tokenization.TRUNCATE);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), Tokenization.SPAN);
    }

    public AbstractTokenizationUpdate(@Nullable Tokenization.Truncate truncate, @Nullable Integer span) {
        this.truncate = truncate;
        this.span = span;
    }

    public AbstractTokenizationUpdate(StreamInput in) throws IOException {
        this.truncate = in.readOptionalEnum(Tokenization.Truncate.class);
        this.span = in.readOptionalInt();
    }

    @Override
    public boolean isNoop() {
        return this.truncate == null && this.span == null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.truncate != null) {
            builder.field(Tokenization.TRUNCATE.getPreferredName(), this.truncate.toString());
        }
        if (this.span != null) {
            builder.field(Tokenization.SPAN.getPreferredName(), this.span);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalEnum(this.truncate);
        out.writeOptionalInt(this.span);
    }

    public Integer getSpan() {
        return this.span;
    }

    public Tokenization.Truncate getTruncate() {
        return this.truncate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractTokenizationUpdate)) {
            return false;
        }
        AbstractTokenizationUpdate that = (AbstractTokenizationUpdate)o;
        return Objects.equals((Object)this.truncate, (Object)that.truncate) && Objects.equals(this.span, that.span);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.truncate, this.span});
    }
}

