/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.inference.WeightedToken;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.results.ChunkedNlpInferenceResults;

public class MlChunkedTextExpansionResults
extends ChunkedNlpInferenceResults {
    public static final String NAME = "chunked_text_expansion_result";
    private final String resultsField;
    private final List<ChunkedResult> chunks;

    public MlChunkedTextExpansionResults(String resultField, List<ChunkedResult> chunks, boolean isTruncated) {
        super(isTruncated);
        this.resultsField = resultField;
        this.chunks = chunks;
    }

    public MlChunkedTextExpansionResults(StreamInput in) throws IOException {
        super(in);
        this.resultsField = in.readString();
        this.chunks = in.readCollectionAsList(ChunkedResult::new);
    }

    @Override
    void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(this.resultsField);
        for (ChunkedResult chunk : this.chunks) {
            chunk.toXContent(builder, params);
        }
        builder.endArray();
    }

    @Override
    void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.resultsField);
        out.writeCollection(this.chunks);
    }

    @Override
    void addMapFields(Map<String, Object> map) {
        map.put(this.resultsField, this.chunks.stream().map(ChunkedResult::asMap).collect(Collectors.toList()));
    }

    @Override
    public Map<String, Object> asMap(String outputField) {
        Map map = super.asMap(outputField);
        map.put(this.resultsField, this.chunks.stream().map(ChunkedResult::asMap).collect(Collectors.toList()));
        return map;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MlChunkedTextExpansionResults that = (MlChunkedTextExpansionResults)o;
        return Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.chunks, that.chunks);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resultsField, this.chunks);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    public List<ChunkedResult> getChunks() {
        return this.chunks;
    }

    @Override
    public Object predictedValue() {
        throw new UnsupportedOperationException("[chunked_text_expansion_result] does not support a single predicted value");
    }

    public record ChunkedResult(String matchedText, List<WeightedToken> weightedTokens) implements Writeable,
    ToXContentObject
    {
        public ChunkedResult(StreamInput in) throws IOException {
            this(in.readString(), in.readCollectionAsList(WeightedToken::new));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.matchedText);
            out.writeCollection(this.weightedTokens);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("text", this.matchedText);
            builder.startObject("inference");
            for (WeightedToken weightedToken : this.weightedTokens) {
                weightedToken.toXContent(builder, params);
            }
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public Map<String, Object> asMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("text", this.matchedText);
            map.put("inference", this.weightedTokens.stream().collect(Collectors.toMap(WeightedToken::token, WeightedToken::weight)));
            return map;
        }
    }
}

