/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.AbstractTransportRequest;

public class ResetMlComponentsAction
extends ActionType<Response> {
    public static final ResetMlComponentsAction INSTANCE = new ResetMlComponentsAction();
    public static final String NAME = "cluster:internal/xpack/ml/auditor/reset";

    private ResetMlComponentsAction() {
        super(NAME);
    }

    public static class Response
    extends BaseNodesResponse<ResetResponse> {
        public Response(ClusterName clusterName, List<ResetResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        protected Response(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        protected List<ResetResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readCollectionAsList(ResetResponse::new);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<ResetResponse> nodes) throws IOException {
            out.writeCollection(nodes);
        }

        public static class ResetResponse
        extends BaseNodeResponse {
            private final boolean acknowledged;

            public ResetResponse(DiscoveryNode node, boolean acknowledged) {
                super(node);
                this.acknowledged = acknowledged;
            }

            public ResetResponse(StreamInput in) throws IOException {
                super(in, null);
                this.acknowledged = in.readBoolean();
            }

            public ResetResponse(StreamInput in, DiscoveryNode node) throws IOException {
                super(in, node);
                this.acknowledged = in.readBoolean();
            }

            public boolean isAcknowledged() {
                return this.acknowledged;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                out.writeBoolean(this.acknowledged);
            }

            public boolean equals(Object o) {
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ResetResponse that = (ResetResponse)o;
                return this.acknowledged == that.acknowledged;
            }

            public int hashCode() {
                return Objects.hashCode(this.acknowledged);
            }
        }
    }

    public static class NodeRequest
    extends AbstractTransportRequest {
        public NodeRequest(StreamInput in) throws IOException {
            super(in);
        }

        public NodeRequest() {
        }

        public boolean equals(Object o) {
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return Objects.hash(new Object[0]);
        }
    }

    public static class Request
    extends BaseNodesRequest {
        public static Request RESET_AUDITOR_REQUEST = new Request();

        private Request() {
            super(new String[]{"ml:true"});
        }
    }
}

