/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.action.NodeAcknowledgedResponse;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlTaskParams;

public class OpenJobAction
extends ActionType<NodeAcknowledgedResponse> {
    public static final OpenJobAction INSTANCE = new OpenJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/open";

    private OpenJobAction() {
        super(NAME);
    }

    public static interface JobTaskMatcher {
        public static boolean match(Task task, String expectedJobId) {
            if (task instanceof JobTaskMatcher) {
                if (Strings.isAllOrWildcard(expectedJobId)) {
                    return true;
                }
                String expectedDescription = "job-" + expectedJobId;
                return expectedDescription.equals(task.getDescription());
            }
            return false;
        }
    }

    public static class JobParams
    implements PersistentTaskParams,
    MlTaskParams {
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static final ParseField JOB = new ParseField("job", new String[0]);
        public static final ObjectParser<JobParams, Void> PARSER = new ObjectParser("xpack/ml/job", true, JobParams::new);
        private String jobId;
        private TimeValue timeout = MachineLearningField.STATE_PERSIST_RESTORE_TIMEOUT;
        private Job job;

        public static JobParams fromXContent(XContentParser parser) {
            return JobParams.parseRequest(null, parser);
        }

        public static JobParams parseRequest(String jobId, XContentParser parser) {
            JobParams params = PARSER.apply(parser, null);
            if (jobId != null) {
                params.jobId = jobId;
            }
            return params;
        }

        JobParams() {
        }

        public JobParams(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public JobParams(StreamInput in) throws IOException {
            this.jobId = in.readString();
            this.timeout = TimeValue.timeValueMillis(in.readVLong());
            this.job = in.readOptionalWriteable(Job::new);
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public void setTimeout(TimeValue timeout) {
            this.timeout = timeout;
        }

        @Nullable
        public Job getJob() {
            return this.job;
        }

        public void setJob(Job job) {
            this.job = job;
        }

        @Override
        public String getWriteableName() {
            return "xpack/ml/job";
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.jobId);
            out.writeVLong(this.timeout.millis());
            out.writeOptionalWriteable(this.job);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
            if (this.job != null) {
                builder.field("job", this.job);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.timeout, this.job);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            JobParams other = (JobParams)obj;
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.job, other.job);
        }

        public String toString() {
            return Strings.toString(this);
        }

        @Override
        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersion.minimumCompatible();
        }

        @Override
        public String getMlId() {
            return this.jobId;
        }

        static {
            PARSER.declareString(JobParams::setJobId, Job.ID);
            PARSER.declareString((params, val) -> params.setTimeout(TimeValue.parseTimeValue(val, TIMEOUT.getPreferredName())), TIMEOUT);
            PARSER.declareObject(JobParams::setJob, (p, c) -> Job.LENIENT_PARSER.apply(p, (Void)c).build(), JOB);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements ToXContentObject {
        private JobParams jobParams;

        public static Request parseRequest(String jobId, XContentParser parser) {
            JobParams jobParams = JobParams.PARSER.apply(parser, null);
            if (jobId != null) {
                jobParams.jobId = jobId;
            }
            return new Request(jobParams);
        }

        public Request(JobParams jobParams) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
            this.jobParams = Objects.requireNonNull(jobParams);
        }

        public Request(String jobId) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
            this.jobParams = new JobParams(jobId);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobParams = new JobParams(in);
        }

        public JobParams getJobParams() {
            return this.jobParams;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.jobParams.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.jobParams.toXContent(builder, params);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobParams);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.jobParams, other.jobParams);
        }

        @Override
        public String toString() {
            return Strings.toString(this);
        }
    }
}

