/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.JobTaskRequest;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.output.FlushAcknowledgement;

public class FlushJobAction
extends ActionType<Response> {
    public static final FlushJobAction INSTANCE = new FlushJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/flush";

    private FlushJobAction() {
        super(NAME);
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable,
    ToXContentObject {
        private final boolean flushed;
        private final Instant lastFinalizedBucketEnd;

        public Response(boolean flushed, @Nullable Instant lastFinalizedBucketEnd) {
            super(null, null);
            this.flushed = flushed;
            this.lastFinalizedBucketEnd = lastFinalizedBucketEnd != null ? Instant.ofEpochMilli(lastFinalizedBucketEnd.toEpochMilli()) : null;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.flushed = in.readBoolean();
            this.lastFinalizedBucketEnd = in.readOptionalInstant();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.flushed);
            out.writeOptionalInstant(this.lastFinalizedBucketEnd);
        }

        public boolean isFlushed() {
            return this.flushed;
        }

        public Instant getLastFinalizedBucketEnd() {
            return this.lastFinalizedBucketEnd;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("flushed", this.flushed);
            if (this.lastFinalizedBucketEnd != null) {
                builder.timestampFieldsFromUnixEpochMillis(FlushAcknowledgement.LAST_FINALIZED_BUCKET_END.getPreferredName(), FlushAcknowledgement.LAST_FINALIZED_BUCKET_END.getPreferredName() + "_string", this.lastFinalizedBucketEnd.toEpochMilli());
            }
            builder.endObject();
            return builder;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.flushed == response.flushed && Objects.equals(this.lastFinalizedBucketEnd, response.lastFinalizedBucketEnd);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.flushed, this.lastFinalizedBucketEnd);
        }
    }

    public static class Request
    extends JobTaskRequest<Request>
    implements ToXContentObject {
        public static final ParseField CALC_INTERIM = new ParseField("calc_interim", new String[0]);
        public static final ParseField START = new ParseField("start", new String[0]);
        public static final ParseField END = new ParseField("end", new String[0]);
        public static final ParseField ADVANCE_TIME = new ParseField("advance_time", new String[0]);
        public static final ParseField SKIP_TIME = new ParseField("skip_time", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/job/flush", Request::new);
        private boolean calcInterim = false;
        private boolean waitForNormalization = true;
        private boolean refreshRequired = true;
        private String start;
        private String end;
        private String advanceTime;
        private String skipTime;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = PARSER.apply(parser, null);
            if (jobId != null) {
                request.jobId = jobId;
            }
            return request;
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.calcInterim = in.readBoolean();
            this.start = in.readOptionalString();
            this.end = in.readOptionalString();
            this.advanceTime = in.readOptionalString();
            this.skipTime = in.readOptionalString();
            this.waitForNormalization = in.readBoolean();
            this.refreshRequired = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.calcInterim);
            out.writeOptionalString(this.start);
            out.writeOptionalString(this.end);
            out.writeOptionalString(this.advanceTime);
            out.writeOptionalString(this.skipTime);
            out.writeBoolean(this.waitForNormalization);
            out.writeBoolean(this.refreshRequired);
        }

        public Request(String jobId) {
            super(jobId);
        }

        public boolean getCalcInterim() {
            return this.calcInterim;
        }

        public void setCalcInterim(boolean calcInterim) {
            this.calcInterim = calcInterim;
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public String getAdvanceTime() {
            return this.advanceTime;
        }

        public void setAdvanceTime(String advanceTime) {
            this.advanceTime = advanceTime;
        }

        public String getSkipTime() {
            return this.skipTime;
        }

        public void setSkipTime(String skipTime) {
            this.skipTime = skipTime;
        }

        public boolean isWaitForNormalization() {
            return this.waitForNormalization;
        }

        public boolean isRefreshRequired() {
            return this.refreshRequired;
        }

        public void setWaitForNormalization(boolean waitForNormalization) {
            this.waitForNormalization = waitForNormalization;
        }

        public void setRefreshRequired(boolean refreshRequired) {
            this.refreshRequired = refreshRequired;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.calcInterim, this.start, this.end, this.advanceTime, this.skipTime, this.waitForNormalization, this.refreshRequired);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.jobId, other.jobId) && this.calcInterim == other.calcInterim && this.waitForNormalization == other.waitForNormalization && this.refreshRequired == other.refreshRequired && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.advanceTime, other.advanceTime) && Objects.equals(this.skipTime, other.skipTime);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(CALC_INTERIM.getPreferredName(), this.calcInterim);
            if (this.start != null) {
                builder.field(START.getPreferredName(), this.start);
            }
            if (this.end != null) {
                builder.field(END.getPreferredName(), this.end);
            }
            if (this.advanceTime != null) {
                builder.field(ADVANCE_TIME.getPreferredName(), this.advanceTime);
            }
            if (this.skipTime != null) {
                builder.field(SKIP_TIME.getPreferredName(), this.skipTime);
            }
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareBoolean(Request::setCalcInterim, CALC_INTERIM);
            PARSER.declareString(Request::setStart, START);
            PARSER.declareString(Request::setEnd, END);
            PARSER.declareString(Request::setAdvanceTime, ADVANCE_TIME);
            PARSER.declareString(Request::setSkipTime, SKIP_TIME);
        }
    }
}

