/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.DequeUtils;

public record StreamingUnifiedChatCompletionResults(Flow.Publisher<Results> publisher) implements InferenceServiceResults
{
    public static final String NAME = "chat_completion_chunk";
    public static final String MODEL_FIELD = "model";
    public static final String OBJECT_FIELD = "object";
    public static final String USAGE_FIELD = "usage";
    public static final String INDEX_FIELD = "index";
    public static final String ID_FIELD = "id";
    public static final String FUNCTION_NAME_FIELD = "name";
    public static final String FUNCTION_ARGUMENTS_FIELD = "arguments";
    public static final String FUNCTION_FIELD = "function";
    public static final String CHOICES_FIELD = "choices";
    public static final String DELTA_FIELD = "delta";
    public static final String CONTENT_FIELD = "content";
    public static final String REFUSAL_FIELD = "refusal";
    public static final String ROLE_FIELD = "role";
    private static final String TOOL_CALLS_FIELD = "tool_calls";
    public static final String FINISH_REASON_FIELD = "finish_reason";
    public static final String COMPLETION_TOKENS_FIELD = "completion_tokens";
    public static final String TOTAL_TOKENS_FIELD = "total_tokens";
    public static final String PROMPT_TOKENS_FIELD = "prompt_tokens";
    public static final String PROMPT_TOKENS_DETAILS_FIELD = "prompt_tokens_details";
    public static final String CACHED_TOKENS_FIELD = "cached_tokens";
    public static final String TYPE_FIELD = "type";
    private static final TransportVersion INFERENCE_CACHED_TOKENS = TransportVersion.fromName("inference_cached_tokens");

    public StreamingUnifiedChatCompletionResults(Flow.Publisher<Results> publisher) {
        final LinkedBlockingDeque buffer = new LinkedBlockingDeque();
        final AtomicBoolean onComplete = new AtomicBoolean();
        this.publisher = downstream -> publisher.subscribe(new Flow.Subscriber<Results>(this){

            @Override
            public void onSubscribe(final Flow.Subscription subscription) {
                downstream.onSubscribe(new Flow.Subscription(){

                    @Override
                    public void request(long n) {
                        ChatCompletionChunk nextItem = (ChatCompletionChunk)buffer.poll();
                        if (nextItem != null) {
                            downstream.onNext(new Results(DequeUtils.of(nextItem)));
                        } else if (onComplete.get()) {
                            downstream.onComplete();
                        } else {
                            subscription.request(n);
                        }
                    }

                    @Override
                    public void cancel() {
                        subscription.cancel();
                    }
                });
            }

            @Override
            public void onNext(Results item) {
                Deque<ChatCompletionChunk> chunks = item.chunks();
                ChatCompletionChunk firstItem = chunks.poll();
                chunks.forEach(buffer::offer);
                downstream.onNext(new Results(DequeUtils.of(firstItem)));
            }

            @Override
            public void onError(Throwable throwable) {
                downstream.onError(throwable);
            }

            @Override
            public void onComplete() {
                if (onComplete.compareAndSet(false, true) && buffer.isEmpty()) {
                    downstream.onComplete();
                }
            }
        });
    }

    @Override
    public boolean isStreaming() {
        return true;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public record ChatCompletionChunk(String id, List<Choice> choices, String model, String object, Usage usage) implements ChunkedToXContent,
    Writeable
    {
        private ChatCompletionChunk(StreamInput in) throws IOException {
            this(in.readString(), in.readOptionalCollectionAsList(Choice::new), in.readString(), in.readString(), in.readOptional(Usage::new));
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return Iterators.concat(ChunkedToXContentHelper.startObject(), ChunkedToXContentHelper.chunk((b, p) -> b.field(StreamingUnifiedChatCompletionResults.ID_FIELD, this.id)), this.choices != null ? ChunkedToXContentHelper.array(StreamingUnifiedChatCompletionResults.CHOICES_FIELD, this.choices.iterator(), params) : Collections.emptyIterator(), ChunkedToXContentHelper.chunk((b, p) -> b.field(StreamingUnifiedChatCompletionResults.MODEL_FIELD, this.model).field(StreamingUnifiedChatCompletionResults.OBJECT_FIELD, this.object)), this.usage != null ? ChunkedToXContentHelper.chunk((b, p) -> {
                XContentBuilder builder = b.startObject(StreamingUnifiedChatCompletionResults.USAGE_FIELD).field(StreamingUnifiedChatCompletionResults.COMPLETION_TOKENS_FIELD, this.usage.completionTokens()).field(StreamingUnifiedChatCompletionResults.PROMPT_TOKENS_FIELD, this.usage.promptTokens()).field(StreamingUnifiedChatCompletionResults.TOTAL_TOKENS_FIELD, this.usage.totalTokens());
                if (this.usage.cachedTokens() != null) {
                    builder.startObject(StreamingUnifiedChatCompletionResults.PROMPT_TOKENS_DETAILS_FIELD).field(StreamingUnifiedChatCompletionResults.CACHED_TOKENS_FIELD, this.usage.cachedTokens()).endObject();
                }
                return builder.endObject();
            }) : Collections.emptyIterator(), ChunkedToXContentHelper.endObject());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.id);
            out.writeOptionalCollection(this.choices);
            out.writeString(this.model);
            out.writeString(this.object);
            out.writeOptionalWriteable(this.usage);
        }

        private static Iterator<ToXContent> optionalField(String name, String value) {
            if (value == null) {
                return Collections.emptyIterator();
            }
            return ChunkedToXContentHelper.chunk((b, p) -> b.field(name, value));
        }

        public record Usage(int completionTokens, int promptTokens, int totalTokens, @Nullable Integer cachedTokens) implements Writeable
        {
            public Usage(int completionTokens, int promptTokens, int totalTokens) {
                this(completionTokens, promptTokens, totalTokens, null);
            }

            private Usage(StreamInput in) throws IOException {
                this(in.readInt(), in.readInt(), in.readInt(), in.getTransportVersion().supports(INFERENCE_CACHED_TOKENS) ? in.readOptionalInt() : null);
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeInt(this.completionTokens);
                out.writeInt(this.promptTokens);
                out.writeInt(this.totalTokens);
                if (out.getTransportVersion().supports(INFERENCE_CACHED_TOKENS)) {
                    out.writeOptionalInt(this.cachedTokens);
                }
            }
        }

        public record Choice(Delta delta, String finishReason, int index) implements ChunkedToXContentObject,
        Writeable
        {
            private Choice(StreamInput in) throws IOException {
                this(new Delta(in), in.readOptionalString(), in.readInt());
            }

            @Override
            public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
                return Iterators.concat(ChunkedToXContentHelper.startObject(), this.delta.toXContentChunked(params), ChatCompletionChunk.optionalField(StreamingUnifiedChatCompletionResults.FINISH_REASON_FIELD, this.finishReason), ChunkedToXContentHelper.chunk((b, p) -> b.field(StreamingUnifiedChatCompletionResults.INDEX_FIELD, this.index)), ChunkedToXContentHelper.endObject());
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeWriteable(this.delta);
                out.writeOptionalString(this.finishReason);
                out.writeInt(this.index);
            }

            public record Delta(String content, String refusal, String role, List<ToolCall> toolCalls) implements Writeable
            {
                private Delta(StreamInput in) throws IOException {
                    this(in.readOptionalString(), in.readOptionalString(), in.readOptionalString(), in.readOptionalCollectionAsList(ToolCall::new));
                }

                public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
                    Iterator xContent = Iterators.concat(ChunkedToXContentHelper.startObject(StreamingUnifiedChatCompletionResults.DELTA_FIELD), ChatCompletionChunk.optionalField(StreamingUnifiedChatCompletionResults.CONTENT_FIELD, this.content), ChatCompletionChunk.optionalField(StreamingUnifiedChatCompletionResults.REFUSAL_FIELD, this.refusal), ChatCompletionChunk.optionalField(StreamingUnifiedChatCompletionResults.ROLE_FIELD, this.role));
                    if (this.toolCalls != null && !this.toolCalls.isEmpty()) {
                        xContent = Iterators.concat(xContent, ChunkedToXContentHelper.startArray(StreamingUnifiedChatCompletionResults.TOOL_CALLS_FIELD), Iterators.flatMap(this.toolCalls.iterator(), t -> t.toXContentChunked(params)), ChunkedToXContentHelper.endArray());
                    }
                    xContent = Iterators.concat(xContent, ChunkedToXContentHelper.endObject());
                    return xContent;
                }

                @Override
                public void writeTo(StreamOutput out) throws IOException {
                    out.writeOptionalString(this.content);
                    out.writeOptionalString(this.refusal);
                    out.writeOptionalString(this.role);
                    out.writeOptionalCollection(this.toolCalls);
                }

                public record ToolCall(int index, String id, Function function, String type) implements ChunkedToXContentObject,
                Writeable
                {
                    private ToolCall(StreamInput in) throws IOException {
                        this(in.readInt(), in.readOptionalString(), in.readOptional(Function::new), in.readOptionalString());
                    }

                    @Override
                    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
                        Iterator content = Iterators.concat(ChunkedToXContentHelper.startObject(), ChunkedToXContentHelper.chunk((b, p) -> b.field(StreamingUnifiedChatCompletionResults.INDEX_FIELD, this.index)), ChatCompletionChunk.optionalField(StreamingUnifiedChatCompletionResults.ID_FIELD, this.id));
                        if (this.function != null) {
                            content = Iterators.concat(content, ChunkedToXContentHelper.startObject(StreamingUnifiedChatCompletionResults.FUNCTION_FIELD), ChatCompletionChunk.optionalField(StreamingUnifiedChatCompletionResults.FUNCTION_ARGUMENTS_FIELD, this.function.arguments()), ChatCompletionChunk.optionalField(StreamingUnifiedChatCompletionResults.FUNCTION_NAME_FIELD, this.function.name()), ChunkedToXContentHelper.endObject());
                        }
                        content = Iterators.concat(content, ChunkedToXContentHelper.chunk((b, p) -> b.field(StreamingUnifiedChatCompletionResults.TYPE_FIELD, this.type)), ChunkedToXContentHelper.endObject());
                        return content;
                    }

                    @Override
                    public void writeTo(StreamOutput out) throws IOException {
                        out.writeInt(this.index);
                        out.writeOptionalString(this.id);
                        out.writeOptionalWriteable(this.function);
                        out.writeOptionalString(this.type);
                    }

                    public record Function(String arguments, String name) implements Writeable
                    {
                        private Function(StreamInput in) throws IOException {
                            this(in.readOptionalString(), in.readOptionalString());
                        }

                        @Override
                        public void writeTo(StreamOutput out) throws IOException {
                            out.writeOptionalString(this.arguments);
                            out.writeOptionalString(this.name);
                        }
                    }
                }
            }
        }
    }

    public record Results(Deque<ChatCompletionChunk> chunks) implements InferenceServiceResults.Result
    {
        public static String NAME = "streaming_unified_chat_completion_results";

        public Results(StreamInput in) throws IOException {
            this(DequeUtils.readDeque(in, ChatCompletionChunk::new));
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return Iterators.flatMap(this.chunks.iterator(), c -> c.toXContentChunked(params));
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.chunks, StreamOutput::writeWriteable);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Results results = (Results)o;
            return DequeUtils.dequeEquals(this.chunks, results.chunks());
        }

        @Override
        public int hashCode() {
            return DequeUtils.dequeHashCode(this.chunks);
        }
    }
}

