/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.inference.results.DenseEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.EmbeddingByteResults;
import org.elasticsearch.xpack.core.ml.inference.results.MlDenseEmbeddingResults;

public abstract class EmbeddingBitResults
implements DenseEmbeddingResults<EmbeddingByteResults.Embedding> {
    private final List<EmbeddingByteResults.Embedding> embeddings;
    private final String arrayName;

    public EmbeddingBitResults(List<EmbeddingByteResults.Embedding> embeddings, String arrayName) {
        this.embeddings = embeddings;
        this.arrayName = arrayName;
    }

    public EmbeddingBitResults(StreamInput in, String arrayName) throws IOException {
        this(in.readCollectionAsList(EmbeddingByteResults.Embedding::new), arrayName);
    }

    @Override
    public List<EmbeddingByteResults.Embedding> embeddings() {
        return this.embeddings;
    }

    @Override
    public int getFirstEmbeddingSize() {
        if (this.embeddings.isEmpty()) {
            throw new IllegalStateException("Embeddings list is empty");
        }
        return 8 * this.embeddings.getFirst().values().length;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContentHelper.array(this.arrayName, this.embeddings.iterator());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.embeddings);
    }

    @Override
    public List<? extends InferenceResults> transformToCoordinationFormat() {
        return this.embeddings.stream().map(embedding -> new MlDenseEmbeddingResults(this.arrayName, embedding.toDoubleArray(), false)).toList();
    }

    @Override
    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.arrayName, this.embeddings);
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddingBitResults that = (EmbeddingBitResults)o;
        return Objects.equals(this.embeddings, that.embeddings);
    }

    public int hashCode() {
        return Objects.hash(this.embeddings);
    }
}

