/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.chunking;

import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.xpack.core.inference.chunking.Chunker;
import org.elasticsearch.xpack.core.inference.chunking.NoneChunkingSettings;

public class NoopChunker
implements Chunker {
    public static final NoopChunker INSTANCE = new NoopChunker();

    private NoopChunker() {
    }

    @Override
    public List<Chunker.ChunkOffset> chunk(String input, ChunkingSettings chunkingSettings) {
        if (chunkingSettings instanceof NoneChunkingSettings) {
            return List.of(new Chunker.ChunkOffset(0, input.length()));
        }
        throw new IllegalArgumentException(Strings.format("NoopChunker can't use ChunkingSettings with strategy [%s]", new Object[]{chunkingSettings.getChunkingStrategy()}));
    }
}

