/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.inference.InferenceContext;
import org.elasticsearch.xpack.core.inference.action.BaseInferenceActionRequest;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;

public class UnifiedCompletionAction
extends ActionType<InferenceAction.Response> {
    public static final UnifiedCompletionAction INSTANCE = new UnifiedCompletionAction();
    public static final String NAME = "cluster:internal/xpack/inference/unified";

    public UnifiedCompletionAction() {
        super(NAME);
    }

    public static class Request
    extends BaseInferenceActionRequest {
        private final String inferenceEntityId;
        private final TaskType taskType;
        private final UnifiedCompletionRequest unifiedCompletionRequest;
        private final TimeValue timeout;

        public static Request parseRequest(String inferenceEntityId, TaskType taskType, TimeValue timeout, InferenceContext context, XContentParser parser) throws IOException {
            UnifiedCompletionRequest unifiedRequest = UnifiedCompletionRequest.PARSER.apply(parser, null);
            return new Request(inferenceEntityId, taskType, unifiedRequest, context, timeout);
        }

        public Request(String inferenceEntityId, TaskType taskType, UnifiedCompletionRequest unifiedCompletionRequest, TimeValue timeout) {
            this(inferenceEntityId, taskType, unifiedCompletionRequest, InferenceContext.EMPTY_INSTANCE, timeout);
        }

        public Request(String inferenceEntityId, TaskType taskType, UnifiedCompletionRequest unifiedCompletionRequest, InferenceContext context, TimeValue timeout) {
            super(context);
            this.inferenceEntityId = Objects.requireNonNull(inferenceEntityId);
            this.taskType = Objects.requireNonNull(taskType);
            this.unifiedCompletionRequest = Objects.requireNonNull(unifiedCompletionRequest);
            this.timeout = Objects.requireNonNull(timeout);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.inferenceEntityId = in.readString();
            this.taskType = TaskType.fromStream(in);
            this.unifiedCompletionRequest = new UnifiedCompletionRequest(in);
            this.timeout = in.readTimeValue();
        }

        @Override
        public TaskType getTaskType() {
            return this.taskType;
        }

        @Override
        public String getInferenceEntityId() {
            return this.inferenceEntityId;
        }

        public UnifiedCompletionRequest getUnifiedCompletionRequest() {
            return this.unifiedCompletionRequest;
        }

        @Override
        public boolean isStreaming() {
            return true;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        @Override
        public ActionRequestValidationException validate() {
            if (this.unifiedCompletionRequest == null || this.unifiedCompletionRequest.messages() == null) {
                ActionRequestValidationException e = new ActionRequestValidationException();
                e.addValidationError("Field [messages] cannot be null");
                return e;
            }
            if (this.unifiedCompletionRequest.messages().isEmpty()) {
                ActionRequestValidationException e = new ActionRequestValidationException();
                e.addValidationError("Field [messages] cannot be an empty array");
                return e;
            }
            if (!this.taskType.isAnyOrSame(TaskType.CHAT_COMPLETION)) {
                ActionRequestValidationException e = new ActionRequestValidationException();
                e.addValidationError("Field [taskType] must be [chat_completion]");
                return e;
            }
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.inferenceEntityId);
            this.taskType.writeTo(out);
            this.unifiedCompletionRequest.writeTo(out);
            out.writeTimeValue(this.timeout);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return super.equals(o) && Objects.equals(this.inferenceEntityId, request.inferenceEntityId) && this.taskType == request.taskType && Objects.equals(this.unifiedCompletionRequest, request.unifiedCompletionRequest) && Objects.equals(this.timeout, request.timeout);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.inferenceEntityId, this.taskType, this.unifiedCompletionRequest, this.timeout);
        }
    }
}

