/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.inference.action.CCMEnabledActionResponse;

public class PutCCMConfigurationAction
extends ActionType<CCMEnabledActionResponse> {
    public static final PutCCMConfigurationAction INSTANCE = new PutCCMConfigurationAction();
    public static final String NAME = "cluster:admin/xpack/inference/ccm/put";
    static final String API_KEY_FIELD_ERROR = "The [api_key] field cannot be an empty string or null";

    public PutCCMConfigurationAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("cluster:admin/xpack/inference/ccm/put", Builder::new);
        private final SecureString apiKey;

        public static Request parseRequest(TimeValue masterNodeTimeout, TimeValue ackTimeout, XContentParser parser) throws IOException {
            Builder builder = PARSER.parse(parser, null);
            return builder.build(masterNodeTimeout, ackTimeout);
        }

        public static Request createEnabled(String apiKey, TimeValue masterNodeTimeout, TimeValue ackTimeout) {
            return new Request(new SecureString(Objects.requireNonNull(apiKey).toCharArray()), masterNodeTimeout, ackTimeout);
        }

        public Request(SecureString apiKey, TimeValue masterNodeTimeout, TimeValue ackTimeout) {
            super(masterNodeTimeout, ackTimeout);
            this.apiKey = apiKey;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.apiKey = in.readSecureString();
        }

        public SecureString getApiKey() {
            return this.apiKey;
        }

        @Override
        public ActionRequestValidationException validate() {
            if (this.apiKey == null || Strings.isNullOrEmpty(this.apiKey.toString())) {
                return ValidateActions.addValidationError(PutCCMConfigurationAction.API_KEY_FIELD_ERROR, null);
            }
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeSecureString(this.apiKey);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.apiKey, request.apiKey);
        }

        public int hashCode() {
            return Objects.hash(this.apiKey);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.apiKey != null) {
                builder.field("api_key", this.apiKey.toString());
            }
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareString(Builder::setApiKey, new ParseField("api_key", new String[0]));
        }

        public static class Builder {
            private SecureString apiKey;

            private Builder() {
            }

            public Builder setApiKey(SecureString apiKey) {
                this.apiKey = apiKey;
                return this;
            }

            public Builder setApiKey(String apiKey) {
                this.apiKey = new SecureString(apiKey.toCharArray());
                return this;
            }

            public Request build(TimeValue masterNodeTimeout, TimeValue ackTimeout) {
                return new Request(this.apiKey, masterNodeTimeout, ackTimeout);
            }
        }
    }
}

