/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetRerankerWindowSizeAction
extends ActionType<Response> {
    public static final GetRerankerWindowSizeAction INSTANCE = new GetRerankerWindowSizeAction();
    public static final String NAME = "cluster:internal/xpack/inference/rerankwindowsize/get";

    public GetRerankerWindowSizeAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse {
        private final int windowSize;

        public Response(int windowSize) {
            this.windowSize = windowSize;
        }

        public Response(StreamInput in) throws IOException {
            this.windowSize = in.readVInt();
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.windowSize);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.windowSize == response.windowSize;
        }

        public int hashCode() {
            return Objects.hashCode(this.windowSize);
        }
    }

    public static class Request
    extends ActionRequest {
        private final String inferenceEntityId;

        public Request(String inferenceEntityId) {
            this.inferenceEntityId = inferenceEntityId;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.inferenceEntityId = in.readString();
        }

        public String getInferenceEntityId() {
            return this.inferenceEntityId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.inferenceEntityId);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.inferenceEntityId, request.inferenceEntityId);
        }

        public int hashCode() {
            return Objects.hashCode(this.inferenceEntityId);
        }
    }
}

