/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.InferenceFieldMetadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InferenceResults;

public class GetInferenceFieldsAction
extends ActionType<Response> {
    public static final GetInferenceFieldsAction INSTANCE = new GetInferenceFieldsAction();
    public static final RemoteClusterActionType<Response> REMOTE_TYPE = new RemoteClusterActionType<Response>(INSTANCE.name(), Response::new);
    public static final TransportVersion GET_INFERENCE_FIELDS_ACTION_TV = TransportVersion.fromName("get_inference_fields_action");
    public static final String NAME = "cluster:internal/xpack/inference/fields/get";

    public GetInferenceFieldsAction() {
        super(NAME);
    }

    public record ExtendedInferenceFieldMetadata(InferenceFieldMetadata inferenceFieldMetadata, float weight) implements Writeable
    {
        public ExtendedInferenceFieldMetadata(StreamInput in) throws IOException {
            this(new InferenceFieldMetadata(in), in.readFloat());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeWriteable(this.inferenceFieldMetadata);
            out.writeFloat(this.weight);
        }
    }

    public static class Response
    extends ActionResponse {
        private final Map<String, List<ExtendedInferenceFieldMetadata>> inferenceFieldsMap;
        private final Map<String, InferenceResults> inferenceResultsMap;

        public Response(Map<String, List<ExtendedInferenceFieldMetadata>> inferenceFieldsMap, Map<String, InferenceResults> inferenceResultsMap) {
            this.inferenceFieldsMap = inferenceFieldsMap;
            this.inferenceResultsMap = inferenceResultsMap;
        }

        public Response(StreamInput in) throws IOException {
            this.inferenceFieldsMap = in.readImmutableMap(i -> i.readCollectionAsImmutableList(ExtendedInferenceFieldMetadata::new));
            this.inferenceResultsMap = in.readImmutableMap(i -> i.readNamedWriteable(InferenceResults.class));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.inferenceFieldsMap, StreamOutput::writeCollection);
            out.writeMap(this.inferenceResultsMap, StreamOutput::writeNamedWriteable);
        }

        public Map<String, List<ExtendedInferenceFieldMetadata>> getInferenceFieldsMap() {
            return Collections.unmodifiableMap(this.inferenceFieldsMap);
        }

        public Map<String, InferenceResults> getInferenceResultsMap() {
            return Collections.unmodifiableMap(this.inferenceResultsMap);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.inferenceFieldsMap, response.inferenceFieldsMap) && Objects.equals(this.inferenceResultsMap, response.inferenceResultsMap);
        }

        public int hashCode() {
            return Objects.hash(this.inferenceFieldsMap, this.inferenceResultsMap);
        }
    }

    public static class Request
    extends ActionRequest {
        private final Set<String> indices;
        private final Map<String, Float> fields;
        private final boolean resolveWildcards;
        private final boolean useDefaultFields;
        private final String query;
        private final IndicesOptions indicesOptions;

        public Request(Set<String> indices, Map<String, Float> fields, boolean resolveWildcards, boolean useDefaultFields, @Nullable String query) {
            this(indices, fields, resolveWildcards, useDefaultFields, query, null);
        }

        public Request(Set<String> indices, Map<String, Float> fields, boolean resolveWildcards, boolean useDefaultFields, @Nullable String query, @Nullable IndicesOptions indicesOptions) {
            this.indices = indices;
            this.fields = fields;
            this.resolveWildcards = resolveWildcards;
            this.useDefaultFields = useDefaultFields;
            this.query = query;
            this.indicesOptions = indicesOptions == null ? IndicesOptions.DEFAULT : indicesOptions;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.indices = in.readCollectionAsSet(StreamInput::readString);
            this.fields = in.readMap(StreamInput::readFloat);
            this.resolveWildcards = in.readBoolean();
            this.useDefaultFields = in.readBoolean();
            this.query = in.readOptionalString();
            this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringCollection(this.indices);
            out.writeMap(this.fields, StreamOutput::writeFloat);
            out.writeBoolean(this.resolveWildcards);
            out.writeBoolean(this.useDefaultFields);
            out.writeOptionalString(this.query);
            this.indicesOptions.writeIndicesOptions(out);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.indices == null) {
                validationException = ValidateActions.addValidationError("indices must not be null", validationException);
            }
            if (this.fields == null) {
                validationException = ValidateActions.addValidationError("fields must not be null", validationException);
            } else {
                for (Map.Entry<String, Float> entry : this.fields.entrySet()) {
                    if (entry.getValue() != null) continue;
                    validationException = ValidateActions.addValidationError("weight for field [" + entry.getKey() + "] must not be null", validationException);
                }
            }
            return validationException;
        }

        public Set<String> getIndices() {
            return Collections.unmodifiableSet(this.indices);
        }

        public Map<String, Float> getFields() {
            return Collections.unmodifiableMap(this.fields);
        }

        public boolean resolveWildcards() {
            return this.resolveWildcards;
        }

        public boolean useDefaultFields() {
            return this.useDefaultFields;
        }

        public String getQuery() {
            return this.query;
        }

        public IndicesOptions getIndicesOptions() {
            return this.indicesOptions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.indices, request.indices) && Objects.equals(this.fields, request.fields) && this.resolveWildcards == request.resolveWildcards && this.useDefaultFields == request.useDefaultFields && Objects.equals(this.query, request.query) && Objects.equals(this.indicesOptions, request.indicesOptions);
        }

        public int hashCode() {
            return Objects.hash(this.indices, this.fields, this.resolveWildcards, this.useDefaultFields, this.query, this.indicesOptions);
        }
    }
}

