/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.OperationMode;

public class OperationModeUpdateTask
extends ClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(OperationModeUpdateTask.class);
    private final ProjectId projectId;
    @Nullable
    private final OperationMode ilmMode;
    @Nullable
    private final OperationMode slmMode;

    public static AckedClusterStateUpdateTask wrap(final OperationModeUpdateTask task, AcknowledgedRequest<?> request, ActionListener<AcknowledgedResponse> listener) {
        return new AckedClusterStateUpdateTask(task.priority(), request, listener){

            @Override
            public ClusterState execute(ClusterState currentState) {
                return task.execute(currentState);
            }
        };
    }

    private OperationModeUpdateTask(Priority priority, ProjectId projectId, OperationMode ilmMode, OperationMode slmMode) {
        super(priority);
        this.projectId = projectId;
        this.ilmMode = ilmMode;
        this.slmMode = slmMode;
    }

    public static OperationModeUpdateTask ilmMode(ProjectId projectId, OperationMode mode) {
        return new OperationModeUpdateTask(OperationModeUpdateTask.getPriority(mode), projectId, mode, null);
    }

    public static OperationModeUpdateTask slmMode(OperationMode mode) {
        ProjectId projectId = ProjectId.DEFAULT;
        return new OperationModeUpdateTask(OperationModeUpdateTask.getPriority(mode), projectId, null, mode);
    }

    private static Priority getPriority(OperationMode mode) {
        if (mode == OperationMode.STOPPED || mode == OperationMode.STOPPING) {
            return Priority.IMMEDIATE;
        }
        return Priority.NORMAL;
    }

    public OperationMode getILMOperationMode() {
        return this.ilmMode;
    }

    public OperationMode getSLMOperationMode() {
        return this.slmMode;
    }

    @Override
    public ClusterState execute(ClusterState currentState) {
        ProjectMetadata oldProject = currentState.metadata().getProject(this.projectId);
        ProjectMetadata newProject = this.updateILMState(oldProject);
        if ((newProject = this.updateSLMState(newProject)) == oldProject) {
            return currentState;
        }
        return ClusterState.builder(currentState).putProjectMetadata(newProject).build();
    }

    private ProjectMetadata updateILMState(ProjectMetadata currentProject) {
        if (this.ilmMode == null) {
            return currentProject;
        }
        OperationMode currentMode = LifecycleOperationMetadata.currentILMMode(currentProject);
        if (currentMode.equals((Object)this.ilmMode)) {
            return currentProject;
        }
        if (!currentMode.isValidChange(this.ilmMode)) {
            return currentProject;
        }
        OperationMode newMode = this.ilmMode;
        logger.info("updating ILM operation mode to {}", (Object)newMode);
        LifecycleOperationMetadata updatedMetadata = new LifecycleOperationMetadata(newMode, LifecycleOperationMetadata.currentSLMMode(currentProject));
        return currentProject.copyAndUpdate(b -> b.putCustom("lifecycle_operation", updatedMetadata));
    }

    private ProjectMetadata updateSLMState(ProjectMetadata currentProject) {
        if (this.slmMode == null) {
            return currentProject;
        }
        OperationMode currentMode = LifecycleOperationMetadata.currentSLMMode(currentProject);
        if (currentMode.equals((Object)this.slmMode)) {
            return currentProject;
        }
        if (!currentMode.isValidChange(this.slmMode)) {
            return currentProject;
        }
        OperationMode newMode = this.slmMode;
        logger.info("updating SLM operation mode to {}", (Object)newMode);
        LifecycleOperationMetadata updatedMetadata = new LifecycleOperationMetadata(LifecycleOperationMetadata.currentILMMode(currentProject), newMode);
        return currentProject.copyAndUpdate(b -> b.putCustom("lifecycle_operation", updatedMetadata));
    }

    @Override
    public void onFailure(Exception e) {
        logger.error(() -> Strings.format("unable to update lifecycle metadata with new ilm mode [%s], slm mode [%s]", new Object[]{this.ilmMode, this.slmMode}), (Throwable)e);
    }

    @Override
    public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
        if (this.ilmMode != null) {
            logger.info("ILM operation mode updated to {}", (Object)this.ilmMode);
        }
        if (this.slmMode != null) {
            logger.info("SLM operation mode updated to {}", (Object)this.slmMode);
        }
    }
}

