/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.XPackFeatureUsage;

public class XPackUsageResponse
extends ActionResponse {
    private final List<XPackFeatureUsage> usages;

    public XPackUsageResponse(List<XPackFeatureUsage> usages) {
        this.usages = Objects.requireNonNull(usages);
    }

    public XPackUsageResponse(StreamInput in) throws IOException {
        this.usages = in.readNamedWriteableCollectionAsList(XPackFeatureUsage.class);
    }

    public List<XPackFeatureUsage> getUsages() {
        return this.usages;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        List<XPackFeatureUsage> usagesToWrite = this.usages.stream().filter(usage -> out.getTransportVersion().supports(usage.getMinimalSupportedVersion())).toList();
        XPackUsageResponse.writeTo(out, usagesToWrite);
    }

    private static void writeTo(StreamOutput out, List<XPackFeatureUsage> usages) throws IOException {
        out.writeNamedWriteableCollection(usages);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XPackUsageResponse that = (XPackUsageResponse)o;
        return Objects.equals(this.usages, that.usages);
    }

    public int hashCode() {
        return Objects.hashCode(this.usages);
    }
}

