/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SetUpgradeModeActionRequest
extends AcknowledgedRequest<SetUpgradeModeActionRequest>
implements ToXContentObject {
    private final boolean enabled;

    public SetUpgradeModeActionRequest(TimeValue masterNodeTimeout, TimeValue ackTimeout, boolean enabled) {
        super(masterNodeTimeout, ackTimeout);
        this.enabled = enabled;
    }

    public SetUpgradeModeActionRequest(StreamInput in) throws IOException {
        super(in);
        this.enabled = in.readBoolean();
    }

    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.enabled);
    }

    public int hashCode() {
        return Objects.hash(this.masterNodeTimeout(), this.ackTimeout(), this.enabled);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SetUpgradeModeActionRequest other = (SetUpgradeModeActionRequest)obj;
        return Objects.equals(this.masterNodeTimeout(), other.masterNodeTimeout()) && Objects.equals(this.ackTimeout(), other.ackTimeout()) && this.enabled == other.enabled();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("enabled", this.enabled);
        builder.endObject();
        return builder;
    }
}

