/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent;

import java.util.Map;
import java.util.Set;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.MediaType;
import org.elasticsearch.xcontent.MediaTypeRegistry;
import org.elasticsearch.xcontent.ParsedMediaType;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.cbor.CborXContent;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xcontent.smile.SmileXContent;
import org.elasticsearch.xcontent.yaml.YamlXContent;

public enum XContentType implements MediaType
{
    JSON(0, JsonXContent.jsonXContent){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/json";
        }

        @Override
        public String mediaType() {
            return "application/json;charset=utf-8";
        }

        @Override
        public String queryParameter() {
            return "json";
        }

        @Override
        public Set<MediaType.HeaderValue> headerValues() {
            return Set.of(new MediaType.HeaderValue("application/json"), new MediaType.HeaderValue("application/x-ndjson"), new MediaType.HeaderValue("application/*"));
        }
    }
    ,
    SMILE(1, SmileXContent.smileXContent){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/smile";
        }

        @Override
        public String queryParameter() {
            return "smile";
        }

        @Override
        public Set<MediaType.HeaderValue> headerValues() {
            return Set.of(new MediaType.HeaderValue("application/smile"));
        }
    }
    ,
    YAML(2, YamlXContent.yamlXContent){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/yaml";
        }

        @Override
        public String queryParameter() {
            return "yaml";
        }

        @Override
        public Set<MediaType.HeaderValue> headerValues() {
            return Set.of(new MediaType.HeaderValue("application/yaml"));
        }
    }
    ,
    CBOR(3, CborXContent.cborXContent){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/cbor";
        }

        @Override
        public String queryParameter() {
            return "cbor";
        }

        @Override
        public Set<MediaType.HeaderValue> headerValues() {
            return Set.of(new MediaType.HeaderValue("application/cbor"));
        }
    }
    ,
    VND_JSON(4, JsonXContent.jsonXContent){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/vnd.elasticsearch+json";
        }

        @Override
        public String queryParameter() {
            return "vnd_json";
        }

        @Override
        public Set<MediaType.HeaderValue> headerValues() {
            return Set.of(new MediaType.HeaderValue("application/vnd.elasticsearch+json", Map.of("compatible-with", "\\d+")), new MediaType.HeaderValue("application/vnd.elasticsearch+x-ndjson", Map.of("compatible-with", "\\d+")));
        }

        @Override
        public XContentType canonical() {
            return JSON;
        }
    }
    ,
    VND_SMILE(5, SmileXContent.smileXContent){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/vnd.elasticsearch+smile";
        }

        @Override
        public String queryParameter() {
            return "vnd_smile";
        }

        @Override
        public Set<MediaType.HeaderValue> headerValues() {
            return Set.of(new MediaType.HeaderValue("application/vnd.elasticsearch+smile", Map.of("compatible-with", "\\d+")));
        }

        @Override
        public XContentType canonical() {
            return SMILE;
        }
    }
    ,
    VND_YAML(6, YamlXContent.yamlXContent){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/vnd.elasticsearch+yaml";
        }

        @Override
        public String queryParameter() {
            return "vnd_yaml";
        }

        @Override
        public Set<MediaType.HeaderValue> headerValues() {
            return Set.of(new MediaType.HeaderValue("application/vnd.elasticsearch+yaml", Map.of("compatible-with", "\\d+")));
        }

        @Override
        public XContentType canonical() {
            return YAML;
        }
    }
    ,
    VND_CBOR(7, CborXContent.cborXContent){

        @Override
        public String mediaTypeWithoutParameters() {
            return "application/vnd.elasticsearch+cbor";
        }

        @Override
        public String queryParameter() {
            return "vnd_cbor";
        }

        @Override
        public Set<MediaType.HeaderValue> headerValues() {
            return Set.of(new MediaType.HeaderValue("application/vnd.elasticsearch+cbor", Map.of("compatible-with", "\\d+")));
        }

        @Override
        public XContentType canonical() {
            return CBOR;
        }
    };

    public static final MediaTypeRegistry<XContentType> MEDIA_TYPE_REGISTRY;
    public static final String VENDOR_APPLICATION_PREFIX = "application/vnd.elasticsearch+";
    private final ParsedMediaType mediaType = ParsedMediaType.parseMediaType(this.mediaTypeWithoutParameters());
    private final int index;
    private final XContent xContent;
    private static final XContentType[] values;

    public static XContentType fromFormat(String format) {
        return MEDIA_TYPE_REGISTRY.queryParamToMediaType(format);
    }

    public static XContentType fromMediaType(String mediaTypeHeaderValue) throws IllegalArgumentException {
        ParsedMediaType parsedMediaType = ParsedMediaType.parseMediaType(mediaTypeHeaderValue);
        if (parsedMediaType != null) {
            return parsedMediaType.toMediaType(MEDIA_TYPE_REGISTRY);
        }
        return null;
    }

    private XContentType(int index, XContent xContent) {
        this.index = index;
        this.xContent = xContent;
    }

    public static Byte parseVersion(String mediaType) {
        ParsedMediaType parsedMediaType = ParsedMediaType.parseMediaType(mediaType);
        if (parsedMediaType != null) {
            String version = parsedMediaType.getParameters().get("compatible-with");
            return version != null ? Byte.valueOf(Byte.parseByte(version)) : null;
        }
        return null;
    }

    public int index() {
        return this.index;
    }

    public String mediaType() {
        return this.mediaTypeWithoutParameters();
    }

    public final XContent xContent() {
        return this.xContent;
    }

    public abstract String mediaTypeWithoutParameters();

    public ParsedMediaType toParsedMediaType() {
        return this.mediaType;
    }

    public XContentType canonical() {
        return this;
    }

    public static XContentType ofOrdinal(int ordinal) {
        return values[ordinal];
    }

    public static boolean supportsDelimitedBulkRequests(@Nullable XContentType xContentType) {
        return xContentType != null && xContentType.xContent.hasBulkSeparator();
    }

    static {
        MEDIA_TYPE_REGISTRY = new MediaTypeRegistry().register(XContentType.values());
        values = XContentType.values();
    }
}

