/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.admin.cluster.remote.RemoteClusterNodesAction;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.cluster.state.RemoteClusterStateRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ClusterConnectionManager;
import org.elasticsearch.transport.ConnectionManager;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.LinkedProjectConfig;
import org.elasticsearch.transport.RemoteClusterCredentialsManager;
import org.elasticsearch.transport.RemoteConnectionInfo;
import org.elasticsearch.transport.RemoteConnectionManager;
import org.elasticsearch.transport.RemoteConnectionStrategy;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public final class RemoteClusterConnection
implements Closeable {
    private final TransportService transportService;
    private final RemoteConnectionManager remoteConnectionManager;
    private final RemoteConnectionStrategy connectionStrategy;
    private final String clusterAlias;
    private final ThreadPool threadPool;
    private volatile boolean skipUnavailable;
    private final TimeValue initialConnectionTimeout;

    RemoteClusterConnection(LinkedProjectConfig config, TransportService transportService, RemoteClusterCredentialsManager credentialsManager, boolean crossProjectEnabled) {
        this.transportService = transportService;
        this.clusterAlias = config.linkedProjectAlias();
        ConnectionProfile profile = RemoteConnectionStrategy.buildConnectionProfile(config, crossProjectEnabled || credentialsManager.hasCredentials(this.clusterAlias) ? "_remote_cluster" : "default");
        this.remoteConnectionManager = new RemoteConnectionManager(this.clusterAlias, credentialsManager, RemoteClusterConnection.createConnectionManager(profile, transportService));
        this.connectionStrategy = config.buildRemoteConnectionStrategy(transportService, this.remoteConnectionManager);
        this.remoteConnectionManager.addListener(transportService);
        this.skipUnavailable = config.skipUnavailable();
        this.threadPool = transportService.threadPool;
        this.initialConnectionTimeout = config.initialConnectionTimeout();
    }

    void setSkipUnavailable(boolean skipUnavailable) {
        this.skipUnavailable = skipUnavailable;
    }

    public boolean isSkipUnavailable() {
        return this.skipUnavailable;
    }

    void ensureConnected(ActionListener<Void> listener) {
        if (this.remoteConnectionManager.size() == 0) {
            this.connectionStrategy.connect(listener);
        } else {
            listener.onResponse(null);
        }
    }

    void collectNodes(ActionListener<Function<String, DiscoveryNode>> listener) {
        Runnable runnable = () -> {
            ThreadContext threadContext = this.threadPool.getThreadContext();
            ContextPreservingActionListener contextPreservingActionListener = new ContextPreservingActionListener(threadContext.newRestorableContext(false), listener);
            try (ThreadContext.StoredContext ignore = threadContext.newEmptySystemContext();){
                Transport.Connection connection = this.remoteConnectionManager.getAnyRemoteConnection();
                if ("_remote_cluster".equals(this.remoteConnectionManager.getConnectionProfile().getTransportProfile())) {
                    this.transportService.sendRequest(connection, RemoteClusterNodesAction.TYPE.name(), (TransportRequest)RemoteClusterNodesAction.Request.ALL_NODES, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<RemoteClusterNodesAction.Response>(contextPreservingActionListener.map(response -> {
                        Map nodeLookup = response.getNodes().stream().collect(Collectors.toUnmodifiableMap(DiscoveryNode::getId, Function.identity()));
                        return nodeLookup::get;
                    }), RemoteClusterNodesAction.Response::new, TransportResponseHandler.TRANSPORT_WORKER));
                } else {
                    RemoteClusterStateRequest request = new RemoteClusterStateRequest(TimeValue.THIRTY_SECONDS);
                    request.clear();
                    request.nodes(true);
                    this.transportService.sendRequest(connection, "cluster:monitor/state", (TransportRequest)request, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<ClusterStateResponse>(contextPreservingActionListener.map(response -> response.getState().nodes()::get), ClusterStateResponse::new, TransportResponseHandler.TRANSPORT_WORKER));
                }
            }
        };
        try {
            this.ensureConnected(listener.delegateFailureAndWrap((l, x) -> runnable.run()));
        }
        catch (Exception ex) {
            listener.onFailure(ex);
        }
    }

    Transport.Connection getConnection(DiscoveryNode remoteClusterNode) {
        return this.remoteConnectionManager.getConnection(remoteClusterNode);
    }

    Transport.Connection getConnection() {
        return this.remoteConnectionManager.getAnyRemoteConnection();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.connectionStrategy, this.remoteConnectionManager);
    }

    public boolean isClosed() {
        return this.connectionStrategy.isClosed();
    }

    boolean assertNoRunningConnections() {
        return this.connectionStrategy.assertNoRunningConnections();
    }

    boolean isNodeConnected(DiscoveryNode node) {
        return this.remoteConnectionManager.nodeConnected(node);
    }

    public RemoteConnectionInfo getConnectionInfo() {
        return new RemoteConnectionInfo(this.clusterAlias, this.connectionStrategy.getModeInfo(), this.initialConnectionTimeout, this.skipUnavailable, this.remoteConnectionManager.getCredentialsManager().hasCredentials(this.clusterAlias));
    }

    int getNumNodesConnected() {
        return this.remoteConnectionManager.size();
    }

    private static ConnectionManager createConnectionManager(ConnectionProfile connectionProfile, TransportService transportService) {
        return new ClusterConnectionManager(connectionProfile, transportService.transport, transportService.threadPool.getThreadContext());
    }

    ConnectionManager getConnectionManager() {
        return this.remoteConnectionManager;
    }

    boolean shouldRebuildConnection(LinkedProjectConfig config) {
        return this.connectionStrategy.shouldRebuildConnection(config);
    }
}

