/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.ProxyConnectionStrategy;
import org.elasticsearch.transport.RemoteClusterSettings;
import org.elasticsearch.transport.RemoteConnectionManager;
import org.elasticsearch.transport.RemoteConnectionStrategy;
import org.elasticsearch.transport.SniffConnectionStrategy;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportSettings;

public sealed interface LinkedProjectConfig {
    public ProjectId originProjectId();

    public ProjectId linkedProjectId();

    public String linkedProjectAlias();

    public TimeValue transportConnectTimeout();

    public Compression.Enabled connectionCompression();

    public Compression.Scheme connectionCompressionScheme();

    public TimeValue clusterPingSchedule();

    public TimeValue initialConnectionTimeout();

    public boolean skipUnavailable();

    public int maxPendingConnectionListeners();

    public RemoteConnectionStrategy.ConnectionStrategy connectionStrategy();

    public int maxNumConnections();

    public String proxyAddress();

    public RemoteConnectionStrategy buildRemoteConnectionStrategy(TransportService var1, RemoteConnectionManager var2);

    public static class SniffLinkedProjectConfigBuilder
    extends Builder<SniffLinkedProjectConfigBuilder> {
        private Predicate<DiscoveryNode> nodePredicate = RemoteClusterSettings.SniffConnectionStrategySettings.DEFAULT_NODE_PREDICATE;
        private List<String> seedNodes = RemoteClusterSettings.SniffConnectionStrategySettings.DEFAULT_SEED_NODES;

        public SniffLinkedProjectConfigBuilder(String linkedProjectAlias) {
            super(ProjectId.DEFAULT, ProjectId.DEFAULT, linkedProjectAlias, RemoteConnectionStrategy.ConnectionStrategy.SNIFF);
        }

        public SniffLinkedProjectConfigBuilder(ProjectId originProjectId, ProjectId linkedProjectId, String linkedProjectAlias) {
            super(originProjectId, linkedProjectId, linkedProjectAlias, RemoteConnectionStrategy.ConnectionStrategy.SNIFF);
        }

        public SniffLinkedProjectConfigBuilder nodePredicate(Predicate<DiscoveryNode> nodePredicate) {
            this.nodePredicate = Objects.requireNonNull(nodePredicate);
            return this;
        }

        public SniffLinkedProjectConfigBuilder seedNodes(List<String> seedNodes) {
            SniffLinkedProjectConfigBuilder.requireNonEmpty(seedNodes, "seedNodes").forEach(RemoteConnectionStrategy::parsePort);
            this.seedNodes = seedNodes;
            return this;
        }

        @Override
        public SniffLinkedProjectConfig build() {
            if (this.seedNodes.isEmpty()) {
                throw new IllegalStateException("seedNodes wasn't configured");
            }
            return new SniffLinkedProjectConfig(this.originProjectId, this.linkedProjectId, this.linkedProjectAlias, this.transportConnectTimeout, this.connectionCompression, this.connectionCompressionScheme, this.clusterPingSchedule, this.initialConnectionTimeout, this.skipUnavailable, this.maxPendingConnectionListeners, this.maxNumConnections, this.nodePredicate, this.seedNodes, this.proxyAddress);
        }

        @Override
        protected SniffLinkedProjectConfigBuilder self() {
            return this;
        }
    }

    public static class ProxyLinkedProjectConfigBuilder
    extends Builder<ProxyLinkedProjectConfigBuilder> {
        private String serverName = "";

        public ProxyLinkedProjectConfigBuilder(String linkedProjectAlias) {
            super(ProjectId.DEFAULT, ProjectId.DEFAULT, linkedProjectAlias, RemoteConnectionStrategy.ConnectionStrategy.PROXY);
        }

        public ProxyLinkedProjectConfigBuilder(ProjectId originProjectId, ProjectId linkedProjectId, String linkedProjectAlias) {
            super(originProjectId, linkedProjectId, linkedProjectAlias, RemoteConnectionStrategy.ConnectionStrategy.PROXY);
        }

        public ProxyLinkedProjectConfigBuilder serverName(String serverName) {
            this.serverName = ProxyLinkedProjectConfigBuilder.requireNonEmpty(serverName, "serverName");
            return this;
        }

        @Override
        public ProxyLinkedProjectConfig build() {
            if (this.proxyAddress.isEmpty()) {
                throw new IllegalStateException("proxyAddress wasn't configured");
            }
            return new ProxyLinkedProjectConfig(this.originProjectId, this.linkedProjectId, this.linkedProjectAlias, this.transportConnectTimeout, this.connectionCompression, this.connectionCompressionScheme, this.clusterPingSchedule, this.initialConnectionTimeout, this.skipUnavailable, this.maxPendingConnectionListeners, this.maxNumConnections, this.proxyAddress, this.serverName);
        }

        @Override
        protected ProxyLinkedProjectConfigBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<B extends Builder<B>> {
        protected final ProjectId originProjectId;
        protected final ProjectId linkedProjectId;
        protected final String linkedProjectAlias;
        protected final RemoteConnectionStrategy.ConnectionStrategy connectionStrategy;
        private final B concreteBuilder;
        protected TimeValue transportConnectTimeout = TransportSettings.DEFAULT_CONNECT_TIMEOUT;
        protected Compression.Enabled connectionCompression = TransportSettings.DEFAULT_TRANSPORT_COMPRESS;
        protected Compression.Scheme connectionCompressionScheme = TransportSettings.DEFAULT_TRANSPORT_COMPRESSION_SCHEME;
        protected TimeValue clusterPingSchedule = TransportSettings.DEFAULT_PING_SCHEDULE;
        protected TimeValue initialConnectionTimeout = RemoteClusterSettings.DEFAULT_INITIAL_CONNECTION_TIMEOUT;
        protected boolean skipUnavailable = true;
        protected String proxyAddress = "";
        protected int maxNumConnections;
        protected int maxPendingConnectionListeners = 1000;

        private Builder(ProjectId originProjectId, ProjectId linkedProjectId, String linkedProjectAlias, RemoteConnectionStrategy.ConnectionStrategy connectionStrategy) {
            this.originProjectId = Objects.requireNonNull(originProjectId);
            this.linkedProjectId = Objects.requireNonNull(linkedProjectId);
            this.linkedProjectAlias = Builder.requireNonEmpty(linkedProjectAlias, "linkedProjectAlias");
            this.connectionStrategy = Objects.requireNonNull(connectionStrategy);
            this.concreteBuilder = this.self();
            this.maxNumConnections = switch (connectionStrategy) {
                default -> throw new MatchException(null, null);
                case RemoteConnectionStrategy.ConnectionStrategy.PROXY -> 18;
                case RemoteConnectionStrategy.ConnectionStrategy.SNIFF -> 3;
            };
        }

        public B transportConnectTimeout(TimeValue transportConnectTimeout) {
            this.transportConnectTimeout = Objects.requireNonNull(transportConnectTimeout);
            return this.concreteBuilder;
        }

        public B connectionCompression(Compression.Enabled connectionCompression) {
            this.connectionCompression = Objects.requireNonNull(connectionCompression);
            return this.concreteBuilder;
        }

        public B connectionCompressionScheme(Compression.Scheme connectionCompressionScheme) {
            this.connectionCompressionScheme = Objects.requireNonNull(connectionCompressionScheme);
            return this.concreteBuilder;
        }

        public B clusterPingSchedule(TimeValue clusterPingSchedule) {
            this.clusterPingSchedule = Objects.requireNonNull(clusterPingSchedule);
            return this.concreteBuilder;
        }

        public B initialConnectionTimeout(TimeValue initialConnectionTimeout) {
            this.initialConnectionTimeout = Objects.requireNonNull(initialConnectionTimeout);
            return this.concreteBuilder;
        }

        public B skipUnavailable(boolean skipUnavailable) {
            this.skipUnavailable = skipUnavailable;
            return this.concreteBuilder;
        }

        public B proxyAddress(String proxyAddress) {
            this.proxyAddress = Builder.requireNonEmpty(proxyAddress, "proxyAddress");
            RemoteConnectionStrategy.parsePort(proxyAddress);
            return this.concreteBuilder;
        }

        public B maxNumConnections(int maxNumConnections) {
            this.maxNumConnections = Builder.requireGreaterThanZero(maxNumConnections, "maxNumConnections");
            return this.concreteBuilder;
        }

        public B maxPendingConnectionListeners(int maxPendingConnectionListeners) {
            this.maxPendingConnectionListeners = Builder.requireGreaterThanZero(maxPendingConnectionListeners, "maxPendingConnectionListeners");
            return this.concreteBuilder;
        }

        public abstract LinkedProjectConfig build();

        protected abstract B self();

        protected static int requireGreaterThanZero(int value, String name) {
            if (value <= 0) {
                throw new IllegalArgumentException("[" + name + "] must be greater than 0");
            }
            return value;
        }

        protected static String requireNonEmpty(String value, String name) {
            if (Objects.requireNonNull(value).isBlank()) {
                throw new IllegalArgumentException("[" + name + "] cannot be empty");
            }
            return value;
        }

        protected static <T> Collection<T> requireNonEmpty(Collection<T> value, String name) {
            if (Objects.requireNonNull(value).isEmpty()) {
                throw new IllegalArgumentException("[" + name + "] cannot be empty");
            }
            return value;
        }
    }

    public record SniffLinkedProjectConfig(ProjectId originProjectId, ProjectId linkedProjectId, String linkedProjectAlias, TimeValue transportConnectTimeout, Compression.Enabled connectionCompression, Compression.Scheme connectionCompressionScheme, TimeValue clusterPingSchedule, TimeValue initialConnectionTimeout, boolean skipUnavailable, int maxPendingConnectionListeners, int maxNumConnections, Predicate<DiscoveryNode> nodePredicate, List<String> seedNodes, String proxyAddress) implements LinkedProjectConfig
    {
        @Override
        public RemoteConnectionStrategy.ConnectionStrategy connectionStrategy() {
            return RemoteConnectionStrategy.ConnectionStrategy.SNIFF;
        }

        @Override
        public RemoteConnectionStrategy buildRemoteConnectionStrategy(TransportService transportService, RemoteConnectionManager connectionManager) {
            return new SniffConnectionStrategy(this, transportService, connectionManager);
        }
    }

    public record ProxyLinkedProjectConfig(ProjectId originProjectId, ProjectId linkedProjectId, String linkedProjectAlias, TimeValue transportConnectTimeout, Compression.Enabled connectionCompression, Compression.Scheme connectionCompressionScheme, TimeValue clusterPingSchedule, TimeValue initialConnectionTimeout, boolean skipUnavailable, int maxPendingConnectionListeners, int maxNumConnections, String proxyAddress, String serverName) implements LinkedProjectConfig
    {
        @Override
        public RemoteConnectionStrategy.ConnectionStrategy connectionStrategy() {
            return RemoteConnectionStrategy.ConnectionStrategy.PROXY;
        }

        @Override
        public RemoteConnectionStrategy buildRemoteConnectionStrategy(TransportService transportService, RemoteConnectionManager connectionManager) {
            return new ProxyConnectionStrategy(this, transportService, connectionManager);
        }
    }
}

