/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.CancellableTasksTracker;
import org.elasticsearch.tasks.RemovedTaskListener;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskCancellationService;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskResult;
import org.elasticsearch.tasks.TaskResultsService;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TaskTransportChannel;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TcpTransportChannel;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;

public class TaskManager
implements ClusterStateApplier {
    private static final Logger logger = LogManager.getLogger(TaskManager.class);
    private final Set<String> taskHeaders;
    private final ThreadPool threadPool;
    private final Map<Long, Task> tasks = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private final CancellableTasksTracker<CancellableTaskHolder> cancellableTasks = new CancellableTasksTracker();
    private final AtomicLong taskIdGenerator = new AtomicLong();
    private final Map<TaskId, Ban> bannedParents = new ConcurrentHashMap<TaskId, Ban>();
    private TaskResultsService taskResultsService;
    private final String nodeId;
    private DiscoveryNodes lastDiscoveryNodes = DiscoveryNodes.EMPTY_NODES;
    private final Tracer tracer;
    private final ByteSizeValue maxHeaderSize;
    private final Map<TcpChannel, ChannelPendingTaskTracker> channelPendingTaskTrackers = ConcurrentCollections.newConcurrentMap();
    private final SetOnce<TaskCancellationService> cancellationService = new SetOnce();
    private final List<RemovedTaskListener> removedTaskListeners = new CopyOnWriteArrayList<RemovedTaskListener>();
    private static final ChannelPendingTaskTracker DIRECT_CHANNEL_TRACKER = new ChannelPendingTaskTracker();

    public TaskManager(Settings settings, ThreadPool threadPool, Set<String> taskHeaders) {
        this(settings, threadPool, taskHeaders, Tracer.NOOP);
    }

    public TaskManager(Settings settings, ThreadPool threadPool, Set<String> taskHeaders, Tracer tracer) {
        this(settings, threadPool, taskHeaders, tracer, UUIDs.randomBase64UUID());
    }

    public TaskManager(Settings settings, ThreadPool threadPool, Set<String> taskHeaders, Tracer tracer, String nodeId) {
        this.threadPool = threadPool;
        this.taskHeaders = Set.copyOf(taskHeaders);
        this.maxHeaderSize = HttpTransportSettings.SETTING_HTTP_MAX_HEADER_SIZE.get(settings);
        this.tracer = tracer;
        this.nodeId = nodeId;
    }

    public void setTaskResultsService(TaskResultsService taskResultsService) {
        assert (this.taskResultsService == null);
        this.taskResultsService = taskResultsService;
    }

    public void setTaskCancellationService(TaskCancellationService taskCancellationService) {
        this.cancellationService.set(taskCancellationService);
    }

    public Task register(String type, String action, TaskAwareRequest request) {
        return this.register(type, action, request, true);
    }

    public Task register(String type, String action, TaskAwareRequest request, boolean traceRequest) {
        HashMap<String, String> headers = new HashMap<String, String>();
        long headerSize = 0L;
        long maxSize = this.maxHeaderSize.getBytes();
        ThreadContext threadContext = this.threadPool.getThreadContext();
        assert (!threadContext.hasApmTraceContext()) : "Expected threadContext to have no APM trace context";
        for (String key : this.taskHeaders) {
            String httpHeader = threadContext.getHeader(key);
            if (httpHeader == null) continue;
            if ((headerSize += (long)(key.length() * 2 + httpHeader.length() * 2)) > maxSize) {
                throw new IllegalArgumentException("Request exceeded the maximum size of task headers " + String.valueOf(this.maxHeaderSize));
            }
            headers.put(key, httpHeader);
        }
        Task task = request.createTask(new TaskId(this.nodeId, this.taskIdGenerator.incrementAndGet()), type, action, request.getParentTask(), headers);
        Objects.requireNonNull(task);
        assert (task.getParentTaskId().equals(request.getParentTask())) : "Request [ " + String.valueOf(request) + "] didn't preserve it parentTaskId";
        if (logger.isTraceEnabled()) {
            logger.trace("register {} [{}] [{}] [{}]", (Object)task.getId(), (Object)type, (Object)action, (Object)task.getDescription());
        }
        if (task instanceof CancellableTask) {
            this.registerCancellableTask(task, request.getRequestId(), traceRequest);
        } else {
            Task previousTask = this.tasks.put(task.getId(), task);
            assert (previousTask == null);
            if (traceRequest) {
                this.maybeStartTrace(threadContext, task);
            }
        }
        return task;
    }

    void maybeStartTrace(ThreadContext threadContext, Task task) {
        if (!threadContext.hasParentApmTraceContext()) {
            return;
        }
        TaskId parentTask = task.getParentTaskId();
        Map<String, Object> attributes = parentTask.isSet() ? Map.of("es.task.id", task.getId(), "es.task.parent.id", parentTask.toString()) : Map.of("es.task.id", task.getId());
        this.tracer.startTrace(threadContext, task, task.getAction(), attributes);
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task registerAndExecute(String type, TransportAction<Request, Response> action, final Request request, Transport.Connection localConnection, final ActionListener<Response> taskListener) {
        final Releasable unregisterChildNode = request.getParentTask().isSet() ? this.registerChildConnection(request.getParentTask().getId(), localConnection) : null;
        try (ThreadContext.StoredContext ignored = this.threadPool.getThreadContext().newTraceContext();){
            Task task;
            try {
                task = this.register(type, action.actionName, request);
            }
            catch (TaskCancelledException e) {
                Releasables.close(unregisterChildNode);
                throw e;
            }
            action.execute(task, request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response response) {
                    try {
                        this.release();
                    }
                    finally {
                        taskListener.onResponse(response);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    try {
                        if (request.getParentTask().isSet()) {
                            TaskManager.this.cancelChildLocal(request.getParentTask(), request.getRequestId(), e.toString());
                        }
                        this.release();
                    }
                    finally {
                        taskListener.onFailure(e);
                    }
                }

                public String toString() {
                    return this.getClass().getName() + "{" + String.valueOf(taskListener) + "}{" + String.valueOf(task) + "}";
                }

                private void release() {
                    Releasables.close(unregisterChildNode, () -> TaskManager.this.unregister(task));
                }
            });
            Task task2 = task;
            return task2;
        }
    }

    private void registerCancellableTask(Task task, long requestId, boolean traceRequest) {
        Ban ban;
        CancellableTask cancellableTask = (CancellableTask)task;
        CancellableTaskHolder holder = new CancellableTaskHolder(cancellableTask);
        this.cancellableTasks.put(task, requestId, holder);
        if (traceRequest) {
            this.maybeStartTrace(this.threadPool.getThreadContext(), task);
        }
        if (task.getParentTaskId().isSet() && (ban = this.bannedParents.get(task.getParentTaskId())) != null) {
            try {
                holder.cancel(ban.reason);
                throw new TaskCancelledException("task cancelled before starting [" + ban.reason + "]");
            }
            catch (Throwable throwable) {
                this.unregister(task);
                throw throwable;
            }
        }
    }

    private TaskCancellationService getCancellationService() {
        TaskCancellationService service = this.cancellationService.get();
        if (service != null) {
            return service;
        }
        assert (false) : "TaskCancellationService is not initialized";
        throw new IllegalStateException("TaskCancellationService is not initialized");
    }

    public void cancel(CancellableTask task, String reason, Runnable listener) {
        CancellableTaskHolder holder = this.cancellableTasks.get(task.getId());
        if (holder != null) {
            logger.trace("cancelling task with id {}", (Object)task.getId());
            holder.cancel(reason, listener);
        } else {
            listener.run();
        }
    }

    public void cancelChildLocal(TaskId parentTaskId, long childRequestId, String reason) {
        List<CancellableTaskHolder> children;
        if (childRequestId > 0L && !(children = this.cancellableTasks.getChildrenByRequestId(parentTaskId, childRequestId).toList()).isEmpty()) {
            for (CancellableTaskHolder child : children) {
                if (logger.isTraceEnabled()) {
                    logger.trace("cancelling child task [{}] of parent task [{}] and request ID [{}] with reason [{}]", (Object)child.getTask(), (Object)parentTaskId, (Object)childRequestId, (Object)reason);
                }
                child.cancel(reason);
            }
        }
    }

    public void cancelChildRemote(TaskId parentTask, long childRequestId, Transport.Connection childConnection, String reason) {
        this.getCancellationService().cancelChildRemote(parentTask, childRequestId, childConnection, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task unregister(Task task) {
        logger.trace("unregister task for id: {}", (Object)task.getId());
        try {
            if (task instanceof CancellableTask) {
                CancellableTaskHolder holder = this.cancellableTasks.remove(task);
                if (holder != null) {
                    holder.finish();
                    assert (holder.task == task);
                    CancellableTask cancellableTask = holder.getTask();
                    return cancellableTask;
                }
                Task task2 = null;
                return task2;
            }
            Task removedTask = this.tasks.remove(task.getId());
            assert (removedTask == null || removedTask == task);
            Task task3 = removedTask;
            return task3;
        }
        finally {
            this.tracer.stopTrace(task);
            for (RemovedTaskListener listener : this.removedTaskListeners) {
                listener.onRemoved(task);
            }
        }
    }

    public void registerRemovedTaskListener(RemovedTaskListener removedTaskListener) {
        this.removedTaskListeners.add(removedTaskListener);
    }

    public void unregisterRemovedTaskListener(RemovedTaskListener removedTaskListener) {
        this.removedTaskListeners.remove(removedTaskListener);
    }

    @Nullable
    public Releasable registerChildConnection(long taskId, Transport.Connection childConnection) {
        assert (TransportService.unwrapConnection(childConnection) == childConnection) : "Child connection must be unwrapped";
        CancellableTaskHolder holder = this.cancellableTasks.get(taskId);
        if (holder != null) {
            logger.trace("register child connection [{}] task [{}]", (Object)childConnection, (Object)taskId);
            holder.registerChildConnection(childConnection);
            return Releasables.releaseOnce(() -> {
                logger.trace("unregister child connection [{}] task [{}]", (Object)childConnection, (Object)taskId);
                holder.unregisterChildConnection(childConnection);
            });
        }
        return null;
    }

    Integer childTasksPerConnection(long taskId, Transport.Connection childConnection) {
        CancellableTaskHolder holder = this.cancellableTasks.get(taskId);
        if (holder != null) {
            return holder.childTasksPerConnection.get(childConnection);
        }
        return null;
    }

    public <Response extends ActionResponse> void storeResult(Task task, final Exception error, final ActionListener<Response> listener) {
        TaskResult taskResult;
        DiscoveryNode localNode = this.lastDiscoveryNodes.getLocalNode();
        if (localNode == null) {
            listener.onFailure(error);
            return;
        }
        try {
            taskResult = task.result(localNode, error);
        }
        catch (IOException ex) {
            logger.warn(() -> Strings.format("couldn't store error %s", ExceptionsHelper.stackTrace(error)), (Throwable)ex);
            listener.onFailure(ex);
            return;
        }
        this.taskResultsService.storeResult(taskResult, new ActionListener<Void>(){

            @Override
            public void onResponse(Void aVoid) {
                listener.onFailure(error);
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn(() -> Strings.format("couldn't store error %s", ExceptionsHelper.stackTrace(error)), (Throwable)e);
                listener.onFailure(e);
            }
        });
    }

    public <Response extends ActionResponse> void storeResult(Task task, final Response response, final ActionListener<Response> listener) {
        TaskResult taskResult;
        DiscoveryNode localNode = this.lastDiscoveryNodes.getLocalNode();
        if (localNode == null) {
            logger.warn("couldn't store response {}, the node didn't join the cluster yet", response);
            listener.onResponse(response);
            return;
        }
        try {
            taskResult = task.result(localNode, response);
        }
        catch (IOException ex) {
            logger.warn(() -> Strings.format("couldn't store response %s", response), (Throwable)ex);
            listener.onFailure(ex);
            return;
        }
        this.taskResultsService.storeResult(taskResult, new ActionListener<Void>(){

            @Override
            public void onResponse(Void aVoid) {
                listener.onResponse(response);
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn(() -> Strings.format("couldn't store response %s", response), (Throwable)e);
                listener.onFailure(e);
            }
        });
    }

    public Map<Long, Task> getTasks() {
        HashMap<Long, Task> taskHashMap = new HashMap<Long, Task>(this.tasks);
        for (CancellableTaskHolder holder : this.cancellableTasks.values()) {
            taskHashMap.put(holder.getTask().getId(), holder.getTask());
        }
        return Collections.unmodifiableMap(taskHashMap);
    }

    public Map<Long, CancellableTask> getCancellableTasks() {
        HashMap<Long, CancellableTask> taskHashMap = new HashMap<Long, CancellableTask>();
        for (CancellableTaskHolder holder : this.cancellableTasks.values()) {
            taskHashMap.put(holder.getTask().getId(), holder.getTask());
        }
        return Collections.unmodifiableMap(taskHashMap);
    }

    public Task getTask(long id) {
        Task task = this.tasks.get(id);
        if (task != null) {
            return task;
        }
        return this.getCancellableTask(id);
    }

    public CancellableTask getCancellableTask(long id) {
        CancellableTaskHolder holder = this.cancellableTasks.get(id);
        if (holder != null) {
            return holder.getTask();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CancellableTask> setBan(TaskId parentTaskId, String reason, TransportChannel channel) {
        logger.trace("setting ban for the parent task {} {}", (Object)parentTaskId, (Object)reason);
        Map<TaskId, Ban> map = this.bannedParents;
        synchronized (map) {
            Ban ban = this.bannedParents.computeIfAbsent(parentTaskId, k -> new Ban(reason));
            while (channel instanceof TaskTransportChannel) {
                channel = ((TaskTransportChannel)channel).getChannel();
            }
            if (channel instanceof TcpTransportChannel) {
                this.startTrackingChannel(((TcpTransportChannel)channel).getChannel(), ban::registerChannel);
            } else {
                assert (TransportService.isDirectResponseChannel(channel)) : "expect direct channel; got [" + String.valueOf(channel) + "]";
                ban.registerChannel(DIRECT_CHANNEL_TRACKER);
            }
        }
        return this.cancellableTasks.getByParent(parentTaskId).map(t -> t.task).toList();
    }

    public void removeBan(TaskId parentTaskId) {
        logger.trace("removing ban for the parent task {}", (Object)parentTaskId);
        this.bannedParents.remove(parentTaskId);
    }

    public Set<TaskId> getBannedTaskIds() {
        return Collections.unmodifiableSet(this.bannedParents.keySet());
    }

    public boolean assertCancellableTaskConsistency() {
        return this.cancellableTasks.assertConsistent();
    }

    public Collection<Transport.Connection> startBanOnChildTasks(long taskId, String reason, Runnable onChildTasksCompleted) {
        CancellableTaskHolder holder = this.cancellableTasks.get(taskId);
        if (holder != null) {
            return holder.startBan(reason, onChildTasksCompleted);
        }
        onChildTasksCompleted.run();
        return Collections.emptySet();
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        this.lastDiscoveryNodes = event.state().getNodes();
    }

    public Releasable startTrackingCancellableChannelTask(TcpChannel channel, CancellableTask task) {
        assert (this.cancellableTasks.get(task.getId()) != null) : "task [" + task.getId() + "] is not registered yet";
        ChannelPendingTaskTracker tracker = this.startTrackingChannel(channel, trackerChannel -> trackerChannel.addTask(task));
        return () -> tracker.removeTask(task);
    }

    private ChannelPendingTaskTracker startTrackingChannel(TcpChannel channel, Consumer<ChannelPendingTaskTracker> onRegister) {
        ChannelPendingTaskTracker tracker = this.channelPendingTaskTrackers.compute(channel, (k, curr) -> {
            if (curr == null) {
                curr = new ChannelPendingTaskTracker();
            }
            onRegister.accept((ChannelPendingTaskTracker)curr);
            return curr;
        });
        if (tracker.registered.compareAndSet(false, true)) {
            channel.addCloseListener(ActionListener.running(() -> {
                ChannelPendingTaskTracker removedTracker = this.channelPendingTaskTrackers.remove(channel);
                assert (removedTracker == tracker);
                this.onChannelClosed(tracker);
            }));
        }
        return tracker;
    }

    final int numberOfChannelPendingTaskTrackers() {
        return this.channelPendingTaskTrackers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChannelClosed(ChannelPendingTaskTracker channel) {
        final Set<CancellableTask> tasks = channel.drainTasks();
        if (!tasks.isEmpty()) {
            this.threadPool.generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    logger.warn("failed to cancel tasks on channel closed", (Throwable)e);
                }

                @Override
                protected void doRun() {
                    for (CancellableTask task : tasks) {
                        TaskManager.this.cancelTaskAndDescendants(task, "channel was closed", false, ActionListener.noop());
                    }
                }
            });
        }
        Map<TaskId, Ban> map = this.bannedParents;
        synchronized (map) {
            this.bannedParents.values().removeIf(ban -> ban.unregisterChannel(channel) && ban.registeredChannels() == 0);
        }
    }

    public void cancelTaskAndDescendants(CancellableTask task, String reason, boolean waitForCompletion, ActionListener<Void> listener) {
        this.getCancellationService().cancelTaskAndDescendants(task, reason, waitForCompletion, listener);
    }

    public Set<String> getTaskHeaders() {
        return this.taskHeaders;
    }

    private static class CancellableTaskHolder {
        private final CancellableTask task;
        private boolean finished = false;
        private List<Runnable> cancellationListeners = null;
        private Map<Transport.Connection, Integer> childTasksPerConnection = null;
        private String banChildrenReason;
        private List<Runnable> childTaskCompletedListeners = null;

        CancellableTaskHolder(CancellableTask task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel(String reason, Runnable listener) {
            Runnable toRun;
            CancellableTaskHolder cancellableTaskHolder = this;
            synchronized (cancellableTaskHolder) {
                if (this.finished) {
                    assert (this.cancellationListeners == null);
                    toRun = listener;
                } else {
                    toRun = () -> {};
                    if (listener != null) {
                        if (this.cancellationListeners == null) {
                            this.cancellationListeners = new ArrayList<Runnable>();
                        }
                        this.cancellationListeners.add(listener);
                    }
                }
            }
            try {
                this.task.cancel(reason);
            }
            finally {
                if (toRun != null) {
                    toRun.run();
                }
            }
        }

        void cancel(String reason) {
            this.task.cancel(reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            List<Runnable> listeners;
            CancellableTaskHolder cancellableTaskHolder = this;
            synchronized (cancellableTaskHolder) {
                this.finished = true;
                if (this.cancellationListeners == null) {
                    return;
                }
                listeners = this.cancellationListeners;
                this.cancellationListeners = null;
            }
            this.notifyListeners(listeners);
        }

        private void notifyListeners(List<Runnable> listeners) {
            assert (!Thread.holdsLock(this));
            Exception rootException = null;
            for (Runnable listener : listeners) {
                try {
                    listener.run();
                }
                catch (RuntimeException inner) {
                    rootException = ExceptionsHelper.useOrSuppress(rootException, inner);
                }
            }
            ExceptionsHelper.reThrowIfNotNull(rootException);
        }

        public CancellableTask getTask() {
            return this.task;
        }

        synchronized void registerChildConnection(Transport.Connection connection) {
            if (this.banChildrenReason != null) {
                throw new TaskCancelledException("parent task was cancelled [" + this.banChildrenReason + "]");
            }
            if (this.childTasksPerConnection == null) {
                this.childTasksPerConnection = new HashMap<Transport.Connection, Integer>();
            }
            this.childTasksPerConnection.merge(connection, 1, Integer::sum);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregisterChildConnection(Transport.Connection node) {
            List<Runnable> listeners;
            CancellableTaskHolder cancellableTaskHolder = this;
            synchronized (cancellableTaskHolder) {
                if (this.childTasksPerConnection.merge(node, -1, Integer::sum) == 0) {
                    this.childTasksPerConnection.remove(node);
                }
                if (!this.childTasksPerConnection.isEmpty() || this.childTaskCompletedListeners == null) {
                    return;
                }
                listeners = this.childTaskCompletedListeners;
                this.childTaskCompletedListeners = null;
            }
            this.notifyListeners(listeners);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set<Transport.Connection> startBan(String reason, Runnable onChildTasksCompleted) {
            Runnable toRun;
            Set<Object> pendingChildConnections;
            CancellableTaskHolder cancellableTaskHolder = this;
            synchronized (cancellableTaskHolder) {
                assert (reason != null);
                this.banChildrenReason = reason == null ? "none" : reason;
                pendingChildConnections = this.childTasksPerConnection == null ? Collections.emptySet() : Set.copyOf(this.childTasksPerConnection.keySet());
                if (pendingChildConnections.isEmpty()) {
                    assert (this.childTaskCompletedListeners == null);
                    toRun = onChildTasksCompleted;
                } else {
                    toRun = () -> {};
                    if (this.childTaskCompletedListeners == null) {
                        this.childTaskCompletedListeners = new ArrayList<Runnable>();
                    }
                    this.childTaskCompletedListeners.add(onChildTasksCompleted);
                }
            }
            toRun.run();
            return pendingChildConnections;
        }
    }

    private class Ban {
        final String reason;
        final Set<ChannelPendingTaskTracker> channels;

        Ban(String reason) {
            assert (Thread.holdsLock(TaskManager.this.bannedParents));
            this.reason = reason;
            this.channels = new HashSet<ChannelPendingTaskTracker>();
        }

        void registerChannel(ChannelPendingTaskTracker channel) {
            assert (Thread.holdsLock(TaskManager.this.bannedParents));
            this.channels.add(channel);
        }

        boolean unregisterChannel(ChannelPendingTaskTracker channel) {
            assert (Thread.holdsLock(TaskManager.this.bannedParents));
            return this.channels.remove(channel);
        }

        int registeredChannels() {
            assert (Thread.holdsLock(TaskManager.this.bannedParents));
            return this.channels.size();
        }

        public String toString() {
            return "Ban{reason=" + this.reason + ", channels=" + String.valueOf(this.channels) + "}";
        }
    }

    private static class ChannelPendingTaskTracker {
        final AtomicBoolean registered = new AtomicBoolean();
        final Semaphore permits = Assertions.ENABLED ? new Semaphore(Integer.MAX_VALUE) : null;
        final Set<CancellableTask> pendingTasks = ConcurrentCollections.newConcurrentSet();

        private ChannelPendingTaskTracker() {
        }

        void addTask(CancellableTask task) {
            assert (this.permits.tryAcquire()) : "tracker was drained";
            boolean added = this.pendingTasks.add(task);
            assert (added) : "task " + task.getId() + " is in the pending list already";
            assert (this.releasePermit());
        }

        boolean acquireAllPermits() {
            this.permits.acquireUninterruptibly(Integer.MAX_VALUE);
            return true;
        }

        boolean releasePermit() {
            this.permits.release();
            return true;
        }

        Set<CancellableTask> drainTasks() {
            assert (this.acquireAllPermits());
            return Collections.unmodifiableSet(this.pendingTasks);
        }

        void removeTask(CancellableTask task) {
            boolean removed = this.pendingTasks.remove(task);
            assert (removed) : "task is not in the pending list: " + String.valueOf(task);
        }
    }
}

