/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.cluster.snapshots.clone.CloneSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.ProjectRepo;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.repositories.SnapshotMetrics;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.InFlightShardSnapshotStates;
import org.elasticsearch.snapshots.RegisteredPolicySnapshots;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotFeatureInfo;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotUtils;
import org.elasticsearch.snapshots.SnapshotsServiceUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public final class SnapshotsService
extends AbstractLifecycleComponent
implements ClusterStateApplier {
    public static final IndexVersion SHARD_GEN_IN_REPO_DATA_VERSION = IndexVersions.V_7_6_0;
    public static final IndexVersion INDEX_GEN_IN_REPO_DATA_VERSION = IndexVersions.V_7_9_0;
    public static final IndexVersion UUIDS_IN_REPO_DATA_VERSION = IndexVersions.V_7_12_0;
    public static final IndexVersion FILE_INFO_WRITER_UUIDS_IN_SHARD_DATA_VERSION = IndexVersions.V_7_16_0;
    public static final IndexVersion OLD_SNAPSHOT_FORMAT = IndexVersions.V_7_5_0;
    public static final String POLICY_ID_METADATA_FIELD = "policy";
    private static final Logger logger = LogManager.getLogger(SnapshotsService.class);
    public static final String NO_FEATURE_STATES_VALUE = "none";
    private final ClusterService clusterService;
    private final RerouteService rerouteService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final RepositoriesService repositoriesService;
    private final ThreadPool threadPool;
    private final Map<Snapshot, List<ActionListener<SnapshotInfo>>> snapshotCompletionListeners = new ConcurrentHashMap<Snapshot, List<ActionListener<SnapshotInfo>>>();
    private final Map<String, List<ActionListener<Void>>> snapshotDeletionListeners = new ConcurrentHashMap<String, List<ActionListener<Void>>>();
    private final Set<ProjectRepo> currentlyFinalizing = Collections.synchronizedSet(new HashSet());
    private final Set<Snapshot> endingSnapshots = Collections.synchronizedSet(new HashSet());
    private final Set<Snapshot> initializingClones = Collections.synchronizedSet(new HashSet());
    private final OngoingRepositoryOperations repositoryOperations = new OngoingRepositoryOperations();
    private final SystemIndices systemIndices;
    private final boolean serializeProjectMetadata;
    private final SnapshotMetrics snapshotMetrics;
    private final MasterServiceTaskQueue<SnapshotTask> masterServiceTaskQueue;
    private final ShardSnapshotUpdateCompletionHandler shardSnapshotUpdateCompletionHandler;
    public static final Setting<Integer> MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING = Setting.intSetting("snapshot.max_concurrent_operations", 1000, 1, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private volatile int maxConcurrentOperations;
    private final Set<RepositoryShardId> currentlyCloning = Collections.synchronizedSet(new HashSet());
    private static final String REMOVE_SNAPSHOT_METADATA_TASK_SOURCE = "remove snapshot metadata";
    private final MasterServiceTaskQueue<UpdateNodeIdsForRemovalTask> updateNodeIdsToRemoveQueue;

    public SnapshotsService(Settings settings, ClusterService clusterService, RerouteService rerouteService, IndexNameExpressionResolver indexNameExpressionResolver, RepositoriesService repositoriesService, TransportService transportService, SystemIndices systemIndices, boolean serializeProjectMetadata, SnapshotMetrics snapshotMetrics) {
        this.clusterService = clusterService;
        this.rerouteService = rerouteService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.repositoriesService = repositoriesService;
        this.threadPool = transportService.getThreadPool();
        this.snapshotMetrics = snapshotMetrics;
        if (DiscoveryNode.isMasterNode(settings)) {
            clusterService.addLowPriorityApplier(this);
            this.maxConcurrentOperations = MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING.get(settings);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING, i -> {
                this.maxConcurrentOperations = i;
            });
        }
        this.systemIndices = systemIndices;
        this.serializeProjectMetadata = serializeProjectMetadata;
        this.masterServiceTaskQueue = clusterService.createTaskQueue("snapshots-service", Priority.NORMAL, new SnapshotTaskExecutor());
        this.updateNodeIdsToRemoveQueue = clusterService.createTaskQueue("snapshots-service-node-ids", Priority.NORMAL, UpdateNodeIdsForRemovalTask::executeBatch);
        this.shardSnapshotUpdateCompletionHandler = this::handleShardSnapshotUpdateCompletion;
    }

    public void executeSnapshot(ProjectId projectId, CreateSnapshotRequest request, ActionListener<SnapshotInfo> listener) {
        this.createSnapshot(projectId, request, listener.delegateFailureAndWrap((l, snapshot) -> this.addListener((Snapshot)snapshot, (ActionListener<SnapshotInfo>)l)));
    }

    public void createSnapshot(ProjectId projectId, CreateSnapshotRequest request, ActionListener<Snapshot> listener) {
        String repositoryName = request.repository();
        String snapshotName = IndexNameExpressionResolver.resolveDateMathExpression(request.snapshot());
        SnapshotsServiceUtils.validate(repositoryName, snapshotName);
        SnapshotId snapshotId = new SnapshotId(snapshotName, request.uuid());
        Repository repository = this.repositoriesService.repository(projectId, request.repository());
        if (repository.isReadOnly()) {
            listener.onFailure(new RepositoryException(repository.getMetadata().name(), "cannot create snapshot in a readonly repository", new Object[0]));
            return;
        }
        this.submitCreateSnapshotRequest(request, listener, repository, new Snapshot(projectId, repositoryName, snapshotId), repository.getMetadata());
    }

    private void submitCreateSnapshotRequest(CreateSnapshotRequest request, ActionListener<Snapshot> listener, Repository repository, Snapshot snapshot, RepositoryMetadata initialRepositoryMetadata) {
        repository.getRepositoryData(EsExecutors.DIRECT_EXECUTOR_SERVICE, listener.delegateFailure((l, repositoryData) -> this.masterServiceTaskQueue.submitTask("create_snapshot [" + snapshot.getSnapshotId().getName() + "]", new CreateSnapshotTask(repository, (RepositoryData)repositoryData, (ActionListener<Snapshot>)l, snapshot, request, initialRepositoryMetadata), request.masterNodeTimeout())));
    }

    public void cloneSnapshot(final ProjectId projectId, CloneSnapshotRequest request, ActionListener<Void> listener) {
        final String repositoryName = request.repository();
        Repository repository = this.repositoriesService.repository(projectId, repositoryName);
        if (repository.isReadOnly()) {
            listener.onFailure(new RepositoryException(repositoryName, "cannot create snapshot in a readonly repository", new Object[0]));
            return;
        }
        String snapshotName = IndexNameExpressionResolver.resolveDateMathExpression(request.target());
        SnapshotsServiceUtils.validate(repositoryName, snapshotName);
        SnapshotId snapshotId = new SnapshotId(snapshotName, UUIDs.randomBase64UUID());
        Snapshot snapshot = new Snapshot(projectId, repositoryName, snapshotId);
        this.initializingClones.add(snapshot);
        this.executeConsistentStateUpdate(repository, repositoryData -> new ClusterStateUpdateTask(request.masterNodeTimeout(), (RepositoryData)repositoryData, snapshotName, repository, request, snapshot, listener){
            private SnapshotsInProgress.Entry newEntry;
            final /* synthetic */ RepositoryData val$repositoryData;
            final /* synthetic */ String val$snapshotName;
            final /* synthetic */ Repository val$repository;
            final /* synthetic */ CloneSnapshotRequest val$request;
            final /* synthetic */ Snapshot val$snapshot;
            final /* synthetic */ ActionListener val$listener;
            {
                this.val$repositoryData = repositoryData;
                this.val$snapshotName = string2;
                this.val$repository = repository;
                this.val$request = cloneSnapshotRequest;
                this.val$snapshot = snapshot;
                this.val$listener = actionListener;
                super(timeout);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                ProjectMetadata projectMetadata = currentState.metadata().getProject(projectId);
                SnapshotsServiceUtils.ensureRepositoryExists(repositoryName, projectMetadata);
                SnapshotsServiceUtils.ensureSnapshotNameAvailableInRepo(this.val$repositoryData, this.val$snapshotName, this.val$repository);
                SnapshotsServiceUtils.ensureNoCleanupInProgress(currentState, repositoryName, this.val$snapshotName, "clone snapshot");
                SnapshotsServiceUtils.ensureNotReadOnly(projectMetadata, repositoryName);
                SnapshotsInProgress snapshots = SnapshotsInProgress.get(currentState);
                SnapshotsServiceUtils.ensureSnapshotNameNotRunning(snapshots, projectId, repositoryName, this.val$snapshotName);
                SnapshotsServiceUtils.validate(repositoryName, this.val$snapshotName, projectMetadata);
                SnapshotId sourceSnapshotId = this.val$repositoryData.getSnapshotIds().stream().filter(src -> src.getName().equals(this.val$request.source())).findAny().orElseThrow(() -> new SnapshotMissingException(repositoryName, this.val$request.source()));
                SnapshotDeletionsInProgress deletionsInProgress = SnapshotDeletionsInProgress.get(currentState);
                if (deletionsInProgress.getEntries().stream().anyMatch(entry -> entry.snapshots().contains(sourceSnapshotId))) {
                    throw new ConcurrentSnapshotExecutionException(repositoryName, sourceSnapshotId.getName(), "cannot clone from snapshot that is being deleted");
                }
                SnapshotsService.this.ensureBelowConcurrencyLimit(repositoryName, this.val$snapshotName, snapshots, deletionsInProgress);
                ArrayList<String> indicesForSnapshot = new ArrayList<String>();
                for (IndexId indexId : this.val$repositoryData.getIndices().values()) {
                    if (!this.val$repositoryData.getSnapshots(indexId).contains(sourceSnapshotId)) continue;
                    indicesForSnapshot.add(indexId.getName());
                }
                List<String> matchingIndices = SnapshotUtils.filterIndices(indicesForSnapshot, this.val$request.indices(), this.val$request.indicesOptions());
                if (matchingIndices.isEmpty()) {
                    throw new SnapshotException(new Snapshot(projectId, repositoryName, sourceSnapshotId), "No indices in the source snapshot [" + String.valueOf(sourceSnapshotId) + "] matched requested pattern [" + org.elasticsearch.common.Strings.arrayToCommaDelimitedString(this.val$request.indices()) + "]");
                }
                this.newEntry = SnapshotsInProgress.startClone(this.val$snapshot, sourceSnapshotId, this.val$repositoryData.resolveIndices(matchingIndices), SnapshotsService.this.threadPool.absoluteTimeInMillis(), this.val$repositoryData.getGenId(), SnapshotsServiceUtils.minCompatibleVersion(currentState.nodes().getMaxDataNodeCompatibleIndexVersion(), this.val$repositoryData, null));
                return ClusterState.builder(currentState).putCustom("snapshots", snapshots.withAddedEntry(this.newEntry)).build();
            }

            @Override
            public void onFailure(Exception e) {
                SnapshotsService.this.initializingClones.remove(this.val$snapshot);
                SnapshotsServiceUtils.logSnapshotFailure("clone", this.val$snapshot, e);
                this.val$listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                logger.info("snapshot clone [{}] started", (Object)this.val$snapshot);
                SnapshotsService.this.addListener(this.val$snapshot, this.val$listener.delegateFailureAndWrap((l, r) -> l.onResponse(null)));
                SnapshotsService.this.startCloning(this.val$repository, this.newEntry);
            }
        }, "clone_snapshot [" + request.source() + "][" + snapshotName + "]", listener::onFailure);
    }

    private void startCloning(Repository repository, final SnapshotsInProgress.Entry cloneEntry) {
        Collection<IndexId> indices = cloneEntry.indices().values();
        SnapshotId sourceSnapshot = cloneEntry.source();
        Snapshot targetSnapshot = cloneEntry.snapshot();
        ExecutorService executor = this.threadPool.executor("snapshot");
        Consumer<Exception> onFailure = e -> {
            this.endingSnapshots.add(targetSnapshot);
            this.initializingClones.remove(targetSnapshot);
            logger.info(() -> "Failed to start snapshot clone [" + String.valueOf(cloneEntry) + "]", (Throwable)e);
            this.removeFailedSnapshotFromClusterState(targetSnapshot, (Exception)e, null, FinalizeSnapshotContext.UpdatedShardGenerations.EMPTY);
        };
        ListenableFuture<SnapshotInfo> snapshotInfoListener = new ListenableFuture<SnapshotInfo>();
        repository.getSnapshotInfo(sourceSnapshot, snapshotInfoListener);
        ListenableFuture<Collection<Collection>> allShardCountsListener = new ListenableFuture<Collection<Collection>>();
        GroupedActionListener shardCountListener = new GroupedActionListener(indices.size(), allShardCountsListener);
        snapshotInfoListener.addListener(ActionListener.wrap(snapshotInfo -> {
            for (IndexId indexId : indices) {
                if (!RestoreService.failed(snapshotInfo, indexId.getName())) continue;
                throw new SnapshotException(targetSnapshot, "Can't clone index [" + String.valueOf(indexId) + "] because its snapshot was not successful.");
            }
            repository.getRepositoryData(EsExecutors.DIRECT_EXECUTOR_SERVICE, ActionListener.wrap(repositoryData -> {
                for (IndexId index : indices) {
                    executor.execute(ActionRunnable.supply(shardCountListener, () -> {
                        IndexMetadata metadata = repository.getSnapshotIndexMetaData((RepositoryData)repositoryData, sourceSnapshot, index);
                        return Tuple.tuple(index, metadata.getNumberOfShards());
                    }));
                }
            }, onFailure));
        }, onFailure));
        allShardCountsListener.addListener(ActionListener.wrap(counts -> this.executeConsistentStateUpdate(repository, repoData -> new ClusterStateUpdateTask((RepositoryData)repoData, (Collection)counts, targetSnapshot, repository){
            private SnapshotsInProgress.Entry updatedEntry;
            final /* synthetic */ RepositoryData val$repoData;
            final /* synthetic */ Collection val$counts;
            final /* synthetic */ Snapshot val$targetSnapshot;
            final /* synthetic */ Repository val$repository;
            {
                this.val$repoData = repositoryData;
                this.val$counts = collection;
                this.val$targetSnapshot = snapshot;
                this.val$repository = repository;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(currentState);
                ProjectId projectId = cloneEntry.projectId();
                String repoName = cloneEntry.repository();
                List<SnapshotsInProgress.Entry> existingEntries = snapshotsInProgress.forRepo(projectId, repoName);
                ArrayList<SnapshotsInProgress.Entry> updatedEntries = new ArrayList<SnapshotsInProgress.Entry>(existingEntries.size());
                String localNodeId = currentState.nodes().getLocalNodeId();
                ShardGenerations shardGenerations = this.val$repoData.shardGenerations();
                for (SnapshotsInProgress.Entry existing : existingEntries) {
                    if (cloneEntry.snapshot().getSnapshotId().equals(existing.snapshot().getSnapshotId())) {
                        ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clonesBuilder = ImmutableOpenMap.builder();
                        boolean readyToExecute = !SnapshotDeletionsInProgress.get(currentState).hasExecutingDeletion(projectId, repoName);
                        InFlightShardSnapshotStates inFlightShardStates = readyToExecute ? InFlightShardSnapshotStates.forEntries(snapshotsInProgress.forRepo(projectId, repoName)) : null;
                        for (Tuple count : this.val$counts) {
                            for (int shardId = 0; shardId < (Integer)count.v2(); ++shardId) {
                                RepositoryShardId repoShardId = new RepositoryShardId((IndexId)count.v1(), shardId);
                                String indexName = repoShardId.indexName();
                                if (!readyToExecute || inFlightShardStates.isActive(indexName, shardId)) {
                                    clonesBuilder.put(repoShardId, SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED);
                                    continue;
                                }
                                clonesBuilder.put(repoShardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, inFlightShardStates.generationForShard(repoShardId.index(), shardId, shardGenerations)));
                            }
                        }
                        this.updatedEntry = cloneEntry.withClones(clonesBuilder.build());
                        continue;
                    }
                    updatedEntries.add(existing);
                }
                if (this.updatedEntry != null) {
                    updatedEntries.add(this.updatedEntry);
                    return SnapshotsServiceUtils.updateWithSnapshots(currentState, snapshotsInProgress.createCopyWithUpdatedEntriesForRepo(projectId, repoName, updatedEntries), null);
                }
                return currentState;
            }

            @Override
            public void onFailure(Exception e) {
                SnapshotsService.this.initializingClones.remove(this.val$targetSnapshot);
                logger.info(() -> "Failed to start snapshot clone [" + String.valueOf(cloneEntry) + "]", (Throwable)e);
                SnapshotsService.this.failAllListenersOnMasterFailOver(e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                SnapshotsService.this.initializingClones.remove(this.val$targetSnapshot);
                if (this.updatedEntry != null) {
                    Snapshot target = this.updatedEntry.snapshot();
                    SnapshotId sourceSnapshot = this.updatedEntry.source();
                    for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> indexClone : this.updatedEntry.shardSnapshotStatusByRepoShardId().entrySet()) {
                        SnapshotsInProgress.ShardSnapshotStatus shardStatusBefore = indexClone.getValue();
                        if (shardStatusBefore.state() != SnapshotsInProgress.ShardState.INIT) continue;
                        RepositoryShardId repoShardId = indexClone.getKey();
                        SnapshotsService.this.runReadyClone(target, sourceSnapshot, shardStatusBefore, repoShardId, this.val$repository);
                    }
                } else {
                    logger.warn("Did not find expected entry [{}] in the cluster state", (Object)cloneEntry);
                }
            }

            public String toString() {
                return org.elasticsearch.common.Strings.format("start snapshot clone [%s] from [%s]", this.updatedEntry.snapshot(), this.updatedEntry.source());
            }
        }, "start snapshot clone", onFailure), onFailure));
    }

    private void runReadyClone(Snapshot target, SnapshotId sourceSnapshot, SnapshotsInProgress.ShardSnapshotStatus shardStatusBefore, RepositoryShardId repoShardId, Repository repository) {
        SnapshotId targetSnapshot = target.getSnapshotId();
        String localNodeId = this.clusterService.localNode().getId();
        if (this.currentlyCloning.add(repoShardId)) {
            repository.cloneShardSnapshot(sourceSnapshot, targetSnapshot, repoShardId, shardStatusBefore.generation(), ActionListener.wrap(shardSnapshotResult -> this.createAndSubmitRequestToUpdateSnapshotState(target, null, repoShardId, SnapshotsInProgress.ShardSnapshotStatus.success(localNodeId, shardSnapshotResult), ActionListener.runBefore(ActionListener.wrap(v -> logger.trace("Marked [{}] as successfully cloned from [{}] to [{}]", (Object)repoShardId, (Object)sourceSnapshot, (Object)targetSnapshot), e -> {
                logger.warn("Cluster state update after successful shard clone [{}] failed", (Object)repoShardId);
                this.failAllListenersOnMasterFailOver((Exception)e);
            }), () -> this.currentlyCloning.remove(repoShardId))), e -> this.createAndSubmitRequestToUpdateSnapshotState(target, null, repoShardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, SnapshotsInProgress.ShardState.FAILED, shardStatusBefore.generation(), "failed to clone shard snapshot"), ActionListener.runBefore(ActionListener.wrap(v -> logger.trace("Marked [{}] as failed clone from [{}] to [{}]", (Object)repoShardId, (Object)sourceSnapshot, (Object)targetSnapshot), ex -> {
                logger.warn("Cluster state update after failed shard clone [{}] failed", (Object)repoShardId);
                this.failAllListenersOnMasterFailOver((Exception)ex);
            }), () -> this.currentlyCloning.remove(repoShardId)))));
        }
    }

    private void ensureBelowConcurrencyLimit(String repository, String name, SnapshotsInProgress snapshotsInProgress, SnapshotDeletionsInProgress deletionsInProgress) {
        int maxOps;
        int inProgressOperations = snapshotsInProgress.count() + deletionsInProgress.getEntries().size();
        if (inProgressOperations >= (maxOps = this.maxConcurrentOperations)) {
            throw new ConcurrentSnapshotExecutionException(repository, name, "Cannot start another operation, already running [" + inProgressOperations + "] operations and the current limit for concurrent snapshot operations is set to [" + maxOps + "]");
        }
    }

    private Metadata metadataForSnapshot(SnapshotsInProgress.Entry snapshot, Metadata metadata, ProjectId projectId) {
        ProjectMetadata snapshotProject = SnapshotsServiceUtils.projectForSnapshot(snapshot, metadata.getProject(projectId));
        Metadata.Builder builder = !snapshot.includeGlobalState() ? Metadata.builder() : Metadata.builder(metadata);
        builder.put(snapshotProject);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        block14: {
            try {
                if (event.localNodeMaster()) {
                    SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(event.state());
                    boolean newMaster = !event.previousState().nodes().isLocalNodeElectedMaster();
                    this.processExternalChanges(newMaster || SnapshotsServiceUtils.removedNodesCleanupNeeded(snapshotsInProgress, event.nodesDelta().removedNodes()), snapshotsInProgress.nodeIdsForRemovalChanged(SnapshotsInProgress.get(event.previousState())) || event.routingTableChanged() && SnapshotsServiceUtils.waitingShardsStartedOrUnassigned(snapshotsInProgress, event));
                    if (newMaster || !event.state().metadata().nodeShutdowns().equals(event.previousState().metadata().nodeShutdowns())) {
                        this.updateNodeIdsToRemoveQueue.submitTask("SnapshotsService#updateNodeIdsToRemove", new UpdateNodeIdsForRemovalTask(), null);
                    }
                    break block14;
                }
                ArrayList<Runnable> readyToResolveListeners = new ArrayList<Runnable>();
                Set<ProjectRepo> set = this.currentlyFinalizing;
                synchronized (set) {
                    for (Snapshot snapshot : this.snapshotCompletionListeners.keySet()) {
                        if (!this.endingSnapshots.add(snapshot)) continue;
                        this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "no longer master"), readyToResolveListeners::add);
                        assert (!this.endingSnapshots.contains(snapshot)) : snapshot;
                    }
                    if (!this.snapshotDeletionListeners.isEmpty()) {
                        NotMasterException cause = new NotMasterException("no longer master");
                        Iterator<List<ActionListener<Void>>> it = this.snapshotDeletionListeners.values().iterator();
                        while (it.hasNext()) {
                            List<ActionListener<Void>> listeners = it.next();
                            readyToResolveListeners.add(() -> SnapshotsServiceUtils.failListenersIgnoringException(listeners, cause));
                            it.remove();
                        }
                    }
                }
                readyToResolveListeners.forEach(Runnable::run);
            }
            catch (Exception e) {
                assert (false) : new AssertionError((Object)e);
                logger.warn("Failed to update snapshot state ", (Throwable)e);
            }
        }
        assert (this.assertConsistentWithClusterState(event.state()));
        assert (SnapshotsServiceUtils.assertNoDanglingSnapshots(event.state()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assertConsistentWithClusterState(ClusterState state) {
        SnapshotDeletionsInProgress snapshotDeletionsInProgress;
        SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(state);
        if (!snapshotsInProgress.isEmpty()) {
            Set<Snapshot> set = this.endingSnapshots;
            synchronized (set) {
                Set runningSnapshots = Stream.concat(snapshotsInProgress.asStream().map(SnapshotsInProgress.Entry::snapshot), this.endingSnapshots.stream()).collect(Collectors.toSet());
                Set<Snapshot> snapshotListenerKeys = this.snapshotCompletionListeners.keySet();
                assert (runningSnapshots.containsAll(snapshotListenerKeys)) : "Saw completion listeners for unknown snapshots in " + String.valueOf(snapshotListenerKeys) + " but running snapshots are " + String.valueOf(runningSnapshots);
            }
        }
        if ((snapshotDeletionsInProgress = SnapshotDeletionsInProgress.get(state)).hasDeletionsInProgress()) {
            Set<String> set = this.repositoryOperations.runningDeletions;
            synchronized (set) {
                Set runningDeletes = Stream.concat(snapshotDeletionsInProgress.getEntries().stream().map(SnapshotDeletionsInProgress.Entry::uuid), this.repositoryOperations.runningDeletions.stream()).collect(Collectors.toSet());
                Set<String> deleteListenerKeys = this.snapshotDeletionListeners.keySet();
                assert (runningDeletes.containsAll(deleteListenerKeys)) : "Saw deletions listeners for unknown uuids in " + String.valueOf(deleteListenerKeys) + " but running deletes are " + String.valueOf(runningDeletes);
            }
        }
        return true;
    }

    private void processExternalChanges(final boolean changedNodes, boolean changedShards) {
        if (!changedNodes && !changedShards) {
            return;
        }
        final String source = "update snapshot after shards changed [" + changedShards + "] or node configuration changed [" + changedNodes + "]";
        this.submitUnbatchedTask(source, new ClusterStateUpdateTask(){
            private final Collection<SnapshotsInProgress.Entry> finishedSnapshots = new ArrayList<SnapshotsInProgress.Entry>();
            private final Collection<SnapshotDeletionsInProgress.Entry> deletionsToExecute = new ArrayList<SnapshotDeletionsInProgress.Entry>();

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(currentState);
                SnapshotDeletionsInProgress deletesInProgress = SnapshotDeletionsInProgress.get(currentState);
                DiscoveryNodes nodes = currentState.nodes();
                EnumSet<SnapshotsInProgress.State> statesToUpdate = changedNodes ? EnumSet.of(SnapshotsInProgress.State.STARTED, SnapshotsInProgress.State.ABORTED) : EnumSet.of(SnapshotsInProgress.State.STARTED);
                SnapshotsInProgress updatedSnapshots = snapshotsInProgress;
                for (List<SnapshotsInProgress.Entry> snapshotsInRepo : snapshotsInProgress.entriesByRepo()) {
                    boolean changed = false;
                    ArrayList<SnapshotsInProgress.Entry> updatedEntriesForRepo = new ArrayList<SnapshotsInProgress.Entry>();
                    HashMap<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> knownFailures = new HashMap<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus>();
                    ProjectId projectId = snapshotsInRepo.get(0).projectId();
                    String repositoryName = snapshotsInRepo.get(0).repository();
                    for (SnapshotsInProgress.Entry snapshotEntry : snapshotsInRepo) {
                        if (statesToUpdate.contains((Object)snapshotEntry.state())) {
                            if (snapshotEntry.isClone()) {
                                if (snapshotEntry.shardSnapshotStatusByRepoShardId().isEmpty()) {
                                    if (SnapshotsService.this.initializingClones.contains(snapshotEntry.snapshot())) {
                                        updatedEntriesForRepo.add(snapshotEntry);
                                        continue;
                                    }
                                    logger.debug("removing not yet started clone operation [{}]", (Object)snapshotEntry);
                                    changed = true;
                                    continue;
                                }
                                if (deletesInProgress.hasExecutingDeletion(projectId, repositoryName)) {
                                    updatedEntriesForRepo.add(snapshotEntry);
                                    continue;
                                }
                                ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clones = null;
                                InFlightShardSnapshotStates inFlightShardSnapshotStates = null;
                                for (Map.Entry failureEntry : knownFailures.entrySet()) {
                                    RepositoryShardId repositoryShardId = (RepositoryShardId)failureEntry.getKey();
                                    SnapshotsInProgress.ShardSnapshotStatus existingStatus = snapshotEntry.shardSnapshotStatusByRepoShardId().get(repositoryShardId);
                                    if (!SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED.equals(existingStatus)) continue;
                                    if (inFlightShardSnapshotStates == null) {
                                        inFlightShardSnapshotStates = InFlightShardSnapshotStates.forEntries(updatedEntriesForRepo);
                                    }
                                    if (inFlightShardSnapshotStates.isActive(repositoryShardId.indexName(), repositoryShardId.shardId())) continue;
                                    if (clones == null) {
                                        clones = ImmutableOpenMap.builder(snapshotEntry.shardSnapshotStatusByRepoShardId());
                                    }
                                    clones.put(repositoryShardId, new SnapshotsInProgress.ShardSnapshotStatus(nodes.getLocalNodeId(), ((SnapshotsInProgress.ShardSnapshotStatus)failureEntry.getValue()).generation()));
                                }
                                if (clones != null) {
                                    changed = true;
                                    updatedEntriesForRepo.add(snapshotEntry.withClones(clones.build()));
                                    continue;
                                }
                                updatedEntriesForRepo.add(snapshotEntry);
                                continue;
                            }
                            ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = SnapshotsServiceUtils.processWaitingShardsAndRemovedNodes(snapshotEntry, currentState.routingTable(projectId), nodes, snapshotsInProgress::isNodeIdForRemoval, knownFailures);
                            if (shards != null) {
                                SnapshotsInProgress.Entry updatedSnapshot = snapshotEntry.withShardStates(shards);
                                changed = true;
                                if (updatedSnapshot.state().completed()) {
                                    this.finishedSnapshots.add(updatedSnapshot);
                                }
                                updatedEntriesForRepo.add(updatedSnapshot);
                                continue;
                            }
                            updatedEntriesForRepo.add(snapshotEntry);
                            continue;
                        }
                        if (snapshotEntry.repositoryStateId() == -2L) {
                            changed = true;
                            logger.debug("[{}] was found in dangling INIT or ABORTED state", (Object)snapshotEntry);
                            continue;
                        }
                        if (snapshotEntry.state().completed() || SnapshotsInProgress.completed(snapshotEntry.shardSnapshotStatusByRepoShardId().values())) {
                            this.finishedSnapshots.add(snapshotEntry);
                        }
                        updatedEntriesForRepo.add(snapshotEntry);
                    }
                    if (!changed) continue;
                    updatedSnapshots = updatedSnapshots.createCopyWithUpdatedEntriesForRepo(projectId, repositoryName, updatedEntriesForRepo);
                }
                ClusterState res = SnapshotsServiceUtils.readyDeletions(updatedSnapshots != snapshotsInProgress ? ClusterState.builder(currentState).putCustom("snapshots", updatedSnapshots).build() : currentState, null).v1();
                for (SnapshotDeletionsInProgress.Entry delete : SnapshotDeletionsInProgress.get(res).getEntries()) {
                    if (delete.state() != SnapshotDeletionsInProgress.State.STARTED) continue;
                    this.deletionsToExecute.add(delete);
                }
                return res;
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn(() -> Strings.format("failed to update snapshot state after shards started or nodes removed from [%s] ", source), (Throwable)e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                SnapshotDeletionsInProgress snapshotDeletionsInProgress = SnapshotDeletionsInProgress.get(newState);
                if (!this.finishedSnapshots.isEmpty()) {
                    Set reposWithRunningDeletes = snapshotDeletionsInProgress.getEntries().stream().filter(entry -> entry.state() == SnapshotDeletionsInProgress.State.STARTED).map(SnapshotDeletionsInProgress.Entry::repository).collect(Collectors.toSet());
                    for (SnapshotsInProgress.Entry entry2 : this.finishedSnapshots) {
                        if (reposWithRunningDeletes.contains(entry2.repository())) continue;
                        SnapshotsService.this.endSnapshot(entry2, newState.metadata(), null);
                    }
                }
                SnapshotsService.this.startExecutableClones(SnapshotsInProgress.get(newState));
                for (SnapshotDeletionsInProgress.Entry entry3 : this.deletionsToExecute) {
                    if (!SnapshotsService.this.tryEnterRepoLoop(entry3.projectId(), entry3.repository())) continue;
                    SnapshotsService.this.deleteSnapshotsFromRepository(entry3, newState.nodes().getMaxDataNodeCompatibleIndexVersion());
                }
            }
        });
    }

    private void endSnapshot(SnapshotsInProgress.Entry entry, final Metadata metadata, @Nullable RepositoryData repositoryData) {
        String repoName;
        final Snapshot snapshot = entry.snapshot();
        final boolean newFinalization = this.endingSnapshots.add(snapshot);
        if (entry.isClone() && entry.state() == SnapshotsInProgress.State.FAILED) {
            logger.debug("Removing failed snapshot clone [{}] from cluster state", (Object)entry);
            if (newFinalization) {
                this.removeFailedSnapshotFromClusterState(snapshot, new SnapshotException(snapshot, entry.failure()), null, FinalizeSnapshotContext.UpdatedShardGenerations.EMPTY);
            }
            return;
        }
        final ProjectId projectId = snapshot.getProjectId();
        if (this.tryEnterRepoLoop(projectId, repoName = snapshot.getRepository())) {
            if (repositoryData == null) {
                this.repositoriesService.repository(projectId, repoName).getRepositoryData(EsExecutors.DIRECT_EXECUTOR_SERVICE, new ActionListener<RepositoryData>(){

                    @Override
                    public void onResponse(RepositoryData repositoryData) {
                        if (newFinalization) {
                            SnapshotsService.this.finalizeSnapshotEntry(snapshot, metadata, repositoryData);
                        } else {
                            SnapshotsService.this.runNextQueuedOperation(repositoryData, projectId, repoName, false);
                        }
                    }

                    @Override
                    public void onFailure(Exception e) {
                        SnapshotsService.this.submitUnbatchedTask("fail repo tasks for [" + repoName + "]", new FailPendingRepoTasksTask(projectId, repoName, e));
                    }
                });
            } else if (newFinalization) {
                this.finalizeSnapshotEntry(snapshot, metadata, repositoryData);
            } else {
                this.runNextQueuedOperation(repositoryData, projectId, repoName, false);
            }
        } else if (newFinalization) {
            this.repositoryOperations.addFinalization(snapshot, metadata);
        }
    }

    private boolean tryEnterRepoLoop(ProjectId projectId, String repository) {
        return this.currentlyFinalizing.add(new ProjectRepo(projectId, repository));
    }

    private void leaveRepoLoop(ProjectId projectId, String repository) {
        boolean removed = this.currentlyFinalizing.remove(new ProjectRepo(projectId, repository));
        assert (removed);
    }

    private void finalizeSnapshotEntry(Snapshot snapshot, Metadata metadata, RepositoryData repositoryData) {
        ProjectId projectId = snapshot.getProjectId();
        Metadata effectiveMetadata = this.serializeProjectMetadata ? Metadata.builder().put(metadata.getProject(projectId)).build() : metadata;
        this.threadPool.executor("snapshot").execute(new SnapshotFinalization(snapshot, effectiveMetadata, repositoryData));
    }

    private List<ActionListener<SnapshotInfo>> endAndGetListenersToResolve(Snapshot snapshot) {
        List<ActionListener<SnapshotInfo>> listenersToComplete = this.snapshotCompletionListeners.remove(snapshot);
        this.endingSnapshots.remove(snapshot);
        return listenersToComplete;
    }

    private void handleFinalizationFailure(Exception e, Snapshot snapshot, RepositoryData repositoryData, FinalizeSnapshotContext.UpdatedShardGenerations updatedShardGenerations) {
        if (ExceptionsHelper.unwrap(e, NotMasterException.class, FailedToCommitClusterStateException.class) != null) {
            logger.debug(() -> "[" + String.valueOf(snapshot) + "] failed to update cluster state during snapshot finalization", (Throwable)e);
            this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "Failed to update cluster state during snapshot finalization", e), Runnable::run);
            this.failAllListenersOnMasterFailOver(e);
        } else {
            logger.warn(() -> "[" + String.valueOf(snapshot) + "] failed to finalize snapshot", (Throwable)e);
            this.removeFailedSnapshotFromClusterState(snapshot, e, repositoryData, updatedShardGenerations);
        }
    }

    private void runNextQueuedOperation(RepositoryData repositoryData, ProjectId projectId, String repository, boolean attemptDelete) {
        assert (this.currentlyFinalizing.contains(new ProjectRepo(projectId, repository)));
        Tuple<Snapshot, Metadata> nextFinalization = this.repositoryOperations.pollFinalization(projectId, repository);
        if (nextFinalization == null) {
            if (attemptDelete) {
                this.runReadyDeletions(repositoryData, projectId, repository);
            } else {
                this.leaveRepoLoop(projectId, repository);
            }
        } else {
            logger.trace("Moving on to finalizing next snapshot [{}]", nextFinalization);
            this.finalizeSnapshotEntry(nextFinalization.v1(), nextFinalization.v2(), repositoryData);
        }
    }

    private void runReadyDeletions(final RepositoryData repositoryData, final ProjectId projectId, final String repository) {
        this.submitUnbatchedTask("Run ready deletions", new ClusterStateUpdateTask(){
            private SnapshotDeletionsInProgress.Entry deletionToRun;

            @Override
            public ClusterState execute(ClusterState currentState) {
                assert (SnapshotsServiceUtils.readyDeletions(currentState, projectId).v1() == currentState) : "Deletes should have been set to ready by finished snapshot deletes and finalizations";
                for (SnapshotDeletionsInProgress.Entry entry : SnapshotDeletionsInProgress.get(currentState).getEntries()) {
                    if (!entry.projectId().equals(projectId) || !entry.repository().equals(repository) || entry.state() != SnapshotDeletionsInProgress.State.STARTED) continue;
                    this.deletionToRun = entry;
                    break;
                }
                return currentState;
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn("Failed to run ready delete operations", (Throwable)e);
                SnapshotsService.this.failAllListenersOnMasterFailOver(e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                if (this.deletionToRun == null) {
                    SnapshotsService.this.runNextQueuedOperation(repositoryData, projectId, repository, false);
                } else {
                    SnapshotsService.this.deleteSnapshotsFromRepository(this.deletionToRun, repositoryData, newState.nodes().getMaxDataNodeCompatibleIndexVersion());
                }
            }
        });
    }

    private void removeFailedSnapshotFromClusterState(final Snapshot snapshot, final Exception failure, final @Nullable RepositoryData repositoryData, final FinalizeSnapshotContext.UpdatedShardGenerations updatedShardGenerations) {
        assert (failure != null) : "Failure must be supplied";
        this.submitUnbatchedTask(REMOVE_SNAPSHOT_METADATA_TASK_SOURCE, new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                ClusterState updatedState = SnapshotsServiceUtils.stateWithoutSnapshot(currentState, snapshot, updatedShardGenerations);
                assert (updatedState == currentState || SnapshotsService.this.endingSnapshots.contains(snapshot)) : "did not track [" + String.valueOf(snapshot) + "] in ending snapshots while removing it from the cluster state";
                return SnapshotsServiceUtils.updateWithSnapshots(updatedState, null, SnapshotsServiceUtils.deletionsWithoutSnapshots(SnapshotDeletionsInProgress.get(updatedState), Collections.singletonList(snapshot.getSnapshotId()), snapshot.getProjectId(), snapshot.getRepository()));
            }

            @Override
            public void onFailure(Exception e) {
                if (e instanceof NotMasterException) {
                    failure.addSuppressed(new SnapshotException(snapshot, "no longer master"));
                }
                logger.log(MasterService.isPublishFailureException(e) ? Level.DEBUG : Level.WARN, () -> "[" + String.valueOf(snapshot) + "] failed to remove snapshot metadata", (Throwable)e);
                SnapshotsService.this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "Failed to remove snapshot from cluster state", e), Runnable::run);
                SnapshotsService.this.failAllListenersOnMasterFailOver(e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                SnapshotsService.this.failSnapshotCompletionListeners(snapshot, failure, Runnable::run);
                if (repositoryData != null) {
                    SnapshotsService.this.runNextQueuedOperation(repositoryData, snapshot.getProjectId(), snapshot.getRepository(), true);
                }
            }
        });
    }

    private void failSnapshotCompletionListeners(Snapshot snapshot, Exception e, Consumer<Runnable> failingListenersConsumer) {
        List<ActionListener<SnapshotInfo>> listeners = this.endAndGetListenersToResolve(snapshot);
        failingListenersConsumer.accept(() -> SnapshotsServiceUtils.failListenersIgnoringException(listeners, e));
        assert (this.repositoryOperations.assertNotQueued(snapshot));
    }

    public void deleteSnapshots(ProjectId projectId, DeleteSnapshotRequest request, ActionListener<Void> listener) {
        String repositoryName = request.repository();
        Object[] snapshotNames = request.snapshots();
        Repository repository = this.repositoriesService.repository(projectId, repositoryName);
        this.executeConsistentStateUpdate(repository, arg_0 -> this.lambda$deleteSnapshots$23(request, projectId, repositoryName, (String[])snapshotNames, listener, repository, arg_0), "delete snapshot [" + String.valueOf(repository) + "]" + Arrays.toString(snapshotNames), listener::onFailure);
    }

    private void addDeleteListener(String deleteUUID, ActionListener<Void> listener) {
        this.snapshotDeletionListeners.computeIfAbsent(deleteUUID, k -> new CopyOnWriteArrayList()).add(ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext()));
    }

    private void deleteSnapshotsFromRepository(final SnapshotDeletionsInProgress.Entry deleteEntry, final IndexVersion minNodeVersion) {
        final long expectedRepoGen = deleteEntry.repositoryStateId();
        this.repositoriesService.getRepositoryData(deleteEntry.projectId(), deleteEntry.repository(), new ActionListener<RepositoryData>(){

            @Override
            public void onResponse(RepositoryData repositoryData) {
                assert (repositoryData.getGenId() == expectedRepoGen) : "Repository generation should not change as long as a ready delete is found in the cluster state but found [" + expectedRepoGen + "] in cluster state and [" + repositoryData.getGenId() + "] in the repository";
                SnapshotsService.this.deleteSnapshotsFromRepository(deleteEntry, repositoryData, minNodeVersion);
            }

            @Override
            public void onFailure(Exception e) {
                SnapshotsService.this.submitUnbatchedTask("fail repo tasks for [" + deleteEntry.repository() + "]", new FailPendingRepoTasksTask(deleteEntry.projectId(), deleteEntry.repository(), e));
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    private void executeConsistentStateUpdate(final Repository repository, final Function<RepositoryData, ClusterStateUpdateTask> createUpdateTask, final String source, final Consumer<Exception> onFailure) {
        final RepositoryMetadata repositoryMetadataStart = repository.getMetadata();
        repository.getRepositoryData(EsExecutors.DIRECT_EXECUTOR_SERVICE, ActionListener.wrap(repositoryData -> {
            final ClusterStateUpdateTask updateTask = (ClusterStateUpdateTask)createUpdateTask.apply((RepositoryData)repositoryData);
            this.submitUnbatchedTask(source, new ClusterStateUpdateTask(updateTask.priority(), updateTask.timeout()){
                private boolean executedTask;
                {
                    super(priority, timeout);
                    this.executedTask = false;
                }

                @Override
                public ClusterState execute(ClusterState currentState) throws Exception {
                    ProjectMetadata projectMetadata = currentState.metadata().getProject(repository.getProjectId());
                    if (repositoryMetadataStart.equals(RepositoriesMetadata.get(projectMetadata).repository(repository.getMetadata().name()))) {
                        this.executedTask = true;
                        return updateTask.execute(currentState);
                    }
                    return currentState;
                }

                @Override
                public void onFailure(Exception e) {
                    if (this.executedTask) {
                        updateTask.onFailure(e);
                    } else {
                        onFailure.accept(e);
                    }
                }

                @Override
                public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                    if (this.executedTask) {
                        updateTask.clusterStateProcessed(oldState, newState);
                    } else {
                        SnapshotsService.this.executeConsistentStateUpdate(repository, createUpdateTask, source, onFailure);
                    }
                }
            });
        }, onFailure));
    }

    private void deleteSnapshotsFromRepository(final SnapshotDeletionsInProgress.Entry deleteEntry, final RepositoryData repositoryData, IndexVersion minNodeVersion) {
        if (this.repositoryOperations.startDeletion(deleteEntry.uuid())) {
            assert (this.currentlyFinalizing.contains(new ProjectRepo(deleteEntry.projectId(), deleteEntry.repository())));
            List<SnapshotId> snapshotIds = deleteEntry.snapshots();
            assert (deleteEntry.state() == SnapshotDeletionsInProgress.State.STARTED) : "incorrect state for entry [" + String.valueOf(deleteEntry) + "]";
            if (snapshotIds.isEmpty()) {
                this.removeSnapshotDeletionFromClusterState(deleteEntry, repositoryData, listeners -> SnapshotsServiceUtils.completeListenersIgnoringException(listeners, null));
                return;
            }
            final SubscribableListener doneFuture = new SubscribableListener();
            this.repositoriesService.repository(deleteEntry.projectId(), deleteEntry.repository()).deleteSnapshots(snapshotIds, repositoryData.getGenId(), minNodeVersion, new ActionListener<RepositoryData>(){

                @Override
                public void onResponse(RepositoryData updatedRepoData) {
                    SnapshotsService.this.removeSnapshotDeletionFromClusterState(deleteEntry, updatedRepoData, listeners -> doneFuture.addListener(new ActionListener<Void>(this){

                        @Override
                        public void onResponse(Void unused) {
                            SnapshotsServiceUtils.completeListenersIgnoringException(listeners, null);
                        }

                        @Override
                        public void onFailure(Exception e) {
                            assert (false) : e;
                        }
                    }));
                }

                @Override
                public void onFailure(final Exception e) {
                    logger.warn(() -> {
                        StringBuilder sb = new StringBuilder("failed to complete snapshot deletion for [");
                        Strings.BoundedDelimitedStringCollector collector = new Strings.BoundedDelimitedStringCollector(sb, ",", 1024);
                        deleteEntry.snapshots().forEach(s -> collector.appendItem(s.getName()));
                        collector.finish();
                        sb.append("] from repository ").append(ProjectRepo.projectRepoString(deleteEntry.projectId(), deleteEntry.repository()));
                        return sb;
                    }, (Throwable)e);
                    SnapshotsService.this.submitUnbatchedTask("remove snapshot deletion metadata after failed delete", new RemoveSnapshotDeletionAndContinueTask(this, deleteEntry, repositoryData){

                        @Override
                        protected void handleListeners(List<ActionListener<Void>> deleteListeners) {
                            SnapshotsServiceUtils.failListenersIgnoringException(deleteListeners, e);
                        }
                    });
                }
            }, () -> {
                logger.info(() -> {
                    StringBuilder sb = new StringBuilder("snapshots [");
                    Strings.BoundedDelimitedStringCollector collector = new Strings.BoundedDelimitedStringCollector(sb, ",", 1024);
                    snapshotIds.forEach(collector::appendItem);
                    collector.finish();
                    sb.append("] deleted in repository ");
                    sb.append(ProjectRepo.projectRepoString(deleteEntry.projectId(), deleteEntry.repository()));
                    return sb;
                });
                doneFuture.onResponse(null);
            });
        }
    }

    private void removeSnapshotDeletionFromClusterState(SnapshotDeletionsInProgress.Entry deleteEntry, final RepositoryData repositoryData, final Consumer<List<ActionListener<Void>>> listenersHandler) {
        this.submitUnbatchedTask("remove snapshot deletion metadata", new RemoveSnapshotDeletionAndContinueTask(this, deleteEntry, repositoryData){

            @Override
            protected SnapshotDeletionsInProgress filterDeletions(SnapshotDeletionsInProgress deletions) {
                SnapshotDeletionsInProgress updatedDeletions = SnapshotsServiceUtils.deletionsWithoutSnapshots(deletions, this.deleteEntry.snapshots(), this.deleteEntry.projectId(), this.deleteEntry.repository());
                return updatedDeletions == null ? deletions : updatedDeletions;
            }

            @Override
            protected void handleListeners(List<ActionListener<Void>> deleteListeners) {
                assert (repositoryData.getSnapshotIds().stream().noneMatch(this.deleteEntry.snapshots()::contains)) : "Repository data contained snapshot ids " + String.valueOf(repositoryData.getSnapshotIds()) + " that should should been deleted by [" + String.valueOf(this.deleteEntry) + "]";
                listenersHandler.accept(deleteListeners);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failAllListenersOnMasterFailOver(Exception e) {
        logger.debug("Failing all snapshot operation listeners because this node is not master any longer", (Throwable)e);
        ArrayList<Runnable> readyToResolveListeners = new ArrayList<Runnable>();
        Set<ProjectRepo> set = this.currentlyFinalizing;
        synchronized (set) {
            if (ExceptionsHelper.unwrap(e, NotMasterException.class, FailedToCommitClusterStateException.class) != null) {
                this.repositoryOperations.clear();
                for (Snapshot snapshot : this.snapshotCompletionListeners.keySet()) {
                    this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "no longer master"), readyToResolveListeners::add);
                }
                RepositoryException wrapped = new RepositoryException("_all", "Failed to update cluster state during repository operation", e, new Object[0]);
                Iterator<List<ActionListener<Void>>> it = this.snapshotDeletionListeners.values().iterator();
                while (it.hasNext()) {
                    List<ActionListener<Void>> listeners = it.next();
                    readyToResolveListeners.add(() -> SnapshotsServiceUtils.failListenersIgnoringException(listeners, wrapped));
                    it.remove();
                }
                assert (this.snapshotDeletionListeners.isEmpty()) : "No new listeners should have been added but saw " + String.valueOf(this.snapshotDeletionListeners);
            } else {
                assert (false) : new AssertionError("Modifying snapshot state should only ever fail because we failed to publish new state", e);
                logger.error("Unexpected failure during cluster state update", (Throwable)e);
            }
            this.currentlyFinalizing.clear();
        }
        readyToResolveListeners.forEach(Runnable::run);
    }

    private void addListener(Snapshot snapshot, ActionListener<SnapshotInfo> listener) {
        this.snapshotCompletionListeners.computeIfAbsent(snapshot, k -> new CopyOnWriteArrayList()).add(ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext()));
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        this.clusterService.removeApplier(this);
    }

    public boolean assertAllListenersResolved() {
        DiscoveryNode localNode = this.clusterService.localNode();
        assert (this.endingSnapshots.isEmpty()) : "Found leaked ending snapshots " + String.valueOf(this.endingSnapshots) + " on [" + String.valueOf(localNode) + "]";
        assert (this.snapshotCompletionListeners.isEmpty()) : "Found leaked snapshot completion listeners " + String.valueOf(this.snapshotCompletionListeners) + " on [" + String.valueOf(localNode) + "]";
        assert (this.currentlyFinalizing.isEmpty()) : "Found leaked finalizations " + String.valueOf(this.currentlyFinalizing) + " on [" + String.valueOf(localNode) + "]";
        assert (this.snapshotDeletionListeners.isEmpty()) : "Found leaked snapshot delete listeners " + String.valueOf(this.snapshotDeletionListeners) + " on [" + String.valueOf(localNode) + "]";
        assert (this.repositoryOperations.isEmpty()) : "Found leaked snapshots to finalize " + String.valueOf(this.repositoryOperations) + " on [" + String.valueOf(localNode) + "]";
        return true;
    }

    private void handleShardSnapshotUpdateCompletion(ShardSnapshotUpdateResult shardSnapshotUpdateResult, List<SnapshotsInProgress.Entry> newlyCompletedEntries, Set<ProjectRepo> updatedRepositories) {
        SnapshotsInProgress snapshotsInProgress = shardSnapshotUpdateResult.snapshotsInProgress();
        for (SnapshotsInProgress.Entry newlyCompletedEntry : newlyCompletedEntries) {
            if (this.endingSnapshots.contains(newlyCompletedEntry.snapshot())) continue;
            this.endSnapshot(newlyCompletedEntry, shardSnapshotUpdateResult.metadata, null);
        }
        for (ProjectRepo updatedRepository : updatedRepositories) {
            this.startExecutableClones(snapshotsInProgress, updatedRepository);
        }
        if (!updatedRepositories.isEmpty()) {
            this.rerouteService.reroute("after shards snapshot update", Priority.NORMAL, ActionListener.noop());
        }
    }

    public void createAndSubmitRequestToUpdateSnapshotState(Snapshot snapshot, ShardId shardId, RepositoryShardId repoShardId, SnapshotsInProgress.ShardSnapshotStatus updatedState, ActionListener<Void> listener) {
        ShardSnapshotUpdate update = new ShardSnapshotUpdate(snapshot, shardId, repoShardId, updatedState, listener.delegateFailure((delegate, result) -> delegate.onResponse(null)));
        logger.trace("received updated snapshot restore state [{}]", (Object)update);
        this.masterServiceTaskQueue.submitTask("update snapshot state", update, null);
    }

    private void startExecutableClones(SnapshotsInProgress snapshotsInProgress) {
        for (List<SnapshotsInProgress.Entry> entries : snapshotsInProgress.entriesByRepo()) {
            this.startExecutableClones(entries);
        }
    }

    private void startExecutableClones(SnapshotsInProgress snapshotsInProgress, ProjectId projectId) {
        for (List<SnapshotsInProgress.Entry> entries : snapshotsInProgress.entriesByRepo(projectId)) {
            this.startExecutableClones(entries);
        }
    }

    private void startExecutableClones(SnapshotsInProgress snapshotsInProgress, ProjectRepo projectRepo) {
        this.startExecutableClones(snapshotsInProgress.forRepo(Objects.requireNonNull(projectRepo)));
    }

    private void startExecutableClones(List<SnapshotsInProgress.Entry> entries) {
        for (SnapshotsInProgress.Entry entry : entries) {
            if (!entry.isClone() || entry.state() != SnapshotsInProgress.State.STARTED) continue;
            for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clone : entry.shardSnapshotStatusByRepoShardId().entrySet()) {
                if (clone.getValue().state() != SnapshotsInProgress.ShardState.INIT) continue;
                this.runReadyClone(entry.snapshot(), entry.source(), clone.getValue(), clone.getKey(), this.repositoriesService.repository(entry.projectId(), entry.repository()));
            }
        }
    }

    private /* synthetic */ ClusterStateUpdateTask lambda$deleteSnapshots$23(final DeleteSnapshotRequest request, final ProjectId projectId, final String repositoryName, final String[] snapshotNames, final ActionListener listener, final Repository repository, final RepositoryData repositoryData) {
        return new ClusterStateUpdateTask(request.masterNodeTimeout()){
            private SnapshotDeletionsInProgress.Entry newDelete;
            private boolean reusedExistingDelete;
            private final Collection<Snapshot> completedNoCleanup;
            private final Collection<SnapshotsInProgress.Entry> completedWithCleanup;
            {
                super(timeout);
                this.newDelete = null;
                this.reusedExistingDelete = false;
                this.completedNoCleanup = new ArrayList<Snapshot>();
                this.completedWithCleanup = new ArrayList<SnapshotsInProgress.Entry>();
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                ProjectMetadata projectMetadata = currentState.metadata().getProject(projectId);
                SnapshotsServiceUtils.ensureRepositoryExists(repositoryName, projectMetadata);
                HashSet<SnapshotId> snapshotIds = new HashSet<SnapshotId>();
                SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(currentState);
                for (SnapshotsInProgress.Entry entry2 : snapshotsInProgress.forRepo(projectId, repositoryName)) {
                    SnapshotId snapshotId2 = entry2.snapshot().getSnapshotId();
                    if (!Regex.simpleMatch(snapshotNames, snapshotId2.getName())) continue;
                    snapshotIds.add(snapshotId2);
                }
                Map snapshotsIdsInRepository = repositoryData.getSnapshotIds().stream().collect(Collectors.toMap(SnapshotId::getName, Function.identity()));
                for (String snapshotOrPattern : snapshotNames) {
                    if (Regex.isSimpleMatchPattern(snapshotOrPattern)) {
                        for (Map.Entry entry3 : snapshotsIdsInRepository.entrySet()) {
                            if (!Regex.simpleMatch(snapshotOrPattern, entry3.getKey())) continue;
                            snapshotIds.add((SnapshotId)entry3.getValue());
                        }
                        continue;
                    }
                    SnapshotId foundId = (SnapshotId)snapshotsIdsInRepository.get(snapshotOrPattern);
                    if (foundId == null) {
                        if (!snapshotIds.stream().noneMatch(snapshotId -> snapshotId.getName().equals(snapshotOrPattern))) continue;
                        SnapshotMissingException snapshotMissingException = new SnapshotMissingException(repositoryName, snapshotOrPattern);
                        logger.debug(snapshotMissingException.getMessage());
                        throw snapshotMissingException;
                    }
                    snapshotIds.add(foundId);
                }
                if (snapshotIds.isEmpty()) {
                    return currentState;
                }
                Set set = snapshotsInProgress.asStream(projectId).filter(SnapshotsInProgress.Entry::isClone).map(SnapshotsInProgress.Entry::source).collect(Collectors.toSet());
                for (SnapshotId snapshotId3 : snapshotIds) {
                    if (!set.contains(snapshotId3)) continue;
                    throw new ConcurrentSnapshotExecutionException(new Snapshot(projectId, repositoryName, snapshotId3), "cannot delete snapshot while it is being cloned");
                }
                SnapshotsServiceUtils.ensureNoCleanupInProgress(currentState, repositoryName, ((SnapshotId)snapshotIds.stream().findFirst().get()).getName(), "delete snapshot");
                SnapshotsServiceUtils.ensureNotReadOnly(projectMetadata, repositoryName);
                SnapshotDeletionsInProgress deletionsInProgress = SnapshotDeletionsInProgress.get(currentState);
                RestoreInProgress restoreInProgress = RestoreInProgress.get(currentState);
                for (RestoreInProgress.Entry entry4 : restoreInProgress) {
                    if (!repositoryName.equals(entry4.snapshot().getRepository()) || !snapshotIds.contains(entry4.snapshot().getSnapshotId())) continue;
                    throw new ConcurrentSnapshotExecutionException(new Snapshot(projectId, repositoryName, (SnapshotId)snapshotIds.stream().findFirst().get()), "cannot delete snapshot during a restore in progress in [" + String.valueOf(restoreInProgress) + "]");
                }
                HashSet<SnapshotId> snapshotIdsRequiringCleanup = new HashSet<SnapshotId>(snapshotIds);
                SnapshotsInProgress updatedSnapshots = snapshotsInProgress.createCopyWithUpdatedEntriesForRepo(projectId, repositoryName, snapshotsInProgress.forRepo(projectId, repositoryName).stream().map(existing -> {
                    if (existing.state() == SnapshotsInProgress.State.STARTED && snapshotIdsRequiringCleanup.contains(existing.snapshot().getSnapshotId())) {
                        SnapshotsInProgress.Entry abortedEntry = existing.abort();
                        if (abortedEntry == null) {
                            Snapshot existingNotYetStartedSnapshot = existing.snapshot();
                            if (SnapshotsService.this.endingSnapshots.add(existingNotYetStartedSnapshot)) {
                                this.completedNoCleanup.add(existingNotYetStartedSnapshot);
                            }
                            snapshotIdsRequiringCleanup.remove(existingNotYetStartedSnapshot.getSnapshotId());
                        } else if (abortedEntry.state().completed()) {
                            this.completedWithCleanup.add(abortedEntry);
                        }
                        return abortedEntry;
                    }
                    return existing;
                }).filter(Objects::nonNull).toList());
                if (snapshotIdsRequiringCleanup.isEmpty()) {
                    return SnapshotsServiceUtils.updateWithSnapshots(currentState, updatedSnapshots, null);
                }
                SnapshotDeletionsInProgress.Entry replacedEntry = deletionsInProgress.getEntries().stream().filter(entry -> entry.projectId().equals(projectId) && entry.repository().equals(repositoryName)).filter(entry -> entry.state() == SnapshotDeletionsInProgress.State.WAITING).findFirst().orElse(null);
                if (replacedEntry == null) {
                    Optional<SnapshotDeletionsInProgress.Entry> foundDuplicate = deletionsInProgress.getEntries().stream().filter(entry -> entry.projectId().equals(projectId) && entry.repository().equals(repositoryName) && entry.state() == SnapshotDeletionsInProgress.State.STARTED && entry.snapshots().containsAll(snapshotIds)).findFirst();
                    if (foundDuplicate.isPresent()) {
                        this.newDelete = foundDuplicate.get();
                        this.reusedExistingDelete = true;
                        return currentState;
                    }
                    this.newDelete = new SnapshotDeletionsInProgress.Entry(projectId, repositoryName, List.copyOf(snapshotIdsRequiringCleanup), SnapshotsService.this.threadPool.absoluteTimeInMillis(), repositoryData.getGenId(), updatedSnapshots.forRepo(projectId, repositoryName).stream().noneMatch(SnapshotsServiceUtils::isWritingToRepository) && !deletionsInProgress.hasExecutingDeletion(projectId, repositoryName) ? SnapshotDeletionsInProgress.State.STARTED : SnapshotDeletionsInProgress.State.WAITING);
                } else {
                    this.newDelete = replacedEntry.withAddedSnapshots(snapshotIdsRequiringCleanup);
                }
                return SnapshotsServiceUtils.updateWithSnapshots(currentState, updatedSnapshots, (replacedEntry == null ? deletionsInProgress : deletionsInProgress.withRemovedEntry(replacedEntry.uuid())).withAddedEntry(this.newDelete));
            }

            @Override
            public void onFailure(Exception e) {
                SnapshotsService.this.endingSnapshots.removeAll(this.completedNoCleanup);
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                logger.info(() -> Strings.format("deleting snapshots [%s] from repository %s", org.elasticsearch.common.Strings.arrayToCommaDelimitedString(snapshotNames), ProjectRepo.projectRepoString(projectId, repositoryName)));
                if (!this.completedNoCleanup.isEmpty()) {
                    logger.info("snapshots {} aborted", this.completedNoCleanup);
                }
                for (Snapshot snapshot : this.completedNoCleanup) {
                    SnapshotsService.this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "Snapshot was aborted by deletion"), Runnable::run);
                }
                if (this.newDelete == null || !request.waitForCompletion()) {
                    listener.onResponse(null);
                } else {
                    SnapshotsService.this.addDeleteListener(this.newDelete.uuid(), listener);
                }
                if (this.newDelete != null) {
                    if (this.reusedExistingDelete) {
                        return;
                    }
                    if (this.newDelete.state() == SnapshotDeletionsInProgress.State.STARTED) {
                        if (SnapshotsService.this.tryEnterRepoLoop(projectId, repositoryName)) {
                            SnapshotsService.this.deleteSnapshotsFromRepository(this.newDelete, repositoryData, newState.nodes().getMaxDataNodeCompatibleIndexVersion());
                        } else {
                            logger.trace("Delete [{}] could not execute directly and was queued", (Object)this.newDelete);
                        }
                    } else {
                        for (SnapshotsInProgress.Entry completedSnapshot : this.completedWithCleanup) {
                            SnapshotsService.this.endSnapshot(completedSnapshot, newState.metadata(), repositoryData);
                        }
                    }
                }
            }

            public String toString() {
                return org.elasticsearch.common.Strings.format("delete snapshot task [%s]%s", repository, Arrays.toString(snapshotNames));
            }
        };
    }

    private static final class OngoingRepositoryOperations {
        private final Map<ProjectRepo, Deque<Snapshot>> snapshotsToFinalize = new HashMap<ProjectRepo, Deque<Snapshot>>();
        private final Set<String> runningDeletions = Collections.synchronizedSet(new HashSet());
        @Nullable
        private Metadata latestKnownMetaData;

        private OngoingRepositoryOperations() {
        }

        @Nullable
        synchronized Tuple<Snapshot, Metadata> pollFinalization(ProjectId projectId, String repository) {
            this.assertConsistent();
            ProjectRepo projectRepo = new ProjectRepo(projectId, repository);
            Deque<Snapshot> queued = this.snapshotsToFinalize.get(projectRepo);
            if (queued == null) {
                return null;
            }
            Snapshot nextEntry = queued.pollFirst();
            assert (nextEntry != null);
            Tuple<Snapshot, Metadata> res = Tuple.tuple(nextEntry, this.latestKnownMetaData);
            if (queued.isEmpty()) {
                this.snapshotsToFinalize.remove(projectRepo);
            }
            if (this.snapshotsToFinalize.isEmpty()) {
                this.latestKnownMetaData = null;
            }
            assert (this.assertConsistent());
            return res;
        }

        boolean startDeletion(String deleteUUID) {
            return this.runningDeletions.add(deleteUUID);
        }

        void finishDeletion(String deleteUUID) {
            this.runningDeletions.remove(deleteUUID);
        }

        synchronized void addFinalization(Snapshot snapshot, Metadata metadata) {
            this.snapshotsToFinalize.computeIfAbsent(new ProjectRepo(snapshot.getProjectId(), snapshot.getRepository()), k -> new LinkedList()).add(snapshot);
            this.latestKnownMetaData = metadata;
            this.assertConsistent();
        }

        synchronized void clear() {
            this.snapshotsToFinalize.clear();
            this.runningDeletions.clear();
            this.latestKnownMetaData = null;
        }

        synchronized boolean isEmpty() {
            return this.snapshotsToFinalize.isEmpty();
        }

        synchronized boolean assertNotQueued(Snapshot snapshot) {
            if (((Deque)this.snapshotsToFinalize.getOrDefault(new ProjectRepo(snapshot.getProjectId(), snapshot.getRepository()), new LinkedList())).stream().anyMatch(entry -> entry.equals(snapshot))) {
                AssertionError assertionError = new AssertionError((Object)("[" + String.valueOf(snapshot) + "] should not be in " + String.valueOf(this.snapshotsToFinalize)));
                logger.error("assertNotQueued failure", (Throwable)((Object)assertionError));
                throw assertionError;
            }
            return true;
        }

        synchronized boolean assertConsistent() {
            assert (this.latestKnownMetaData == null && this.snapshotsToFinalize.isEmpty() || this.latestKnownMetaData != null && !this.snapshotsToFinalize.isEmpty()) : "Should not hold on to metadata if there are no more queued snapshots";
            assert (this.snapshotsToFinalize.values().stream().noneMatch(Collection::isEmpty)) : "Found empty queue in " + String.valueOf(this.snapshotsToFinalize);
            return true;
        }
    }

    private class SnapshotTaskExecutor
    implements ClusterStateTaskExecutor<SnapshotTask> {
        private SnapshotTaskExecutor() {
        }

        @Override
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<SnapshotTask> batchExecutionContext) throws Exception {
            ClusterState state = batchExecutionContext.initialState();
            SnapshotShardsUpdateContext shardsUpdateContext = new SnapshotShardsUpdateContext(batchExecutionContext, SnapshotsService.this.shardSnapshotUpdateCompletionHandler);
            SnapshotsInProgress initialSnapshots = SnapshotsInProgress.get(state);
            SnapshotsInProgress snapshotsInProgress = shardsUpdateContext.computeUpdatedState();
            HashMap<ProjectId, RegisteredPolicySnapshots.Builder> registeredPolicySnapshotsBuilders = new HashMap<ProjectId, RegisteredPolicySnapshots.Builder>();
            for (ClusterStateTaskExecutor.TaskContext<SnapshotTask> taskContext : batchExecutionContext.taskContexts()) {
                SnapshotTask snapshotTask = taskContext.getTask();
                if (!(snapshotTask instanceof CreateSnapshotTask)) continue;
                CreateSnapshotTask task = (CreateSnapshotTask)snapshotTask;
                try {
                    ProjectMetadata projectMetadata = state.metadata().getProject(task.snapshot.getProjectId());
                    RepositoryMetadata repoMeta = RepositoriesMetadata.get(projectMetadata).repository(task.snapshot.getRepository());
                    if (RepositoriesService.isReadOnly(repoMeta.settings())) {
                        taskContext.onFailure(new RepositoryException(repoMeta.name(), "repository is readonly", new Object[0]));
                        continue;
                    }
                    registeredPolicySnapshotsBuilders.computeIfAbsent(projectMetadata.id(), ignored -> projectMetadata.custom("registered_snapshots", RegisteredPolicySnapshots.EMPTY).builder()).addIfSnapshotIsSLMInitiated(task.createSnapshotRequest.userMetadata(), task.snapshot.getSnapshotId());
                    if (Objects.equals(task.initialRepositoryMetadata, repoMeta)) {
                        snapshotsInProgress = this.createSnapshot(task, taskContext, state, snapshotsInProgress);
                        continue;
                    }
                    taskContext.success(() -> SnapshotsService.this.submitCreateSnapshotRequest(task.createSnapshotRequest, task.listener, task.repository, task.snapshot, repoMeta));
                }
                catch (Exception e) {
                    taskContext.onFailure(e);
                }
            }
            shardsUpdateContext.setupSuccessfulPublicationCallbacks(snapshotsInProgress);
            if (snapshotsInProgress == initialSnapshots) {
                return state;
            }
            Metadata.Builder metadataBuilder = Metadata.builder(state.metadata());
            registeredPolicySnapshotsBuilders.forEach((projectId, builder) -> metadataBuilder.getProject((ProjectId)projectId).putCustom("registered_snapshots", builder.build()));
            return ClusterState.builder(state).putCustom("snapshots", snapshotsInProgress).metadata(metadataBuilder).build();
        }

        private SnapshotsInProgress createSnapshot(CreateSnapshotTask createSnapshotTask, ClusterStateTaskExecutor.TaskContext<SnapshotTask> taskContext, ClusterState currentState, SnapshotsInProgress snapshotsInProgress) {
            Set<Object> featureStatesSet;
            RepositoryData repositoryData = createSnapshotTask.repositoryData;
            Snapshot snapshot = createSnapshotTask.snapshot;
            String repositoryName = snapshot.getRepository();
            String snapshotName = snapshot.getSnapshotId().getName();
            ProjectState projectState = currentState.projectState(snapshot.getProjectId());
            SnapshotsServiceUtils.ensureRepositoryExists(repositoryName, projectState.metadata());
            Repository repository = createSnapshotTask.repository;
            SnapshotsServiceUtils.ensureSnapshotNameAvailableInRepo(repositoryData, snapshotName, repository);
            SnapshotsServiceUtils.ensureSnapshotNameNotRunning(snapshotsInProgress, snapshot.getProjectId(), repositoryName, snapshotName);
            SnapshotsServiceUtils.validate(repositoryName, snapshotName, projectState.metadata());
            SnapshotDeletionsInProgress deletionsInProgress = SnapshotDeletionsInProgress.get(currentState);
            SnapshotsServiceUtils.ensureNoCleanupInProgress(currentState, repositoryName, snapshotName, "create snapshot");
            SnapshotsService.this.ensureBelowConcurrencyLimit(repositoryName, snapshotName, snapshotsInProgress, deletionsInProgress);
            CreateSnapshotRequest request = createSnapshotTask.createSnapshotRequest;
            Map<Boolean, List<String>> requestedIndices = Arrays.stream(SnapshotsService.this.indexNameExpressionResolver.concreteIndexNames(projectState.metadata(), (IndicesRequest)request)).collect(Collectors.partitioningBy(SnapshotsService.this.systemIndices::isSystemIndex));
            List<String> requestedSystemIndices = requestedIndices.get(true);
            if (!requestedSystemIndices.isEmpty()) {
                HashSet<String> explicitlyRequestedSystemIndices = new HashSet<String>(requestedSystemIndices);
                explicitlyRequestedSystemIndices.retainAll(Arrays.asList(request.indices()));
                if (!explicitlyRequestedSystemIndices.isEmpty()) {
                    throw new IllegalArgumentException(Strings.format("the [indices] parameter includes system indices %s; to include or exclude system indices from a snapshot, use the [include_global_state] or [feature_states] parameters", explicitlyRequestedSystemIndices));
                }
            }
            List<String> indices = requestedIndices.get(false);
            List<String> requestedStates = Arrays.asList(request.featureStates());
            if (request.includeGlobalState() || !requestedStates.isEmpty()) {
                if (request.includeGlobalState() && requestedStates.isEmpty()) {
                    featureStatesSet = SnapshotsService.this.systemIndices.getFeatureNames();
                } else if (requestedStates.size() == 1 && SnapshotsService.NO_FEATURE_STATES_VALUE.equalsIgnoreCase(requestedStates.get(0))) {
                    featureStatesSet = Collections.emptySet();
                } else {
                    if (requestedStates.contains(SnapshotsService.NO_FEATURE_STATES_VALUE)) {
                        throw new IllegalArgumentException("the feature_states value [none] indicates that no feature states should be snapshotted, but other feature states were requested: " + String.valueOf(requestedStates));
                    }
                    featureStatesSet = new HashSet<String>(requestedStates);
                    featureStatesSet.retainAll(SnapshotsService.this.systemIndices.getFeatureNames());
                }
            } else {
                featureStatesSet = Collections.emptySet();
            }
            HashSet<SnapshotFeatureInfo> featureStates = new HashSet<SnapshotFeatureInfo>();
            HashSet systemDataStreamNames = new HashSet();
            HashSet<String> indexNames = new HashSet<String>(indices);
            for (Object featureName : featureStatesSet) {
                SystemIndices.Feature feature = SnapshotsService.this.systemIndices.getFeature((String)featureName);
                Set featureSystemIndices = feature.getIndexDescriptors().stream().flatMap(descriptor -> descriptor.getMatchingIndices(projectState.metadata()).stream()).collect(Collectors.toSet());
                Set featureAssociatedIndices = feature.getAssociatedIndexDescriptors().stream().flatMap(descriptor -> descriptor.getMatchingIndices(projectState.metadata()).stream()).collect(Collectors.toSet());
                HashSet featureSystemDataStreams = new HashSet();
                HashSet<String> hashSet = new HashSet<String>();
                for (SystemDataStreamDescriptor sdd : feature.getDataStreamDescriptors()) {
                    List<String> backingIndexNames = sdd.getBackingIndexNames(projectState.metadata());
                    if (backingIndexNames.size() <= 0) continue;
                    hashSet.addAll(backingIndexNames);
                    featureSystemDataStreams.add(sdd.getDataStreamName());
                }
                if (featureSystemIndices.size() > 0 || featureAssociatedIndices.size() > 0 || hashSet.size() > 0) {
                    featureStates.add(new SnapshotFeatureInfo((String)featureName, List.copyOf(Stream.concat(featureSystemIndices.stream(), hashSet.stream()).collect(Collectors.toSet()))));
                    indexNames.addAll(featureSystemIndices);
                    indexNames.addAll(featureAssociatedIndices);
                    indexNames.addAll(hashSet);
                    systemDataStreamNames.addAll(featureSystemDataStreams);
                }
                indices = List.copyOf(indexNames);
            }
            logger.trace("[{}][{}] creating snapshot for indices [{}]", (Object)repositoryName, (Object)snapshotName, indices);
            HashMap<String, IndexId> allIndices = new HashMap<String, IndexId>();
            for (SnapshotsInProgress.Entry runningSnapshot : snapshotsInProgress.forRepo(projectState.projectId(), repositoryName)) {
                allIndices.putAll(runningSnapshot.indices());
            }
            Map<String, IndexId> indexIds = repositoryData.resolveNewIndices(indices, allIndices);
            IndexVersion version = SnapshotsServiceUtils.minCompatibleVersion(currentState.nodes().getMaxDataNodeCompatibleIndexVersion(), repositoryData, null);
            ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = SnapshotsServiceUtils.shards(snapshotsInProgress, deletionsInProgress, projectState, indexIds.values(), SnapshotsServiceUtils.useShardGenerations(version), repositoryData, repositoryName);
            if (!request.partial()) {
                TreeSet<String> missing = new TreeSet<String>();
                for (Map.Entry entry : shards.entrySet()) {
                    if (((SnapshotsInProgress.ShardSnapshotStatus)entry.getValue()).state() != SnapshotsInProgress.ShardState.MISSING) continue;
                    missing.add(((ShardId)entry.getKey()).getIndex().getName());
                }
                if (!missing.isEmpty()) {
                    throw new SnapshotException(snapshot, org.elasticsearch.common.Strings.format("the following indices have unassigned primary shards and cannot be included in a snapshot unless [partial] is set to [true]: %s; for help with troubleshooting unassigned shards see %s\n", new Object[]{missing, ReferenceDocs.UNASSIGNED_SHARDS}));
                }
            }
            SnapshotsInProgress.Entry newEntry = SnapshotsInProgress.startedEntry(snapshot, request.includeGlobalState(), request.partial(), indexIds, CollectionUtils.concatLists(SnapshotsService.this.indexNameExpressionResolver.dataStreamNames(projectState.metadata(), request.indicesOptions(), request.indices()), systemDataStreamNames), SnapshotsService.this.threadPool.absoluteTimeInMillis(), repositoryData.getGenId(), shards, request.userMetadata(), version, List.copyOf(featureStates));
            SnapshotsInProgress res = snapshotsInProgress.withAddedEntry(newEntry);
            taskContext.success(() -> {
                logger.info("snapshot [{}] started", (Object)snapshot);
                Map<String, Object> attributes = SnapshotMetrics.createAttributesMap(snapshot.getProjectId(), repository.getMetadata());
                SnapshotsService.this.snapshotMetrics.snapshotsStartedCounter().incrementBy(1L, attributes);
                createSnapshotTask.listener.onResponse(snapshot);
                if (newEntry.state().completed()) {
                    SnapshotsService.this.endSnapshot(newEntry, currentState.metadata(), createSnapshotTask.repositoryData);
                }
            });
            return res;
        }
    }

    static interface ShardSnapshotUpdateCompletionHandler {
        public void handleCompletion(ShardSnapshotUpdateResult var1, List<SnapshotsInProgress.Entry> var2, Set<ProjectRepo> var3);
    }

    private record UpdateNodeIdsForRemovalTask() implements ClusterStateTaskListener
    {
        @Override
        public void onFailure(Exception e) {
            assert (MasterService.isPublishFailureException(e)) : e;
        }

        static ClusterState executeBatch(ClusterStateTaskExecutor.BatchExecutionContext<UpdateNodeIdsForRemovalTask> batchExecutionContext) {
            for (ClusterStateTaskExecutor.TaskContext<UpdateNodeIdsForRemovalTask> taskContext : batchExecutionContext.taskContexts()) {
                taskContext.success(() -> {});
            }
            ClusterState clusterState = batchExecutionContext.initialState();
            SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(clusterState);
            SnapshotsInProgress newSnapshotsInProgress = snapshotsInProgress.withUpdatedNodeIdsForRemoval(clusterState);
            if (newSnapshotsInProgress != snapshotsInProgress) {
                return ClusterState.builder(clusterState).putCustom("snapshots", newSnapshotsInProgress).build();
            }
            return clusterState;
        }
    }

    private class SnapshotFinalization
    extends AbstractRunnable {
        private final Snapshot snapshot;
        private final Metadata metadata;
        private final RepositoryData repositoryData;

        SnapshotFinalization(Snapshot snapshot, Metadata metadata, RepositoryData repositoryData) {
            this.snapshot = snapshot;
            this.metadata = metadata;
            this.repositoryData = repositoryData;
        }

        @Override
        protected void doRun() {
            assert (ThreadPool.assertCurrentThreadPool("snapshot"));
            assert (SnapshotsService.this.currentlyFinalizing.contains(new ProjectRepo(this.snapshot.getProjectId(), this.snapshot.getRepository())));
            assert (SnapshotsService.this.repositoryOperations.assertNotQueued(this.snapshot));
            SnapshotsInProgress.Entry entry = SnapshotsInProgress.get(SnapshotsService.this.clusterService.state()).snapshot(this.snapshot);
            String failure = entry.failure();
            logger.trace("[{}] finalizing snapshot in repository, state: [{}], failure[{}]", (Object)this.snapshot, (Object)entry.state(), (Object)failure);
            FinalizeSnapshotContext.UpdatedShardGenerations updatedShardGenerations = SnapshotsServiceUtils.buildGenerations(entry, this.metadata);
            ShardGenerations updatedShardGensForLiveIndices = updatedShardGenerations.liveIndices();
            List<String> finalIndices = updatedShardGensForLiveIndices.indices().stream().map(IndexId::getName).toList();
            HashSet<String> indexNames = new HashSet<String>(finalIndices);
            ArrayList<SnapshotShardFailure> shardFailures = new ArrayList<SnapshotShardFailure>();
            for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> shardStatus : entry.shardSnapshotStatusByRepoShardId().entrySet()) {
                RepositoryShardId shardId = shardStatus.getKey();
                if (!indexNames.contains(shardId.indexName())) {
                    assert (entry.partial()) : "only ignoring shard failures for concurrently deleted indices for partial snapshots";
                    continue;
                }
                SnapshotsInProgress.ShardSnapshotStatus status = shardStatus.getValue();
                SnapshotsInProgress.ShardState state = status.state();
                if (state.failed()) {
                    shardFailures.add(new SnapshotShardFailure(status.nodeId(), entry.shardId(shardId), status.reason()));
                    continue;
                }
                if (!state.completed()) {
                    shardFailures.add(new SnapshotShardFailure(status.nodeId(), entry.shardId(shardId), "skipped"));
                    continue;
                }
                assert (state == SnapshotsInProgress.ShardState.SUCCESS);
            }
            ProjectId projectId = this.snapshot.getProjectId();
            String repository = this.snapshot.getRepository();
            ListenableFuture<Metadata> metadataListener = new ListenableFuture<Metadata>();
            final Repository repo = SnapshotsService.this.repositoriesService.repository(projectId, repository);
            if (entry.isClone()) {
                SnapshotsService.this.threadPool.executor("snapshot").execute(ActionRunnable.supply(metadataListener, () -> {
                    Metadata existingMetadata = repo.getSnapshotGlobalMetadata(entry.source(), SnapshotsService.this.serializeProjectMetadata);
                    ProjectMetadata existingProject = existingMetadata.getProject(projectId);
                    ProjectMetadata.Builder projBuilder = ProjectMetadata.builder(existingProject);
                    HashSet<Index> existingIndices = new HashSet<Index>();
                    for (IndexId indexId : entry.indices().values()) {
                        IndexMetadata indexMetadata = repo.getSnapshotIndexMetaData(this.repositoryData, entry.source(), indexId);
                        existingIndices.add(indexMetadata.getIndex());
                        projBuilder.put(indexMetadata, false);
                    }
                    HashMap<String, DataStream> dataStreamsToCopy = new HashMap<String, DataStream>();
                    for (Map.Entry<String, DataStream> entry2 : existingProject.dataStreams().entrySet()) {
                        if (!existingIndices.containsAll(entry2.getValue().getIndices())) continue;
                        dataStreamsToCopy.put(entry2.getKey(), entry2.getValue());
                    }
                    Map<String, DataStreamAlias> map = SnapshotsServiceUtils.filterDataStreamAliases(dataStreamsToCopy, existingProject.dataStreamAliases());
                    projBuilder.dataStreams(dataStreamsToCopy, map);
                    return Metadata.builder(existingMetadata).put(projBuilder).build();
                }));
            } else {
                metadataListener.onResponse(this.metadata);
            }
            metadataListener.addListener(ActionListener.wrap(meta -> {
                assert (ThreadPool.assertCurrentThreadPool("snapshot"));
                Metadata metaForSnapshot = SnapshotsService.this.metadataForSnapshot(entry, (Metadata)meta, projectId);
                Map<String, SnapshotInfo.IndexSnapshotDetails> indexSnapshotDetails = Maps.newMapWithExpectedSize(finalIndices.size());
                for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> shardEntry : entry.shardSnapshotStatusByRepoShardId().entrySet()) {
                    indexSnapshotDetails.compute(shardEntry.getKey().indexName(), (indexName, current) -> {
                        if (current == SnapshotInfo.IndexSnapshotDetails.SKIPPED) {
                            return current;
                        }
                        SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = (SnapshotsInProgress.ShardSnapshotStatus)shardEntry.getValue();
                        if (shardSnapshotStatus.state() != SnapshotsInProgress.ShardState.SUCCESS) {
                            return SnapshotInfo.IndexSnapshotDetails.SKIPPED;
                        }
                        ShardSnapshotResult result = shardSnapshotStatus.shardSnapshotResult();
                        if (result == null) {
                            return SnapshotInfo.IndexSnapshotDetails.SKIPPED;
                        }
                        if (current == null) {
                            return new SnapshotInfo.IndexSnapshotDetails(1, result.getSize(), result.getSegmentCount());
                        }
                        return new SnapshotInfo.IndexSnapshotDetails(current.getShardCount() + 1, ByteSizeValue.ofBytes(current.getSize().getBytes() + result.getSize().getBytes()), Math.max(current.getMaxSegmentsPerShard(), result.getSegmentCount()));
                    });
                }
                indexSnapshotDetails.entrySet().removeIf(e -> ((SnapshotInfo.IndexSnapshotDetails)e.getValue()).getShardCount() == 0);
                final SnapshotInfo snapshotInfo = new SnapshotInfo(this.snapshot, finalIndices, entry.dataStreams().stream().filter(metaForSnapshot.getProject(projectId).dataStreams()::containsKey).toList(), entry.partial() ? SnapshotsServiceUtils.onlySuccessfulFeatureStates(entry, finalIndices) : entry.featureStates(), failure, SnapshotsService.this.threadPool.absoluteTimeInMillis(), entry.partial() ? updatedShardGensForLiveIndices.totalShards() : entry.shardSnapshotStatusByRepoShardId().size(), shardFailures, entry.includeGlobalState(), entry.userMetadata(), entry.startTime(), indexSnapshotDetails);
                ListenableFuture snapshotListeners = new ListenableFuture();
                repo.finalizeSnapshot(new FinalizeSnapshotContext(SnapshotsService.this.serializeProjectMetadata, updatedShardGenerations, this.repositoryData.getGenId(), metaForSnapshot, snapshotInfo, entry.version(), ActionListener.wrap(updatedRepositoryData -> {
                    snapshotListeners.onResponse(SnapshotsService.this.endAndGetListenersToResolve(this.snapshot));
                    SnapshotsService.this.runNextQueuedOperation((RepositoryData)updatedRepositoryData, projectId, repository, true);
                }, e -> SnapshotsService.this.handleFinalizationFailure((Exception)e, this.snapshot, this.repositoryData, updatedShardGenerations)), () -> snapshotListeners.addListener(new ActionListener<List<ActionListener<SnapshotInfo>>>(){

                    @Override
                    public void onResponse(List<ActionListener<SnapshotInfo>> actionListeners) {
                        Map<String, Object> attributesWithState = Maps.copyMapWithAddedEntry(SnapshotMetrics.createAttributesMap(SnapshotFinalization.this.snapshot.getProjectId(), repo.getMetadata()), "state", snapshotInfo.state().name());
                        SnapshotsService.this.snapshotMetrics.snapshotsCompletedCounter().incrementBy(1L, attributesWithState);
                        SnapshotsService.this.snapshotMetrics.snapshotsDurationHistogram().record((double)(snapshotInfo.endTime() - snapshotInfo.startTime()) / 1000.0, attributesWithState);
                        SnapshotsServiceUtils.completeListenersIgnoringException(actionListeners, snapshotInfo);
                        logger.info("snapshot [{}] completed with state [{}]", (Object)SnapshotFinalization.this.snapshot, (Object)snapshotInfo.state());
                    }

                    @Override
                    public void onFailure(Exception e) {
                        assert (false) : e;
                    }
                })));
            }, e -> SnapshotsService.this.handleFinalizationFailure((Exception)e, this.snapshot, this.repositoryData, updatedShardGenerations)));
        }

        @Override
        public void onRejection(Exception e) {
            EsRejectedExecutionException esre;
            if (e instanceof EsRejectedExecutionException && (esre = (EsRejectedExecutionException)e).isExecutorShutdown()) {
                logger.debug("failing finalization of {} due to shutdown", (Object)this.snapshot);
                SnapshotsService.this.handleFinalizationFailure(e, this.snapshot, this.repositoryData, FinalizeSnapshotContext.UpdatedShardGenerations.EMPTY);
            } else {
                this.onFailure(e);
            }
        }

        @Override
        public void onFailure(Exception e) {
            logger.error(org.elasticsearch.common.Strings.format("unexpected failure finalizing %s", this.snapshot), (Throwable)e);
            assert (false) : new AssertionError("unexpected failure finalizing " + String.valueOf(this.snapshot), e);
            SnapshotsService.this.handleFinalizationFailure(e, this.snapshot, this.repositoryData, FinalizeSnapshotContext.UpdatedShardGenerations.EMPTY);
        }
    }

    record ShardSnapshotUpdateResult(Metadata metadata, SnapshotsInProgress snapshotsInProgress) {
    }

    static final class ShardSnapshotUpdate
    implements SnapshotTask {
        private final Snapshot snapshot;
        private final ShardId shardId;
        private final RepositoryShardId repoShardId;
        private final SnapshotsInProgress.ShardSnapshotStatus updatedState;
        private final ActionListener<ShardSnapshotUpdateResult> listener;

        ShardSnapshotUpdate(Snapshot snapshot, ShardId shardId, RepositoryShardId repoShardId, SnapshotsInProgress.ShardSnapshotStatus updatedState, ActionListener<ShardSnapshotUpdateResult> listener) {
            assert (shardId != null ^ repoShardId != null);
            this.snapshot = snapshot;
            this.shardId = shardId;
            this.repoShardId = repoShardId;
            this.updatedState = updatedState;
            this.listener = listener;
        }

        public boolean isClone() {
            return this.repoShardId != null;
        }

        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShardSnapshotUpdate)) {
                return false;
            }
            ShardSnapshotUpdate that = (ShardSnapshotUpdate)other;
            return this.snapshot.equals(that.snapshot) && Objects.equals(this.shardId, that.shardId) && Objects.equals(this.repoShardId, that.repoShardId) && this.updatedState == that.updatedState;
        }

        public int hashCode() {
            return Objects.hash(this.snapshot, this.shardId, this.updatedState, this.repoShardId);
        }

        public String toString() {
            return "ShardSnapshotUpdate{snapshot=" + String.valueOf(this.snapshot) + ", shardId=" + String.valueOf(this.shardId) + ", repoShardId=" + String.valueOf(this.repoShardId) + ", updatedState=" + String.valueOf(this.updatedState) + "}";
        }
    }

    private record CreateSnapshotTask(Repository repository, RepositoryData repositoryData, ActionListener<Snapshot> listener, Snapshot snapshot, CreateSnapshotRequest createSnapshotRequest, RepositoryMetadata initialRepositoryMetadata) implements SnapshotTask
    {
        @Override
        public void onFailure(Exception e) {
            SnapshotsServiceUtils.logSnapshotFailure("create", this.snapshot, e);
            this.listener.onFailure(e);
        }

        @Override
        public String toString() {
            return "CreateSnapshotTask{repository=" + this.repository.getMetadata().name() + ", snapshot=" + String.valueOf(this.snapshot) + "}";
        }
    }

    static interface SnapshotTask
    extends ClusterStateTaskListener {
    }

    private final class FailPendingRepoTasksTask
    extends ClusterStateUpdateTask {
        private final List<Snapshot> snapshotsToFail = new ArrayList<Snapshot>();
        private final List<String> deletionsToFail = new ArrayList<String>();
        private final Exception failure;
        private final ProjectId projectId;
        private final String repository;

        FailPendingRepoTasksTask(ProjectId projectId, String repository, Exception failure) {
            this.projectId = projectId;
            this.repository = repository;
            this.failure = failure;
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            SnapshotDeletionsInProgress deletionsInProgress = SnapshotDeletionsInProgress.get(currentState);
            boolean changed = false;
            List<SnapshotDeletionsInProgress.Entry> remainingEntries = deletionsInProgress.getEntries();
            ArrayList<SnapshotDeletionsInProgress.Entry> updatedEntries = new ArrayList<SnapshotDeletionsInProgress.Entry>(remainingEntries.size());
            for (SnapshotDeletionsInProgress.Entry entry : remainingEntries) {
                if (entry.projectId().equals(this.projectId) && entry.repository().equals(this.repository)) {
                    changed = true;
                    this.deletionsToFail.add(entry.uuid());
                    continue;
                }
                updatedEntries.add(entry);
            }
            SnapshotDeletionsInProgress updatedDeletions = changed ? SnapshotDeletionsInProgress.of(updatedEntries) : null;
            SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(currentState);
            boolean changedSnapshots = false;
            for (SnapshotsInProgress.Entry entry : snapshotsInProgress.forRepo(this.projectId, this.repository)) {
                this.snapshotsToFail.add(entry.snapshot());
                changedSnapshots = true;
            }
            SnapshotsInProgress updatedSnapshotsInProgress = changedSnapshots ? snapshotsInProgress.createCopyWithUpdatedEntriesForRepo(this.projectId, this.repository, List.of()) : null;
            return SnapshotsServiceUtils.updateWithSnapshots(currentState, updatedSnapshotsInProgress, updatedDeletions);
        }

        @Override
        public void onFailure(Exception e) {
            logger.info(() -> "Failed to remove all snapshot tasks for repo [" + ProjectRepo.projectRepoString(this.projectId, this.repository) + "] from cluster state", (Throwable)e);
            SnapshotsService.this.failAllListenersOnMasterFailOver(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
            logger.warn(() -> Strings.format("Removed all snapshot tasks for repository %s from cluster state, now failing listeners", ProjectRepo.projectRepoString(this.projectId, this.repository), this.failure));
            ArrayList<Runnable> readyToResolveListeners = new ArrayList<Runnable>();
            Set<ProjectRepo> set = SnapshotsService.this.currentlyFinalizing;
            synchronized (set) {
                Tuple<Snapshot, Metadata> finalization;
                while ((finalization = SnapshotsService.this.repositoryOperations.pollFinalization(this.projectId, this.repository)) != null) {
                    assert (this.snapshotsToFail.contains(finalization.v1())) : "[" + String.valueOf(finalization.v1()) + "] not found in snapshots to fail " + String.valueOf(this.snapshotsToFail);
                }
                SnapshotsService.this.leaveRepoLoop(this.projectId, this.repository);
                for (Snapshot snapshot : this.snapshotsToFail) {
                    SnapshotsService.this.failSnapshotCompletionListeners(snapshot, this.failure, readyToResolveListeners::add);
                }
                for (String delete : this.deletionsToFail) {
                    List<ActionListener<Void>> listeners = SnapshotsService.this.snapshotDeletionListeners.remove(delete);
                    readyToResolveListeners.add(() -> SnapshotsServiceUtils.failListenersIgnoringException(listeners, this.failure));
                    SnapshotsService.this.repositoryOperations.finishDeletion(delete);
                }
            }
            readyToResolveListeners.forEach(Runnable::run);
        }
    }

    static final class SnapshotShardsUpdateContext {
        private int changedCount = 0;
        private int startedCount = 0;
        private final ClusterStateTaskExecutor.BatchExecutionContext<SnapshotTask> batchExecutionContext;
        private final ClusterState initialState;
        private final Predicate<String> nodeIdRemovalPredicate;
        private final Map<ProjectRepo, List<ShardSnapshotUpdate>> updatesByRepo;
        private final Set<ShardSnapshotUpdate> executedUpdates = new HashSet<ShardSnapshotUpdate>();
        private final ShardSnapshotUpdateCompletionHandler completionHandler;
        private final List<SnapshotsInProgress.Entry> newlyCompletedEntries = new ArrayList<SnapshotsInProgress.Entry>();

        SnapshotShardsUpdateContext(ClusterStateTaskExecutor.BatchExecutionContext<SnapshotTask> batchExecutionContext, ShardSnapshotUpdateCompletionHandler completionHandler) {
            this.batchExecutionContext = batchExecutionContext;
            this.initialState = batchExecutionContext.initialState();
            this.nodeIdRemovalPredicate = SnapshotsInProgress.get(this.initialState)::isNodeIdForRemoval;
            this.completionHandler = completionHandler;
            this.updatesByRepo = new HashMap<ProjectRepo, List<ShardSnapshotUpdate>>();
            for (ClusterStateTaskExecutor.TaskContext<SnapshotTask> taskContext : batchExecutionContext.taskContexts()) {
                SnapshotTask snapshotTask = taskContext.getTask();
                if (!(snapshotTask instanceof ShardSnapshotUpdate)) continue;
                ShardSnapshotUpdate task = (ShardSnapshotUpdate)snapshotTask;
                this.updatesByRepo.computeIfAbsent(new ProjectRepo(task.snapshot.getProjectId(), task.snapshot.getRepository()), r -> new ArrayList()).add(task);
            }
        }

        SnapshotsInProgress computeUpdatedState() {
            SnapshotsInProgress existing;
            SnapshotsInProgress updated = existing = SnapshotsInProgress.get(this.initialState);
            for (Map.Entry<ProjectRepo, List<ShardSnapshotUpdate>> updates : this.updatesByRepo.entrySet()) {
                ProjectRepo projectRepo = updates.getKey();
                List<SnapshotsInProgress.Entry> oldEntries = existing.forRepo(projectRepo);
                if (oldEntries.isEmpty()) continue;
                ArrayList<SnapshotsInProgress.Entry> newEntries = new ArrayList<SnapshotsInProgress.Entry>(oldEntries.size());
                for (SnapshotsInProgress.Entry entry : oldEntries) {
                    SnapshotsInProgress.Entry newEntry = this.applyUpdatesToEntry(entry, updates.getValue());
                    newEntries.add(newEntry);
                    if (newEntry == entry || !newEntry.state().completed()) continue;
                    this.newlyCompletedEntries.add(newEntry);
                }
                updated = updated.createCopyWithUpdatedEntriesForRepo(projectRepo.projectId(), projectRepo.name(), newEntries);
            }
            if (this.changedCount > 0) {
                logger.trace("changed cluster state triggered by [{}] snapshot state updates and resulted in starting [{}] shard snapshots", (Object)this.changedCount, (Object)this.startedCount);
                return updated.withUpdatedNodeIdsForRemoval(this.initialState);
            }
            return existing;
        }

        void setupSuccessfulPublicationCallbacks(SnapshotsInProgress snapshotsInProgress) {
            if (this.updatesByRepo.isEmpty()) {
                return;
            }
            ShardSnapshotUpdateResult result = new ShardSnapshotUpdateResult(this.initialState.metadata(), snapshotsInProgress);
            try (RefCountingRunnable onCompletionRefs = new RefCountingRunnable(() -> this.completionHandler.handleCompletion(result, this.newlyCompletedEntries, this.updatesByRepo.keySet()));){
                for (ClusterStateTaskExecutor.TaskContext<SnapshotTask> taskContext : this.batchExecutionContext.taskContexts()) {
                    SnapshotTask snapshotTask = taskContext.getTask();
                    if (!(snapshotTask instanceof ShardSnapshotUpdate)) continue;
                    ShardSnapshotUpdate task = (ShardSnapshotUpdate)snapshotTask;
                    Releasable ref = onCompletionRefs.acquire();
                    taskContext.success(() -> {
                        try (Releasable releasable = ref;){
                            task.listener.onResponse(result);
                        }
                    });
                }
            }
        }

        private SnapshotsInProgress.Entry applyUpdatesToEntry(SnapshotsInProgress.Entry entry, List<ShardSnapshotUpdate> shardUpdates) {
            if (entry.state().completed() || shardUpdates.isEmpty()) {
                return entry;
            }
            return new EntryContext(entry, shardUpdates).computeUpdatedSnapshotEntryFromShardUpdates();
        }

        private final class EntryContext {
            private final SnapshotsInProgress.Entry entry;
            private final Iterator<ShardSnapshotUpdate> updatesIterator;
            private ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardsBuilder = null;
            private ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clonesBuilder = null;

            EntryContext(SnapshotsInProgress.Entry entry, List<ShardSnapshotUpdate> shardSnapshotUpdates) {
                this.entry = entry;
                this.updatesIterator = shardSnapshotUpdates.iterator();
            }

            SnapshotsInProgress.Entry computeUpdatedSnapshotEntryFromShardUpdates() {
                assert (this.shardsBuilder == null && this.clonesBuilder == null) : "update context was already used";
                while (this.updatesIterator.hasNext()) {
                    ShardSnapshotUpdate update = this.updatesIterator.next();
                    if (this.entry.snapshot().getSnapshotId().equals(update.snapshot.getSnapshotId())) {
                        if (update.isClone()) {
                            this.applyShardSnapshotUpdate(this.entry.shardSnapshotStatusByRepoShardId(), this::clonesBuilder, update, update.repoShardId);
                            continue;
                        }
                        this.applyShardSnapshotUpdate(this.entry.shards(), this::shardsBuilder, update, update.shardId);
                        continue;
                    }
                    if (!SnapshotShardsUpdateContext.this.executedUpdates.contains(update)) continue;
                    if (update.isClone()) {
                        this.tryStartNextTaskAfterCloneUpdated(update.repoShardId, update.updatedState);
                        continue;
                    }
                    this.tryStartNextTaskAfterSnapshotUpdated(update.shardId, update.updatedState);
                }
                if (this.shardsBuilder != null) {
                    assert (this.clonesBuilder == null) : "Should not have updated clones when updating shard snapshots but saw " + String.valueOf(this.clonesBuilder) + " as well as " + String.valueOf(this.shardsBuilder);
                    return this.entry.withShardStates(this.shardsBuilder.build());
                }
                if (this.clonesBuilder != null) {
                    return this.entry.withClones(this.clonesBuilder.build());
                }
                return this.entry;
            }

            private <T> void startShardOperation(ImmutableOpenMap.Builder<T, SnapshotsInProgress.ShardSnapshotStatus> newStates, String nodeId, ShardGeneration generation, T shardId) {
                this.startShardOperation(newStates, shardId, new SnapshotsInProgress.ShardSnapshotStatus(nodeId, generation));
            }

            private <T> void startShardOperation(ImmutableOpenMap.Builder<T, SnapshotsInProgress.ShardSnapshotStatus> newStates, T shardId, SnapshotsInProgress.ShardSnapshotStatus newState) {
                logger.trace("[{}] Starting [{}] on [{}] with generation [{}]", (Object)this.entry.snapshot(), shardId, (Object)newState.nodeId(), (Object)newState.generation());
                newStates.put(shardId, newState);
                this.updatesIterator.remove();
                ++SnapshotShardsUpdateContext.this.startedCount;
            }

            private <T> void applyShardSnapshotUpdate(Map<T, SnapshotsInProgress.ShardSnapshotStatus> existingShardSnapshotStatuses, Supplier<ImmutableOpenMap.Builder<T, SnapshotsInProgress.ShardSnapshotStatus>> newShardSnapshotStatusesSupplier, ShardSnapshotUpdate shardSnapshotStatusUpdate, T shardSnapshotId) {
                assert (shardSnapshotStatusUpdate.snapshot.equals(this.entry.snapshot()));
                SnapshotsInProgress.ShardSnapshotStatus existing = existingShardSnapshotStatuses.get(shardSnapshotId);
                if (existing == null) {
                    logger.error("Received shard snapshot status update [{}] but this shard is not tracked in [{}]", (Object)shardSnapshotStatusUpdate, (Object)this.entry);
                    assert (false) : "This should never happen, should only receive updates for expected shards";
                    return;
                }
                if (existing.state().completed()) {
                    this.updatesIterator.remove();
                    return;
                }
                ImmutableOpenMap.Builder<T, SnapshotsInProgress.ShardSnapshotStatus> newShardSnapshotStatusesBuilder = newShardSnapshotStatusesSupplier.get();
                SnapshotsInProgress.ShardSnapshotStatus newShardSnapshotStatus = newShardSnapshotStatusesBuilder.get(shardSnapshotId);
                assert (newShardSnapshotStatus != null);
                if (newShardSnapshotStatus.state().completed()) {
                    this.updatesIterator.remove();
                    return;
                }
                SnapshotsInProgress.ShardSnapshotStatus updatedShardSnapshotStatus = existing.state() == SnapshotsInProgress.ShardState.ABORTED && shardSnapshotStatusUpdate.updatedState.state() == SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL ? new SnapshotsInProgress.ShardSnapshotStatus(shardSnapshotStatusUpdate.updatedState.nodeId(), SnapshotsInProgress.ShardState.FAILED, shardSnapshotStatusUpdate.updatedState.generation(), "snapshot aborted") : shardSnapshotStatusUpdate.updatedState;
                if (updatedShardSnapshotStatus.state() == SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL) {
                    this.updatesIterator.remove();
                } else assert (!updatedShardSnapshotStatus.isActive()) : updatedShardSnapshotStatus;
                logger.trace("[{}] Updating shard [{}] with status [{}]", (Object)shardSnapshotStatusUpdate.snapshot, shardSnapshotId, (Object)updatedShardSnapshotStatus.state());
                ++SnapshotShardsUpdateContext.this.changedCount;
                newShardSnapshotStatusesBuilder.put(shardSnapshotId, updatedShardSnapshotStatus);
                SnapshotShardsUpdateContext.this.executedUpdates.add(shardSnapshotStatusUpdate);
            }

            private void tryStartNextTaskAfterCloneUpdated(RepositoryShardId repoShardId, SnapshotsInProgress.ShardSnapshotStatus updatedState) {
                if (!this.entry.isClone()) {
                    this.tryStartSnapshotAfterCloneFinish(repoShardId, updatedState.generation());
                } else if (SnapshotsServiceUtils.isQueued(this.entry.shardSnapshotStatusByRepoShardId().get(repoShardId))) {
                    String localNodeId = SnapshotShardsUpdateContext.this.initialState.nodes().getLocalNodeId();
                    assert (updatedState.nodeId().equals(localNodeId)) : "Clone updated with node id [" + updatedState.nodeId() + "] but local node id is [" + localNodeId + "]";
                    this.startShardOperation(this.clonesBuilder(), localNodeId, updatedState.generation(), repoShardId);
                }
            }

            private void tryStartNextTaskAfterSnapshotUpdated(ShardId shardId, SnapshotsInProgress.ShardSnapshotStatus updatedState) {
                IndexId indexId = this.entry.indices().get(shardId.getIndexName());
                if (indexId != null) {
                    RepositoryShardId repoShardId = new RepositoryShardId(indexId, shardId.id());
                    if (SnapshotsServiceUtils.isQueued(this.entry.shardSnapshotStatusByRepoShardId().get(repoShardId))) {
                        if (this.entry.isClone()) {
                            this.startShardOperation(this.clonesBuilder(), SnapshotShardsUpdateContext.this.initialState.nodes().getLocalNodeId(), updatedState.generation(), repoShardId);
                        } else {
                            this.startShardSnapshot(repoShardId, updatedState.generation());
                        }
                    }
                }
            }

            private void tryStartSnapshotAfterCloneFinish(RepositoryShardId repoShardId, ShardGeneration generation) {
                assert (this.entry.source() == null);
                if (SnapshotsServiceUtils.isQueued(this.entry.shardSnapshotStatusByRepoShardId().get(repoShardId))) {
                    this.startShardSnapshot(repoShardId, generation);
                }
            }

            private void startShardSnapshot(RepositoryShardId repoShardId, ShardGeneration generation) {
                ShardId routingShardId;
                Index index = this.entry.indexByName(repoShardId.indexName());
                assert (index != null) : "index [" + String.valueOf(repoShardId.index()) + "] must exist in snapshot entry [" + String.valueOf(this.entry) + "] because it's a normal snapshot but did not";
                IndexRoutingTable indexRouting = SnapshotShardsUpdateContext.this.initialState.routingTable(this.entry.projectId()).index(index);
                ShardRouting shardRouting = indexRouting == null ? null : indexRouting.shard(repoShardId.shardId()).primaryShard();
                SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = SnapshotsServiceUtils.initShardSnapshotStatus(generation, shardRouting, SnapshotShardsUpdateContext.this.nodeIdRemovalPredicate);
                ShardId shardId = routingShardId = shardRouting != null ? shardRouting.shardId() : new ShardId(index, repoShardId.shardId());
                if (shardSnapshotStatus.isActive()) {
                    this.startShardOperation(this.shardsBuilder(), routingShardId, shardSnapshotStatus);
                } else {
                    this.shardsBuilder().put(routingShardId, shardSnapshotStatus);
                }
            }

            private ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clonesBuilder() {
                assert (this.shardsBuilder == null);
                if (this.clonesBuilder == null) {
                    this.clonesBuilder = ImmutableOpenMap.builder(this.entry.shardSnapshotStatusByRepoShardId());
                }
                return this.clonesBuilder;
            }

            private ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardsBuilder() {
                assert (this.clonesBuilder == null);
                if (this.shardsBuilder == null) {
                    this.shardsBuilder = ImmutableOpenMap.builder(this.entry.shards());
                }
                return this.shardsBuilder;
            }
        }
    }

    private abstract class RemoveSnapshotDeletionAndContinueTask
    extends ClusterStateUpdateTask {
        protected final List<SnapshotsInProgress.Entry> newFinalizations = new ArrayList<SnapshotsInProgress.Entry>();
        private List<SnapshotDeletionsInProgress.Entry> readyDeletions = Collections.emptyList();
        protected final SnapshotDeletionsInProgress.Entry deleteEntry;
        private final RepositoryData repositoryData;

        RemoveSnapshotDeletionAndContinueTask(SnapshotDeletionsInProgress.Entry deleteEntry, RepositoryData repositoryData) {
            this.deleteEntry = deleteEntry;
            this.repositoryData = repositoryData;
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            SnapshotDeletionsInProgress deletions = (SnapshotDeletionsInProgress)currentState.custom("snapshot_deletions");
            assert (deletions != null) : "We only run this if there were deletions in the cluster state before";
            SnapshotDeletionsInProgress updatedDeletions = deletions.withRemovedEntry(this.deleteEntry.uuid());
            if (updatedDeletions == deletions) {
                return currentState;
            }
            SnapshotDeletionsInProgress newDeletions = this.filterDeletions(updatedDeletions);
            Tuple<ClusterState, List<SnapshotDeletionsInProgress.Entry>> res = SnapshotsServiceUtils.readyDeletions(SnapshotsServiceUtils.updateWithSnapshots(currentState, this.updatedSnapshotsInProgress(currentState, newDeletions), newDeletions), this.deleteEntry.projectId());
            this.readyDeletions = res.v2();
            return res.v1();
        }

        @Override
        public void onFailure(Exception e) {
            logger.warn(() -> Strings.format("%s failed to remove snapshot deletion metadata", this.deleteEntry), (Throwable)e);
            SnapshotsService.this.repositoryOperations.finishDeletion(this.deleteEntry.uuid());
            SnapshotsService.this.failAllListenersOnMasterFailOver(e);
        }

        protected SnapshotDeletionsInProgress filterDeletions(SnapshotDeletionsInProgress deletions) {
            return deletions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
            SnapshotsService.this.repositoryOperations.finishDeletion(this.deleteEntry.uuid());
            ArrayList<Runnable> readyToResolveListeners = new ArrayList<Runnable>();
            Iterator<SnapshotsInProgress.Entry> iterator = SnapshotsService.this.currentlyFinalizing;
            synchronized (iterator) {
                List<ActionListener<Void>> deleteListeners = SnapshotsService.this.snapshotDeletionListeners.remove(this.deleteEntry.uuid());
                readyToResolveListeners.add(() -> this.handleListeners(deleteListeners));
            }
            readyToResolveListeners.forEach(Runnable::run);
            if (this.newFinalizations.isEmpty()) {
                if (this.readyDeletions.isEmpty()) {
                    SnapshotsService.this.leaveRepoLoop(this.deleteEntry.projectId(), this.deleteEntry.repository());
                } else {
                    for (SnapshotDeletionsInProgress.Entry readyDeletion : this.readyDeletions) {
                        SnapshotsService.this.deleteSnapshotsFromRepository(readyDeletion, this.repositoryData, newState.nodes().getMaxDataNodeCompatibleIndexVersion());
                    }
                }
            } else {
                SnapshotsService.this.leaveRepoLoop(this.deleteEntry.projectId(), this.deleteEntry.repository());
                assert (this.readyDeletions.stream().noneMatch(entry -> entry.repository().equals(this.deleteEntry.repository()))) : "New finalizations " + String.valueOf(this.newFinalizations) + " added even though deletes " + String.valueOf(this.readyDeletions) + " are ready";
                for (SnapshotsInProgress.Entry entry2 : this.newFinalizations) {
                    SnapshotsService.this.endSnapshot(entry2, newState.metadata(), this.repositoryData);
                }
            }
            SnapshotsService.this.startExecutableClones(SnapshotsInProgress.get(newState), this.deleteEntry.projectId());
        }

        protected abstract void handleListeners(@Nullable List<ActionListener<Void>> var1);

        @Nullable
        private SnapshotsInProgress updatedSnapshotsInProgress(ClusterState currentState, SnapshotDeletionsInProgress updatedDeletions) {
            SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(currentState);
            ArrayList<SnapshotsInProgress.Entry> snapshotEntries = new ArrayList<SnapshotsInProgress.Entry>();
            HashSet<RepositoryShardId> reassignedShardIds = new HashSet<RepositoryShardId>();
            boolean changed = false;
            String localNodeId = currentState.nodes().getLocalNodeId();
            ProjectId projectId = this.deleteEntry.projectId();
            String repoName = this.deleteEntry.repository();
            InFlightShardSnapshotStates inFlightShardStates = null;
            HashSet<IndexId> newIndexIdsToRefresh = new HashSet<IndexId>();
            for (SnapshotsInProgress.Entry entry2 : snapshotsInProgress.forRepo(projectId, repoName)) {
                if (!entry2.state().completed()) {
                    ArrayList<RepositoryShardId> canBeUpdated;
                    if (entry2.isClone()) {
                        Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> value2;
                        canBeUpdated = new ArrayList<RepositoryShardId>();
                        for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> value2 : entry2.shardSnapshotStatusByRepoShardId().entrySet()) {
                            if (!value2.getValue().equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED) || reassignedShardIds.contains(value2.getKey())) continue;
                            canBeUpdated.add(value2.getKey());
                        }
                        if (canBeUpdated.isEmpty() || updatedDeletions.hasExecutingDeletion(projectId, repoName)) {
                            snapshotEntries.add(entry2);
                            continue;
                        }
                        if (inFlightShardStates == null) {
                            inFlightShardStates = InFlightShardSnapshotStates.forEntries(snapshotsInProgress.forRepo(projectId, repoName));
                        }
                        ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedAssignmentsBuilder = ImmutableOpenMap.builder(entry2.shardSnapshotStatusByRepoShardId());
                        value2 = canBeUpdated.iterator();
                        while (value2.hasNext()) {
                            RepositoryShardId shardId = (RepositoryShardId)value2.next();
                            if (inFlightShardStates.isActive(shardId.indexName(), shardId.shardId())) continue;
                            RemoveSnapshotDeletionAndContinueTask.markShardReassigned(shardId, reassignedShardIds);
                            updatedAssignmentsBuilder.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, inFlightShardStates.generationForShard(shardId.index(), shardId.shardId(), this.repositoryData.shardGenerations())));
                        }
                        snapshotEntries.add(entry2.withClones(updatedAssignmentsBuilder.build()));
                        changed = true;
                        continue;
                    }
                    canBeUpdated = new ArrayList();
                    for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> value2 : entry2.shardSnapshotStatusByRepoShardId().entrySet()) {
                        RepositoryShardId repositoryShardId = value2.getKey();
                        if (!value2.getValue().equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED) || reassignedShardIds.contains(repositoryShardId)) continue;
                        canBeUpdated.add(repositoryShardId);
                        if (this.repositoryData.hasIndex(repositoryShardId.indexName())) continue;
                        newIndexIdsToRefresh.add(repositoryShardId.index());
                    }
                    if (canBeUpdated.isEmpty()) {
                        snapshotEntries.add(entry2);
                        continue;
                    }
                    ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardAssignments = SnapshotsServiceUtils.shards(snapshotsInProgress, updatedDeletions, currentState.projectState(projectId), entry2.indices().values(), entry2.version().onOrAfter(SHARD_GEN_IN_REPO_DATA_VERSION), this.repositoryData, repoName);
                    ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedAssignmentsBuilder = ImmutableOpenMap.builder(entry2.shards());
                    for (RepositoryShardId shardId : canBeUpdated) {
                        ShardId sid = entry2.shardId(shardId);
                        SnapshotsInProgress.ShardSnapshotStatus updated = shardAssignments.get(sid);
                        if (updated == null) {
                            assert (!currentState.routingTable(projectId).hasIndex(sid.getIndex())) : "Missing assignment for [" + String.valueOf(sid) + "]";
                            updatedAssignmentsBuilder.put(sid, SnapshotsInProgress.ShardSnapshotStatus.MISSING);
                            continue;
                        }
                        if (updated.isActive()) {
                            RemoveSnapshotDeletionAndContinueTask.markShardReassigned(shardId, reassignedShardIds);
                        }
                        updatedAssignmentsBuilder.put(sid, updated);
                    }
                    SnapshotsInProgress.Entry updatedEntry = entry2.withShardStates(updatedAssignmentsBuilder.build());
                    snapshotEntries.add(updatedEntry);
                    changed = true;
                    if (!updatedEntry.state().completed()) continue;
                    this.newFinalizations.add(entry2);
                    continue;
                }
                this.newFinalizations.add(entry2);
                snapshotEntries.add(entry2);
            }
            if (changed && !newIndexIdsToRefresh.isEmpty()) {
                Map<IndexId, IndexId> updatedIndexIds = Maps.newMapWithExpectedSize(newIndexIdsToRefresh.size());
                for (IndexId indexIdToRefresh : newIndexIdsToRefresh) {
                    updatedIndexIds.put(indexIdToRefresh, new IndexId(indexIdToRefresh.getName(), UUIDs.randomBase64UUID()));
                }
                snapshotEntries.replaceAll(entry -> entry.withUpdatedIndexIds(updatedIndexIds));
            }
            return changed ? snapshotsInProgress.createCopyWithUpdatedEntriesForRepo(projectId, repoName, snapshotEntries) : null;
        }

        private static void markShardReassigned(RepositoryShardId shardId, Set<RepositoryShardId> reassignments) {
            boolean added = reassignments.add(shardId);
            assert (added) : "should only ever reassign each shard once but assigned [" + String.valueOf(shardId) + "] multiple times";
        }

        public String toString() {
            return "RemoveSnapshotDeletionAndContinueTask[" + String.valueOf(this.deleteEntry) + "]";
        }
    }
}

