/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.repositories.SnapshotMetrics;
import org.elasticsearch.telemetry.metric.LongWithAttributes;

public class CachingSnapshotAndShardByStateMetricsService {
    private final ClusterService clusterService;
    private volatile CachedSnapshotStateMetrics cachedSnapshotStateMetrics;

    public CachingSnapshotAndShardByStateMetricsService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public Collection<LongWithAttributes> getShardsByState() {
        if (this.clusterService.lifecycleState() != Lifecycle.State.STARTED) {
            return List.of();
        }
        ClusterState state = this.clusterService.state();
        if (!state.nodes().isLocalNodeElectedMaster()) {
            return List.of();
        }
        return this.recalculateIfStale(state).shardStateMetrics();
    }

    public Collection<LongWithAttributes> getSnapshotsByState() {
        if (this.clusterService.lifecycleState() != Lifecycle.State.STARTED) {
            return List.of();
        }
        ClusterState state = this.clusterService.state();
        if (!state.nodes().isLocalNodeElectedMaster()) {
            return List.of();
        }
        return this.recalculateIfStale(state).snapshotStateMetrics();
    }

    private CachedSnapshotStateMetrics recalculateIfStale(ClusterState currentState) {
        if (this.cachedSnapshotStateMetrics == null || this.cachedSnapshotStateMetrics.isStale(currentState)) {
            this.cachedSnapshotStateMetrics = this.recalculateSnapshotStats(currentState);
        }
        return this.cachedSnapshotStateMetrics;
    }

    private CachedSnapshotStateMetrics recalculateSnapshotStats(ClusterState currentState) {
        SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(currentState);
        ArrayList<LongWithAttributes> snapshotStateMetrics = new ArrayList<LongWithAttributes>();
        ArrayList<LongWithAttributes> shardStateMetrics = new ArrayList<LongWithAttributes>();
        currentState.metadata().projects().forEach((projectId, project) -> {
            RepositoriesMetadata repositoriesMetadata = RepositoriesMetadata.get(project);
            if (repositoriesMetadata != null) {
                for (RepositoryMetadata repository : repositoriesMetadata.repositories()) {
                    Tuple<Map<SnapshotsInProgress.State, Integer>, Map<SnapshotsInProgress.ShardState, Integer>> stateSummaries = snapshotsInProgress.shardStateSummaryForRepository((ProjectId)projectId, repository.name());
                    Map<String, Object> attributesMap = SnapshotMetrics.createAttributesMap(projectId, repository);
                    stateSummaries.v1().forEach((snapshotState, count) -> snapshotStateMetrics.add(new LongWithAttributes(count.intValue(), Maps.copyMapWithAddedEntry(attributesMap, "state", snapshotState.name()))));
                    stateSummaries.v2().forEach((shardState, count) -> shardStateMetrics.add(new LongWithAttributes(count.intValue(), Maps.copyMapWithAddedEntry(attributesMap, "state", shardState.name()))));
                }
            }
        });
        return new CachedSnapshotStateMetrics(currentState, snapshotStateMetrics, shardStateMetrics);
    }

    private record CachedSnapshotStateMetrics(String clusterStateId, int snapshotsInProgressIdentityHashcode, Collection<LongWithAttributes> snapshotStateMetrics, Collection<LongWithAttributes> shardStateMetrics) {
        CachedSnapshotStateMetrics(ClusterState sourceState, Collection<LongWithAttributes> snapshotStateMetrics, Collection<LongWithAttributes> shardStateMetrics) {
            this(sourceState.stateUUID(), System.identityHashCode(SnapshotsInProgress.get(sourceState)), snapshotStateMetrics, shardStateMetrics);
        }

        public boolean isStale(ClusterState currentClusterState) {
            return System.identityHashCode(SnapshotsInProgress.get(currentClusterState)) != this.snapshotsInProgressIdentityHashcode;
        }
    }
}

