/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteAsyncAction;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.ToChildBlockJoinQueryBuilder;
import org.elasticsearch.index.query.support.AutoPrefilteringUtils;
import org.elasticsearch.index.search.NestedHelper;
import org.elasticsearch.search.vectors.CachingEnableFilterQuery;
import org.elasticsearch.search.vectors.ExactKnnQueryBuilder;
import org.elasticsearch.search.vectors.QueryVectorBuilder;
import org.elasticsearch.search.vectors.RescoreVectorBuilder;
import org.elasticsearch.search.vectors.VectorData;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class KnnVectorQueryBuilder
extends AbstractQueryBuilder<KnnVectorQueryBuilder> {
    public static final TransportVersion AUTO_PREFILTERING = TransportVersion.fromName("knn_vector_query_auto_prefiltering");
    public static final String NAME = "knn";
    private static final int NUM_CANDS_LIMIT = 10000;
    private static final float NUM_CANDS_MULTIPLICATIVE_FACTOR = 1.5f;
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ParseField K_FIELD = new ParseField("k", new String[0]);
    public static final ParseField NUM_CANDS_FIELD = new ParseField("num_candidates", new String[0]);
    public static final ParseField VISIT_PERCENTAGE_FIELD = new ParseField("visit_percentage", new String[0]);
    public static final ParseField QUERY_VECTOR_FIELD = new ParseField("query_vector", new String[0]);
    public static final ParseField VECTOR_SIMILARITY_FIELD = new ParseField("similarity", new String[0]);
    public static final ParseField FILTER_FIELD = new ParseField("filter", new String[0]);
    public static final ParseField QUERY_VECTOR_BUILDER_FIELD = new ParseField("query_vector_builder", new String[0]);
    public static final ParseField RESCORE_VECTOR_FIELD = new ParseField("rescore_vector", new String[0]);
    public static final ConstructingObjectParser<KnnVectorQueryBuilder, Void> PARSER = new ConstructingObjectParser("knn", args -> new KnnVectorQueryBuilder((String)args[0], (VectorData)args[1], (QueryVectorBuilder)args[6], null, (Integer)args[2], (Integer)args[3], (Float)args[4], (RescoreVectorBuilder)args[7], (Float)args[5]));
    public static final Set<Class<? extends QueryBuilder>> UNSUPPORTED_AUTO_PREFILTERING_QUERY_TYPES = Set.of(NestedQueryBuilder.class);
    public static final TransportVersion VISIT_PERCENTAGE;
    private final String fieldName;
    private final VectorData queryVector;
    private final Integer k;
    private final Integer numCands;
    private final Float visitPercentage;
    private final List<QueryBuilder> filterQueries = new ArrayList<QueryBuilder>();
    private final Float vectorSimilarity;
    private final QueryVectorBuilder queryVectorBuilder;
    private final Supplier<float[]> queryVectorSupplier;
    private final RescoreVectorBuilder rescoreVectorBuilder;
    private boolean isAutoPrefilteringEnabled = false;

    public static KnnVectorQueryBuilder fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public KnnVectorQueryBuilder(String fieldName, float[] queryVector, Integer k, Integer numCands, Float visitPercentage, RescoreVectorBuilder rescoreVectorBuilder, Float vectorSimilarity) {
        this(fieldName, VectorData.fromFloats(queryVector), null, null, k, numCands, visitPercentage, rescoreVectorBuilder, vectorSimilarity);
    }

    public KnnVectorQueryBuilder(String fieldName, QueryVectorBuilder queryVectorBuilder, Integer k, Integer numCands, Float visitPercentage, Float vectorSimilarity) {
        this(fieldName, null, queryVectorBuilder, null, k, numCands, visitPercentage, null, vectorSimilarity);
    }

    public KnnVectorQueryBuilder(String fieldName, byte[] queryVector, Integer k, Integer numCands, Float visitPercentage, RescoreVectorBuilder rescoreVectorBuilder, Float vectorSimilarity) {
        this(fieldName, VectorData.fromBytes(queryVector), null, null, k, numCands, visitPercentage, rescoreVectorBuilder, vectorSimilarity);
    }

    public KnnVectorQueryBuilder(String fieldName, VectorData queryVector, Integer k, Integer numCands, Float visitPercentage, RescoreVectorBuilder rescoreVectorBuilder, Float vectorSimilarity) {
        this(fieldName, queryVector, null, null, k, numCands, visitPercentage, rescoreVectorBuilder, vectorSimilarity);
    }

    private KnnVectorQueryBuilder(String fieldName, VectorData queryVector, QueryVectorBuilder queryVectorBuilder, Supplier<float[]> queryVectorSupplier, Integer k, Integer numCands, Float visitPercentage, RescoreVectorBuilder rescoreVectorBuilder, Float vectorSimilarity) {
        if (k != null && k < 1) {
            throw new IllegalArgumentException("[" + K_FIELD.getPreferredName() + "] must be greater than 0");
        }
        if (numCands != null && numCands > 10000) {
            throw new IllegalArgumentException("[" + NUM_CANDS_FIELD.getPreferredName() + "] cannot exceed [10000]");
        }
        if (k != null && numCands != null && numCands < k) {
            throw new IllegalArgumentException("[" + NUM_CANDS_FIELD.getPreferredName() + "] cannot be less than [" + K_FIELD.getPreferredName() + "]");
        }
        if (visitPercentage != null && (visitPercentage.floatValue() < 0.0f || visitPercentage.floatValue() > 100.0f)) {
            throw new IllegalArgumentException("[" + VISIT_PERCENTAGE_FIELD.getPreferredName() + "] must be between 0.0 and 100.0");
        }
        if (queryVector == null && queryVectorBuilder == null) {
            throw new IllegalArgumentException(Strings.format("either [%s] or [%s] must be provided", QUERY_VECTOR_FIELD.getPreferredName(), QUERY_VECTOR_BUILDER_FIELD.getPreferredName()));
        }
        if (queryVector != null && queryVectorBuilder != null) {
            throw new IllegalArgumentException(Strings.format("only one of [%s] and [%s] must be provided", QUERY_VECTOR_FIELD.getPreferredName(), QUERY_VECTOR_BUILDER_FIELD.getPreferredName()));
        }
        this.fieldName = fieldName;
        this.queryVector = queryVector;
        this.k = k;
        this.numCands = numCands;
        this.visitPercentage = visitPercentage;
        this.vectorSimilarity = vectorSimilarity;
        this.queryVectorBuilder = queryVectorBuilder;
        this.queryVectorSupplier = queryVectorSupplier;
        this.rescoreVectorBuilder = rescoreVectorBuilder;
    }

    public KnnVectorQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.k = in.readOptionalVInt();
        this.numCands = in.readOptionalVInt();
        this.visitPercentage = in.getTransportVersion().supports(VISIT_PERCENTAGE) ? in.readOptionalFloat() : null;
        this.queryVector = in.readOptionalWriteable(VectorData::new);
        this.filterQueries.addAll(KnnVectorQueryBuilder.readQueries(in));
        this.vectorSimilarity = in.readOptionalFloat();
        this.queryVectorBuilder = in.readOptionalNamedWriteable(QueryVectorBuilder.class);
        this.rescoreVectorBuilder = in.readOptional(RescoreVectorBuilder::new);
        if (in.getTransportVersion().supports(AUTO_PREFILTERING)) {
            this.isAutoPrefilteringEnabled = in.readBoolean();
        }
        this.queryVectorSupplier = null;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Nullable
    public VectorData queryVector() {
        return this.queryVector;
    }

    @Nullable
    public Float getVectorSimilarity() {
        return this.vectorSimilarity;
    }

    public Integer k() {
        return this.k;
    }

    public Integer numCands() {
        return this.numCands;
    }

    public Float visitPercentage() {
        return this.visitPercentage;
    }

    public List<QueryBuilder> filterQueries() {
        return this.filterQueries;
    }

    @Nullable
    public QueryVectorBuilder queryVectorBuilder() {
        return this.queryVectorBuilder;
    }

    public RescoreVectorBuilder rescoreVectorBuilder() {
        return this.rescoreVectorBuilder;
    }

    public KnnVectorQueryBuilder addFilterQuery(QueryBuilder filterQuery) {
        Objects.requireNonNull(filterQuery);
        this.filterQueries.add(filterQuery);
        return this;
    }

    public KnnVectorQueryBuilder addFilterQueries(List<QueryBuilder> filterQueries) {
        Objects.requireNonNull(filterQueries);
        this.filterQueries.addAll(filterQueries);
        return this;
    }

    public KnnVectorQueryBuilder setFilterQueries(List<QueryBuilder> filterQueries) {
        Objects.requireNonNull(filterQueries);
        this.filterQueries.clear();
        this.filterQueries.addAll(filterQueries);
        return this;
    }

    public boolean isAutoPrefilteringEnabled() {
        return this.isAutoPrefilteringEnabled;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.queryVectorSupplier != null) {
            throw new IllegalStateException("missing a rewriteAndFetch?");
        }
        out.writeString(this.fieldName);
        out.writeOptionalVInt(this.k);
        out.writeOptionalVInt(this.numCands);
        if (out.getTransportVersion().supports(VISIT_PERCENTAGE)) {
            out.writeOptionalFloat(this.visitPercentage);
        }
        out.writeOptionalWriteable(this.queryVector);
        KnnVectorQueryBuilder.writeQueries(out, this.filterQueries);
        out.writeOptionalFloat(this.vectorSimilarity);
        out.writeOptionalNamedWriteable(this.queryVectorBuilder);
        out.writeOptionalWriteable(this.rescoreVectorBuilder);
        if (out.getTransportVersion().supports(AUTO_PREFILTERING)) {
            out.writeBoolean(this.isAutoPrefilteringEnabled);
        }
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.queryVectorSupplier != null) {
            throw new IllegalStateException("missing a rewriteAndFetch?");
        }
        builder.startObject(NAME);
        builder.field(FIELD_FIELD.getPreferredName(), this.fieldName);
        if (this.queryVector != null) {
            builder.field(QUERY_VECTOR_FIELD.getPreferredName(), this.queryVector);
        }
        if (this.k != null) {
            builder.field(K_FIELD.getPreferredName(), this.k);
        }
        if (this.numCands != null) {
            builder.field(NUM_CANDS_FIELD.getPreferredName(), this.numCands);
        }
        if (this.visitPercentage != null) {
            builder.field(VISIT_PERCENTAGE_FIELD.getPreferredName(), this.visitPercentage);
        }
        if (this.vectorSimilarity != null) {
            builder.field(VECTOR_SIMILARITY_FIELD.getPreferredName(), this.vectorSimilarity);
        }
        if (this.queryVectorBuilder != null) {
            builder.startObject(QUERY_VECTOR_BUILDER_FIELD.getPreferredName());
            builder.field(this.queryVectorBuilder.getWriteableName(), this.queryVectorBuilder);
            builder.endObject();
        }
        if (!this.filterQueries.isEmpty()) {
            builder.startArray(FILTER_FIELD.getPreferredName());
            for (QueryBuilder filterQuery : this.filterQueries) {
                filterQuery.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.rescoreVectorBuilder != null) {
            builder.field(RESCORE_VECTOR_FIELD.getPreferredName(), this.rescoreVectorBuilder);
        }
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext ctx) throws IOException {
        if (this.queryVectorSupplier != null) {
            if (this.queryVectorSupplier.get() == null) {
                return this;
            }
            return ((KnnVectorQueryBuilder)((KnnVectorQueryBuilder)new KnnVectorQueryBuilder(this.fieldName, this.queryVectorSupplier.get(), this.k, this.numCands, this.visitPercentage, this.rescoreVectorBuilder, this.vectorSimilarity).boost(this.boost)).queryName(this.queryName)).addFilterQueries(this.filterQueries).setAutoPrefilteringEnabled(this.isAutoPrefilteringEnabled);
        }
        if (this.queryVectorBuilder != null) {
            SetOnce toSet = new SetOnce();
            ctx.registerUniqueAsyncAction(new QueryVectorBuilderAsyncAction(this.queryVectorBuilder), v -> {
                toSet.set(v);
                if (v == null) {
                    throw new IllegalArgumentException(Strings.format("[%s] with name [%s] returned null query_vector", QUERY_VECTOR_BUILDER_FIELD.getPreferredName(), this.queryVectorBuilder.getWriteableName()));
                }
            });
            return ((KnnVectorQueryBuilder)((KnnVectorQueryBuilder)new KnnVectorQueryBuilder(this.fieldName, this.queryVector, this.queryVectorBuilder, toSet::get, this.k, this.numCands, this.visitPercentage, this.rescoreVectorBuilder, this.vectorSimilarity).boost(this.boost)).queryName(this.queryName)).addFilterQueries(this.filterQueries).setAutoPrefilteringEnabled(this.isAutoPrefilteringEnabled);
        }
        boolean changed = false;
        ArrayList<QueryBuilder> rewrittenQueries = new ArrayList<QueryBuilder>(this.filterQueries.size());
        for (QueryBuilder query : this.filterQueries) {
            QueryBuilder rewrittenQuery = query.rewrite(ctx);
            if (rewrittenQuery instanceof MatchNoneQueryBuilder) {
                return rewrittenQuery;
            }
            if (rewrittenQuery != query) {
                changed = true;
            }
            rewrittenQueries.add(rewrittenQuery);
        }
        if (changed) {
            return ((KnnVectorQueryBuilder)((KnnVectorQueryBuilder)new KnnVectorQueryBuilder(this.fieldName, this.queryVector, this.queryVectorBuilder, this.queryVectorSupplier, this.k, this.numCands, this.visitPercentage, this.rescoreVectorBuilder, this.vectorSimilarity).boost(this.boost)).queryName(this.queryName)).addFilterQueries(rewrittenQueries).setAutoPrefilteringEnabled(this.isAutoPrefilteringEnabled);
        }
        if (ctx.convertToInnerHitsRewriteContext() != null) {
            ExactKnnQueryBuilder exactKnnQuery = new ExactKnnQueryBuilder(this.queryVector, this.fieldName, this.vectorSimilarity);
            if (this.filterQueries.isEmpty()) {
                return exactKnnQuery;
            }
            BoolQueryBuilder boolQuery = new BoolQueryBuilder();
            boolQuery.must(exactKnnQuery);
            for (QueryBuilder filter : this.filterQueries) {
                BoolQueryBuilder adjustedFilter = new BoolQueryBuilder().should(filter).should(new ToChildBlockJoinQueryBuilder(filter));
                boolQuery.filter(adjustedFilter);
            }
            return boolQuery;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        Float oversample;
        Query filterQuery;
        int adjustedNumCands;
        int k;
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        if (this.k != null) {
            k = this.k;
        } else {
            int n = k = context.requestSize() == null || context.requestSize() < 0 ? 10 : context.requestSize();
            if (this.numCands != null) {
                k = Math.min(k, this.numCands);
            }
        }
        int n = adjustedNumCands = this.numCands == null ? Math.round(Math.min(1.5f * (float)k, 10000.0f)) : this.numCands;
        if (fieldType == null) {
            return Queries.NO_DOCS_INSTANCE;
        }
        if (!(fieldType instanceof DenseVectorFieldMapper.DenseVectorFieldType)) {
            throw new IllegalArgumentException("[knn] queries are only supported on [dense_vector] fields");
        }
        DenseVectorFieldMapper.DenseVectorFieldType vectorFieldType = (DenseVectorFieldMapper.DenseVectorFieldType)fieldType;
        List<Query> filtersInitial = this.doFiltersToQuery(context);
        String parentPath = context.nestedLookup().getNestedParent(this.fieldName);
        BitSetProducer parentBitSet = null;
        if (parentPath == null) {
            filterQuery = KnnVectorQueryBuilder.buildFilterQuery(filtersInitial);
        } else {
            Query parentFilter;
            NestedObjectMapper originalObjectMapper = context.nestedScope().getObjectMapper();
            if (originalObjectMapper != null) {
                try {
                    context.nestedScope().previousLevel();
                    NestedObjectMapper objectMapper = context.nestedScope().getObjectMapper();
                    parentFilter = objectMapper == null ? Queries.newNonNestedFilter(context.indexVersionCreated()) : objectMapper.nestedTypeFilter();
                }
                finally {
                    context.nestedScope().nextLevel(originalObjectMapper);
                }
            } else {
                parentFilter = Queries.newNonNestedFilter(context.indexVersionCreated());
            }
            parentBitSet = context.bitsetFilter(parentFilter);
            ArrayList<Query> filterAdjusted = new ArrayList<Query>(filtersInitial.size());
            for (Query f : filtersInitial) {
                if (NestedHelper.mightMatchNonNestedDocs(f, parentPath, context)) {
                    f = Queries.filtered(f, parentFilter);
                    f = new ToChildBlockJoinQuery(f, parentBitSet);
                }
                filterAdjusted.add(f);
            }
            filterQuery = KnnVectorQueryBuilder.buildFilterQuery(filterAdjusted);
        }
        DenseVectorFieldMapper.FilterHeuristic heuristic = context.getIndexSettings().getHnswFilterHeuristic();
        boolean hnswEarlyTermination = context.getIndexSettings().getHnswEarlyTermination();
        Float f = oversample = this.rescoreVectorBuilder() == null ? null : Float.valueOf(this.rescoreVectorBuilder.oversample());
        if (!(filterQuery == null || vectorFieldType.getIndexOptions() != null && vectorFieldType.getIndexOptions().isFlat())) {
            filterQuery = new CachingEnableFilterQuery(filterQuery);
        }
        return vectorFieldType.createKnnQuery(this.queryVector, k, adjustedNumCands, this.visitPercentage, oversample, filterQuery, this.vectorSimilarity, parentBitSet, heuristic, hnswEarlyTermination);
    }

    private List<Query> doFiltersToQuery(SearchExecutionContext context) throws IOException {
        List<Query> autoPrefilters = this.applyAutoPrefilteringIfEnabled(context);
        ArrayList<Query> allFilters = new ArrayList<Query>(this.filterQueries.size() + autoPrefilters.size() + (context.getAliasFilter() == null ? 0 : 1));
        allFilters.addAll(autoPrefilters);
        for (QueryBuilder queryBuilder : this.filterQueries) {
            allFilters.add(queryBuilder.toQuery(context));
        }
        if (context.getAliasFilter() != null) {
            allFilters.add(context.getAliasFilter().toQuery(context));
        }
        return allFilters;
    }

    private List<Query> applyAutoPrefilteringIfEnabled(SearchExecutionContext context) throws IOException {
        if (!this.isAutoPrefilteringEnabled) {
            return List.of();
        }
        ArrayList<Query> autoPrefilters = new ArrayList<Query>();
        for (QueryBuilder queryBuilder : context.autoPrefilteringScope().getPrefilters().stream().filter(f -> this != f).toList()) {
            Optional<QueryBuilder> pruned = AutoPrefilteringUtils.pruneQuery(queryBuilder, UNSUPPORTED_AUTO_PREFILTERING_QUERY_TYPES);
            if (!pruned.isPresent()) continue;
            Query query = pruned.get().toQuery(context);
            autoPrefilters.add(query);
        }
        return autoPrefilters;
    }

    private static Query buildFilterQuery(List<Query> filters) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (Query f : filters) {
            builder.add(f, BooleanClause.Occur.FILTER);
        }
        BooleanQuery booleanQuery = builder.build();
        BooleanQuery filterQuery = booleanQuery.clauses().isEmpty() ? null : booleanQuery;
        return filterQuery;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, Objects.hashCode(this.queryVector), this.k, this.numCands, this.visitPercentage, this.filterQueries, this.vectorSimilarity, this.queryVectorBuilder, this.rescoreVectorBuilder, this.isAutoPrefilteringEnabled);
    }

    @Override
    protected boolean doEquals(KnnVectorQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.queryVector, other.queryVector) && Objects.equals(this.k, other.k) && Objects.equals(this.numCands, other.numCands) && Objects.equals(this.visitPercentage, other.visitPercentage) && Objects.equals(this.filterQueries, other.filterQueries) && Objects.equals(this.vectorSimilarity, other.vectorSimilarity) && Objects.equals(this.queryVectorBuilder, other.queryVectorBuilder) && Objects.equals(this.rescoreVectorBuilder, other.rescoreVectorBuilder) && this.isAutoPrefilteringEnabled == other.isAutoPrefilteringEnabled;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    public KnnVectorQueryBuilder setAutoPrefilteringEnabled(boolean isAutoPrefilteringEnabled) {
        this.isAutoPrefilteringEnabled = isAutoPrefilteringEnabled;
        return this;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> VectorData.parseXContent(p), QUERY_VECTOR_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_STRING_OR_NUMBER);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), K_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_CANDS_FIELD);
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), VISIT_PERCENTAGE_FIELD);
        PARSER.declareFloat(ConstructingObjectParser.optionalConstructorArg(), VECTOR_SIMILARITY_FIELD);
        PARSER.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> p.namedObject(QueryVectorBuilder.class, n, c), QUERY_VECTOR_BUILDER_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> RescoreVectorBuilder.fromXContent(p), RESCORE_VECTOR_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareFieldArray(KnnVectorQueryBuilder::addFilterQueries, (p, c) -> AbstractQueryBuilder.parseTopLevelQuery(p), FILTER_FIELD, ObjectParser.ValueType.OBJECT_ARRAY);
        KnnVectorQueryBuilder.declareStandardFields(PARSER);
        VISIT_PERCENTAGE = TransportVersion.fromName("visit_percentage");
    }

    private static final class QueryVectorBuilderAsyncAction
    extends QueryRewriteAsyncAction<float[], QueryVectorBuilderAsyncAction> {
        private final QueryVectorBuilder queryVectorBuilder;

        private QueryVectorBuilderAsyncAction(QueryVectorBuilder queryVectorBuilder) {
            this.queryVectorBuilder = Objects.requireNonNull(queryVectorBuilder);
        }

        @Override
        protected void execute(Client client, ActionListener<float[]> listener) {
            this.queryVectorBuilder.buildVector(client, listener);
        }

        @Override
        public int doHashCode() {
            return Objects.hash(this.queryVectorBuilder);
        }

        @Override
        public boolean doEquals(QueryVectorBuilderAsyncAction other) {
            return Objects.equals(this.queryVectorBuilder, other.queryVectorBuilder);
        }
    }
}

