/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class CachingEnableFilterQuery
extends Query {
    private final Query in;

    public CachingEnableFilterQuery(Query in) {
        this.in = in;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        Weight inWeight = this.in.createWeight(searcher, scoreMode, boost);
        return new FilterWeight(this, this, inWeight){};
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewrite = this.in.rewrite(indexSearcher);
        if (rewrite instanceof MatchNoDocsQuery || rewrite instanceof MatchAllDocsQuery || rewrite instanceof BooleanQuery) {
            return rewrite;
        }
        return rewrite != this.in ? new CachingEnableFilterQuery(rewrite) : this;
    }

    @Override
    public String toString(String field) {
        return this.in.toString(field);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.in.visit(visitor);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.in.equals(((CachingEnableFilterQuery)obj).in);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.in.hashCode());
    }
}

