/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.Objects;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.search.runtime.AbstractStringScriptFieldAutomatonQuery;

public class StringScriptFieldRegexpQuery
extends AbstractStringScriptFieldAutomatonQuery {
    private final String pattern;
    private final int syntaxFlags;
    private final int matchFlags;

    public StringScriptFieldRegexpQuery(Script script, StringFieldScript.LeafFactory leafFactory, String fieldName, String pattern, int syntaxFlags, int matchFlags, int maxDeterminizedStates) {
        super(script, leafFactory, fieldName, new ByteRunAutomaton(Operations.determinize(new RegExp(Objects.requireNonNull(pattern), syntaxFlags, matchFlags).toAutomaton(), maxDeterminizedStates)));
        this.pattern = pattern;
        this.syntaxFlags = syntaxFlags;
        this.matchFlags = matchFlags;
    }

    @Override
    public final String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.fieldName().contentEquals(field)) {
            b.append(this.fieldName()).append(':');
        }
        return b.append('/').append(this.pattern).append('/').toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pattern, this.syntaxFlags, this.matchFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        StringScriptFieldRegexpQuery other = (StringScriptFieldRegexpQuery)obj;
        return this.pattern.equals(other.pattern) && this.syntaxFlags == other.syntaxFlags && this.matchFlags == other.matchFlags;
    }

    String pattern() {
        return this.pattern;
    }

    int syntaxFlags() {
        return this.syntaxFlags;
    }

    int matchFlags() {
        return this.matchFlags;
    }
}

