/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.crossproject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ResolvedIndexExpression;
import org.elasticsearch.action.ResolvedIndexExpressions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.transport.RemoteClusterAware;

public class CrossProjectIndexResolutionValidator {
    private static final Logger logger = LogManager.getLogger(CrossProjectIndexResolutionValidator.class);

    public static ElasticsearchException validate(IndicesOptions indicesOptions, @Nullable String projectRouting, ResolvedIndexExpressions localResolvedExpressions, Map<String, ResolvedIndexExpressions> remoteResolvedExpressions) {
        ElasticsearchSecurityException firstException;
        if (indicesOptions.allowNoIndices() && indicesOptions.ignoreUnavailable()) {
            logger.debug("Skipping index existence check in lenient mode");
            return null;
        }
        HashMap<String, ElasticsearchSecurityException> remoteAuthorizationExceptions = null;
        HashMap<String, List> remoteUnauthorizedIndices = null;
        ElasticsearchSecurityException localAuthorizationException = null;
        ArrayList<String> localUnauthorizedIndices = null;
        IndexNotFoundException notFoundException = null;
        boolean hasProjectRouting = !Strings.isEmpty(projectRouting);
        logger.debug("Checking index existence for [{}] and [{}] with indices options [{}]{}", (Object)localResolvedExpressions, remoteResolvedExpressions, (Object)indicesOptions, hasProjectRouting ? " and project routing [" + projectRouting + "]" : "");
        for (ResolvedIndexExpression localResolvedIndices : localResolvedExpressions.expressions()) {
            String originalExpression = localResolvedIndices.original();
            logger.debug("Checking replaced expression for original expression [{}]", (Object)originalExpression);
            boolean isQualifiedExpression = RemoteClusterAware.isRemoteIndexName(originalExpression);
            List remoteExpressions = localResolvedIndices.remoteExpressions().stream().sorted().toList();
            ResolvedIndexExpression.LocalExpressions localExpressions = localResolvedIndices.localExpressions();
            ResolvedIndexExpression.LocalIndexResolutionResult result = localExpressions.localIndexResolutionResult();
            ElasticsearchException localException = CrossProjectIndexResolutionValidator.checkResolutionFailure(localExpressions, result, originalExpression, indicesOptions);
            if (isQualifiedExpression) {
                if (localException != null) {
                    if (localException instanceof ElasticsearchSecurityException) {
                        ElasticsearchSecurityException securityException = (ElasticsearchSecurityException)localException;
                        if (localAuthorizationException == null) {
                            localAuthorizationException = securityException;
                            localUnauthorizedIndices = new ArrayList<String>();
                        }
                        localUnauthorizedIndices.add(originalExpression);
                    } else if (notFoundException == null) {
                        notFoundException = (IndexNotFoundException)localException;
                    }
                }
                for (String remoteExpression : remoteExpressions) {
                    String resource;
                    String[] splitResource = CrossProjectIndexResolutionValidator.splitQualifiedResource(remoteExpression);
                    String projectAlias = splitResource[0];
                    ElasticsearchException remoteException = CrossProjectIndexResolutionValidator.checkSingleRemoteExpression(remoteResolvedExpressions, projectAlias, resource = splitResource[1], remoteExpression, indicesOptions);
                    if (remoteException == null) continue;
                    if (remoteException instanceof ElasticsearchSecurityException) {
                        ElasticsearchSecurityException securityException = (ElasticsearchSecurityException)remoteException;
                        if (remoteAuthorizationExceptions == null) {
                            remoteAuthorizationExceptions = new LinkedHashMap();
                            remoteUnauthorizedIndices = new HashMap();
                        }
                        remoteAuthorizationExceptions.putIfAbsent(projectAlias, securityException);
                        remoteUnauthorizedIndices.computeIfAbsent(projectAlias, k -> new ArrayList()).add(remoteExpression);
                        continue;
                    }
                    if (notFoundException != null) continue;
                    notFoundException = (IndexNotFoundException)remoteException;
                }
                continue;
            }
            if (localException == null && localExpressions != ResolvedIndexExpression.LocalExpressions.NONE) continue;
            assert (localExpressions != ResolvedIndexExpression.LocalExpressions.NONE || !remoteExpressions.isEmpty()) : "both local expression and remote expressions are empty which should have errored earlier at index rewriting time";
            ElasticsearchSecurityException currentExpressionSecurityException = null;
            if (localException instanceof ElasticsearchSecurityException) {
                ElasticsearchSecurityException securityException;
                currentExpressionSecurityException = securityException = (ElasticsearchSecurityException)localException;
            }
            boolean foundFlat = false;
            BiConsumer<Map, Map> populateRemoteSecurityExceptionAndIndices = null;
            for (String remoteExpression : remoteExpressions) {
                ElasticsearchSecurityException securityException;
                String resource;
                String[] splitResource = CrossProjectIndexResolutionValidator.splitQualifiedResource(remoteExpression);
                String projectAlias = splitResource[0];
                ElasticsearchException remoteException = CrossProjectIndexResolutionValidator.checkSingleRemoteExpression(remoteResolvedExpressions, projectAlias, resource = splitResource[1], remoteExpression, indicesOptions);
                if (remoteException == null) {
                    foundFlat = true;
                    break;
                }
                if (currentExpressionSecurityException != null || !(remoteException instanceof ElasticsearchSecurityException)) continue;
                currentExpressionSecurityException = securityException = (ElasticsearchSecurityException)remoteException;
                assert (populateRemoteSecurityExceptionAndIndices == null);
                populateRemoteSecurityExceptionAndIndices = (exceptionsMap, unauthorizedIndicesMap) -> {
                    exceptionsMap.putIfAbsent(projectAlias, securityException);
                    unauthorizedIndicesMap.computeIfAbsent(projectAlias, k -> new ArrayList()).add(remoteExpression);
                };
            }
            if (foundFlat) continue;
            if (populateRemoteSecurityExceptionAndIndices != null) {
                assert (!(localException instanceof ElasticsearchSecurityException));
                if (remoteAuthorizationExceptions == null) {
                    remoteAuthorizationExceptions = new HashMap<String, ElasticsearchSecurityException>();
                    remoteUnauthorizedIndices = new HashMap<String, List>();
                }
                populateRemoteSecurityExceptionAndIndices.accept(remoteAuthorizationExceptions, remoteUnauthorizedIndices);
            }
            if (currentExpressionSecurityException != null && currentExpressionSecurityException == localException) {
                if (localAuthorizationException == null) {
                    localAuthorizationException = currentExpressionSecurityException;
                    localUnauthorizedIndices = new ArrayList();
                }
                localUnauthorizedIndices.add(originalExpression);
                continue;
            }
            if (localException != null) {
                assert (localException instanceof IndexNotFoundException) : "Expected local exception to be IndexNotFoundException, but found: " + String.valueOf(localException);
                if (notFoundException != null) continue;
                notFoundException = (IndexNotFoundException)localException;
                continue;
            }
            assert (localExpressions == ResolvedIndexExpression.LocalExpressions.NONE) : localExpressions;
            assert (!remoteExpressions.isEmpty()) : "expected remote expressions to be non-empty";
            if (notFoundException != null) continue;
            notFoundException = new IndexNotFoundException((String)remoteExpressions.getFirst());
        }
        if (localAuthorizationException == null && remoteAuthorizationExceptions == null) {
            return notFoundException;
        }
        ElasticsearchSecurityException elasticsearchSecurityException = firstException = localAuthorizationException != null ? CrossProjectIndexResolutionValidator.formatAuthorizationException(localAuthorizationException, localUnauthorizedIndices) : null;
        if (remoteAuthorizationExceptions != null) {
            for (Map.Entry e : remoteAuthorizationExceptions.entrySet()) {
                List unauthorizedIndices = (List)remoteUnauthorizedIndices.get(e.getKey());
                assert (!unauthorizedIndices.isEmpty());
                ElasticsearchSecurityException exception = CrossProjectIndexResolutionValidator.formatAuthorizationException((ElasticsearchException)e.getValue(), unauthorizedIndices);
                if (firstException == null) {
                    firstException = exception;
                    continue;
                }
                firstException.addSuppressed(exception);
            }
        }
        return firstException;
    }

    private static ElasticsearchSecurityException formatAuthorizationException(ElasticsearchException exceptionWithPlaceholder, List<String> unauthorizedIndices) {
        return new ElasticsearchSecurityException(Strings.replace(exceptionWithPlaceholder.getMessage(), "-*", Strings.collectionToCommaDelimitedString(unauthorizedIndices)), exceptionWithPlaceholder.status(), new Object[0]);
    }

    public static IndicesOptions indicesOptionsForCrossProjectFanout(IndicesOptions indicesOptions) {
        return IndicesOptions.builder(indicesOptions).concreteTargetOptions(new IndicesOptions.ConcreteTargetOptions(true)).wildcardOptions(IndicesOptions.WildcardOptions.builder(indicesOptions.wildcardOptions()).allowEmptyExpressions(true).build()).crossProjectModeOptions(IndicesOptions.CrossProjectModeOptions.DEFAULT).build();
    }

    private static ElasticsearchException checkSingleRemoteExpression(Map<String, ResolvedIndexExpressions> remoteResolvedExpressions, String projectAlias, String resource, String remoteExpression, IndicesOptions indicesOptions) {
        ResolvedIndexExpressions resolvedExpressionsInProject = remoteResolvedExpressions.get(projectAlias);
        if (resolvedExpressionsInProject == null) {
            return new IndexNotFoundException(remoteExpression);
        }
        ResolvedIndexExpression.LocalExpressions matchingExpression = CrossProjectIndexResolutionValidator.findMatchingExpression(resolvedExpressionsInProject, resource);
        if (matchingExpression == null) {
            assert (false) : "Expected to find matching expression [" + resource + "] in project [" + projectAlias + "]";
            return new IndexNotFoundException(remoteExpression);
        }
        return CrossProjectIndexResolutionValidator.checkResolutionFailure(matchingExpression, matchingExpression.localIndexResolutionResult(), remoteExpression, indicesOptions);
    }

    public static String[] splitQualifiedResource(String resource) {
        String[] splitResource = RemoteClusterAware.splitIndexName(resource);
        assert (splitResource.length == 2) : "Expected two strings (project and indexExpression) for a qualified resource [" + resource + "], but found [" + splitResource.length + "]";
        return splitResource;
    }

    private static ResolvedIndexExpression.LocalExpressions findMatchingExpression(ResolvedIndexExpressions projectExpressions, String resource) {
        return projectExpressions.expressions().stream().filter(expr -> expr.original().equals(resource)).map(ResolvedIndexExpression::localExpressions).findFirst().orElse(null);
    }

    private static ElasticsearchException checkResolutionFailure(ResolvedIndexExpression.LocalExpressions localExpressions, ResolvedIndexExpression.LocalIndexResolutionResult result, String expression, IndicesOptions indicesOptions) {
        assert (!(indicesOptions.allowNoIndices() && indicesOptions.ignoreUnavailable())) : "Should not be checking index existence in lenient mode";
        if (!indicesOptions.ignoreUnavailable()) {
            if (result == ResolvedIndexExpression.LocalIndexResolutionResult.CONCRETE_RESOURCE_NOT_VISIBLE) {
                return new IndexNotFoundException(expression);
            }
            if (result == ResolvedIndexExpression.LocalIndexResolutionResult.CONCRETE_RESOURCE_UNAUTHORIZED) {
                assert (localExpressions.exception() != null) : "ResolvedIndexExpression should have exception set when concrete index is unauthorized";
                return localExpressions.exception();
            }
        }
        if (!indicesOptions.allowNoIndices() && result == ResolvedIndexExpression.LocalIndexResolutionResult.SUCCESS && localExpressions.indices().isEmpty()) {
            return new IndexNotFoundException(expression);
        }
        return null;
    }
}

