/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.composite.MissingOrder;
import org.elasticsearch.search.aggregations.bucket.composite.SortedDocsProducer;

abstract class SingleDimensionValuesSource<T extends Comparable<T>>
implements Releasable {
    protected final BigArrays bigArrays;
    protected final DocValueFormat format;
    @Nullable
    protected final MappedFieldType fieldType;
    protected final boolean missingBucket;
    protected final MissingOrder missingOrder;
    protected final int reverseMul;
    protected T afterValue;

    SingleDimensionValuesSource(BigArrays bigArrays, DocValueFormat format, @Nullable MappedFieldType fieldType, boolean missingBucket, MissingOrder missingOrder, int reverseMul) {
        this.bigArrays = bigArrays;
        this.format = format;
        this.fieldType = fieldType;
        this.missingBucket = missingBucket;
        this.missingOrder = missingOrder;
        this.reverseMul = reverseMul;
        this.afterValue = null;
    }

    abstract void copyCurrent(int var1);

    abstract int compare(int var1, int var2);

    abstract int compareCurrent(int var1);

    abstract int compareCurrentWithAfter();

    abstract int hashCode(int var1);

    abstract int hashCodeCurrent();

    abstract void setAfter(Comparable<?> var1);

    T getAfter() {
        return this.afterValue;
    }

    abstract T toComparable(int var1) throws IOException;

    abstract LeafBucketCollector getLeafCollector(LeafReaderContext var1, LeafBucketCollector var2) throws IOException;

    abstract LeafBucketCollector getLeafCollector(Comparable<T> var1, LeafReaderContext var2, LeafBucketCollector var3) throws IOException;

    abstract SortedDocsProducer createSortedDocsProducerOrNull(IndexReader var1, Query var2);

    protected boolean checkIfSortedDocsIsApplicable(IndexReader reader, MappedFieldType fieldType) {
        if (fieldType == null || this.missingBucket && this.afterValue == null || !fieldType.indexType().supportsSortShortcuts() || this.reverseMul == -1) {
            return false;
        }
        return !reader.hasDeletions() || reader.numDocs() != 0 && !((double)reader.numDocs() / (double)reader.maxDoc() < 0.5);
    }
}

