/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.script.field.AbstractScriptFieldFactory;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.Field;
import org.elasticsearch.script.field.IPAddress;

public class IpDocValuesField
extends AbstractScriptFieldFactory<IPAddress>
implements Field<IPAddress>,
DocValuesScriptFieldFactory,
ScriptDocValues.Supplier<String> {
    protected final String name;
    protected final ScriptDocValues.Supplier<InetAddress> raw;
    protected ScriptDocValues.Strings strings = null;

    public IpDocValuesField(SortedSetDocValues input, String name) {
        this.name = name;
        this.raw = new SortedSetIpSupplier(input);
    }

    public IpDocValuesField(SortedBinaryDocValues input, String name) {
        this.name = name;
        this.raw = new SortedBinaryIpSupplier(input);
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        this.raw.setNextDocId(docId);
    }

    @Override
    public String getInternal(int index) {
        return InetAddresses.toAddrString(this.raw.getInternal(index));
    }

    public ScriptDocValues<String> toScriptDocValues() {
        if (this.strings == null) {
            this.strings = new ScriptDocValues.Strings(this);
        }
        return this.strings;
    }

    public String asString(String defaultValue) {
        return this.asString(0, defaultValue);
    }

    public String asString(int index, String defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.size()) {
            return defaultValue;
        }
        return this.getInternal(index);
    }

    public List<String> asStrings() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            values.add(this.getInternal(i));
        }
        return values;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.raw.size();
    }

    public IPAddress get(IPAddress defaultValue) {
        return this.get(0, defaultValue);
    }

    public IPAddress get(int index, IPAddress defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.size()) {
            return defaultValue;
        }
        return new IPAddress(this.raw.getInternal(index));
    }

    @Override
    public Iterator<IPAddress> iterator() {
        return new Iterator<IPAddress>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < IpDocValuesField.this.size();
            }

            @Override
            public IPAddress next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new IPAddress(IpDocValuesField.this.raw.getInternal(this.index++));
            }
        };
    }

    protected static class SortedSetIpSupplier
    implements ScriptDocValues.Supplier<InetAddress> {
        private final SortedSetDocValues in;
        private long[] ords = new long[0];
        private int count;

        public SortedSetIpSupplier(SortedSetDocValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            this.count = 0;
            if (this.in.advanceExact(docId)) {
                for (int i = 0; i < this.in.docValueCount(); ++i) {
                    long ord = this.in.nextOrd();
                    this.ords = ArrayUtil.grow(this.ords, this.count + 1);
                    this.ords[this.count++] = ord;
                }
            }
        }

        @Override
        public InetAddress getInternal(int index) {
            try {
                BytesRef encoded = this.in.lookupOrd(this.ords[index]);
                return InetAddressPoint.decode(Arrays.copyOfRange(encoded.bytes, encoded.offset, encoded.offset + encoded.length));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int size() {
            return this.count;
        }
    }

    protected static class SortedBinaryIpSupplier
    implements ScriptDocValues.Supplier<InetAddress> {
        private final SortedBinaryDocValues in;
        private BytesRefBuilder[] values = new BytesRefBuilder[0];
        private int count;

        public SortedBinaryIpSupplier(SortedBinaryDocValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i].copyBytes(this.in.nextValue());
                }
            } else {
                this.resize(0);
            }
        }

        private void resize(int newSize) {
            this.count = newSize;
            if (newSize > this.values.length) {
                int oldLength = this.values.length;
                this.values = ArrayUtil.grow(this.values, this.count);
                for (int i = oldLength; i < this.values.length; ++i) {
                    this.values[i] = new BytesRefBuilder();
                }
            }
        }

        @Override
        public InetAddress getInternal(int index) {
            return InetAddressPoint.decode(BytesReference.toBytes(new BytesArray(this.values[index].toBytesRef())));
        }

        @Override
        public int size() {
            return this.count;
        }
    }
}

