/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.script.field.AbstractScriptFieldFactory;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.Field;

public class ByteDocValuesField
extends AbstractScriptFieldFactory<Byte>
implements Field<Byte>,
DocValuesScriptFieldFactory,
ScriptDocValues.Supplier<Long> {
    protected final SortedNumericLongValues input;
    protected final String name;
    protected byte[] values = new byte[0];
    protected int count;
    private ScriptDocValues.Longs longs = null;

    public ByteDocValuesField(SortedNumericLongValues input, String name) {
        this.input = input;
        this.name = name;
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        if (this.input.advanceExact(docId)) {
            this.resize(this.input.docValueCount());
            for (int i = 0; i < this.count; ++i) {
                this.values[i] = (byte)this.input.nextValue();
            }
        } else {
            this.resize(0);
        }
    }

    protected void resize(int newSize) {
        this.count = newSize;
        assert (this.count >= 0) : "size must be positive (got " + this.count + "): likely integer overflow?";
        this.values = ArrayUtil.grow(this.values, this.count);
    }

    public ScriptDocValues<Long> toScriptDocValues() {
        if (this.longs == null) {
            this.longs = new ScriptDocValues.Longs(this);
        }
        return this.longs;
    }

    @Override
    public Long getInternal(int index) {
        return this.values[index];
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public Iterator<Byte> iterator() {
        return new Iterator<Byte>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ByteDocValuesField.this.count;
            }

            @Override
            public Byte next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ByteDocValuesField.this.values[this.index++];
            }
        };
    }

    public byte get(int defaultValue) {
        return this.get(0, defaultValue);
    }

    public byte get(int index, int defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.count) {
            return (byte)defaultValue;
        }
        return this.values[index];
    }
}

