/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.http.HttpBody;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.rest.RestRequest;

public class RestContentAggregator {
    private static void replaceBody(RestRequest restRequest, ReleasableBytesReference aggregate) {
        restRequest.getHttpRequest().setBody(new HttpBody.ByteRefHttpBody(aggregate));
    }

    public static void aggregate(RestRequest restRequest, Consumer<RestRequest> resultConsumer) {
        HttpRequest httpRequest = restRequest.getHttpRequest();
        HttpBody httpBody = httpRequest.body();
        Objects.requireNonNull(httpBody);
        HttpBody httpBody2 = httpBody;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HttpBody.Full.class, HttpBody.Stream.class}, (Object)httpBody2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                HttpBody.Full full = (HttpBody.Full)httpBody2;
                resultConsumer.accept(restRequest);
                break;
            }
            case 1: {
                HttpBody.Stream stream = (HttpBody.Stream)httpBody2;
                AggregationChunkHandler aggregationHandler = new AggregationChunkHandler(restRequest, resultConsumer);
                stream.setHandler(aggregationHandler);
                stream.next();
            }
        }
    }

    private static class AggregationChunkHandler
    implements HttpBody.ChunkHandler {
        final RestRequest restRequest;
        final Consumer<RestRequest> resultConsumer;
        final HttpBody.Stream stream;
        boolean closing;
        ArrayList<ReleasableBytesReference> chunks;

        private AggregationChunkHandler(RestRequest restRequest, Consumer<RestRequest> resultConsumer) {
            this.restRequest = restRequest;
            this.resultConsumer = resultConsumer;
            this.stream = restRequest.getHttpRequest().body().asStream();
        }

        @Override
        public void onNext(ReleasableBytesReference chunk, boolean isLast) {
            if (this.closing) {
                chunk.close();
                return;
            }
            if (!isLast) {
                if (this.chunks == null) {
                    this.chunks = new ArrayList();
                }
                this.chunks.add(chunk);
                this.stream.next();
            } else {
                if (this.chunks == null) {
                    RestContentAggregator.replaceBody(this.restRequest, chunk);
                } else {
                    this.chunks.add(chunk);
                    BytesReference comp = CompositeBytesReference.of(this.chunks.toArray(new ReleasableBytesReference[0]));
                    ReleasableBytesReference relComp = new ReleasableBytesReference(comp, Releasables.wrap(this.chunks));
                    RestContentAggregator.replaceBody(this.restRequest, relComp);
                }
                this.chunks = null;
                this.closing = true;
                this.resultConsumer.accept(this.restRequest);
            }
        }

        @Override
        public void close() {
            if (!this.closing) {
                this.closing = true;
                if (this.chunks != null) {
                    Releasables.close(this.chunks);
                    this.chunks = null;
                }
            }
        }
    }
}

